/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.interpark;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCategoryCommand;
import com.kdjsystem.mlink.shop.common.IShopListener;
import com.kdjsystem.mlink.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.shop.data.interpark.IShopCategoryInterParkCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

class InterParkCategoryLevel2Command
extends IShopCategoryInterParkCommand
implements IShopListener {
    private static IShopCategoryCommand instance = new InterParkCategoryLevel2Command();
    IShopListener listener = null;

    public static IShopCategoryCommand getInstance() {
        return instance;
    }

    private InterParkCategoryLevel2Command() {
    }

    @Override
    public List<ShopCategoryDto> Completed(List<ShopCategoryDto> param) throws Exception {
        param = this.getHTMLParseManager(param);
        return param;
    }

    public List<ShopCategoryDto> getHTMLParseManager(List<ShopCategoryDto> param) throws Exception {
        ArrayList<ShopCategoryDto> dtolist = new ArrayList<ShopCategoryDto>();
        try {
            Map<String, String> cookies = IShopCategoryInterParkCommand.getLoginCookie();
            String categ = param.get(0).getCatlrgcd();
            JsonParser jsonparser = new JsonParser();
            Connection.Response response = Jsoup.connect((String)("https://seller.buyzle.co.kr/api/common/display-category?dispKind=01&highDispNo=" + categ)).cookies(cookies).method(Connection.Method.GET).ignoreContentType(true).execute();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(response.body());
            if (jsonobject.get("code").toString().equals("200")) {
                JsonArray jsonArray = (JsonArray)jsonobject.get("data");
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String value = object.get("dispNo").getAsString();
                    String text = object.get("dispNm").getAsString();
                    ShopCategoryDto shopCateDto = new ShopCategoryDto();
                    shopCateDto.setShopcd("shop0004");
                    shopCateDto.setCatmidcd(value);
                    shopCateDto.setCatmidnm(text);
                    dtolist.add(shopCateDto);
                    ++i;
                }
            }
            return dtolist;
        }
        catch (Exception exception) {
            throw new Exception("\ubc14\uc774\uc990 \uc911\ubd84\ub958 \uce74\ud14c\uace0\ub9ac \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public void addEventListner(IShopListener listener) {
        this.listener = listener;
    }

    @Override
    public void onEvent(String val) {
        this.listener.onEvent(val);
    }

    @Override
    public List<ShopCategoryDto> excute(List<ShopCategoryDto> param) throws Exception {
        return null;
    }
}

