/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreLiteOrderCommand
extends IShopOrderKakaoStoreCommand {
    private static IShopOrderCommand instance = new KakaoStoreLiteOrderCommand();
    JsonParser parser = new JsonParser();

    private KakaoStoreLiteOrderCommand() {
    }

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        try {
            String startdt = dto.getStartDt().substring(0, 8);
            String enddt = dto.getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            String[] orderStatus = this.getOrderStatus(dto.getSpecificStatus());
            int i = 0;
            while (i < (int)range) {
                this.getOrder(dto, startdt, retList, orderStatus);
                cal1.add(5, 1);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 lite \uc8fc\ubb38 \uc218\uc9d1 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return retList;
    }

    private void getOrder(ShopOrderMstNewDto dto, String date, List<ShopOrderMstNewDto> retList, String[] orderStatus) throws Exception {
        try {
            String orderDate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(date, false);
            String apiKey = dto.getApikey();
            String[] stringArray = orderStatus;
            int n = orderStatus.length;
            int n2 = 0;
            while (n2 < n) {
                String orderstat = stringArray[n2];
                StringBuilder urlbuilder = new StringBuilder();
                urlbuilder.append("https://kapi.kakao.com/v2/shopping/orders?").append("orderModifiedAtStart=").append(orderDate + "%2000:00:00").append("&orderModifiedAtEnd=").append(orderDate + "%2023:59:59").append("&orderStatus=").append(orderstat).append("&size=100");
                URL url = new URL(urlbuilder.toString());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Host", "kapi.kakao.com");
                conn.setRequestProperty("channel-ids", "101");
                conn.setRequestProperty("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053");
                conn.setRequestProperty("Target-Authorization", "KakaoAK " + apiKey);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoInput(true);
                Throwable throwable = null;
                Object var15_16 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    JsonObject jsonObject = this.parser.parse(sb.toString()).getAsJsonObject();
                    JsonArray contents = jsonObject.get("contents").getAsJsonArray();
                    if (contents.size() > 0) {
                        for (JsonElement ele : contents) {
                            String kakaoStat = ele.getAsJsonObject().get("orderStatus").getAsString();
                            String orderStat = this.getOrderStat(kakaoStat);
                            this.dataMapping(dto, ele.getAsJsonObject(), orderStat, retList);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    private void dataMapping(ShopOrderMstNewDto ordDto, JsonObject object, String status2, List<ShopOrderMstNewDto> retList) throws Exception {
        try {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setResult_code("1");
            dto.setUser_email("");
            dto.setReceive_email("");
            dto.setUser_id("");
            dto.setUser_name("");
            dto.setWon_cost("0");
            dto.setLabel("");
            dto.setBox_ea("0");
            dto.setMall_exp_cd("");
            String orderId = this.jsonElementNullStr(object.get("orderId"));
            dto.setOrder_id(orderId);
            dto.setOrder_status(status2);
            dto.setOrder_date(this.dateformat(this.jsonElementNullStr(object.get("createdAt"))));
            JsonObject orderDetail = this.getOrderDetailByOrderNo(orderId, ordDto.getApikey());
            JsonObject orderer = orderDetail.get("orderer").getAsJsonObject();
            String phoneNumber = this.jsonElementNullStr(orderer.get("phoneNumber")).replace("+82 ", "0");
            dto.setUser_tel(phoneNumber);
            dto.setUser_cel(phoneNumber);
            JsonObject prdinfo = orderDetail.get("orderProduct").getAsJsonObject();
            dto.setMall_product_id(this.jsonElementNullStr(prdinfo.get("id")));
            dto.setP_product_name(this.jsonElementNullStr(prdinfo.get("name")));
            dto.setProduct_name(this.jsonElementNullStr(prdinfo.get("name")));
            dto.setCompayny_goods_cd(this.jsonElementNullStr(prdinfo.get("sellerItemNo")));
            dto.setProduct_id(this.jsonElementNullStr(prdinfo.get("sellerItemNo")));
            dto.setP_sku_value(this.jsonElementNullStr(prdinfo.get("optionContent")));
            if (orderDetail.has("orderDeliveryRequest")) {
                JsonObject deliveryReq = orderDetail.get("orderDeliveryRequest").getAsJsonObject();
                dto.setDelv_msg(this.jsonElementNullStr(deliveryReq.get("requirement")));
                String roadZipCode = this.jsonElementNullStr(deliveryReq.get("roadZipCode"));
                dto.setReceive_zipcode(roadZipCode);
                dto.setReceive_addr(this.jsonElementNullStr(deliveryReq.get("receiverAddress")));
                dto.setReceive_tel(this.jsonElementNullStr(deliveryReq.get("receiverPhoneNumber")));
                dto.setReceive_cel(this.jsonElementNullStr(deliveryReq.get("receiverMobileNumber")));
                dto.setReceive_name(this.jsonElementNullStr(deliveryReq.get("receiverName")));
                if (deliveryReq.has("personalClearanceCode")) {
                    dto.setPersonal_customs_code(this.jsonElementNullStr(deliveryReq.get("personalClearanceCode")));
                }
            } else {
                dto.setReceive_addr("");
                dto.setDelv_msg("");
                dto.setReceive_tel("");
                dto.setReceive_cel("");
                dto.setReceive_name("");
                dto.setReceive_zipcode("");
            }
            String deliveryAmountType = this.deliveryAmountType(this.jsonElementNullStr(prdinfo.get("deliveryAmountType")));
            String PayPointTime = this.jsonElementNullStr(prdinfo.get("deliveryAmountPayPointTime"));
            dto.setDelivery_method_str2(deliveryAmountType.equals("\ubb34\ub8cc") ? "\ubb34\ub8cc" : (PayPointTime.equals("PayedToOrder") ? "\uc120\ubd88" : "\ucc29\ubd88"));
            if (orderDetail.has("orderDelivery")) {
                JsonObject orderDelivery = orderDetail.get("orderDelivery").getAsJsonObject();
                if (orderDelivery.has("deliveryCompanyCode")) {
                    dto.setDelivery_id(this.jsonElementNullStr(orderDelivery.get("deliveryCompanyCode")));
                    dto.setInvoice_no(this.jsonElementNullStr(orderDelivery.get("invoiceNumber")));
                    dto.setDelivery_method(this.jsonElementNullStr(orderDelivery.get("shippingMethod")));
                } else {
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                }
            } else {
                dto.setDelivery_id("");
                dto.setInvoice_no("");
            }
            dto.setCopy_idx(this.jsonElementNullStr(prdinfo.get("deliveryAmountOriginId")));
            if (orderDetail.has("orderBase")) {
                JsonObject orderBase = orderDetail.get("orderBase").getAsJsonObject();
                dto.setPay_date(this.dateformat(this.jsonElementNullStr(orderBase.get("paidAt"))));
                if (!this.jsonElementNullStr(orderBase.get("decidedAt")).isEmpty()) {
                    dto.setPurchase_confirm_date(this.dateformat(this.jsonElementNullStr(orderBase.get("decidedAt"))));
                }
            }
            if (orderDetail.has("orderClaimCancel")) {
                JsonObject orderClaimCancel = orderDetail.get("orderClaimCancel").getAsJsonObject();
                dto.setClaim_reason(this.jsonElementNullStr(orderClaimCancel.get("reasonCodeName")));
                dto.setClaim_reg_date(this.dateformat(this.jsonElementNullStr(orderClaimCancel.get("createdAt"))));
            }
            int productPrice = prdinfo.get("productPrice").getAsInt();
            int quanity = prdinfo.get("quantity").getAsInt();
            int saleCost = productPrice / quanity;
            int optionPrice = prdinfo.get("optionPrice").getAsInt();
            int totalPrice = productPrice + optionPrice;
            int sellerDiscountPrice = prdinfo.get("sellerDiscountPrice").getAsInt();
            int sellerCouponDiscountPrice = prdinfo.get("sellerCouponDiscountPrice").getAsInt();
            int discountCost = sellerDiscountPrice + sellerCouponDiscountPrice;
            int payCost = totalPrice - discountCost;
            int baseFee = prdinfo.get("baseFee").getAsInt();
            int displayFee = prdinfo.get("displayFee").getAsInt();
            int afCommissionFee = prdinfo.get("afCommissionFee").getAsInt();
            int discountFee = prdinfo.get("discountFee").getAsInt();
            int mallFee = baseFee + displayFee + afCommissionFee - discountFee;
            int supplyCost = totalPrice - mallFee;
            int mallWonCost = supplyCost - discountCost;
            int delvCost = prdinfo.get("deliveryAmount").getAsInt();
            dto.setTotal_cost(String.valueOf(totalPrice));
            dto.setSale_cnt(this.fmtInt(quanity));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setOpt_add_cost(this.fmtInt(optionPrice));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setDiscount_cost(this.fmtInt(discountCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setRate(this.percentOf(mallFee, totalPrice, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            retList.add(dto);
        }
        catch (Exception exception) {}
    }

    private JsonObject getOrderDetailByOrderNo(String odNo, String apikey) throws Exception {
        Connection.Response rs = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/order?order_id=" + odNo)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
        return this.parser.parse(rs.body()).getAsJsonObject();
    }

    private String[] getOrderStatus(String specificStatus) {
        switch (specificStatus) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return new String[]{"ShippingRequest"};
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                return new String[]{"ShippingWaiting"};
            }
            case "\ubc30\uc1a1\uc911": {
                return new String[]{"ShippingProgress"};
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return new String[]{"ShippingComplete"};
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return new String[]{"BuyDecision"};
            }
            case "\ucde8\uc18c": {
                return new String[]{"ShippingCancelRequestBuyer", "ShippingCancelRequest", "ShippingCancelRequestSeller", "ShippingCancelComplete", "PayCancelComplete"};
            }
            case "\ubc18\ud488": {
                return new String[]{"ReturnRequest", "ReturnApproved", "ReturnPending", "ShippingRefundComplete", "ReturnCancelComplete", "ReturnRefundComplete", "ReturnShippingComplete"};
            }
            case "\uad50\ud658": {
                return new String[]{"ExchangeRequest", "ExchangeApproved", "ExchangePending", "ExchangeReturning", "ExchangeReturnComplete", "ExchangeShippingProgress", "ExchangeShippingComplete"};
            }
            case "\ud1b5\ud569": {
                return new String[]{"ShippingRequest", "ShippingWaiting", "ShippingProgress", "ShippingComplete", "BuyDecision", "ShippingCancelRequestBuyer", "ShippingCancelRequest", "ShippingCancelRequestSeller", "ShippingCancelComplete", "PayCancelComplete", "ReturnRequest", "ReturnApproved", "ReturnPending", "ShippingRefundComplete", "ReturnCancelComplete", "ReturnRefundComplete", "ReturnShippingComplete", "ExchangeRequest", "ExchangeApproved", "ExchangePending", "ExchangeReturning", "ExchangeReturnComplete", "ExchangeShippingProgress", "ExchangeShippingComplete"};
            }
        }
        return new String[0];
    }

    private String getOrderStat(String kakaoStat) {
        String orderStat = "";
        switch (kakaoStat) {
            case "ShippingRequest": 
            case "ShippingWaiting": {
                orderStat = "100";
                break;
            }
            case "ShippingProgress": {
                orderStat = "403";
                break;
            }
            case "ShippingComplete": 
            case "BuyDecision": {
                orderStat = "410";
                break;
            }
            case "ShippingCancelRequest": 
            case "ShippingCancelRequestBuyer": 
            case "ShippingCancelRequestSeller": {
                orderStat = "C01";
                break;
            }
            case "ShippingCancelComplete": 
            case "PayCancelComplete": {
                orderStat = "C02";
                break;
            }
            case "ReturnApproved": 
            case "ReturnRequest": 
            case "ReturnPending": {
                orderStat = "R01";
                break;
            }
            case "ReturnCancelComplete": 
            case "ReturnRefundComplete": 
            case "ReturnShippingComplete": 
            case "ShippingRefundComplete": {
                orderStat = "R02";
                break;
            }
            case "ExchangePending": 
            case "ExchangeReturnComplete": 
            case "ExchangeRequest": 
            case "ExchangeApproved": 
            case "ExchangeReturning": 
            case "ExchangeShippingProgress": {
                orderStat = "E01";
                break;
            }
            case "ExchangeShippingComplete": {
                orderStat = "E02";
            }
        }
        return orderStat;
    }

    private String deliveryAmountType(String keyword) {
        switch (keyword) {
            case "FREE": {
                return "\ubb34\ub8cc";
            }
            case "PAID": {
                return "\uc720\ub8cc";
            }
            case "CONDITIONAL_FREE": {
                return "\uc870\uac74\ubd80\ubb34\ub8cc";
            }
            case "QUANTITY_PAID": {
                return "\uc218\ub7c9\ubcc4 \ubd80\uacfc";
            }
        }
        return keyword;
    }

    private String dateformat(String ordDt) {
        return ordDt.substring(0, 4) + "-" + ordDt.substring(4, 6) + "-" + ordDt.substring(6, 8) + " " + ordDt.substring(8, 10) + ":" + ordDt.substring(10, 12) + ":" + ordDt.substring(12, 14);
    }
}

