/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreOrderCancleApprovalCommand
extends IShopOrderKakaoStoreCommand {
    private static IShopOrderCommand instance = new KakaoStoreOrderCancleApprovalCommand();
    JsonParser jsonparser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private KakaoStoreOrderCancleApprovalCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : param) {
            String apikey = dto.getApikey();
            String orderID = dto.getOrder_id();
            String claimID = this.getClaimId(orderID, apikey);
            String json = "{\"orderIds\": [" + orderID + "], \"claimId\": " + claimID + "}";
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/shopping/claims/cancel/confirm").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).execute();
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(response.body());
            jsonobject.get("status").getAsString();
            String message = jsonobject.get("message").getAsString();
            dto.setOrder_status("C02");
            dto.setResult_code("1");
            dto.setResult_text(message);
            retList.add(dto);
        }
        return retList;
    }

    private String getClaimId(String orderID, String apikey) {
        String claimID = "";
        try {
            Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/order?order_id=" + orderID)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject object = this.jsonparser.parse(response.body()).getAsJsonObject();
            if (object.has("orderClaimCancel")) {
                object = object.get("orderClaimCancel").getAsJsonObject();
                claimID = object.get("claimId").getAsString();
            }
        }
        catch (Exception exception) {}
        return claimID;
    }
}

