/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.lotteon;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDao;
import com.kdjsystem.mlink.shop.data.lotteon.LotteOnExitsProductCd;
import com.kdjsystem.mlink.shop.data.lotteon.LotteOnProductDto;
import com.kdjsystem.mlink.shop.data.lotteon.ShopLotteOnAdditionalDto;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.ShopAddProdInDto;
import com.kdjsystem.mlink.tot.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.tot.data.dao.ShopProdInDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LotteOnProductRegService
implements IProduct {
    private static final String Host = "https://openapi.lotteon.com";
    List<ShopOptionDto> shopOptionDtos;
    List<ShopAddProdInfoDto> addProdList;
    List<String> imageDelete = new ArrayList<String>();
    private final OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }).build();

    private String setProductReg(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        LotteOnProductDto.ProductRequest prodRequest = new LotteOnProductDto.ProductRequest();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst> spdLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst>();
        LotteOnProductDto.ProductRequest.SpdLst spd = new LotteOnProductDto.ProductRequest.SpdLst();
        this.Transact(dtllist, shoppingMallDetailDto, spd);
        this.Category(dto, dtllist, shoppingMallDetailDto, spd);
        this.Basic(dto, dtllist, spd);
        this.Option(dto, dtllist, spd, strImages);
        this.addOption(dto, spd);
        this.DetailRemark(dto, spd, dtllist);
        this.ItemBasic(dtllist, spd, dto, shoppingMallDetailDto);
        this.Notice(spd, dtllist, dto);
        this.BasicShipping(dtllist, spd);
        spdLst.add(spd);
        prodRequest.spdLst = spdLst;
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)prodRequest);
        String imsiitemId = this.productRegSend(json, shoppingMallDetailDto, "/v1/openapi/product/v1/product/registration/request");
        dto.setResult_code("1");
        dto.setShopprodno(imsiitemId);
        return json;
    }

    private void addOption(ShopProductDto dto, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            this.addProdList = ShopProductDao.get().getAddProdInfo(dto.getProdseq());
            if (this.addProdList.size() > 0) {
                spd.adtnPdYn = "Y";
                LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo adtnPdInfo = new LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo();
                adtnPdInfo.sortCd = "REGIST_ASC";
                List addProdNmList = this.addProdList.stream().map(p -> p.getProd_val1()).distinct().collect(Collectors.toList());
                ArrayList<LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst> adtnTypeLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst>();
                int i = 0;
                while (i < addProdNmList.size()) {
                    String name = (String)addProdNmList.get(i);
                    LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst adtnType = new LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst();
                    adtnType.adtnTypNm = name;
                    adtnType.epsrPrirRnkg = i + 1;
                    List addProdValList = this.addProdList.stream().filter(p -> p.getProd_val1().equals(name)).collect(Collectors.toList());
                    ArrayList<LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst.AdtnPdLst> adtnPdLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst.AdtnPdLst>();
                    for (ShopAddProdInfoDto addProdVal : addProdValList) {
                        LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst.AdtnPdLst adtnPd = new LotteOnProductDto.ProductRequest.SpdLst.AdtnPdInfo.AdtnTypeLst.AdtnPdLst();
                        adtnPd.adtnPdNm = addProdVal.getProd_val2();
                        adtnPd.slPrc = addProdVal.getProd_amt();
                        adtnPd.stkQty = addProdVal.getProd_cnt();
                        adtnPd.useYn = addProdVal.getProd_cnt() != 0 ? "Y" : "N";
                        adtnPdLst.add(adtnPd);
                    }
                    adtnType.adtnPdLst = adtnPdLst;
                    adtnTypeLst.add(adtnType);
                    ++i;
                }
                adtnPdInfo.adtnTypeLst = adtnTypeLst;
                spd.adtnPdInfo = adtnPdInfo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void Transact(ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            spd.trGrpCd = "SR";
            spd.trNo = shoppingMallDetailDto.getAuthkey1();
            spd.ctrtTypCd = "A";
            if (dtllist.getCtrtTypCd().equals("A")) {
                spd.rtrvTypCd = "ENTP_RTRV";
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uac70\ub798\ucc98, \uacc4\uc57d\uc720\ud615\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private JsonObject Category(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        spd.scatNo = dtllist.getIsCategory().equals("1") ? dtllist.getShopcatno() : dto.getShopCid();
        JsonParser parser = new JsonParser();
        Request request2 = new Request.Builder().url("https://onpick-api.lotteon.com/cheetah/econCheetah.ecn?job=cheetahStandardCategory&filter_1=" + spd.scatNo).method("GET", null).addHeader("Content-Type", "application/json; charset=\"UTF-8\"").addHeader("Referer", "https://store.lotteon.com/").addHeader("accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Safari/537.36").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        Response response = this.client.newCall(request2).execute();
        JsonObject result = (JsonObject)parser.parse(response.body().string().toString());
        JsonArray data2 = (JsonArray)result.get("itemList");
        if (data2.size() == 0) {
            dto.setResult_text("\ud574\ub2f9 \uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new Exception("\ud574\ub2f9 \uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        JsonObject itemList = (JsonObject)data2.get(0);
        JsonObject item = (JsonObject)itemList.get("data");
        JsonArray disp_list = (JsonArray)item.get("disp_list");
        JsonObject disp = (JsonObject)disp_list.get(0);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.DcatLst> dcatLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.DcatLst>();
        LotteOnProductDto.ProductRequest.SpdLst.DcatLst dcat = new LotteOnProductDto.ProductRequest.SpdLst.DcatLst();
        dcat.mallCd = "LTON";
        dcat.lfDcatNo = disp.get("disp_cat_id").getAsString();
        dcatLst.add(dcat);
        spd.dcatLst = dcatLst;
        return item;
    }

    private void Basic(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        String value = "";
        try {
            value = IProduct.formatProductNameByCode(dtllist.getPdPrtWay(), dto);
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 148);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (!dtllist.getPdNmAddFrtTxt().equals("")) {
                value = dtllist.getPdNmAddFrtTxt().concat(value);
            }
            if (!dtllist.getPdNmAddBackTxt().equals("")) {
                value = value.concat(dtllist.getPdNmAddBackTxt());
            }
            spd.spdNm = YDMAStringUtil.length(value) > 148 ? YDMAStringUtil.Char_substring(value, 148) : value;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud488\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Option(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, List<String> strImages) throws Exception {
        String img;
        this.shopOptionDtos = this.getProductOptions(dto);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst>();
        int i = 0;
        Long salePrice = this.salePrice(dto, dtllist);
        String uploadedImageUrl = img = strImages.get(0);
        try {
            spd.stkMgtYn = dtllist.getStkMgtYn();
            if (this.shopOptionDtos.size() > 0) {
                String addOptionLeftNm = "";
                String addOptionRightNm = "";
                if (dtllist.getAddoptionlb().equals("Y")) {
                    addOptionLeftNm = dtllist.getAddOptionL();
                }
                if (dtllist.getAddoptionrb().equals("Y")) {
                    addOptionRightNm = dtllist.getAddOptionR();
                }
                spd.sitmYn = "Y";
                for (ShopOptionDto option2 : this.shopOptionDtos) {
                    int sortseq = i++;
                    int amt = YDMAStringUtil.convertToInt(option2.getAmt());
                    salePrice = this.salePrice(dto, dtllist);
                    salePrice = salePrice + YDMAStringUtil.convertToLong(option2.getAmt());
                    int limit_price = YDMAStringUtil.convertToInt(option2.getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    }
                    amt = Integer.parseInt(optionprice.getConsumer_if_sale_price());
                    LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
                    itm.sortSeq = String.valueOf(sortseq);
                    itm.dpYn = "Y";
                    itm.slPrc = String.valueOf(amt);
                    if (dtllist.getStkMgtYn().equals("Y")) {
                        itm.stkQty = option2.getCnt();
                    }
                    ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst> itmOptLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst>();
                    String[] optionTypes = option2.getName().split(":");
                    String[] optionValues = option2.getOptspecdes().split(":");
                    int j = 0;
                    while (j < optionTypes.length) {
                        LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
                        if (!optionValues[j].contains("(\ud488\uc808)")) {
                            itmOpt.optNm = optionTypes[j];
                            itmOpt.optVal = addOptionLeftNm + optionValues[j] + addOptionRightNm;
                            itmOptLst.add(itmOpt);
                        }
                        ++j;
                    }
                    ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
                    LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
                    if (itmOptLst.size() == 0) continue;
                    itmImg.epsrTypCd = "IMG";
                    itmImg.epsrTypDtlCd = "IMG_SQRE";
                    itmImg.origImgFileNm = uploadedImageUrl;
                    itmImg.rprtImgYn = "Y";
                    itmImgLst.add(itmImg);
                    itm.itmOptLst = itmOptLst;
                    itm.itmImgLst = itmImgLst;
                    itmLst.add(itm);
                }
                ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst> optSrtLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst>();
                int j = 0;
                while (j < this.shopOptionDtos.get(0).getName().split(":").length) {
                    LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
                    optSrt.optSeq = j + 1;
                    optSrt.optNm = this.shopOptionDtos.get(0).getName().split(":")[j];
                    int index = j;
                    List nameList = this.shopOptionDtos.stream().filter(p -> !p.getCnt().equals("0")).map(p -> p.getOptspecdes().split(":")[index]).distinct().collect(Collectors.toList());
                    ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst> optValSrtLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst>();
                    int k = 0;
                    while (k < nameList.size()) {
                        LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                        optValSrt.optValSeq = k + 1;
                        optValSrt.optVal = addOptionLeftNm + (String)nameList.get(k) + addOptionRightNm;
                        optValSrtLst.add(optValSrt);
                        ++k;
                    }
                    optSrt.optValSrtLst = optValSrtLst;
                    optSrtLst.add(optSrt);
                    ++j;
                }
                spd.optSrtLst = optSrtLst;
            } else {
                LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
                spd.sitmYn = "N";
                itm.sortSeq = "1";
                itm.dpYn = "Y";
                itm.slPrc = dto.getGoods_price();
                itm.stkQty = dto.getQty() == null ? "999" : dto.getQty();
                ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
                LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
                itmImg.epsrTypCd = "IMG";
                itmImg.epsrTypDtlCd = "IMG_SQRE";
                itmImg.origImgFileNm = uploadedImageUrl;
                itmImg.rprtImgYn = "Y";
                itmImgLst.add(itmImg);
                itm.itmImgLst = itmImgLst;
                itmLst.add(itm);
            }
            spd.itmLst = itmLst;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ub2e8\ud488\uc635\uc158\uc744 \ub4f1\ub85d\ud558\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private Long salePrice(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist) throws Exception {
        Long salePrice;
        try {
            salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return salePrice;
    }

    private void setItmLst(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, List<String> strImages, List<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst, List<String> ctName, List<String> ctName2, ShopOptionDto shopOptionDto, LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm, int sortseq, int amt) {
        LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst itmOpt;
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst> itmOptLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst>();
        List<String> names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
        ctName.add(names.get(0));
        if (names.size() > 1) {
            ctName2.add(names.get(1));
        }
        itm.sortSeq = String.valueOf(sortseq);
        itm.dpYn = "Y";
        itm.slPrc = String.valueOf(amt);
        if (dtllist.getStkMgtYn().equals("Y")) {
            itm.stkQty = shopOptionDto.getCnt();
        }
        if (names.size() > 1) {
            itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
            itmOpt.optNm = dto.getChar_2_nm();
            itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(1) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(1) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(1) + dtllist.getAddOptionR() : names.get(1)));
            itmOptLst.add(itmOpt);
        }
        if (names.size() > 1) {
            itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
            itmOpt.optNm = dto.getChar_1_nm();
            itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(0) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(0) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(0) + dtllist.getAddOptionR() : names.get(0)));
            itmOptLst.add(itmOpt);
        } else {
            itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
            itmOpt.optNm = dto.getChar_1_nm();
            itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(0) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(0) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(0) + dtllist.getAddOptionR() : names.get(0)));
            itmOptLst.add(itmOpt);
        }
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
        LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
        String img = strImages.get(0);
        itmImg.epsrTypCd = "IMG";
        itmImg.epsrTypDtlCd = "IMG_SQRE";
        itmImg.origImgFileNm = img;
        itmImg.rprtImgYn = "Y";
        itmImgLst.add(itmImg);
        itm.itmOptLst = itmOptLst;
        itm.itmImgLst = itmImgLst;
        itmLst.add(itm);
    }

    private void OptionSort(ShopProductDto dto, LotteOnProductDto.ProductRequest.SpdLst spd, List<String> ctName, List<String> ctName2, List<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst> optSrtLst, ShopLotteOnAdditionalDto dtllist) {
        LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst optValSrt;
        LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst optSrt;
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst> optValSrtLst;
        List ctNames = ctName.stream().distinct().collect(Collectors.toList());
        List ctNames2 = ctName2.stream().distinct().collect(Collectors.toList());
        if (!dto.getChar_2_val().isEmpty()) {
            optValSrtLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst>();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 1;
            optSrt.optNm = dto.getChar_1_nm();
            int j = 0;
            while (j < ctNames.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = j;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames.get(j) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames.get(j) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames.get(j) + dtllist.getAddOptionR() : (String)ctNames.get(j)));
                optValSrtLst.add(optValSrt);
                ++j;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        }
        if (!dto.getChar_2_val().isEmpty()) {
            optValSrtLst = new ArrayList();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 2;
            optSrt.optNm = dto.getChar_2_nm();
            int z = 0;
            while (z < ctNames2.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = z;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames2.get(z) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames2.get(z) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames2.get(z) + dtllist.getAddOptionR() : (String)ctNames2.get(z)));
                optValSrtLst.add(optValSrt);
                ++z;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        } else {
            optValSrtLst = new ArrayList();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 1;
            optSrt.optNm = dto.getChar_1_nm();
            int y = 0;
            while (y < ctNames.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = y;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames.get(y) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames.get(y) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames.get(y) + dtllist.getAddOptionR() : (String)ctNames.get(y)));
                optValSrtLst.add(optValSrt);
                ++y;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        }
        spd.optSrtLst = optSrtLst;
    }

    private void DetailRemark(ShopProductDto dto, LotteOnProductDto.ProductRequest.SpdLst spd, ShopLotteOnAdditionalDto dtllist) throws Exception {
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.EpnLst> epnLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.EpnLst>();
        LotteOnProductDto.ProductRequest.SpdLst.EpnLst dscrp = new LotteOnProductDto.ProductRequest.SpdLst.EpnLst();
        LotteOnProductDto.ProductRequest.SpdLst.EpnLst ascnts = new LotteOnProductDto.ProductRequest.SpdLst.EpnLst();
        try {
            dscrp.pdEpnTypCd = "DSCRP";
            Object addDetailPlus = "";
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            dscrp.cnts = (String)addDetailPlus + dtllist.getPdDtlFrtDec() + IProduct.removeBrokenImgTag(dto.getGoods_remarks()) + dtllist.getPdDtlBackDec();
            epnLst.add(dscrp);
            ascnts.pdEpnTypCd = "AS_CNTS";
            ascnts.cnts = dtllist.getAsGuide();
            epnLst.add(ascnts);
            spd.epnLst = epnLst;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\uc138\uc124\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void ItemBasic(ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            spd.cshbltyPdYn = "N";
            spd.ageLmtCd = dtllist.getAgeLmtCd();
            spd.bookCultCstDdctYn = dtllist.getBookCultCstDdctYn();
            spd.epdNo = dto.getCompayny_goods_cd();
            spd.slTypCd = dtllist.getSlTypCd();
            spd.pdTypCd = dtllist.getPdTypCd();
            spd.tdfDvsCd = dtllist.getTdfDvsCd();
            spd.oplcCd = "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870";
            spd.mfcrNm = dto.getMaker();
            spd.impCoNm = dtllist.getImpCoNm();
            spd.impDvsCd = dtllist.getImpDvsCd();
            spd.pdStatCd = dtllist.getPdStatCd();
            spd.cnclPsbYn = dtllist.getCnclPsbYn();
            spd.immdCnclPsbYn = dtllist.getImmdCnclPsbYn();
            spd.brkHmapPkcpPsbYn = dtllist.getBrkHmapPkcpPsbYn();
            spd.asGuide = dtllist.getAsGuide();
            spd.pdOptmodifyYn = dtllist.getPdOptmodifyYn();
            spd.selSaleOptSetYn = dtllist.getSelSaleOptSetYn();
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uae30\ubcf8 \ubd80\uac00\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.slStrtDttm = YDMATimeUtil.getCurrentDateHanjin() + "000000";
            spd.slEndDttm = dtllist.getSlEndDttm();
            dto.setSaleenddt(spd.slEndDttm);
            spd.dpYn = "Y";
            spd.prcCmprEpsrYn = dtllist.getPrcCmprEpsrYn();
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.mdlNo = dto.getCompayny_goods_cd();
            spd.prstPsbYn = dtllist.getPrstPsbYn();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ud0c0\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.scKwdLst = new ArrayList<String>();
            String search = dto.getGoods_search();
            String[] splitSearch = search.split(",");
            if (splitSearch.length > 5) {
                int i = 0;
                while (i < 5) {
                    spd.scKwdLst.add(splitSearch[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < splitSearch.length) {
                    spd.scKwdLst.add(splitSearch[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud0a4\uc6cc\ub4dc\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        LotteOnProductDto.ProductRequest.SpdLst.PurPsbQtyInfo purpsbQtyInfo = new LotteOnProductDto.ProductRequest.SpdLst.PurPsbQtyInfo();
        try {
            purpsbQtyInfo.itmByMinPurYn = dtllist.getItmByMinPurYn();
            if (dtllist.getItmByMinPurYn().equals("Y")) {
                purpsbQtyInfo.itmByMinPurQty = dtllist.getItmByMinPurQty();
            }
            purpsbQtyInfo.itmByMaxPurPsbQtyYn = dtllist.getItmByMaxPurPsbQtyYn();
            if (dtllist.getItmByMaxPurPsbQtyYn().equals("Y")) {
                purpsbQtyInfo.maxPurQty = dtllist.getMaxPurQty();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uac00\ub2a5 \uc218\ub7c9\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        spd.purPsbQtyInfo = purpsbQtyInfo;
        if (dtllist.getBrdRegYn().equals("Y")) {
            spd.brdNo = "";
        } else if (dtllist.getBrdPdInfoYn().equals("Y")) {
            String brand_id = this.setBrandSearch(shoppingMallDetailDto, dto);
            if (brand_id.equals("")) {
                if (dtllist.getBrdPdRegPrcYn().equals("Y")) {
                    throw new Exception("\ube0c\ub79c\ub4dc\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ubd80\uac00\uc815\ubcf4 \ud655\uc778\ud6c4 \ub2e4\uc2dc \ub4f1\ub85d\ud574\uc8fc\uc138\uc694.");
                }
                spd.brdNo = "";
            } else {
                spd.brdNo = brand_id;
            }
        } else {
            spd.brdNo = dtllist.getBrnd_id();
        }
    }

    public String setBrandSearch(ShoppingMallDetailDto shoppingMallDetailDto, ShopProductDto dto) throws Exception {
        String brand_id = "";
        JsonParser parser = new JsonParser();
        Request request2 = new Request.Builder().url("https://onpick-api.lotteon.com/cheetah/econCheetah.ecn?job=cheetahBrnd").method("GET", null).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Authorization", shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Response response = this.client.newCall(request2).execute();){
                ArrayList brndInfo = new ArrayList();
                JsonObject result = (JsonObject)parser.parse(response.body().string().toString());
                JsonArray brandList = (JsonArray)result.get("itemList");
                int i = 0;
                while (i < brandList.size()) {
                    JsonObject brand = (JsonObject)brandList.get(i);
                    JsonObject data2 = (JsonObject)brand.get("data");
                    ArrayList<String> brndIdNm = new ArrayList<String>();
                    brndIdNm.add(data2.get("brnd_id").getAsString());
                    brndIdNm.add(data2.get("brnd_nm").getAsString());
                    brndInfo.add(brndIdNm);
                    if (dto.getMaker().contains((CharSequence)((List)brndInfo.get(i)).get(1))) {
                        brand_id = (String)((List)brndInfo.get(i)).get(0);
                        break;
                    }
                    ++i;
                }
                return brand_id;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \ube0c\ub79c\ub4dc \uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Notice(LotteOnProductDto.ProductRequest.SpdLst spd, ShopLotteOnAdditionalDto dtllist, ShopProductDto dto) throws Exception {
        try {
            spd.sbjPstTitUseYn = dtllist.getSbjPstTitUseYn();
            spd.btcAppSetYn = dtllist.getBtcAppSetYn();
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo pdItmsInfo = new LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst> pdItmsArtlLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst>();
            List<ShopProdAttrnmDto> lotteonProductAttrList = ShopProductDao.get().getProductLotteOnNotice(dto.getProp1_cd(), "shop0372");
            pdItmsInfo.pdItmsRegWay = "NEW";
            pdItmsInfo.pdItmsCd = lotteonProductAttrList.get(0).getAttrcd();
            pdItmsInfo.pdTempletCd = "";
            for (ShopProdAttrnmDto lotteonProduct : lotteonProductAttrList) {
                LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst pdItmsArtl = new LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst();
                ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(lotteonProduct.getAttrvl())).findAny().orElse(null);
                pdItmsArtl.pdItmsCd = lotteonProduct.getAttrcd();
                pdItmsArtl.pdArtlCd = lotteonProduct.getColseq();
                if (dtllist.getBtcAppSetYn().equals("Y")) {
                    pdItmsArtl.pdArtlCnts = "\uc0c1\ud488\uc0c1\uc138\ucc38\uc870";
                } else if (shopProdAttrnmDtos != null) {
                    if (shopProdAttrnmDtos.getProp_val().equals("")) {
                        shopProdAttrnmDtos.setProp_val("\uc0c1\ud488\uc0c1\uc138\ucc38\uc870");
                    }
                    pdItmsArtl.pdArtlCnts = shopProdAttrnmDtos.getProp_val();
                } else {
                    pdItmsArtl.pdArtlCnts = "\uc0c1\ud488\uc0c1\uc138\ucc38\uc870";
                }
                pdItmsArtlLst.add(pdItmsArtl);
            }
            pdItmsInfo.pdItmsArtlLst = pdItmsArtlLst;
            spd.pdItmsInfo = pdItmsInfo;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uace0\uc2dc\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void BasicShipping(ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            spd.dmstOvsDvDvsCd = dtllist.getDmstOvsDvDvsCd();
            spd.pstkYn = "N";
            spd.dvProcTypCd = dtllist.getDvProcTypCd();
            String[] spl = dtllist.getDvPdTypCd().split("%%");
            spd.dvPdTypCd = spl[0];
            spd.sndBgtNday = Integer.parseInt(spl[1]);
            LotteOnProductDto.ProductRequest.SpdLst.SndBgtDdInfo BgtDdInfo = new LotteOnProductDto.ProductRequest.SpdLst.SndBgtDdInfo();
            BgtDdInfo.nldySndCloseTm = dtllist.getNldySndCloseTm();
            BgtDdInfo.satSndPsbYn = dtllist.getSatSndPsbYn();
            if (dtllist.getSatSndPsbYn().equals("Y")) {
                BgtDdInfo.satSndCloseTm = dtllist.getSatSndCloseTm();
            }
            spd.sndBgtDdInfo = BgtDdInfo;
            spd.cmbnDvPsbYn = dtllist.getCmbnDvPsbYn();
            spd.dvRgsprGrpCd = dtllist.getDvRgsprGrpCd();
            spd.dvRgsprGrpCd = dtllist.getDvRgsprGrpCd();
            spd.dvMnsCd = dtllist.getDvMnsCd();
            spd.owhpNo = dtllist.getOwhpNo();
            spd.hdcCd = dtllist.getHdcCd();
            spd.dvCstPolNo = dtllist.getDvCstPolNo();
            spd.adtnDvCstPolNo = dtllist.getAdtnDvCstPolNo();
            spd.cmbnDvPsbYn = dtllist.getCmbnDvPsbYn();
            spd.dvCstStdQty = dtllist.getDvCstStdQty();
            spd.qckDvUseYn = dtllist.getQckDvUseYn();
            spd.crdayDvPsbYn = dtllist.getCrdayDvPsbYn();
            if (dtllist.getCrdayDvPsbYn().equals("Y")) {
                spd.crdayDvInfo = new LotteOnProductDto.ProductRequest.SpdLst.CrdayDvInfo();
                spd.crdayDvInfo.odCloseTm = dtllist.getOdCloseTm();
            }
            spd.hpDdDvPsbYn = dtllist.getHpDdDvPsbYn();
            spd.saveTypCd = dtllist.getSaveTypCd();
            spd.rtngPsbYn = dtllist.getRtngPsbYn();
            spd.xchgPsbYn = dtllist.getXchgPsbYn();
            spd.echgPsbYn = dtllist.getEchgPsbYn();
            spd.cmbnRtngPsbYn = dtllist.getCmbnRtngPsbYn();
            spd.rtngHdcCd = dtllist.getRtngHdcCd();
            spd.rtngRtrvPsbYn = dtllist.getRtngRtrvPsbYn();
            spd.rtrpNo = dtllist.getRtrpNo();
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ubc30\uc1a1\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String productRegSend(String json, ShoppingMallDetailDto shoppingMallDetailDto, String url) throws Exception {
        String code = "";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject result = (JsonObject)parser.parse(response.body().string());
                if (result.get("returnCode").getAsString().equals("0000")) {
                    JsonArray data2 = (JsonArray)result.get("data");
                    JsonObject returnData = (JsonObject)data2.get(0);
                    if (returnData.get("resultCode").getAsString().equals("9999")) {
                        throw new Exception(returnData.get("resultMessage").getAsString());
                    }
                    if (data2.size() > 0) {
                        JsonObject data1 = (JsonObject)data2.get(0);
                        code = data1.get("spdNo").getAsString();
                    }
                } else {
                    String erMessage2 = result.get("message").getAsString();
                    throw new Exception(erMessage2);
                }
                return code;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\ub86f\ub370\uc628 \uc0c1\ud488\ub4f1\ub85d \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
    }

    private List<ShopProductOptionDto> getMallItemInfo(ShopProductDto prodInfo, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        ArrayList<ShopProductOptionDto> ItemList2 = new ArrayList<ShopProductOptionDto>();
        String URL2 = "/v1/openapi/product/v1/product/detail";
        String cusNo = shoppingMallDetailDto.getAuthkey1();
        String Json = "{\"trGrpCd\":\"SR\",\"trNo\":\"" + cusNo + "\",\"spdNo\":\"" + prodInfo.getShopprodno() + "\"}";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)Json);
        Request request2 = new Request.Builder().url(Host.concat(URL2)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var11_12 = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject result = (JsonObject)parser.parse(response.body().string());
                if (result.get("returnCode").getAsString().equals("0000")) {
                    ShopProdInDto prodIn = ShopProductDao.get().getShopSaleProductInfo(prodInfo.getCompayny_goods_cd(), prodInfo.getShopcd());
                    JsonObject data2 = (JsonObject)result.get("data");
                    JsonArray itmLst = (JsonArray)data2.get("itmLst");
                    int i = 0;
                    while (i < itmLst.size()) {
                        JsonObject itm = (JsonObject)itmLst.get(i);
                        ShopProductOptionDto dto = new ShopProductOptionDto();
                        dto.setSendseq(prodIn.getSendseq());
                        dto.setSkuseq(i + 1);
                        dto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                        dto.setShopprodno(prodInfo.getShopprodno());
                        dto.setShopprodsku(String.valueOf(itm.get("sitmNo")).split("_")[1].replace("\"", ""));
                        dto.setShopprodsku_nm(prodInfo.getGoods_nm());
                        dto.setProdseq(Integer.parseInt(prodInfo.getProdseq()));
                        dto.setOptprodcd(prodInfo.getCompayny_goods_cd().concat("-").concat(Integer.toString(i + 1)));
                        dto.setOptprodnm(this.shopOptionDtos.get(0).getName());
                        dto.setOptspecdes(itm.get("sitmNm").getAsString().replace(" / ", ":"));
                        dto.setOptsafestock(itm.get("slPrc").getAsString());
                        dto.setOptvertstock(itm.get("stkQty").getAsString());
                        dto.setOptaddamt(0);
                        dto.setInsertdt(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setInsertid(YDMASessonUtil.getCompnoInfo().getUserId());
                        ItemList2.add(dto);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc744 \uc0c1\uc138\uc870\ud68c\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ItemList2;
    }

    private List<ShopAddProdInDto> getShopAddProdInfo(ShopProductDto prodInfo, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        ArrayList<ShopAddProdInDto> shopAddProdIn = new ArrayList<ShopAddProdInDto>();
        String URL2 = "/v1/openapi/product/v1/product/detail";
        String cusNo = shoppingMallDetailDto.getAuthkey1();
        String Json = "{\"trGrpCd\":\"SR\",\"trNo\":\"" + cusNo + "\",\"spdNo\":\"" + prodInfo.getShopprodno() + "\"}";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)Json);
        Request request2 = new Request.Builder().url(Host.concat(URL2)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject result = (JsonObject)parser.parse(response.body().string());
                if (result.get("returnCode").getAsString().equals("0000")) {
                    ShopProdInDto prodIn = ShopProductDao.get().getShopSaleProductInfo(prodInfo.getCompayny_goods_cd(), prodInfo.getShopcd());
                    JsonObject data2 = (JsonObject)result.get("data");
                    JsonObject adtnPdInfo = data2.get("adtnPdInfo").getAsJsonObject();
                    JsonArray adtnTypeLst = adtnPdInfo.get("adtnTypeLst").getAsJsonArray();
                    int idx = 1;
                    int i = 0;
                    while (i < adtnTypeLst.size()) {
                        JsonObject adtnType = adtnTypeLst.get(i).getAsJsonObject();
                        JsonArray adtnPdLst = adtnType.get("adtnPdLst").getAsJsonArray();
                        int j = 0;
                        while (j < adtnPdLst.size()) {
                            ShopAddProdInDto shopAddProd = new ShopAddProdInDto();
                            JsonObject adtnPd = adtnPdLst.get(j).getAsJsonObject();
                            shopAddProd.setSendseq(prodIn.getSendseq());
                            shopAddProd.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                            shopAddProd.setProdseq(Integer.parseInt(prodInfo.getProdseq()));
                            shopAddProd.setShopprodno(prodInfo.getShopprodno());
                            shopAddProd.setSkuseq(idx++);
                            shopAddProd.setShop_prod_code(adtnPd.get("adtnTypNo").getAsString().concat(":").concat(adtnPd.get("adtnPdNo").getAsString()));
                            shopAddProd.setUser_code(adtnPd.get("epdNo").isJsonNull() ? "" : adtnPd.get("epdNo").getAsString());
                            shopAddProd.setProd_val1(adtnType.get("adtnTypNm").getAsString());
                            shopAddProd.setProd_val2(adtnPd.get("adtnPdNm").getAsString());
                            shopAddProd.setProd_amt(adtnPd.get("slPrc").getAsInt());
                            shopAddProd.setProd_cnt(adtnPd.get("stkQty").getAsInt());
                            shopAddProd.setInsertdt(YDMATimeUtil.getCurrentTimeByYDFormat());
                            shopAddProd.setInsertid(YDMASessonUtil.getCompnoInfo().getUserId());
                            shopAddProdIn.add(shopAddProd);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uc0c1\ud488\uc744 \uc0c1\uc138\uc870\ud68c\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return shopAddProdIn;
    }

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopLotteOnAdditionalDto dtllist = null;
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        dtllist = (ShopLotteOnAdditionalDto)sendProdList.getProductAdditionDto();
        double mod = 0.0;
        double rate = 0.0;
        try {
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                this.imageDelete = new ArrayList<String>();
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String matched = IProduct.findFirstForbiddenKeyword(dto, shoppingMallDetailDto.getForbiddenKeywords());
                        if (matched != null) {
                            throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, dto.getGoods_nm(), dto.getGoods_search()));
                        }
                        String spdNo = LotteOnExitsProductCd.get().getisExistsProdNo(shoppingMallDetailDto, dto);
                        if (!spdNo.equals("")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        ArrayList<String> strImages = new ArrayList();
                        ImageTransformParams params = new ImageTransformParams();
                        params.setShopProductDto(dto);
                        params.setChangesize(dtllist.getChangesize());
                        params.setChangeSizeX(dtllist.getChangeSizeX());
                        params.setChangeSizeY(dtllist.getChangeSizeY());
                        params.setChangeSizeW(dtllist.getChangeSizeW());
                        params.setChangeSizeH(dtllist.getChangeSizeH());
                        params.setAngle(dtllist.getAngle());
                        params.setScalePercent(dtllist.getScalePercent());
                        params.setImgThreeOnFour(dtllist.getImgThreeOnFour());
                        params.setRemoveImgTextYN("");
                        params.setMirrorImgYN(dtllist.getMirrorImgYN());
                        params.setImageresize("");
                        params.setImageresize1("");
                        UnifiedUploadManager manager = new UnifiedUploadManager();
                        strImages = manager.processAndUploadImages(params);
                        this.imageDelete = strImages;
                        String json = this.setProductReg(dto, dtllist, shoppingMallDetailDto, strImages);
                        if (dto.getResult_code().equals("1")) {
                            List<ShopAddProdInDto> shopAddProdInList;
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            String message = shoppingMallDetailDto.getShopnm() + "\uc5d0 \uc0c1\ud488\uc774 \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. [" + dto.getShopprodno() + "]";
                            workMngDetailDto.setMessage(message);
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(message);
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                            WorkMngDao.get().saveProdLog(dto, json);
                            if (this.shopOptionDtos.size() > 0) {
                                Thread.sleep(1000L);
                                List<ShopProductOptionDto> ItemList2 = this.getMallItemInfo(dto, shoppingMallDetailDto);
                                if (ItemList2.size() > 0) {
                                    WorkMngDao.get().insertOptprodin(ItemList2);
                                }
                            }
                            if (this.addProdList.size() > 0 && (shopAddProdInList = this.getShopAddProdInfo(dto, shoppingMallDetailDto)).size() > 0) {
                                ShopProductDao.get().insertAddProdIn(shopAddProdInList);
                            }
                        } else {
                            this.setErrorMessage(dto.getResult_text());
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        String errorMessage = "";
                        if (!dto.getResult_text().equals("")) {
                            errorMessage = this.setErrorMessage(dto.getResult_text());
                        }
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(errorMessage.equals("") ? e.getMessage() : errorMessage);
                        dto.setResult_code("-1");
                        dto.setResult_text(errorMessage.equals("") ? e.getMessage() : errorMessage);
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    if (!conf.getSaveproductlogyn().equals("Y")) continue;
                    ArrayList<String> sendList = new ArrayList<String>();
                    sendList.add(uuid);
                    sendList.add(dto.getShopcd());
                    sendList.add(shoppingMallDetailDto.getShopnm());
                    sendList.add(dto.getShopseq());
                    sendList.add(shoppingMallDetailDto.getShoppingid());
                    sendList.add(shoppingMallDetailDto.getNicknm1());
                    sendList.add(workMngDetailDto.getSeq());
                    sendList.add(dto.getCompayny_goods_cd());
                    sendList.add(workMngDetailDto.getStatus());
                    sendList.add(workMngDetailDto.getMessage());
                    sendList.add(dtllist.getSeq());
                    sendList.add(dtllist.getTitle());
                    sendList.add(dtllist.getImgOneOnOne());
                    sendList.add(String.valueOf(dtllist.getSellerDc()));
                    sendList.add(String.valueOf(dtllist.getMargin()));
                    sendList.add(String.valueOf(dtllist.getCommission()));
                    sendList.add(dtllist.getChangeSizeX());
                    sendList.add(dtllist.getChangeSizeY());
                    sendList.add(dtllist.getChangeSizeW());
                    sendList.add(dtllist.getChangeSizeH());
                    sendList.add(String.valueOf(dtllist.getAngle()));
                    sendList.add(String.valueOf(dtllist.getScalePercent()));
                    sendList.add(dtllist.getMirrorImgYN());
                    sendList.add(dto.getGoods_keyword());
                    sendList.add(dto.getClass_cd3());
                    sendList.add(dto.getClass_nm1());
                    sendList.add(YDMATimeUtil.getCurrentTimeByYDFormat());
                    sendList.add(dto.getGoods_cost());
                    sendList.add(dto.getDelv_cost());
                    sendList.add(dto.getGoods_search());
                    sendList.add("0");
                    WorkmgrlogDao.get().insertWorkLog(sendList);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private String setErrorMessage(String error) {
        Object errorMessage = "";
        errorMessage = error.contains("\uc0c1\ud488\uba85\uc5d0 \uc0ac\uc6a9 \uc81c\ud55c\ub41c \ub2e8\uc5b4") || error.contains("\uc0c1\ud488\uba85\uc5d0 \uc785\ub825\uc774 \ubd88\uac00\ub2a5\ud55c \ubb38\uc790") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \ud574\ub2f9 \ubb38\uc790 \uc785\ub825\ubd88\uac00] " + error : (error.contains("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc2b5") || error.contains("\uce74\ud14c\uace0\ub9ac\ub97c \ubaa8\ub450 \uc120\ud0dd") || error.contains("\uad8c\ud55c\uc774 \ud544\uc694\ud55c \uce74\ud14c\uace0\ub9ac") || error.contains("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc2b5") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ubd88\uc77c\uce58 \ubc0f \uc5c6\uc74c] " + error : (error.contains("\uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc") || error.contains("\ub4f1\ub85d \ubd88\uac00 \ud0a4\uc6cc\ub4dc") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\ud574\ub2f9 \ud0a4\uc6cc\ub4dc \uc785\ub825\ubd88\uac00] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error));
        return errorMessage;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }
}

