/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ownerclan;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.ownerclan.IShopOrderOwnerClanCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class OwnerClanLiteOrderCommand
extends IShopOrderOwnerClanCommand {
    private static IShopOrderCommand instance = new OwnerClanLiteOrderCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    OwnerClanLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        if (dto.getSpecificStatus().equals("\uad6c\ub9e4\ud655\uc815")) {
            return retList;
        }
        String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        this.getOrderLite(dto, retList, startdt, enddt, cookies);
        return retList;
    }

    private void getOrderLite(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end, Map<String, String> cookies) throws Exception {
        Object body = "";
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B1%5D=N&s_check=rn&search=&x=25&y=8&searchtype=";
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B2%5D=S&s_check=rn&search=&x=20&y=11&searchtype=";
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B3%5D=Y&s_check=rn&search=&x=16&y=6&searchtype=";
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B8%5D=Y&s_check=rn&search=&x=17&y=16&searchtype=";
                break;
            }
            case "\ucde8\uc18c": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B5%5D=D&deli_gbn%5B4%5D=C&s_check=rn&search=&x=20&y=10&searchtype=";
                break;
            }
            case "\ubc18\ud488": {
                body = this.getCommonBody(start, end) + "&deli_gbn%5B6%5D=B&deli_gbn%5B9%5D=B&deli_gbn%5B7%5D=Z&s_check=rn&search=&x=12&y=9&searchtype=";
                break;
            }
            case "\uad50\ud658": {
                body = this.getCommonBody(start, end) + "deli_gbn%5B11%5D=B&deli_gbn%5B12%5D=B&deli_gbn%5B13%5D=Z&s_check=rn&search=&x=16&y=11&searchtype=";
            }
        }
        this.getNewOrder(dto, retList, cookies, (String)body);
    }

    private void getNewOrder(ShopOrderMstNewDto ordDto, List<ShopOrderMstNewDto> retList, Map<String, String> cookies, String body) throws Exception {
        try {
            Connection.Response rs = Jsoup.connect((String)"https://ownerclan.com/vender/order_list.php").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(body).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("[class='trRow']");
            if (data2 == null) {
                return;
            }
            String commonStartSelector = "body > table > tbody > tr > td > table > tbody >";
            String commonEndSelecotr = "> td > table > tbody > tr";
            String deliveryBoxSelector = " tr:nth-child(28) > td > table > tbody > tr > td > table > tbody > tr:nth-child(3) > td > table:nth-child(1) > tbody > tr ";
            String formatUrl = "https://ownerclan.com/vender/order_detail.php?ordercode=%s&nostatus=Y";
            int i = 0;
            while (i < data2.size()) {
                String orderId = ((Element)data2.get(i)).attr("name").substring(3);
                rs = Jsoup.connect((String)String.format(formatUrl, orderId)).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                doc = Jsoup.parseBodyFragment((String)rs.body());
                Elements orderHistory = doc.select(commonStartSelector + " tr:nth-child(15) " + commonEndSelecotr);
                Elements orderProductInfo = doc.select(commonStartSelector + " tr:nth-child(19) > td > table tbody > tr:nth-child(2)");
                Elements deliInfo = doc.select(commonStartSelector + deliveryBoxSelector + commonEndSelecotr);
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_status(this.SetOrderStatus(orderHistory.select("tr:nth-of-type(1) > td:nth-of-type(2)").text()));
                dto.setOrder_date(this.getOrderDate(orderHistory));
                dto.setDelv_msg(deliInfo.select("tr:nth-of-type(4) > td:nth-of-type(1)").text());
                dto.setSale_cnt(orderProductInfo.select("td:nth-child(6)").text());
                dto.setShopid(ordDto.getShopid());
                dto.setShop_userid(ordDto.getShop_userid());
                String receiveName = deliInfo.select("tr:nth-child(1) > td:nth-of-type(1)").text();
                receiveName = receiveName.substring(0, receiveName.indexOf("("));
                dto.setReceive_name(receiveName);
                dto.setMall_product_id(orderProductInfo.select("td:nth-child(2)").text());
                dto.setCompayny_goods_cd(orderProductInfo.select("td:nth-child(2)").text());
                String productName = orderProductInfo.select("td:nth-child(3)").text().replace("\uc218\uc815", "");
                dto.setP_product_name(productName);
                String optionValue1 = orderProductInfo.select("td:nth-child(4)").text();
                String optionValue2 = orderProductInfo.select("td:nth-child(5)").text();
                String optionValue = optionValue2.equals("") ? optionValue1 : optionValue1 + "," + optionValue2;
                dto.setP_sku_value(optionValue);
                dto.setWon_cost("0");
                dto.setMall_won_cost(orderHistory.select("tr:nth-of-type(4) > td:nth-of-type(1)").text().replaceAll("[^0-9]", ""));
                dto.setSale_cost(orderProductInfo.select("td:nth-child(7)").text().replace(",", ""));
                String deleveryfee = orderHistory.select("tr:nth-of-type(3) > td:nth-of-type(2)").text().replaceAll("[^0-9]", "");
                String deliveryMethod = orderHistory.select("tr:nth-of-type(3) > td:nth-of-type(2)").text();
                deliveryMethod = deliveryMethod.substring(deliveryMethod.indexOf("(") + 1, deliveryMethod.indexOf(")"));
                dto.setDelv_cost(deleveryfee);
                if (deliveryMethod.equals("\uc120\ubd88") && deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                } else {
                    dto.setDelivery_method_str2(deliveryMethod);
                }
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setTotal_cost(orderHistory.select("tr:nth-of-type(3) > td:nth-of-type(1)").text().replaceAll("[^0-9]", ""));
                dto.setPay_cost(orderHistory.select("tr:nth-of-type(4) > td:nth-of-type(1)").text().replaceAll("[^0-9]", ""));
                dto.setProduct_id("");
                dto.setCompno(ordDto.getCompno());
                dto.setOrder_id(orderId);
                dto.setUser_id("");
                dto.setUser_name(deliInfo.select("tr:nth-child(1) > td:nth-child(2)").text());
                dto.setUser_tel(deliInfo.select("tr:nth-child(2) > td:nth-child(4)").text());
                dto.setUser_cel(deliInfo.select("tr:nth-child(2) > td:nth-child(4)").text());
                dto.setUser_email("");
                dto.setReceive_tel(deliInfo.select("tr:nth-child(2) > td:nth-child(4)").text());
                dto.setReceive_cel(deliInfo.select("tr:nth-child(2) > td:nth-child(4)").text());
                dto.setReceive_email("");
                dto.setReceive_zipcode(deliInfo.select("tr:nth-child(3) > td:nth-child(2)").text().split(":")[0].replace("[", "").replace("]", ""));
                dto.setReceive_addr(deliInfo.select("tr:nth-child(3) > td:nth-child(2)").text().split(":")[1].trim());
                dto.setProduct_name(orderProductInfo.select("td:nth-child(2) > span").text());
                dto.setBox_ea("0");
                dto.setSku_value(optionValue);
                dto.setMall_exp_cd("0");
                dto.setAuthkey1(ordDto.getAuthkey1());
                dto.setResult_code("1");
                retList.add(dto);
                i += 2;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String getOrderDate(Elements ele) {
        Object orderDate = ele.select("tr:nth-of-type(2) > td:nth-of-type(1)").text().replace("/", "-");
        orderDate = ((String)orderDate).substring(0, 11) + ((String)orderDate).substring(12, 14) + ":" + ((String)orderDate).substring(15, 17) + ":00";
        return orderDate;
    }

    private String SetOrderStatus(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        switch (text) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return "100";
            }
            case "\ubc30\uc1a1\uc900\ube44": {
                return "100";
            }
            case "\ubc30\uc1a1\uc911": {
                return "403";
            }
        }
        if (text.contains("\ucde8\uc18c\uc694\uccad")) {
            return "C01";
        }
        if (text.contains("\uc8fc\ubb38\ucde8\uc18c")) {
            return "C02";
        }
        if (text.contains("\ubc18\ud488\uc694\uccad") || text.contains("\ubc18\ud488\uc9c4\ud589")) {
            return "R01";
        }
        if (text.contains("\ubc18\ud488\uc644\ub8cc")) {
            return "R02";
        }
        if (text.contains("\uad50\ud658\uc694\uccad") || text.contains("\uad50\ud658\uc9c4\ud589")) {
            return "E01";
        }
        if (text.contains("\uad50\ud658\uc644\ub8cc")) {
            return "E02";
        }
        if (text.contains("\ubc30\uc1a1\uc644\ub8cc")) {
            return "410";
        }
        return "";
    }

    private String getCommonBody(String start, String end) {
        StringBuffer body = new StringBuffer();
        body.append("code=&excel_type=&gbn_mode=&deli_gbn3=&deli_gbnr=&orderby=b.ordercode+DESC&orderbyWhere=b.ordercode+DESC&search_start=");
        body.append(start);
        body.append("&search_end=");
        body.append(end);
        return body.toString();
    }
}

