/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TossShoppingOrderNewCommand
extends IShopOrderTossShoppingCommand {
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private static IShopOrderCommand instance = new TossShoppingOrderNewCommand();
    JsonParser parser = new JsonParser();
    IShopCommonLogin is = new IShopCommonLogin(){};

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 30 == 0 ? (int)range / 30 : (int)range / 30 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            enddt = formatter.format(cal2.getTime());
        }
        int i = 0;
        while (i < num) {
            this.getNewOrder(dto, retList, startdt, enddt);
            cal1.add(5, 30);
            startdt = formatter.format(cal1.getTime());
            if (i == num - 2) {
                enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            } else {
                cal2.add(5, 30);
                enddt = formatter.format(cal2.getTime());
            }
            ++i;
        }
        return retList;
    }

    public void getNewOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        Map<Object, Object> cookies = new HashMap();
        try {
            cookies = this.is.getTossCookies(dto.getShop_userid(), dto.getShopPw());
            String[] orderStatus = this.resolveOrderStatus(dto);
            String strParam = "";
            JsonObject body = new JsonObject();
            JsonObject successObject = new JsonObject();
            JsonArray results = new JsonArray();
            String url = "https://api-public.toss.im/api-public/v1/shopping-order/order/histories/paging";
            int cursor = 0;
            int i = 0;
            while (i < orderStatus.length) {
                boolean isContinue = true;
                int page = 1;
                while (isContinue) {
                    strParam = this.getNewOrderStringParam(dto.getApikey(), start, end, orderStatus[i], page++, cursor);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
                    Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", "application/json");
                    for (Map.Entry<Object, Object> entry : cookies.entrySet()) {
                        requestBuilder.addHeader("Cookie", (String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    Request request2 = requestBuilder.build();
                    Object object = null;
                    Object var20_22 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        if (!response.isSuccessful()) continue;
                        String responseBody = response.body().string();
                        body = this.parser.parse(responseBody).getAsJsonObject();
                        successObject = body.getAsJsonObject("success");
                        JsonObject paging = successObject.getAsJsonObject("paging");
                        isContinue = paging.get("hasNext").getAsBoolean();
                        cursor = paging.get("cursor").getAsInt();
                        results = successObject.getAsJsonArray("results");
                        if (results.size() <= 0) continue;
                        List<ShopOrderMstDto> param = this.setData(dto, results, cookies);
                        param.forEach(d -> d.setResult_code("1"));
                        retList.addAll(param);
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                cursor = 0;
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String[] resolveOrderStatus(ShopOrderMstDto dto) {
        return new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
    }

    public String getNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus, int page, int cursor) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(false));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)page);
        json.addProperty("pageSize", (Number)200);
        json.addProperty("sortDirection", "DESC");
        if (cursor != 0) {
            json.addProperty("cursor", (Number)cursor);
        }
        return json.toString();
    }

    public List<ShopOrderMstDto> setData(ShopOrderMstDto optDto, JsonArray orderArr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Request.Builder requestBuilder = new Request.Builder().url("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/merchants/" + optDto.getApikey() + "/my-settlement-configs?&checkIsMaintenanceTime=false").get().addHeader("Content-Type", "application/json");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            requestBuilder.addHeader("Cookie", entry.getKey() + "=" + entry.getValue());
        }
        Request request2 = requestBuilder.build();
        double paymentFeeRate = 0.016;
        double salesFeeRate = 0.08;
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonObject object = (JsonObject)this.parser.parse(response.body().string());
                if (object.get("resultType").getAsString().equals("SUCCESS")) {
                    JsonObject successObject = object.get("success").getAsJsonObject();
                    paymentFeeRate = successObject.get("tossMoneyFeeRate").getAsDouble() / 100.0;
                    salesFeeRate = successObject.get("feeRate").getAsDouble() / 100.0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uacb0\uc81c \uc218\uc218\ub8cc\uc728 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\ubc23\uc0dd \uc5d0\ub7ec\uba54\uc138\uc9c0 [" + String.valueOf(e) + "]  \n \uae30\ubcf8\uac12\uc73c\ub85c \uac00\uc838\uc634");
        }
        for (JsonElement element : orderArr) {
            JsonObject orderObject = element.getAsJsonObject();
            String orderId = orderObject.get("orderId").getAsString();
            if (ShopOrderDao.get().isOrdered(orderId)) continue;
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orderId);
            dto.setMall_product_id(orderObject.get("productId").getAsString());
            dto.setMall_order_id(orderObject.get("orderProductId").getAsString());
            dto.setP_product_name(orderObject.get("productName").getAsString());
            dto.setProduct_name(orderObject.get("productName").getAsString());
            dto.setOrder_status(this.getStatus(orderObject.get("orderProductStatus").getAsString()));
            String orderDate = orderObject.get("orderedAt").getAsString().replace("T", " ");
            dto.setOrder_date(orderDate);
            dto.setUser_name(orderObject.get("ordererName").getAsString());
            dto.setUser_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setUser_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("ordererPhone").getAsString()));
            dto.setReceive_name(orderObject.get("receiverName").getAsString());
            dto.setReceive_addr(orderObject.get("address").getAsString() + " " + orderObject.get("detailAddress").getAsString());
            dto.setReceive_tel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setReceive_cel(TossShoppingOrderNewCommand.formatPhoneNumber(orderObject.get("receiverPhone").getAsString()));
            dto.setDelv_msg(orderObject.get("shippingNote").getAsString());
            dto.setSale_cnt(orderObject.get("quantity").getAsString());
            dto.setPay_cost(orderObject.get("price").getAsString());
            int saleCount = Integer.parseInt(dto.getSale_cnt());
            int payCost = Integer.parseInt(dto.getPay_cost());
            dto.setSale_cost(String.valueOf(payCost / saleCount));
            String totalCost = orderObject.get("price").getAsString();
            dto.setTotal_cost(totalCost);
            dto.setReceive_zipcode(orderObject.get("zipCode").getAsString());
            dto.setP_sku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setSku_value(orderObject.get("optionName") == null ? "" : orderObject.get("optionName").getAsString());
            dto.setShopid(optDto.getShopid());
            dto.setShop_userid(optDto.getShop_userid());
            dto.setCompno(optDto.getCompno());
            if (orderObject.get("deliveryFee").isJsonNull()) {
                dto.setDelv_cost("0");
            } else {
                dto.setDelv_cost(orderObject.get("deliveryFee").getAsString());
            }
            if (dto.getDelv_cost().equals("0")) {
                dto.setDelivery_method_str2("\ubb34\ub8cc");
            } else {
                dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
            }
            int price2 = Integer.parseInt(totalCost);
            int paymentFee = (int)Math.floor((double)price2 * paymentFeeRate);
            int paymentFeeWithVat = (int)Math.floor((double)paymentFee * 1.1);
            int salesFee = (int)Math.floor((double)price2 * salesFeeRate);
            int salesFeeWithVat = (int)Math.floor((double)salesFee * 1.1);
            int mallExpcd = price2 - paymentFeeWithVat - salesFeeWithVat;
            dto.setMall_exp_cd("0");
            dto.setMall_won_cost(String.valueOf(mallExpcd));
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setDeliveryName(this.jsonElementNullStr(orderObject.get("deliveryCompanyCode")));
            dto.setInvoice_no(this.jsonElementNullStr(orderObject.get("shippingTrackingNumber")));
            String compayny_goods_cd = "";
            compayny_goods_cd = !orderObject.has("productManagementCode") || orderObject.get("productManagementCode").isJsonNull() ? this.getCompanyGoodsCd(orderObject.get("productId").getAsString(), optDto.getShopid()) : orderObject.get("productManagementCode").getAsString();
            dto.setCompayny_goods_cd(compayny_goods_cd);
            list.add(dto);
        }
        return list;
    }

    public static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return phoneNumber;
        }
        if (phoneNumber.startsWith("02")) {
            if (phoneNumber.length() == 10) {
                return phoneNumber.replaceAll("(02)(\\d{4})(\\d{4})", "$1-$2-$3");
            }
            if (phoneNumber.length() == 9) {
                return phoneNumber.replaceAll("(02)(\\d{3})(\\d{4})", "$1-$2-$3");
            }
        }
        if (phoneNumber.length() == 11) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{4})(\\d{4})", "$1-$2-$3");
        }
        if (phoneNumber.length() == 10) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3");
        }
        if (phoneNumber.length() == 12) {
            return phoneNumber.replaceAll("(\\d{4})(\\d{4})(\\d{4})", "$1-$2-$3");
        }
        return phoneNumber;
    }

    private String getCompanyGoodsCd(String productId, String shopId) {
        String company_goods_cd = "";
        try {
            company_goods_cd = ShopCommonDao.get().getCompanyGoodsCd(productId, shopId);
        }
        catch (Exception exception) {}
        return company_goods_cd;
    }

    private String getStatus(String string) {
        String status2 = "";
        switch (string) {
            case "\uc0c1\ud488\uc900\ube44\uc911": 
            case "\uacb0\uc81c\uc644\ub8cc": 
            case "\ubc1c\uc1a1\uc9c0\uc5f0": {
                status2 = "100";
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                status2 = "403";
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": 
            case "\ubc30\uc1a1\uc644\ub8cc": {
                status2 = "410";
            }
        }
        return status2;
    }
}

