/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.data.wemakeprice.ShopWemarketQuestionContext;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopWemarketQuestionSearch
extends ShopWemarketQuestionContext {
    Map<String, String> cookie;

    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        Object startDate = prodList.get(0).getStartDt().substring(0, 8);
        startDate = ((String)startDate).substring(0, 4) + "-" + ((String)startDate).substring(4, 6) + "-" + ((String)startDate).substring(6, 8);
        Object endDate = prodList.get(0).getEndDt().substring(0, 8);
        endDate = ((String)endDate).substring(0, 4) + "-" + ((String)endDate).substring(4, 6) + "-" + ((String)endDate).substring(6, 8);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse((String)startDate);
        Date edate = formatter.parse((String)endDate);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        int i = 0;
        while (i < (int)range) {
            this.getQnaAPI((String)startDate, prodList, dtoArray);
            cal1.add(5, 1);
            startDate = formatter.format(cal1.getTime());
            ++i;
        }
        return dtoArray;
    }

    private void getQnaAPI(String startDate, List<QuestListDto> prodList, List<QuestListDto> dtoArray) throws IOException {
        Connection.Response response = Jsoup.connect((String)("http://api.kdjsystem.com:8082/wemarket/api/v2/getQnaAPI?basicDate=" + startDate)).header("apiKey", prodList.get(0).getApikey()).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute();
        String body = response.body();
        if (body.contains("qnaSeq")) {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int stridx = jsonObject.get("message").getAsString().indexOf("{");
            int endidx = jsonObject.get("message").getAsString().lastIndexOf("}");
            String result = jsonObject.get("message").getAsString().substring(stridx, endidx + 1);
            JsonObject jsonObject2 = (JsonObject)jsonParser.parse(result);
            JsonArray jsonArray = (JsonArray)jsonObject2.get("data");
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject jsonObject1 = (JsonObject)jsonArray.get(i);
                    QuestListDto dto = new QuestListDto();
                    String[] customerinfo = jsonObject1.get("question").getAsString().split("\\[|[|]|\\]");
                    dto.setQnastat("100");
                    dto.setQnaseq(jsonObject1.get("qnaSeq").getAsString());
                    dto.setInsdm(jsonObject1.get("questionDate").getAsString());
                    dto.setMprodid(jsonObject1.get("productNo").getAsString());
                    dto.setInsnm(customerinfo[1]);
                    dto.setSenddt("");
                    dto.setStat("\uace0\uac1d\ubb38\uc758");
                    dto.setRegdm(YDMATimeUtil.getCurrentTime());
                    dto.setProdnm(jsonObject1.get("productName").getAsString());
                    dto.setQuests(customerinfo[3].trim());
                    dto.setShopid(prodList.get(0).getShopid());
                    dto.setShopnm(prodList.get(0).getShopnm());
                    dtoArray.add(dto);
                    ++i;
                }
            }
        }
    }

    private void getCustomerInquiry(List<QuestListDto> prodList, List<QuestListDto> dtoArray) {
        try {
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<String, String> cookies = is.loginCookie(prodList.get(0).getShopid(), prodList.get(0).getShopPw(), "shop0287", true, prodList.get(0).getAuthkey1());
            Object startDate = prodList.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + "-" + ((String)startDate).substring(4, 6) + "-" + ((String)startDate).substring(6, 8);
            Object endDate = prodList.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + "-" + ((String)endDate).substring(4, 6) + "-" + ((String)endDate).substring(6, 8);
            Connection.Response rs = Jsoup.connect((String)("https://backoffice-gateway.wemakeprice.com/api/board/v2/wtalk/partner/chats?startDate=" + (String)startDate + "&endDate=" + (String)endDate + "&answerYn=&searchType=PRODUCT_NO&searchValue=&size=10&page=0&sort=UPDATED%2CDESC&pageType=OFFSET&displayYn=Y ")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://wpartner.wemakeprice.com/qna/qnaMain").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            JsonArray jsonArray = (JsonArray)jsonObject.get("data");
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject jsonObject1 = (JsonObject)jsonArray.get(i);
                    QuestListDto dto = new QuestListDto();
                    dto.setQnastat(this.getExcellFileManager(jsonObject1.get("answerYn").getAsString()));
                    dto.setQnaseq(jsonObject1.get("chatSeq").getAsString());
                    dto.setInsdm(jsonObject1.get("registerDateTime").getAsString());
                    dto.setMprodid(jsonObject1.get("productNo").getAsString());
                    dto.setInsnm(jsonObject1.get("userName").getAsString());
                    dto.setSenddt("");
                    dto.setStat("\uace0\uac1d\ubb38\uc758");
                    dto.setRegdm(YDMATimeUtil.getCurrentTime());
                    dto.setProdnm(jsonObject1.get("productName").getAsString());
                    dto.setQuests(jsonObject1.get("comment").getAsString());
                    dto.setShopid(prodList.get(0).getShopid());
                    dto.setShopnm(prodList.get(0).getShopnm());
                    dtoArray.add(dto);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getProductInquiry(List<QuestListDto> prodList, List<QuestListDto> dtoArray) {
        try {
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<String, String> cookies = is.loginCookie(prodList.get(0).getShopid(), prodList.get(0).getShopPw(), "shop0287", true, prodList.get(0).getAuthkey1());
            Object startDate = prodList.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + "-" + ((String)startDate).substring(4, 6) + "-" + ((String)startDate).substring(6, 8);
            Object endDate = prodList.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + "-" + ((String)endDate).substring(4, 6) + "-" + ((String)endDate).substring(6, 8);
            Connection.Response rs = Jsoup.connect((String)("https://backoffice-gateway.wemakeprice.com/api/board/partner/inquiries?searchStartDate=" + (String)startDate + "&searchEndDate=" + (String)endDate + "&page=0&size=10&pageType=OFFSET&sort=FREQUENCY%2CDESC&sort=CREATED%2CDESC")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://wpartner.wemakeprice.com/qna/qnaMain").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            JsonArray jsonArray = (JsonArray)jsonObject.get("data");
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject jsonObject1 = (JsonObject)jsonArray.get(i);
                    QuestListDto dto = new QuestListDto();
                    dto.setQnastat(this.getExcellFileManager(jsonObject1.get("answerYn").getAsString()));
                    dto.setQnaseq(jsonObject1.get("inquirySeq").getAsString());
                    dto.setInsdm(jsonObject1.get("registerDateTime").getAsString());
                    dto.setMprodid(jsonObject1.get("productNo").getAsString());
                    dto.setInsnm(jsonObject1.get("userName").getAsString());
                    dto.setSenddt("");
                    dto.setStat("\uc0c1\ud488\ubb38\uc758");
                    dto.setRegdm(YDMATimeUtil.getCurrentTime());
                    dto.setProdnm(jsonObject1.get("productName").getAsString());
                    dto.setQuests(jsonObject1.get("comment").getAsString());
                    dto.setShopid(prodList.get(0).getShopid());
                    dto.setShopnm(prodList.get(0).getShopnm());
                    dtoArray.add(dto);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getExcellFileManager(String status2) throws Exception {
        String value = "";
        try {
            switch (status2) {
                case "\ub2f5\ubcc0\ub300\uae30": {
                    value = "100";
                    break;
                }
                case "1": {
                    value = "101";
                    break;
                }
                case "2": {
                    value = "102";
                    break;
                }
                case "3": {
                    value = "104";
                    break;
                }
                case "\ub2f5\ubcc0\uc644\ub8cc": {
                    value = "103";
                    break;
                }
                case "false": {
                    value = "100";
                    break;
                }
                case "true": {
                    value = "103";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ubb38\uc758 \uc0c1\ud0dc\uac12\ubcc0\uacbd\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }
}

