/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jobLog;

import com.kdjsystem.mlink.shop.jobLog.JobLogDTO;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JobLogDAO {
    private static JobLogDAO instance = new JobLogDAO();

    private JobLogDAO() {
    }

    public static JobLogDAO get() {
        return instance;
    }

    public int insertJobLog(JobLogDTO dto) throws Exception {
        int result;
        block5: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO JOBLOG (  \r\n");
                    sql.append("      JOBDATE  \r\n");
                    sql.append("    , JOBTYPE  \r\n");
                    sql.append("    , JOBMAIN  \r\n");
                    sql.append("    , JOBSUB  \r\n");
                    sql.append("    , JOBDETAIL  \r\n");
                    sql.append("    , PRODCD  \r\n");
                    sql.append("    , SHOPPRODNO  \r\n");
                    sql.append("    , SHOPCD  \r\n");
                    sql.append("    , SHOPUSERID  \r\n");
                    sql.append("    , NICKNAME  \r\n");
                    sql.append("    , SHOPSEQ  \r\n");
                    sql.append("    , ORDID  \r\n");
                    sql.append("    , PRODUCTNAME  \r\n");
                    sql.append("    , OPTIONNAME  \r\n");
                    sql.append("    , SALECNT  \r\n");
                    sql.append("    , SALECOST  \r\n");
                    sql.append("    , RECEIVE_NAME  \r\n");
                    sql.append("    , JOBRESULT  \r\n");
                    sql.append("    , LOGMESSAGE  \r\n");
                    sql.append(") VALUES (  \r\n");
                    sql.append("      ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?) \r\n");
                    pstmt = connection.prepareStatement(sql.toString());
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, dto.getJobDate());
                    pstmt.setString(++rowIdx, dto.getJobType());
                    pstmt.setString(++rowIdx, dto.getJobMain());
                    pstmt.setString(++rowIdx, dto.getJobSub());
                    pstmt.setString(++rowIdx, dto.getJobDetail());
                    pstmt.setString(++rowIdx, dto.getProdCd());
                    pstmt.setString(++rowIdx, dto.getShopProdNo());
                    pstmt.setString(++rowIdx, dto.getShopCd());
                    pstmt.setString(++rowIdx, dto.getShopUserId());
                    pstmt.setString(++rowIdx, dto.getNickname());
                    pstmt.setInt(++rowIdx, dto.getShopSeq());
                    pstmt.setString(++rowIdx, dto.getOrdId());
                    pstmt.setString(++rowIdx, dto.getProductName());
                    pstmt.setString(++rowIdx, dto.getOptionName());
                    pstmt.setInt(++rowIdx, dto.getSaleCnt());
                    pstmt.setInt(++rowIdx, dto.getSaleCost());
                    pstmt.setString(++rowIdx, dto.getReceiveName());
                    pstmt.setString(++rowIdx, dto.getJobResult());
                    pstmt.setString(++rowIdx, dto.getLogMessage());
                    YDMAStringUtil.Print("[insertJobLog]" + pstmt.toString());
                    result = pstmt.executeUpdate();
                }
                catch (Exception ex) {
                    System.err.println("[insertJobLog] \ub85c\uadf8 \uc800\uc7a5 \uc2e4\ud328: " + ex.getMessage());
                    ex.printStackTrace();
                    result = 0;
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return result;
    }

    public List<JobLogDTO> selectJobLog(String prodType, String prodCd, String jobMain, String jobSub, String shopCd, String shopUserId, String startDate, String endDate, String jobResult, String matchType) throws Exception {
        ArrayList<JobLogDTO> list;
        block30: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            list = new ArrayList<JobLogDTO>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuilder sql = new StringBuilder();
                    sql.append("SELECT \r\n");
                    sql.append("IFNULL(SEQ,  0) AS SEQ, \r\n");
                    sql.append("IFNULL(JOBTYPE,  '') AS JOBTYPE, \r\n");
                    sql.append("IFNULL(JOBDATE,  '') AS JOBDATE, \r\n");
                    sql.append("IFNULL(JOBMAIN,  '') AS JOBMAIN, \r\n");
                    sql.append("IFNULL(JOBSUB,  '') AS JOBSUB, \r\n");
                    sql.append("IFNULL(JOBDETAIL,  '') AS JOBDETAIL, \r\n");
                    sql.append("IFNULL(PRODCD,  '') AS PRODCD, \r\n");
                    sql.append("IFNULL(SHOPCD,  '') AS SHOPCD, \r\n");
                    sql.append("IFNULL(SHOPUSERID,  '') AS SHOPUSERID, \r\n");
                    sql.append("IFNULL(NICKNAME,  '') AS NICKNAME, \r\n");
                    sql.append("IFNULL(SHOPSEQ,  0) AS SHOPSEQ, \r\n");
                    sql.append("IFNULL(SHOPPRODNO,  '') AS SHOPPRODNO, \r\n");
                    sql.append("IFNULL(ORDID,  '') AS ORDID, \r\n");
                    sql.append("IFNULL(PRODUCTNAME,  '') AS PRODUCTNAME, \r\n");
                    sql.append("IFNULL(OPTIONNAME,  '') AS OPTIONNAME, \r\n");
                    sql.append("IFNULL(SALECNT, 0) AS SALECNT, \r\n");
                    sql.append("IFNULL(SALECOST,  0) AS SALECOST, \r\n");
                    sql.append("IFNULL(RECEIVE_NAME,  '') AS RECEIVE_NAME, \r\n");
                    sql.append("IFNULL(JOBRESULT,  '') AS JOBRESULT, \r\n");
                    sql.append("IFNULL(LOGMESSAGE,  '') AS LOGMESSAGE \r\n");
                    sql.append("FROM JOBLOG \r\n");
                    sql.append("WHERE (JOBDATE >= ? AND JOBDATE <= ?) \r\n");
                    if (prodType.equals("PRODCD") && !prodCd.equals("")) {
                        if (matchType.equals("E")) {
                            sql.append("AND PRODCD = ? \r\n");
                        } else if (matchType.equals("F")) {
                            sql.append("AND PRODCD LIKE ? \r\n");
                        }
                    }
                    if (prodType.equals("SHOPPRODNO") && !prodCd.equals("")) {
                        sql.append("AND SHOPPRODNO like ? \r\n");
                    }
                    if (!jobMain.equals("")) {
                        sql.append("AND JOBMAIN = ? \r\n");
                        if (jobMain.contains(",")) {
                            sql.append("AND JOBMAIN = ? \r\n");
                        }
                    }
                    if (jobSub != null && !jobSub.trim().isEmpty()) {
                        String[] parts = jobSub.split(",");
                        sql.append("AND (");
                        int i = 0;
                        while (i < parts.length) {
                            if (i > 0) {
                                sql.append(" OR ");
                            }
                            sql.append("JOBSUB LIKE ? ");
                            ++i;
                        }
                        sql.append(") \r\n");
                    }
                    if (!shopCd.equals("")) {
                        sql.append("AND SHOPCD = ? \r\n");
                        if (!shopUserId.equals("")) {
                            sql.append("AND SHOPUSERID = ? \r\n");
                        }
                    }
                    if (!jobResult.equals("")) {
                        sql.append("AND JOBRESULT = ? \r\n");
                    }
                    sql.append("ORDER BY JOBDATE DESC \r\n");
                    pstmt = connection.prepareStatement(sql.toString());
                    int idx = 1;
                    pstmt.setString(idx++, startDate);
                    pstmt.setString(idx++, endDate);
                    if (prodType.equals("PRODCD") && !prodCd.equals("")) {
                        if (matchType.equals("E")) {
                            pstmt.setString(idx++, prodCd);
                        } else if (matchType.equals("F")) {
                            pstmt.setString(idx++, "%" + prodCd + "%");
                        }
                    }
                    if (prodType.equals("SHOPPRODNO") && !prodCd.equals("")) {
                        pstmt.setString(idx++, "%" + prodCd + "%");
                    }
                    if (!jobMain.equals("")) {
                        pstmt.setString(idx++, jobMain);
                    }
                    if (jobSub != null && !jobSub.trim().isEmpty()) {
                        String[] parts;
                        String[] stringArray = parts = jobSub.split(",");
                        int n = parts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String part = stringArray[n2];
                            pstmt.setString(idx++, part.trim() + "%");
                            ++n2;
                        }
                    }
                    if (!shopCd.equals("")) {
                        pstmt.setString(idx++, shopCd);
                        if (!shopUserId.equals("")) {
                            pstmt.setString(idx++, shopUserId);
                        }
                    }
                    if (!jobResult.equals("")) {
                        pstmt.setString(idx++, jobResult);
                    }
                    YDMAStringUtil.Print("[selectJobLog]" + pstmt.toString());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        JobLogDTO dto = new JobLogDTO();
                        dto.setSeq(rs.getInt("SEQ"));
                        dto.setJobDate(rs.getString("JOBDATE"));
                        dto.setJobType(rs.getString("JOBTYPE"));
                        dto.setJobMain(rs.getString("JOBMAIN"));
                        dto.setJobSub(rs.getString("JOBSUB"));
                        dto.setJobDetail(rs.getString("JOBDETAIL"));
                        dto.setProdCd(rs.getString("PRODCD"));
                        dto.setShopCd(rs.getString("SHOPCD"));
                        dto.setShopUserId(rs.getString("SHOPUSERID"));
                        dto.setNickname(rs.getString("NICKNAME"));
                        dto.setShopSeq(rs.getInt("SHOPSEQ"));
                        dto.setShopProdNo(rs.getString("SHOPPRODNO"));
                        dto.setOrdId(rs.getString("ORDID"));
                        dto.setProductName(rs.getString("PRODUCTNAME"));
                        dto.setOptionName(rs.getString("OPTIONNAME"));
                        dto.setSaleCnt(rs.getInt("SALECNT"));
                        dto.setSaleCost(rs.getInt("SALECOST"));
                        dto.setReceiveName(rs.getString("RECEIVE_NAME"));
                        dto.setJobResult(rs.getString("JOBRESULT"));
                        dto.setLogMessage(rs.getString("LOGMESSAGE"));
                        list.add(dto);
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    System.err.println("[selectJobLog] \ub85c\uadf8 \uc870\ud68c \uc2e4\ud328: " + ex.getMessage());
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block30;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return list;
    }

    public int insertJobLogBatch(List<JobLogDTO> logList) throws Exception {
        int resultCount;
        block11: {
            PreparedStatement pstmt;
            Connection connection;
            block12: {
                resultCount = 0;
                connection = null;
                pstmt = null;
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO JOBLOG (  \r\n");
                sql.append("      JOBDATE  \r\n");
                sql.append("    , JOBTYPE  \r\n");
                sql.append("    , JOBMAIN  \r\n");
                sql.append("    , JOBSUB  \r\n");
                sql.append("    , JOBDETAIL  \r\n");
                sql.append("    , PRODCD  \r\n");
                sql.append("    , SHOPPRODNO  \r\n");
                sql.append("    , SHOPCD  \r\n");
                sql.append("    , SHOPUSERID  \r\n");
                sql.append("    , NICKNAME  \r\n");
                sql.append("    , SHOPSEQ  \r\n");
                sql.append("    , ORDID  \r\n");
                sql.append("    , PRODUCTNAME  \r\n");
                sql.append("    , OPTIONNAME  \r\n");
                sql.append("    , SALECNT  \r\n");
                sql.append("    , SALECOST  \r\n");
                sql.append("    , RECEIVE_NAME  \r\n");
                sql.append("    , JOBRESULT  \r\n");
                sql.append("    , LOGMESSAGE  \r\n");
                sql.append(") VALUES (  \r\n");
                sql.append("      ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?  \r\n");
                sql.append("    , ?) \r\n");
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql.toString());
                    int batchCount = 0;
                    for (JobLogDTO dto : logList) {
                        int idx = 0;
                        pstmt.setString(++idx, dto.getJobDate());
                        pstmt.setString(++idx, dto.getJobType());
                        pstmt.setString(++idx, dto.getJobMain());
                        pstmt.setString(++idx, dto.getJobSub());
                        pstmt.setString(++idx, dto.getJobDetail());
                        pstmt.setString(++idx, dto.getProdCd());
                        pstmt.setString(++idx, dto.getShopProdNo());
                        pstmt.setString(++idx, dto.getShopCd());
                        pstmt.setString(++idx, dto.getShopUserId());
                        pstmt.setString(++idx, dto.getNickname());
                        pstmt.setInt(++idx, dto.getShopSeq());
                        pstmt.setString(++idx, dto.getOrdId());
                        pstmt.setString(++idx, dto.getProductName());
                        pstmt.setString(++idx, dto.getOptionName());
                        pstmt.setInt(++idx, dto.getSaleCnt());
                        pstmt.setInt(++idx, dto.getSaleCost());
                        pstmt.setString(++idx, dto.getReceiveName());
                        pstmt.setString(++idx, dto.getJobResult());
                        pstmt.setString(++idx, dto.getLogMessage());
                        pstmt.addBatch();
                        if (++batchCount % 1000 != 0) continue;
                        int[] results = pstmt.executeBatch();
                        resultCount += Arrays.stream(results).sum();
                        pstmt.clearBatch();
                    }
                    if (batchCount % 1000 != 0) {
                        int[] results = pstmt.executeBatch();
                        resultCount += Arrays.stream(results).sum();
                    }
                    connection.commit();
                }
                catch (BatchUpdateException be) {
                    System.err.println("[insertJobLogBatch] \uc77c\ubd80 \ubc30\uce58 \uc2e4\ud328: " + be.getMessage());
                    connection.rollback();
                    if (connection != null) {
                        connection.setAutoCommit(true);
                    }
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block11;
                }
                catch (Exception ex) {
                    try {
                        System.err.println("[insertJobLogBatch] \ubc30\uce58 \ub85c\uadf8 \uc800\uc7a5 \uc2e4\ud328: " + ex.getMessage());
                        if (connection != null) {
                            connection.rollback();
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            connection.setAutoCommit(true);
                        }
                        DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                        throw throwable;
                    }
                }
                if (connection == null) break block12;
                connection.setAutoCommit(true);
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return resultCount;
    }

    public String setInsertJobLog() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO JOBLOG (  \r\n");
        sql.append("      JOBDATE  \r\n");
        sql.append("    , JOBTYPE  \r\n");
        sql.append("    , JOBMAIN  \r\n");
        sql.append("    , JOBSUB  \r\n");
        sql.append("    , JOBDETAIL  \r\n");
        sql.append("    , PRODCD  \r\n");
        sql.append("    , SHOPPRODNO  \r\n");
        sql.append("    , SHOPCD  \r\n");
        sql.append("    , SHOPUSERID  \r\n");
        sql.append("    , NICKNAME  \r\n");
        sql.append("    , SHOPSEQ  \r\n");
        sql.append("    , ORDID  \r\n");
        sql.append("    , PRODUCTNAME  \r\n");
        sql.append("    , OPTIONNAME  \r\n");
        sql.append("    , SALECNT  \r\n");
        sql.append("    , SALECOST  \r\n");
        sql.append("    , RECEIVE_NAME  \r\n");
        sql.append("    , JOBRESULT  \r\n");
        sql.append("    , LOGMESSAGE  \r\n");
        sql.append(") VALUES (  \r\n");
        sql.append("      ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?  \r\n");
        sql.append("    , ?) \r\n");
        return sql.toString();
    }

    public PreparedStatement setParam(JobLogDTO dto, PreparedStatement pstmt2) throws Exception {
        int idx = 0;
        pstmt2.setString(++idx, dto.getJobDate());
        pstmt2.setString(++idx, dto.getJobType());
        pstmt2.setString(++idx, dto.getJobMain());
        pstmt2.setString(++idx, dto.getJobSub());
        pstmt2.setString(++idx, dto.getJobDetail());
        pstmt2.setString(++idx, dto.getProdCd());
        pstmt2.setString(++idx, dto.getShopProdNo());
        pstmt2.setString(++idx, dto.getShopCd());
        pstmt2.setString(++idx, dto.getShopUserId());
        pstmt2.setString(++idx, dto.getNickname());
        pstmt2.setInt(++idx, dto.getShopSeq());
        pstmt2.setString(++idx, dto.getOrdId());
        pstmt2.setString(++idx, dto.getProductName());
        pstmt2.setString(++idx, dto.getOptionName());
        pstmt2.setInt(++idx, dto.getSaleCnt());
        pstmt2.setInt(++idx, dto.getSaleCost());
        pstmt2.setString(++idx, dto.getReceiveName());
        pstmt2.setString(++idx, dto.getJobResult());
        pstmt2.setString(++idx, dto.getLogMessage());
        return pstmt2;
    }
}

