/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.tot.common.YDMAGridColumn;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class LiteOrderBulkInvoiceResultDailog
extends CommandDialog {
    String title = "\uc1a1\uc7a5 \uc5c5\ub85c\ub4dc \uacb0\uacfc";
    YDMAGridColumnList col_list = new YDMAGridColumnList();
    private List<LiteOrderBulkInvoiceResultDto> resultList = new ArrayList<LiteOrderBulkInvoiceResultDto>();
    private GridTableViewer gridTableViewer;
    private Grid grid;
    Button btn_ok = null;

    public LiteOrderBulkInvoiceResultDailog(Shell parentShell, List<ShopOrderMstNewDto> retList) {
        super(parentShell);
        this.convertShopOrderToResultList(retList);
    }

    private void convertShopOrderToResultList(List<ShopOrderMstNewDto> list) {
        String failedMessageFormat = "[%s] \uc5d0 \ud574\ub2f9\ud558\ub294 \uc8fc\ubb38\ubc88\ud638\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.";
        int i = 1;
        for (ShopOrderMstNewDto order : list) {
            String result = order.getSpecificStatus();
            LiteOrderBulkInvoiceResultDto dto = new LiteOrderBulkInvoiceResultDto();
            dto.no = i++;
            dto.invoiceInfo = String.join((CharSequence)",", order.getInvoiceInfo());
            dto.shopid = order.getShopid();
            dto.shop_userid = order.getShop_userid();
            dto.order_id = order.getOrder_id();
            dto.result = result;
            dto.resultMessage = result.equals("\uc131\uacf5") ? "\uc815\uc0c1\uc801\uc73c\ub85c \uc801\uc6a9\ub418\uc5c8\uc2b5\ub2c8\ub2e4." : String.format(failedMessageFormat, order.getInvoiceInfo().get(0));
            this.resultList.add(dto);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setGridColumns();
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout(null);
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setBounds(10, 10, 870, 387);
        this.gridTableViewer = new GridTableViewer((Composite)sashForm, 2818);
        this.grid = this.gridTableViewer.getGrid();
        this.grid.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.grid.setLinesVisible(true);
        this.grid.setLineColor(SWTResourceManager.getColor(18));
        this.grid.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setRGB(68, 80, 94);
        myHeaderRender.setFGC(1);
        for (YDMAGridColumn col : this.col_list.getColumns()) {
            GridColumn tableViewerColumn_x = new GridColumn(this.grid, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(col.getWidth());
            tableViewerColumn_x.setText(col.getText());
            tableViewerColumn_x.setAlignment(16384);
            MyCellRenderer myCellRenderer = new MyCellRenderer();
            if (col.getSeq() == 0 || col.getSeq() == 4) {
                myCellRenderer.setColumnAlign(0x1000000);
            } else {
                myCellRenderer.setColumnAlign(16384);
            }
            tableViewerColumn_x.setCellRenderer((GridCellRenderer)myCellRenderer);
        }
        sashForm.setWeights(new int[]{1});
        this.gridTableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.gridTableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.gridTableViewer.setInput(this.resultList);
        return container;
    }

    private void setGridColumns() {
        int i = 0;
        this.col_list.add(i++, "No", "No.", 35);
        this.col_list.add(i++, "test", "\uc801\uc6a9\ud558\ub824\ub294\ub0b4\uc6a9", 150);
        this.col_list.add(i++, "SHOPID", "\uc1fc\ud551\ubab0", 100);
        this.col_list.add(i++, "SHOP_USERID", "\uc1fc\ud551\ubab0ID", 100);
        this.col_list.add(i++, "ORDER_ID", "\uc8fc\ubb38\ubc88\ud638", 140);
        this.col_list.add(i++, "RESULT", "\uacb0\uacfc", 50);
        this.col_list.add(i++, "RESULTMESSAGE", "\uacb0\uacfc\uba54\uc138\uc9c0", 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_ok = this.createButton(parent, 0, "\ud655\uc778", false);
        this.btn_ok.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucc98\ub9ac\uc644\ub8cc.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("\uc1a1\uc7a5 \uacb0\uacfc");
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(900, 500);
    }

    class LiteOrderBulkInvoiceResultDto {
        private int no;
        private String invoiceInfo;
        private String shopid;
        private String shop_userid;
        private String order_id;
        private String result;
        private String resultMessage;

        LiteOrderBulkInvoiceResultDto() {
        }
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            LiteOrderBulkInvoiceResultDto dto = (LiteOrderBulkInvoiceResultDto)element;
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = String.valueOf(dto.no);
                    break;
                }
                case 1: {
                    value = dto.invoiceInfo;
                    break;
                }
                case 2: {
                    value = dto.shopid;
                    break;
                }
                case 3: {
                    value = dto.shop_userid;
                    break;
                }
                case 4: {
                    value = dto.order_id;
                    break;
                }
                case 5: {
                    value = dto.result;
                    break;
                }
                case 6: {
                    value = dto.resultMessage;
                    break;
                }
            }
            return value;
        }

        public Color getForeground(Object element, int columnIndex) {
            Color color = null;
            if (columnIndex == 6 || columnIndex == 7) {
                color = Display.getCurrent().getSystemColor(3);
            }
            return color;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

