/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.onnme;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.mlink.MLinkOption;
import com.kdjsystem.mlink.shop.mlink.MLinkOptionList;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class OnnmeOrderCommon {
    public static OnnmeOrderCommon instance = new OnnmeOrderCommon();

    private OnnmeOrderCommon() {
    }

    public static OnnmeOrderCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> getSearchOnnmeProd(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        try {
            for (ShopOrderMstDto dto : list) {
                String url = "https://onnme.com/product/search.html?banner_action=&keyword=" + dto.getCompayny_goods_cd().replaceAll("OM", "");
                driver.get(url);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"div.xans-search-result ul.prdList li.item")));
                List productElements = driver.findElements(By.cssSelector((String)"div.xans-search-result ul.prdList li.item"));
                for (WebElement productElement : productElements) {
                    WebElement thumbnailElement = productElement.findElement(By.cssSelector((String)"div.thumbnail div.normal_thumb img"));
                    WebElement descriptionElement = productElement.findElement(By.cssSelector((String)"div.description p.name a"));
                    WebElement priceElement = productElement.findElement(By.xpath((String)"/html/body/div[4]/div/div/div[3]/ul/li/div[2]/ul/li/span[1]"));
                    String imageUrl = thumbnailElement.getAttribute("src");
                    String realImageUrl = imageUrl.replace("//cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/", "//www.onnme.com//");
                    String productTitle = descriptionElement.getText();
                    String productName = productTitle.replace("\uc0c1\ud488\uba85 :", "");
                    String price2 = priceElement.getText().replaceAll("[^\\d]", "");
                    String href = descriptionElement.getAttribute("href");
                    String goodsNo = href.split("product_no=")[1].split("&")[0];
                    String domeCateNo = href.split("cate_no=")[1].split("&")[0];
                    String displayGroup = href.split("display_group=")[1];
                    dto.setOrdimg(realImageUrl);
                    dto.setDsGoods_cost(price2);
                    dto.setProduct_name(productName);
                    dto.setGoodsNo(goodsNo);
                    dto.setGoods_keyword("shop9987");
                    String productDetailUrl = "https://onnme.com/product/detail.html?product_no=" + dto.getGoodsNo() + "&cate_no=" + domeCateNo + "&display_group=" + displayGroup;
                    driver.get(productDetailUrl);
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[@id='prdOptionTable']")));
                    List optionTables = driver.findElements(By.xpath((String)"//*[@id='prdOptionTable']"));
                    WebElement optionRows1 = driver.findElement(By.xpath((String)"//*[@id='product_option_id1']"));
                    WebElement optionRows2 = null;
                    try {
                        optionRows2 = driver.findElement(By.xpath((String)"//*[@id='product_option_id2']"));
                    }
                    catch (Exception exception) {
                        optionRows2 = null;
                    }
                    StringBuilder options = new StringBuilder();
                    Object sku_value = "";
                    if (optionRows2 != null) {
                        String optionTitle1 = optionRows1.findElement(By.xpath((String)"ancestor::tr/th")).getText();
                        String optionTitle2 = optionRows2.findElement(By.xpath((String)"ancestor::tr/th")).getText();
                        options.append("[").append(optionTitle1).append("=").append(optionTitle2).append("]\n");
                        List optionElements1 = optionRows1.findElements(By.cssSelector((String)"option"));
                        for (WebElement optionElement1 : optionElements1) {
                            String optionValue1 = optionElement1.getText().trim();
                            if (optionValue1.contains("[\ud544\uc218]") || optionValue1.contains("----------") || optionValue1.isEmpty()) continue;
                            Select select1 = new Select(optionRows1);
                            select1.selectByVisibleText(optionValue1);
                            wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)"//*[@id='product_option_id2']/option[not(contains(text(), '[\ud544\uc218]')) and not(contains(text(), '----------')) and string-length(text()) > 0]")));
                            List optionElements2 = driver.findElements(By.xpath((String)"//*[@id='product_option_id2']/option[not(contains(text(), '[\ud544\uc218]')) and not(contains(text(), '----------')) and string-length(text()) > 0]"));
                            for (WebElement optionElement2 : optionElements2) {
                                String optionValue2 = optionElement2.getText().trim();
                                if (optionValue2.contains("[\ud544\uc218]") || optionValue2.contains("----------") || optionValue2.isEmpty()) continue;
                                options.append(optionValue1).append("=").append(optionValue2).append("=").append(price2).append("=").append(price2).append("=0=0\n");
                            }
                        }
                        sku_value = optionTitle1 + ":" + optionTitle2;
                    } else {
                        String optionTitle = optionRows1.findElement(By.xpath((String)"ancestor::tr/th")).getText();
                        List optionElements = ((WebElement)((WebElement)optionTables.get(0)).findElements(By.cssSelector((String)"tbody tr")).get(0)).findElements(By.cssSelector((String)"td select option"));
                        options.append("[").append(optionTitle).append("]\n");
                        for (WebElement optionElement : optionElements) {
                            String optionValue = optionElement.getText().trim();
                            if (optionValue.contains("[\ud544\uc218]") || optionValue.contains("----------") || optionValue.isEmpty()) continue;
                            options.append(optionValue).append("=").append(price2).append("=").append(price2).append("=0=0\n");
                        }
                        sku_value = optionTitle;
                    }
                    if (((String)sku_value).endsWith(":")) {
                        sku_value = ((String)sku_value).substring(0, ((String)sku_value).length() - 1);
                    }
                    if (options.length() == 0) {
                        sku_value = "\ub2e8\ud488";
                    }
                    dto.setDosinoption(options.toString());
                    dto.setSku_value((String)sku_value);
                    dto.setDosinstatus("\ud310\ub9e4\uc911");
                    dto.setDsdelv_type("0");
                    dto.setDsdelv_cost("3000");
                    ret.add(dto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public List<ShopOrderMstDto> onnmeOptionSetting(List<ShopOrderMstDto> list) {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : list) {
            Object optinon = "\uc635\uc158\uc120\ud0dd``";
            List<MLinkOption> options = this.getOptionList((String)dto.getDosinoption()).options;
            for (MLinkOption option2 : options) {
                int optionPrice = option2.getOptionPrice() - Integer.parseInt(dto.getDsGoods_cost());
                optinon = (String)optinon + (!option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "+" + optionPrice : ":" + option2.getOptionName2() + "+" + optionPrice) : "");
                optinon = (String)optinon + "``";
            }
            dto.setDosinoption((String)optinon);
            ret.add(dto);
        }
        return ret;
    }

    public MLinkOptionList getOptionList(String option2) {
        MLinkOptionList optionList = new MLinkOptionList();
        ArrayList<MLinkOption> ret_options = new ArrayList<MLinkOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        YDMAStringUtil.Print();
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.indexOf("=") > 0 ? 2 : 1;
        optionList.setDan(dan);
        if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        } else {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms[1]);
        }
        for (String line : lines) {
            MLinkOption dto = new MLinkOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            if (dan == 1) {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2("");
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt("0"));
            } else {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2(lst_option.get(1));
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            }
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }
}

