/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.common.ProductFactory;
import com.kdjsystem.mlink.shop.common.ProductService;
import com.kdjsystem.mlink.shop.common.ShopCombo;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.Activator;
import com.kdjsystem.mlink.tot.OpenViewAction;
import com.kdjsystem.mlink.tot.StatusLineContribution;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.ui.Login;
import com.kdjsystem.mlink.tot.ui.LoginYellim;
import com.kdjsystem.mlink.tot.ui.OrderListUpload11stManager;
import com.kdjsystem.mlink.tot.ui.Product11stManager;
import com.kdjsystem.mlink.tot.ui.ProductManagementDosin;
import com.kdjsystem.mlink.tot.ui.ProductUpdateManagement;
import com.kdjsystem.mlink.tot.ui.QuestionsShoppingMallManager;
import com.kdjsystem.mlink.tot.ui.ShopAdditionalInforMationManager;
import com.kdjsystem.mlink.tot.ui.ShopTaskManager;
import com.kdjsystem.mlink.tot.ui.ShoppingMallManager;
import com.kdjsystem.mlink.tot.ui.StatisticalInfoManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction exitAction;
    private OpenViewAction loginAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction introAction;
    private OpenViewAction helpManagerAction;
    private OpenViewAction shoppingMallManagerAction;
    private OpenViewAction productManagementDosinAction;
    private OpenViewAction product11stManagerAction;
    private OpenViewAction shopTaskManagerAction;
    private OpenViewAction orderListUpload11stManagerAction;
    private OpenViewAction questionsShoppingMallManager;
    private OpenViewAction shopAdditionalInforMationManagerAction;
    private OpenViewAction statisticalInfoManagerAction;
    private OpenViewAction ProductUpdateManagementAction;
    private OpenViewAction loginYellimAction;
    public static final String M_TOOLS = "tools";
    public static String host;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.exitAction.setImageDescriptor(Activator.getImageDescriptor("/icons/N\ub85c\uadf8\uc544\uc6c3.png"));
        this.loginAction = new OpenViewAction(window, "\uc5e0\ub9c1\ud06c \ub85c\uadf8\uc778", Login.ID);
        this.loginAction.setImageDescriptor(Activator.getImageDescriptor("icons/MLink20.png"));
        this.loginYellimAction = new OpenViewAction(window, "\uc610\ub9bc \ub85c\uadf8\uc778", LoginYellim.ID);
        this.loginYellimAction.setImageDescriptor(Activator.getImageDescriptor("icons/Yellim_20.png"));
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.newWindowAction);
        this.introAction = ActionFactory.INTRO.create(window);
        this.register((IAction)this.introAction);
        this.introAction.setImageDescriptor(Activator.getImageDescriptor("/icons/N\ud648.png"));
        this.helpManagerAction = new OpenViewAction(window, "\ub3c4\uc6c0\ub9d0", ShoppingMallManager.ID);
        this.register((IAction)this.helpManagerAction);
        this.shoppingMallManagerAction = new OpenViewAction(window, "\ud658\uacbd\uc124\uc815", ShoppingMallManager.ID);
        this.register((IAction)this.shoppingMallManagerAction);
        this.productManagementDosinAction = new OpenViewAction(window, "\uc0c1\ud488\uc218\uc2e0", ProductManagementDosin.ID);
        this.register((IAction)this.productManagementDosinAction);
        this.ProductUpdateManagementAction = new OpenViewAction(window, "\uc0c1\ud488\uc218\uc815", ProductUpdateManagement.ID);
        this.register((IAction)this.ProductUpdateManagementAction);
        this.product11stManagerAction = new OpenViewAction(window, "\uc0c1\ud488\uad00\ub9ac", Product11stManager.ID);
        this.register((IAction)this.product11stManagerAction);
        this.shopTaskManagerAction = new OpenViewAction(window, "\uc791\uc5c5\uad00\ub9ac", ShopTaskManager.ID);
        this.register((IAction)this.shopTaskManagerAction);
        this.orderListUpload11stManagerAction = new OpenViewAction(window, "\uc8fc\ubb38\uc5f0\ub3d9", OrderListUpload11stManager.ID);
        this.register((IAction)this.orderListUpload11stManagerAction);
        this.questionsShoppingMallManager = new OpenViewAction(window, "\ubb38\uc758\uc5f0\ub3d9", QuestionsShoppingMallManager.ID);
        this.register((IAction)this.questionsShoppingMallManager);
        this.shopAdditionalInforMationManagerAction = new OpenViewAction(window, "\ubd80\uac00\uc815\ubcf4", ShopAdditionalInforMationManager.ID);
        this.register((IAction)this.shopAdditionalInforMationManagerAction);
        this.statisticalInfoManagerAction = new OpenViewAction(window, "\ud1b5\uacc4\uc815\ubcf4", StatisticalInfoManager.ID);
        this.register((IAction)this.statisticalInfoManagerAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager toolsMenu = new MenuManager("&Tools", M_TOOLS);
        menuBar.add((IContributionItem)toolsMenu);
        toolsMenu.add((IAction)this.preferencesAction);
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IAction)this.introAction);
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IAction)this.loginAction);
        toolsMenu.add((IAction)this.loginYellimAction);
        toolsMenu.add((IAction)this.exitAction);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "main"));
        toolbar.add((IAction)this.productManagementDosinAction);
        toolbar.add((IAction)this.product11stManagerAction);
        toolbar.add((IAction)this.shopTaskManagerAction);
        toolbar.add((IAction)this.orderListUpload11stManagerAction);
        toolbar.add((IAction)this.questionsShoppingMallManager);
        toolbar.add((IAction)this.statisticalInfoManagerAction);
        toolbar.add((IAction)this.shoppingMallManagerAction);
        toolbar.add((IAction)this.helpManagerAction);
        ControlContribution comboCI = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Combo cmbOnUrl = new Combo(parent, 8);
                final ShopCombo scb_cmbOnUrl = new ShopCombo(cmbOnUrl);
                List<CodeItem> urlItem = ApplicationActionBarAdvisor.this.setMenuTree();
                scb_cmbOnUrl.setDataSource1(urlItem);
                cmbOnUrl.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String sel = scb_cmbOnUrl.getSelectionValue();
                        String str = scb_cmbOnUrl.getSelectionItem().getName();
                        if (!sel.isEmpty()) {
                            List<String> selData = Stream.of(sel.split(",")).map(String::trim).collect(Collectors.toList());
                            if (str.contains("\ub124\uc774\ubc84\ud398\uc774")) {
                                selData.add(str.substring(str.indexOf("-") + 1, str.indexOf("(")));
                            }
                            try {
                                ProductService service = new ProductService(ProductFactory.getRegisterBean((String)selData.get(3)));
                                if (((String)selData.get(3)).equals("shop0119") || ((String)selData.get(3)).equals("shop9984")) {
                                    service.urlLoginDome(selData);
                                } else if (selData.get(3).equals("shop0283")) {
                                    ChromeDriver driver = service.urlLoginDome1(selData);
                                    WebElement connectSCM = driver.findElement(By.className((String)"foot_scm"));
                                    connectSCM.click();
                                } else {
                                    service.urlLogin2(selData);
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return cmbOnUrl;
            }
        };
        toolbar.add((IContributionItem)comboCI);
        ControlContribution comboCIDome = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Combo cmbOnUrlDome = new Combo(parent, 8);
                final ShopCombo scb_cmbOnUrlDome = new ShopCombo(cmbOnUrlDome);
                List<CodeItem> urlItem = ApplicationActionBarAdvisor.this.setMenuTreeDome();
                scb_cmbOnUrlDome.setDataSourceDome(urlItem);
                cmbOnUrlDome.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String sel = scb_cmbOnUrlDome.getSelectionValue();
                        if (!sel.isEmpty()) {
                            List<String> selData = Arrays.asList(sel.split(","));
                            try {
                                ProductService service = new ProductService(ProductFactory.getRegisterBean(selData.get(3)));
                                service.urlLoginDome(selData);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return cmbOnUrlDome;
            }
        };
        toolbar.add((IContributionItem)comboCIDome);
    }

    public List<CodeItem> setMenuTree() {
        ArrayList<CodeItem> urlItem = new ArrayList<CodeItem>();
        try {
            List<ShoppingMallDetailDto> list = ShopCommonDao.get().ShoppingMallDetailList();
            Map<String, Map<String, List<ShoppingMallDetailDto>>> mapList = list.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
            List items = ShopCommon.getCommonCodeList("PRODUCT_SHOP").stream().map(p -> p.getCode()).collect(Collectors.toList());
            Collections.sort(items);
            for (String shopid : items) {
                LinkedHashMap map = new LinkedHashMap();
                if (mapList.get(shopid) == null) continue;
                mapList.get(shopid).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                    List list = map.put((String)x.getKey(), (List)x.getValue());
                });
                for (String shopUserID : map.keySet()) {
                    List listdto = (List)map.get(shopUserID);
                    listdto = listdto.stream().sorted(Comparator.comparing(ShoppingMallDetailDto::getShoppingid)).collect(Collectors.toList());
                    for (ShoppingMallDetailDto dto : listdto) {
                        String code = String.format("%s,%s,%s,%s,%s,%s", dto.getShopUrl(), dto.getShoppingid(), dto.getPassword(), dto.getShopcd(), dto.getAuthkey1(), dto.getApikey());
                        urlItem.add(new CodeItem(code, ((ShoppingMallDetailDto)listdto.get(0)).getShopnm() + "-" + dto.getNicknm1() + "(" + dto.getShoppingid() + ")"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urlItem;
    }

    public List<CodeItem> setMenuTreeDome() {
        ArrayList<CodeItem> urlItem = new ArrayList<CodeItem>();
        try {
            List<ShoppingMallDetailDto> list = ShopCommonDao.get().DomeMallDetailList();
            list = list.stream().filter(d -> !d.getShopcd().equals("shop0000")).collect(Collectors.toList());
            Map<String, Map<String, List<ShoppingMallDetailDto>>> mapList = list.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
            Map<String, List<ShoppingMallDetailDto>> items = list.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd));
            for (String shopid : items.keySet()) {
                LinkedHashMap map = new LinkedHashMap();
                if (mapList.get(shopid) == null) continue;
                mapList.get(shopid).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                    List list = map.put((String)x.getKey(), (List)x.getValue());
                });
                for (String shopUserID : map.keySet()) {
                    List listdto = (List)map.get(shopUserID);
                    listdto = listdto.stream().sorted(Comparator.comparing(ShoppingMallDetailDto::getShoppingid)).collect(Collectors.toList());
                    for (ShoppingMallDetailDto dto : listdto) {
                        String code = String.format("%s,%s,%s,%s,%s,%s", dto.getShopUrl(), dto.getShoppingid(), dto.getPassword(), dto.getShopcd(), dto.getAuthkey1(), dto.getApikey());
                        urlItem.add(new CodeItem(code, ((ShoppingMallDetailDto)listdto.get(0)).getShopnm() + "-" + dto.getNicknm1() + "(" + dto.getShoppingid() + ")"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urlItem;
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        StatusLineContribution statusItem = new StatusLineContribution("sysInfo", 150);
        try {
            long heapsize = Runtime.getRuntime().totalMemory();
            int cores = Runtime.getRuntime().availableProcessors();
            String strHeapUsage = String.format(" Heap: %.2fG", ApplicationActionBarAdvisor.bytesToGigabytes(heapsize));
            String strCoresUsage = String.format("Cores: %s,", cores);
            SystemInfo si = new SystemInfo();
            HardwareAbstractionLayer hal = si.getHardware();
            String strCpuUsage = this.printCpuUsage(hal.getProcessor());
            String strMemoryUsage = this.printMemoryUsage(hal.getMemory());
            String strDiskUsage = this.printDiskUsage(hal);
            statusItem.setText(strDiskUsage + " | " + strCoresUsage + strCpuUsage + " | " + strMemoryUsage + strHeapUsage);
            statusLine.add((IContributionItem)statusItem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String printCpuUsage(CentralProcessor processor) {
        double cpuLoad = processor.getSystemCpuLoad(1000L) * 100.0;
        String strCpuUsage = String.format("CPU: %.2f%%", cpuLoad);
        return strCpuUsage;
    }

    private String printMemoryUsage(GlobalMemory memory) {
        long totalMemory = memory.getTotal();
        long availableMemory = memory.getAvailable();
        long usedMemory = totalMemory - availableMemory;
        String strMemoryUsage = String.format("\uba54\ubaa8\ub9ac: %.2fG/%.2fG(%.2f%%)", ApplicationActionBarAdvisor.bytesToGigabytes(usedMemory), ApplicationActionBarAdvisor.bytesToGigabytes(totalMemory), (double)usedMemory * 100.0 / (double)totalMemory);
        return strMemoryUsage;
    }

    private String printDiskUsage(HardwareAbstractionLayer hal) {
        String strMemoryUsage = "Unknown";
        List diskStores = hal.getDiskStores();
        String drive = YDMASessonUtil.getAppPath().substring(0, 1).trim();
        String execDrivetype = this.checkDiskTypeWindows(drive);
        for (HWDiskStore disk : diskStores) {
            if (!disk.getModel().trim().contains(execDrivetype.split(",")[1].trim())) continue;
            strMemoryUsage = String.format("%s: %.2fGB", execDrivetype.split(",")[0], ApplicationActionBarAdvisor.bytesToGigabytes(disk.getSize()));
            break;
        }
        return strMemoryUsage;
    }

    private String checkDiskTypeWindows(String execDrive) {
        Object diskType = "Unknown";
        try {
            String line;
            String command = "powershell.exe -Command \"$disks = Get-PhysicalDisk | ForEach-Object {    $disk = $_;    Get-Disk | Where-Object { $_.UniqueId -eq $disk.UniqueId } |     Get-Partition | Get-Volume |     Select-Object @{Name='DriveLetter'; Expression={$_.DriveLetter}},                   @{Name='FileSystemLabel'; Expression={','+$_.FileSystemLabel}},                   @{Name='Model'; Expression={','+$disk.Model}},                   @{Name='Type'; Expression={','+$disk.MediaType}}}; $disks | Format-Table -HideTableHeaders\"";
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                String driveLetter;
                if ((line = line.trim()).isEmpty() || (driveLetter = (parts = line.split(","))[0].trim()).isEmpty()) continue;
                String model = parts[2].trim();
                String type = parts[3].trim();
                if (driveLetter.equals(execDrive) && type.equalsIgnoreCase("SSD")) {
                    diskType = "SSD," + model;
                    break;
                }
                if (!driveLetter.equals(execDrive) || !type.equalsIgnoreCase("HDD") && !model.matches(".*(WD|Seagate|Toshiba|Hitachi|5400|7200).*")) continue;
                diskType = "HDD," + model;
                break;
            }
            process.waitFor();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diskType;
    }

    private static double bytesToGigabytes(long bytes) {
        return (double)bytes / 1.073741824E9;
    }
}

