/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class RackDao {
    public boolean checkRackInfo(String prodcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select prodcd from NECPRODMST where prodcd = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[checkRackInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int insertRackInfo(int brandcd, int warecd, String prodcd, String neccd1, String floor, String cell) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert necprodmst (compno, brandcd, warecd, prodcd, neccd1, neccd2, neccd3, insertdt, insertid) values (?,?,?,?,?,?,?,?,?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++i, brandcd);
                pstmt.setInt(++i, warecd);
                pstmt.setString(++i, prodcd);
                pstmt.setString(++i, neccd1);
                pstmt.setString(++i, floor);
                pstmt.setString(++i, cell);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[insertRackInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int insertRackInfo1(List<String> list) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert necprodmst (compno, brandcd, warecd, prodcd, neccd1, neccd2, neccd3, insertdt, insertid) values (?,?,?,?,?,?,?,?,?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++i, Integer.parseInt(list.get(9)));
                pstmt.setInt(++i, Integer.parseInt(list.get(1)));
                pstmt.setString(++i, list.get(3));
                pstmt.setString(++i, list.get(6));
                pstmt.setString(++i, list.get(7));
                pstmt.setString(++i, list.get(8));
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[insertRackInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int updateRackInfo(int warecd, String prodcd, String neccd1, String floor, String cell) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update necprodmst set warecd=?, neccd1=?, neccd2=?, neccd3=? , modifydt=?, modifyid=?  where prodcd=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setInt(++i, warecd);
                pstmt.setString(++i, neccd1);
                pstmt.setString(++i, floor);
                pstmt.setString(++i, cell);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++i, prodcd);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[updateRackInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> selectRackInfo(Connection connection, int brandcd, String prodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select n.warecd, p.prodcd, p.prodnm, ifnull(n.neccd1,''), ifnull(n.neccd2,''), ifnull(n.neccd3,'')    from necprodmst as n left join prodmst as p  on p.prodcd=n.prodcd and p.compno = n.compno  where p.prodcd = ?     and p.compno = ?     and p.brandcd = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, prodcd);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(3, brandcd);
            YDMAStringUtil.Print("[selectRackInfo]" + pstmt.toString());
            rs = pstmt.executeQuery();
            int i = 0;
            while (rs.next()) {
                list.add(rs.getString(++i));
                list.add(rs.getString(++i));
                list.add(rs.getString(++i));
                list.add(rs.getString(++i));
                list.add(String.valueOf(rs.getInt(++i)));
                list.add(String.valueOf(rs.getInt(++i)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return list;
    }

    public List<String> selectRackInfo(int brandcd, String prodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select n.warecd, p.prodcd, p.prodnm, ifnull(n.neccd1,''), ifnull(n.neccd2,''), ifnull(n.neccd3,'')    from necprodmst as n left join prodmst as p  on p.prodcd=n.prodcd and p.compno = n.compno  where p.prodcd = ?     and p.compno = ?     and p.brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(3, brandcd);
                YDMAStringUtil.Print("[selectRackInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int i = 0;
                while (rs.next()) {
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(String.valueOf(rs.getInt(++i)));
                    list.add(String.valueOf(rs.getInt(++i)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getProdcutListforRack(int brandcd, int warecd, int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "select B.warecd, (select warenm from warehouse as C where B.compno=C.compno and B.brandcd=C.brandcd and B.warecd=C.warecd) as warenm, A.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,A.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "case ifnull(A.SPECDES,'') when '' then A.ProdNm ELSE CONCAT(A.prodnm ,'_',A.SPECDES) end, ifnull(B.neccd1, ''), ifnull(B.neccd2, '') , ifnull(B.neccd3, '') , ifnull(A.brandcd, '')  from prodmst as A  left join necprodmst B  on A.prodcd=B.prodcd and A.compno = B.compno and A.brandcd = B.brandcd where A.compno = ? ";
                if (brandcd != -1) {
                    sql = (String)sql + "  and A.brandcd = ? ";
                }
                if (warecd != -1) {
                    sql = (String)sql + "  and B.warecd = ? ";
                }
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = (String)sql + " and  A.prodcd like ? ";
                    }
                    sql = (String)sql + "  order by A.prodcd ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = (String)sql + " and  A.prodnm like ? ";
                    }
                    sql = (String)sql + "  order by A.prodnm ";
                }
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    if (warecd != -1) {
                        pstmt.setInt(3, warecd);
                        if (optStr.length() != 0) {
                            pstmt.setString(4, "%" + optStr + "%");
                        }
                    } else if (optStr.length() != 0) {
                        pstmt.setString(3, "%" + optStr + "%");
                    }
                } else if (warecd != -1) {
                    pstmt.setInt(2, warecd);
                    if (optStr.length() != 0) {
                        pstmt.setString(2, "%" + optStr + "%");
                    }
                } else if (optStr.length() != 0) {
                    pstmt.setString(2, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getProdcutListforRack]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    rs.beforeFirst();
                    contents = new ArrayList<List<String>>();
                    int rowno = 0;
                    while (rs.next()) {
                        int i = 0;
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add("" + ++rowno);
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        contents.add(list);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }
}

