/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ProdReceiveSetDto;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.SchSetMstDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.job.JobContext;
import com.kdjsystem.mlink.shop.job.JobProduct;
import com.kdjsystem.mlink.shop.job.JobProductReceive;
import com.kdjsystem.mlink.shop.job.JobQuestion;
import com.kdjsystem.mlink.shop.job.ShopOrderJob;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.AlimTalkChargeDao;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SchedulerService {
    private static SchedulerService instance = new SchedulerService();
    public String ZONE_URL = "https://oapi.ecounterp.com/OAPI/V2/Zone";
    public String REQ_METHOD = "POST";
    public String ACCEPT = "application/json";
    public String CONTENT_TYPE = "application/json";

    private SchedulerService() {
    }

    public static SchedulerService get() {
        return instance;
    }

    public void orderSchedulerSetup(int jobcd, String key, String value) {
        ArrayList<ScheduleInfoDto> schedlist = new ArrayList();
        List<Object> list = new ArrayList();
        ScheduleInfoDto dto = new ScheduleInfoDto();
        List<Integer> hour = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23);
        try {
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, value, null, null);
            schedlist = ScheduleInfoDao.get().getScheduleInfoNSite(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), jobcd);
            dto = this.setDto(schedlist);
            list = dto.getSitechk().equals("N") ? this.getShopOrderAllList() : ScheduleInfoDao.get().getShopDetailList(dto.getJobcd());
            this.startDateSetting(list);
            if (YDMASessonUtil.getUserInfo().getUserId().equals("test1")) {
                if (dto.getJobstat().equals("Y")) {
                    String cron = "0 0/10 * * * ?";
                    JobContext.get().addJobNamGroup(key, value + "_test1", dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), cron).start();
                } else {
                    JobContext.get().clearKey(key);
                }
            } else if (dto.getJobstat().equals("Y")) {
                String hourList;
                String weekday;
                List<Object> iNotTime3;
                List<Object> iNotTime2;
                List<Integer> iNotTime1;
                if (dto.getWeekchk1().equals("Y")) {
                    iNotTime1 = new ArrayList<Integer>();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * MON,TUE,WED,THU *", dto.getFewminu1());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * MON,TUE,WED,THU *", dto.getFewminu1(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value + "_1", dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk2().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * FRI *", dto.getFewminu2());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * FRI *", dto.getFewminu2(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value + "_2", dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk3().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * SAT *", dto.getFewminu3());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * SAT *", dto.getFewminu3(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value + "_3", dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
                if (dto.getWeekchk4().equals("Y")) {
                    iNotTime1 = new ArrayList();
                    iNotTime2 = new ArrayList();
                    iNotTime3 = new ArrayList();
                    weekday = String.format("0 %s * ? * SUN *", dto.getFewminu4());
                    if (dto.getExcepchk1().equals("Y")) {
                        iNotTime1 = this.getNotHour(Integer.parseInt(dto.getExceps1().substring(0, 2)), Integer.parseInt(dto.getExcepe1().substring(0, 2)));
                    }
                    if (dto.getExcepchk2().equals("Y")) {
                        iNotTime2 = this.getNotHour(Integer.parseInt(dto.getExceps2().substring(0, 2)), Integer.parseInt(dto.getExcepe2().substring(0, 2)));
                        iNotTime1.addAll(iNotTime2);
                    }
                    if (dto.getExcepchk3().equals("Y")) {
                        iNotTime3 = this.getNotHour(Integer.parseInt(dto.getExceps3().substring(0, 2)), Integer.parseInt(dto.getExcepe3().substring(0, 2)));
                        iNotTime1.addAll(iNotTime3);
                    }
                    if (!(hourList = this.getHourString(this.getHourList(hour, iNotTime1))).equals("")) {
                        weekday = String.format("0 %s %s ? * SUN *", dto.getFewminu4(), hourList);
                    }
                    JobContext.get().addJobNamGroup(key, value + "_4", dto, list).addJob(ShopOrderJob.class, dto.getExeckey(), weekday).start();
                }
            } else {
                JobContext.get().clearKey(key);
            }
        }
        catch (Exception exception) {}
    }

    private void startDateSetting(List<ShopOrderMstDto> list) {
        try {
            ShopPreferencesDto dto = ShopCommonDao.get().getSystemConf();
            int period = Integer.parseInt(dto.getOrdimptper());
            Calendar calender_dateTime_from1 = Calendar.getInstance();
            Calendar calender_dateTime_from2 = Calendar.getInstance();
            int specialShop = period >= 30 ? 29 : period - 1;
            int generalShop = period - 1;
            calender_dateTime_from1.add(5, -specialShop);
            calender_dateTime_from2.add(5, -generalShop);
            Date specialShopDate = calender_dateTime_from1.getTime();
            Date generalShopDate = calender_dateTime_from2.getTime();
            String specialShopStartDate = new SimpleDateFormat("yyyyMMdd").format(specialShopDate).concat("0000");
            String generalShopStartDate = new SimpleDateFormat("yyyyMMdd").format(generalShopDate).concat("0000");
            for (ShopOrderMstDto shop : list) {
                boolean isSpecialShop;
                boolean bl = isSpecialShop = shop.getShopid().equals("shop0075") || shop.getShopid().equals("shop0273") || shop.getShopid().equals("shop0287") || shop.getShopid().equals("shop9982");
                if (isSpecialShop) {
                    shop.setStartDt(specialShopStartDate);
                    continue;
                }
                shop.setStartDt(generalShopStartDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void productSchedulerSetup(int jobcd, String key) {
        int compno = Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno());
        String execKey = "";
        try {
            List<ScheduleInfoDto> schedulerInfos = ScheduleInfoDao.get().getScheduleInfoNSite(compno, jobcd);
            schedulerInfos = schedulerInfos.stream().sorted(Comparator.comparing(ScheduleInfoDto::getWorkseq)).collect(Collectors.toList());
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, "", null);
            ScheduleInfoDto scheDto = schedulerInfos.get(0);
            String jobStat = scheDto.getJobstat();
            String useSetCheck = scheDto.getUseSetChk();
            if ("Y".equals(jobStat)) {
                if ("Y".equals(useSetCheck)) {
                    List<SchSetMstDTO> scheMstList = ScheduleInfoDao.get().selectSet_sche_mst();
                    if ((scheMstList = scheMstList.stream().filter(s -> !s.getUseSetDay().equals("") && !s.getUseSetHour().equals("") && !s.getUseSetMin().equals("")).collect(Collectors.toList())).size() == 0) {
                        return;
                    }
                    String syncCheck = scheDto.getSyncChk();
                    String clearCheck = scheDto.getClearChk();
                    int i = 1;
                    for (SchSetMstDTO dto : scheMstList) {
                        int setSeq = dto.getSet_seq();
                        String day = dto.getUseSetDay();
                        String hour = dto.getUseSetHour();
                        String min = dto.getUseSetMin();
                        String timeCron = String.format("0 %s %s ? * %s *", min, hour, day);
                        ScheduleInfoDao.get().replaceSchedusiteWithSet(setSeq, Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), jobcd);
                        ScheduleInfoDao.get().replaceSchedusiteMdfWithSet(setSeq, compno, jobcd);
                        ScheduleInfoDao.get().replaceScheduInfoWithSet(setSeq, Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), jobcd, syncCheck, clearCheck);
                        schedulerInfos = ScheduleInfoDao.get().getScheduleInfoNSite(compno, jobcd);
                        schedulerInfos = schedulerInfos.stream().sorted(Comparator.comparing(ScheduleInfoDto::getWorkseq)).collect(Collectors.toList());
                        execKey = schedulerInfos.get(0).getExeckey();
                        JobContext.get().addJobNamGroup(key, "OLD_PROD_SET_" + i, schedulerInfos).addJob(JobProduct.class, execKey, timeCron).start();
                        ++i;
                    }
                    this.registerSchedulerJobs(scheDto, compno, jobcd, key, execKey, schedulerInfos);
                } else {
                    HashMap<String, CallSite> weekMap = new HashMap<String, CallSite>();
                    weekMap.put("MON", (CallSite)((Object)(scheDto.getWeekchk1() + "," + scheDto.getFewminu1())));
                    weekMap.put("TUE", (CallSite)((Object)(scheDto.getWeekchk2() + "," + scheDto.getFewminu2())));
                    weekMap.put("WED", (CallSite)((Object)(scheDto.getWeekchk3() + "," + scheDto.getFewminu3())));
                    weekMap.put("THU", (CallSite)((Object)(scheDto.getWeekchk4() + "," + scheDto.getFewminu4())));
                    weekMap.put("FRI", (CallSite)((Object)(scheDto.getWeekchk5() + "," + scheDto.getFewminu5())));
                    weekMap.put("SAT", (CallSite)((Object)(scheDto.getWeekchk6() + "," + scheDto.getFewminu6())));
                    weekMap.put("SUN", (CallSite)((Object)(scheDto.getWeekchk7() + "," + scheDto.getFewminu7())));
                    execKey = scheDto.getExeckey();
                    for (Map.Entry entry : weekMap.entrySet()) {
                        String day = (String)entry.getKey();
                        String[] parts = ((String)entry.getValue()).split(",");
                        if (!"Y".equals(parts[0])) continue;
                        String[] timeArray = parts[1].split(":");
                        String timeCron = String.format("0 %s %s ? * %s *", timeArray[1], timeArray[0], day);
                        JobContext.get().addJobNamGroup(key, "OLD_PROD_" + day, schedulerInfos).addJob(JobProduct.class, execKey, timeCron).start();
                    }
                    this.registerSchedulerJobs(scheDto, compno, jobcd, key, execKey, schedulerInfos);
                }
            } else {
                JobContext.get().clearKey(key);
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    private void registerSchedulerJobs(ScheduleInfoDto scheDto, int compno, int jobcd, String key, String execKey, List<ScheduleInfoDto> schedulerInfos) throws Exception {
        List<ProductSchedulerSyncDTO> syncInfos;
        if ("Y".equals(scheDto.getSyncChk()) && !(syncInfos = ScheduleInfoDao.get().getProductScheduleSyncSiteByJobcd(compno, jobcd)).isEmpty()) {
            List syncDates = syncInfos.stream().map(ProductSchedulerSyncDTO::getDate).distinct().collect(Collectors.toList());
            for (String syncDate : syncDates) {
                String[] dateArray;
                List infos = syncInfos.stream().filter(p -> syncDate.equals(p.getDate())).collect(Collectors.toList());
                if (infos.isEmpty() || (dateArray = syncDate.split(":")).length != 3) continue;
                String day = dateArray[0];
                String hour = dateArray[1];
                String minute = dateArray[2];
                String timeCron = String.format("0 %s %s ? * %s *", minute, hour, day);
                JobContext.get().addJobNamGroup(key, String.format("SYNC_%s_%s%s", day, hour, minute), infos).addJob(JobProduct.class, execKey, timeCron).start();
            }
        }
        if ("Y".equals(scheDto.getClearChk())) {
            String timeCron = String.format("0 %s %s ? * %s *", scheDto.getClearMin(), scheDto.getClearHour(), scheDto.getClearDay());
            JobContext.get().addJobNamGroup(key, String.format("CLEAR_%s", scheDto.getClearDay()), schedulerInfos).addJob(JobProduct.class, execKey, timeCron).start();
        }
    }

    public void questionSchedulerSetup(int jobcd, String key, String value) {
        List<Object> schedlist = new ArrayList();
        List<Object> list = new ArrayList();
        ScheduleInfoDto dto = new ScheduleInfoDto();
        try {
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, value, null, null);
            schedlist = ScheduleInfoDao.get().getScheduleInfoNSite(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), jobcd);
            dto = (ScheduleInfoDto)schedlist.get(0);
            list = dto.getSitechk().equals("N") ? this.getShopOrderAllList() : ScheduleInfoDao.get().getShopDetailList(dto.getJobcd());
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String formattedDate = new SimpleDateFormat("yyyyMMdd").format(date_from).concat("0000");
            for (ShopOrderMstDto shopOrderMstDto : list) {
                shopOrderMstDto.setStartDt(formattedDate);
            }
            if (dto.getJobstat().equals("Y")) {
                if (dto.getTypechk().equals("") || dto.getTypechk().equals("B")) {
                    HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
                    hashMap.put("MON,TUE,WED,THU", (CallSite)((Object)(dto.getWeekchk1() + "," + dto.getFewminu1())));
                    hashMap.put("FRI", (CallSite)((Object)(dto.getWeekchk2() + "," + dto.getFewminu2())));
                    hashMap.put("SAT", (CallSite)((Object)(dto.getWeekchk3() + "," + dto.getFewminu3())));
                    hashMap.put("SUN", (CallSite)((Object)(dto.getWeekchk4() + "," + dto.getFewminu4())));
                    int i = 1;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        String days = (String)entry.getKey();
                        String[] parts = ((String)entry.getValue()).split(",", -1);
                        if (parts[1] != null && "Y".equals(parts[0])) {
                            String weekday = String.format("0 %s * ? * %s *", parts[1], days);
                            JobContext.get().addJobNamGroup(key, value + "_" + i, dto, list).addJob(JobQuestion.class, dto.getExeckey(), weekday).start();
                        }
                        ++i;
                    }
                } else {
                    String string = String.format("0 0 %s/%s * * ?", String.valueOf(LocalTime.now().getHour() + 1), dto.getCycleinfo().split(",")[0].replace("\uc2dc\uac04", "").trim());
                    JobContext.get().addJobNamGroup(key, value + "_Cycle", dto, list).addJob(JobQuestion.class, dto.getExeckey(), string).start();
                }
            } else {
                JobContext.get().clearKey(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void productReceiveSchedulerSetup(int jobcd, String key) {
        int compno = Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno());
        try {
            List<ScheduleInfoDto> schedulerInfos = ScheduleInfoDao.get().getScheduleInfoNSite(compno, jobcd);
            List<ProdReceiveSetDto> list = ScheduleInfoDao.get().selectProdreceiveset();
            JobContext.get().clearKey(key);
            JobContext.get().addJobNamGroup(key, "", null);
            list = list.stream().filter(s -> !s.getSetDay().equals("") && !s.getSetHour().equals("") && !s.getSetMin().equals("")).collect(Collectors.toList());
            ScheduleInfoDto scheDto = schedulerInfos.get(0);
            if (scheDto.getJobstat().equals("Y")) {
                if (list.size() == 0) {
                    return;
                }
                int i = 1;
                for (ProdReceiveSetDto dto : list) {
                    int hourInt;
                    String day = dto.getSetDay();
                    String hour = dto.getSetHour();
                    if (day.equals("SAT") || day.equals("SUN") || (hourInt = Integer.parseInt(hour)) < 8 || hourInt > 18) continue;
                    String min = dto.getSetMin();
                    String timeCron = String.format("0 %s %s ? * %s *", min, hour, day);
                    JobContext.get().addJobNamGroup(key, key + i, scheDto, Arrays.asList(dto), "\uc218\uc2e0").addJob(JobProductReceive.class, scheDto.getExeckey(), timeCron).start();
                    ++i;
                }
            } else {
                JobContext.get().clearKey(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ScheduleInfoDto setDto(List<ScheduleInfoDto> schedlist) {
        ScheduleInfoDto dto = new ScheduleInfoDto();
        dto.setCompno(schedlist.get(0).getCompno());
        dto.setJobcd(schedlist.get(0).getJobcd());
        dto.setJobstat(schedlist.get(0).getJobstat());
        dto.setExecid(schedlist.get(0).getExecid());
        dto.setExecdt(schedlist.get(0).getExecdt());
        dto.setWeekchk1(schedlist.get(0).getWeekchk1());
        dto.setFewminu1(schedlist.get(0).getFewminu1());
        dto.setJobexe11(schedlist.get(0).getJobexe11());
        dto.setJobexe21(schedlist.get(0).getJobexe21());
        dto.setJobexe31(schedlist.get(0).getJobexe31());
        dto.setJobexe41(schedlist.get(0).getJobexe41());
        dto.setWeekchk2(schedlist.get(0).getWeekchk2());
        dto.setFewminu2(schedlist.get(0).getFewminu2());
        dto.setJobexe12(schedlist.get(0).getJobexe12());
        dto.setJobexe22(schedlist.get(0).getJobexe22());
        dto.setJobexe32(schedlist.get(0).getJobexe32());
        dto.setJobexe42(schedlist.get(0).getJobexe42());
        dto.setWeekchk3(schedlist.get(0).getWeekchk3());
        dto.setFewminu3(schedlist.get(0).getFewminu3());
        dto.setJobexe13(schedlist.get(0).getJobexe13());
        dto.setJobexe23(schedlist.get(0).getJobexe23());
        dto.setJobexe33(schedlist.get(0).getJobexe33());
        dto.setJobexe43(schedlist.get(0).getJobexe43());
        dto.setWeekchk4(schedlist.get(0).getWeekchk4());
        dto.setFewminu4(schedlist.get(0).getFewminu4());
        dto.setJobexe14(schedlist.get(0).getJobexe14());
        dto.setJobexe24(schedlist.get(0).getJobexe24());
        dto.setJobexe34(schedlist.get(0).getJobexe34());
        dto.setJobexe44(schedlist.get(0).getJobexe44());
        dto.setSitechk(schedlist.get(0).getSitechk());
        dto.setTypechk(schedlist.get(0).getTypechk());
        dto.setMaxchk(schedlist.get(0).getMaxchk());
        dto.setMaxcnt(schedlist.get(0).getMaxcnt());
        dto.setExcepchk1(schedlist.get(0).getExcepchk1());
        dto.setExceps1(schedlist.get(0).getExceps1());
        dto.setExcepe1(schedlist.get(0).getExcepe1());
        dto.setExcepchk2(schedlist.get(0).getExcepchk2());
        dto.setExceps2(schedlist.get(0).getExceps2());
        dto.setExcepe2(schedlist.get(0).getExcepe2());
        dto.setExcepchk3(schedlist.get(0).getExcepchk3());
        dto.setExceps3(schedlist.get(0).getExceps3());
        dto.setExcepe3(schedlist.get(0).getExcepe3());
        dto.setOutofexe(schedlist.get(0).getOutofexe());
        dto.setSmschk(schedlist.get(0).getSmschk());
        dto.setSmsno(schedlist.get(0).getSmsno());
        dto.setDontchk(schedlist.get(0).getDontchk());
        dto.setDontstr(schedlist.get(0).getDontstr());
        dto.setDontend(schedlist.get(0).getDontend());
        dto.setEmailchk(schedlist.get(0).getEmailchk());
        dto.setEmailaddr(schedlist.get(0).getEmailaddr());
        Object shopcd = "";
        Object shopseq = "";
        int i = 0;
        while (i < schedlist.size()) {
            if (i + 1 == schedlist.size()) {
                shopcd = (String)shopcd + schedlist.get(i).getShopcd();
                shopseq = (String)shopseq + schedlist.get(i).getShopseq();
            } else {
                shopcd = (String)shopcd + schedlist.get(i).getShopcd() + ",";
                shopseq = (String)shopseq + schedlist.get(i).getShopseq() + ",";
            }
            ++i;
        }
        dto.setShopcd((String)shopcd);
        dto.setShopseq((String)shopseq);
        dto.setJobexe51(schedlist.get(0).getJobexe51());
        dto.setJobexe61(schedlist.get(0).getJobexe61());
        dto.setJobexe52(schedlist.get(0).getJobexe52());
        dto.setJobexe62(schedlist.get(0).getJobexe62());
        dto.setJobexe53(schedlist.get(0).getJobexe53());
        dto.setJobexe63(schedlist.get(0).getJobexe63());
        dto.setJobexe54(schedlist.get(0).getJobexe54());
        dto.setJobexe64(schedlist.get(0).getJobexe64());
        dto.setJobexe71(schedlist.get(0).getJobexe71());
        dto.setJobexe72(schedlist.get(0).getJobexe72());
        dto.setJobexe73(schedlist.get(0).getJobexe73());
        dto.setJobexe74(schedlist.get(0).getJobexe74());
        dto.setExeckey(schedlist.get(0).getExeckey());
        return dto;
    }

    private List<ShopOrderMstDto> getShopOrderAllList() {
        ArrayList<ShopOrderMstDto> params = new ArrayList<ShopOrderMstDto>();
        try {
            List<ShoppingMallDetailDto> list = ShopCommonDao.get().ShoppingMallDetailList();
            for (ShoppingMallDetailDto d : list) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setShopid(d.getShopcd());
                dto.setShop_userid(d.getShoppingid());
                dto.setShopnm(d.getShopnm());
                dto.setShopPw(d.getPassword());
                dto.setApikey(d.getApikey());
                dto.setAuthkey1(d.getAuthkey1());
                dto.setAuthKey2(d.getAuthkey2());
                dto.setVendorId(d.getVendorId());
                dto.setSuppstditem(d.getSuppstditem());
                dto.setSuppstdrati(d.getSuppstdrati());
                dto.setShopseq(d.getShopseq());
                dto.setSuppcostitem(d.getSuppcostitem());
                dto.setSuppcostrati(d.getSuppcostrati());
                dto.setStartDt(YDMATimeUtil.getCurrentDateHanjin().concat("0000"));
                dto.setEndDt(YDMATimeUtil.getCurrentTime().substring(0, 8).concat("2359"));
                dto.setEDITAUTHKEY1(d.getEditauthkey1());
                dto.setEDITAPIKEY(d.getEditapikey());
                dto.setNickname(d.getNicknm1());
                params.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private List<Integer> getNotHour(Integer start, Integer end) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Integer cnt = start;
        while (cnt != end) {
            if (cnt == 24) {
                cnt = 0;
            }
            ret.add(cnt);
            cnt = cnt + 1;
        }
        ret.add(cnt);
        return ret;
    }

    private List<Integer> getHourList(List<Integer> hourList, List<Integer> notHour) {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (Integer hour : hourList) {
            if (notHour.contains(hour)) continue;
            retList.add(hour);
        }
        return retList;
    }

    private String getHourString(List<Integer> hourList) {
        String ret = "";
        ret = hourList.stream().map(h -> String.valueOf(h)).collect(Collectors.joining(","));
        return ret;
    }

    public void sendEmail(List<String> complist, String emailaddr) throws Exception {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", (Object)true);
            props.put("mail.smtp.starttls.enable", (Object)true);
            props.put("mail.smtp.host", "smtp.gmail.com");
            props.put("mail.smtp.port", "587");
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("hosikan@kdjsystem.com", "dksghtlr1");
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress("hosikan@kdjsystem.com"));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailaddr));
            message.setSubject("\uc2a4\ucf00\uc974\ub9c1 \ucc98\ub9ac\ud604\ud669");
            String body = YDMATimeUtil.getCurrentDate() + " \uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.";
            message.setText(body);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public List<String> sendKakao(String smsno, String startdt, String enddt, String smschk, List<String> comlist) {
        ArrayList<String> responContents = new ArrayList<String>();
        try {
            String userid = "kdjsystem";
            String real_profile_key = comlist.get(21);
            String url = "https://alimtalk-api.sweettracker.net/v2/" + real_profile_key + "/sendMessage";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            List<String> allist = aldao.getAlimTalkChargeList(comlist.get(25));
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setRequestProperty("userid", userid);
            httpConnection.setDoOutput(true);
            int seq = Integer.parseInt(allist.get(7));
            StringBuffer payload = new StringBuffer();
            payload.append("[");
            String num = String.format("%011d", seq + 1);
            payload.append("{");
            payload.append("\"msgid\"").append(":\"").append(comlist.get(24) + num).append("\",");
            payload.append("\"profile_key\"").append(":\"").append(real_profile_key).append("\",");
            if (comlist.get(0).equals("1")) {
                payload.append("\"template_code\"").append(":\"").append("").append("\",");
            } else if (comlist.get(0).equals("2")) {
                payload.append("\"template_code\"").append(":\"").append("udt001").append("\",");
            } else {
                payload.append("\"template_code\"").append(":\"").append("kdj002").append("\",");
            }
            payload.append("\"receiver_num\"").append(":\"").append(this.splitMark(smsno)).append("\",");
            payload.append("\"message\"").append(":\"").append(YDMATimeUtil.getCurrentDate() + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.").append("\",");
            payload.append("\"reserved_time\"").append(":\"").append("00000000000000").append("\",");
            payload.append("\"sms_message\"").append(":\"").append(YDMATimeUtil.getCurrentDate() + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.").append("\",");
            payload.append("\"sms_title\"").append(":\"").append("\",");
            payload.append("\"sms_kind\"").append(":\"").append("S").append("\",");
            payload.append("\"sender_num\"").append(":\"").append("0326751102").append("\",");
            payload.append("\"parcel_company\"").append(":\"").append("08").append("\",");
            payload.append("\"parcel_invoice\"").append(":\"").append("").append("\"");
            payload.append("} ");
            payload.append("\n");
            payload.append("] ");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\uce74\uce74\uc624\ud1a1: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            JsonArray dataObject = jsonObject.getAsJsonArray();
            int i = 0;
            while (i < dataObject.getAsJsonArray().size()) {
                JsonElement jsonElement = dataObject.getAsJsonArray().get(i);
                String result = jsonElement.getAsJsonObject().get("result").getAsString();
                if (result.equals("Y")) {
                    String msgid = jsonElement.getAsJsonObject().get("msgid").getAsString();
                    String code = jsonElement.getAsJsonObject().get("code").getAsString();
                    String error = jsonElement.getAsJsonObject().get("error").getAsString();
                    String kind = jsonElement.getAsJsonObject().get("kind").getAsString();
                    String sendtime = jsonElement.getAsJsonObject().get("sendtime").getAsString();
                    responContents.add(result);
                    responContents.add(msgid);
                    responContents.add(code);
                    responContents.add(error);
                    responContents.add(kind);
                    responContents.add(smsno);
                    responContents.add(YDMATimeUtil.getCurrentDate() + "\uc2a4\ucf00\uc974\ub9c1\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub3d9\uc791\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    responContents.add(sendtime);
                } else {
                    responContents.add(jsonElement.getAsJsonObject().get("result").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("msgid").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("code").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("error").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("kind").getAsString());
                    responContents.add(jsonElement.getAsJsonObject().get("sendtime").getAsString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        Object complite = "";
        int j = 0;
        while (j < split.length) {
            complite = (String)complite + split[j];
            complite = ((String)complite).trim();
            ++j;
        }
        return complite;
    }

    public void schedulerYesorNo() {
        if (!MLinkCommon.get().isPaymentCompleted()) {
            return;
        }
        try {
            List<ScheduleInfoDto> scheduleInfos = ScheduleInfoDao.get().getJobcd();
            List<String> macAddressList = IShopCommonLogin.getLocalMacAddressListNotVirtual();
            for (ScheduleInfoDto scheduleInfo : scheduleInfos) {
                String registeredMac = scheduleInfo.getExeckey();
                if (!macAddressList.contains(registeredMac)) continue;
                int jobcd = scheduleInfo.getJobcd();
                switch (jobcd) {
                    case 1: {
                        this.productSchedulerSetup(jobcd, "PRODUCT");
                        break;
                    }
                    case 2: {
                        this.orderSchedulerSetup(jobcd, "Order", "Ordergroup1");
                        break;
                    }
                    case 3: {
                        this.questionSchedulerSetup(jobcd, "Question", "Questiongroup1");
                        break;
                    }
                    case 5: {
                        this.productReceiveSchedulerSetup(jobcd, "PROD_RCV");
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

