/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.CodeItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Combo;

public class ShopCombo {
    Map<Integer, CodeItem> data = new HashMap<Integer, CodeItem>();
    Combo combo = null;
    List<CodeItem> list = null;

    public ShopCombo(Combo combo) {
        this.combo = combo;
    }

    public String firstValue() {
        String ret = "";
        try {
            ret = this.data.entrySet().stream().map(p -> (CodeItem)p.getValue()).map(p -> p.getCode()).findFirst().orElse("");
            return ret;
        }
        catch (Exception exception) {
            return ret;
        }
    }

    public String getSelectionValue(int index) {
        String ret;
        block4: {
            ret = "";
            try {
                Integer sel = index;
                if (sel != -1) break block4;
                return "";
            }
            catch (Exception exception) {
                return ret;
            }
        }
        CodeItem item = this.data.get(index);
        ret = item.getCode();
        if (item == null) {
            return "";
        }
        return ret;
    }

    public void add(String text, String value, int index) {
        this.data.put(index, new CodeItem(value, text));
        this.combo.add(text, index);
    }

    public void add(String text, String value, String fieldName, int index) {
        this.data.put(index, new CodeItem(value, text, fieldName));
        this.combo.add(text, index);
    }

    public String getSelectionValue() {
        Integer sel = this.combo.getSelectionIndex();
        if (sel == -1) {
            return "";
        }
        CodeItem item = this.data.get(this.combo.getSelectionIndex());
        if (item == null) {
            return "";
        }
        return item.getCode() == null ? "" : item.getCode();
    }

    public String getSelectionValue1() {
        Integer sel = this.combo.getSelectionIndex();
        if (sel == 0) {
            return "";
        }
        return this.data.get(this.combo.getSelectionIndex()).getCode() == null ? "" : this.data.get(this.combo.getSelectionIndex()).getCode();
    }

    public String getSelectionFieldName() {
        Integer sel = this.combo.getSelectionIndex();
        if (sel == -1) {
            return "";
        }
        return this.data.get(this.combo.getSelectionIndex()).getFieldName();
    }

    public CodeItem getSelectionItem() {
        Integer sel = this.combo.getSelectionIndex();
        if (sel == -1) {
            return null;
        }
        return this.data.get(this.combo.getSelectionIndex());
    }

    public void selectValue(String code) {
        int ret = -1;
        for (Integer key : this.data.keySet()) {
            CodeItem item = this.data.get(key);
            if (item.getCode() == null || !item.getCode().equals(code)) continue;
            ret = key;
            break;
        }
        if (ret > -1) {
            this.combo.select(ret);
        } else {
            this.combo.select(0);
        }
    }

    public String selectContainsValue(String code) {
        int ret = -1;
        for (Integer key : this.data.keySet()) {
            CodeItem item = this.data.get(key);
            if (item.getCode() == null || !item.getCode().contains(code)) continue;
            ret = key;
            break;
        }
        if (ret > -1) {
            this.combo.select(ret);
            return this.data.get(ret).getCode();
        }
        this.combo.select(0);
        return this.data.get(0).getCode();
    }

    public String selectContainsNameByAutoSetting(String code) {
        int ret = -1;
        for (Integer key : this.data.keySet()) {
            CodeItem item = this.data.get(key);
            if (item.getCode() == null || !item.getCode().contains(code)) continue;
            ret = key;
            break;
        }
        if (ret > -1) {
            return this.data.get(ret).getName();
        }
        return this.data.get(0).getName();
    }

    public int selectContainsName(String name) {
        int ret = -1;
        for (Integer key : this.data.keySet()) {
            CodeItem item = this.data.get(key);
            if (!name.contains(item.getName())) continue;
            ret = key;
            break;
        }
        if (ret > -1) {
            this.combo.select(ret);
        } else {
            this.combo.select(0);
        }
        return ret;
    }

    public int selectEqualsName(String name) {
        int ret = -1;
        for (Integer key : this.data.keySet()) {
            CodeItem item = this.data.get(key);
            if (item.getName() == null || !item.getName().equals(name)) continue;
            ret = key;
            break;
        }
        if (ret > -1) {
            this.combo.select(ret);
        } else {
            this.combo.select(0);
        }
        return ret;
    }

    public void init(String defaultValue) {
        this.data.clear();
        this.combo.removeAll();
        if (!defaultValue.isEmpty()) {
            this.combo.add(defaultValue, 0);
        } else {
            this.combo.add(defaultValue, 0);
        }
    }

    public ShopCombo setCodeBind(List<List<String>> contents, int codeIndex, int valueIndex) {
        return this.setCodeBind(contents, codeIndex, valueIndex, "");
    }

    public ShopCombo setCodeBind(List<List<String>> contents, int codeIndex, int valueIndex, String filedName) {
        if (this.list != null) {
            this.list.clear();
        }
        this.list = contents.stream().map(p -> new CodeItem((String)p.get(codeIndex), (String)p.get(valueIndex), filedName)).collect(Collectors.toList());
        return this;
    }

    public void build(String firstText, boolean isFirstText) {
        int i = 0;
        this.data.clear();
        this.combo.removeAll();
        if (isFirstText) {
            this.combo.add(firstText, i);
            ++i;
        }
        for (CodeItem item : this.list) {
            this.data.put(i, item);
            this.combo.add(item.getName(), i);
            ++i;
        }
        this.combo.select(0);
    }

    public void build(String firstText) {
        this.build(firstText, true);
    }

    public void setDataSource(List<CodeItem> list, String defaultText) {
        int i = 0;
        this.data.clear();
        this.combo.removeAll();
        if (!defaultText.isEmpty()) {
            this.data.put(i, new CodeItem());
            this.combo.add(defaultText, i);
            ++i;
        }
        for (CodeItem item : list) {
            this.data.put(i, item);
            this.combo.add(item.getName(), i);
            ++i;
        }
        this.combo.select(0);
    }

    public void setDataSource(CodeItem item) {
        this.data.clear();
        this.combo.removeAll();
        this.data.put(0, item);
        this.combo.add(item.getName(), 0);
        this.combo.select(0);
    }

    public void setDataSourceDome(List<CodeItem> list) {
        this.setDataSource(list, "\ub3c4\ub9e4\ubab0\uc811\uc18d");
    }

    public void setDataSource1(List<CodeItem> list) {
        this.setDataSource(list, "SCM\uc811\uc18d");
    }

    public void setDataSource(List<CodeItem> list) {
        this.setDataSource(list, "\uc120\ud0dd\ud574\uc8fc\uc138\uc694");
    }

    public void setDataSourceItem(CodeItem item) {
        this.setDataSource(item);
    }

    public void setDataSourceTotal(List<CodeItem> list) {
        this.setDataSource(list, "\uc804\uccb4");
    }

    public void setDataSourceNew(List<CodeItem> list) {
        this.setDataSource(list, "");
    }

    public void setDataSource() {
        this.build("\uc120\ud0dd\ud574\uc8fc\uc138\uc694");
    }

    public void setDataSourceHome(List<CodeItem> list) {
        this.setDataSource(list, "MLink");
    }

    public void select(int index) {
        this.combo.select(index);
    }
}

