/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ApiRateLimiter;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.coupang.IShopOrderCoupangCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderCancleApprovalCommand
extends IShopOrderCoupangCommand {
    private static IShopOrderCommand instance = new CoupangOrderCancleApprovalCommand();
    ObjectMapper mapper = new ObjectMapper();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangOrderCancleApprovalCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        String vendorid = param.get(0).getVendorId();
        ArrayList<ShopOrderMstDto> retlist = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : param) {
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            OrderStoppedShipmentRequestBody requestBody = new OrderStoppedShipmentRequestBody();
            requestBody.setVendorId(vendorid);
            requestBody.setReceiptId(Long.valueOf(dto.getReceiptid()));
            requestBody.setCancelCount(Long.valueOf(dto.getSale_cnt()));
            String json = this.mapper.writeValueAsString((Object)requestBody);
            ShopOrderMstDto retParam = this.getApiList(dto, json);
            retlist.add(retParam);
        }
        return retlist;
    }

    private ShopOrderMstDto getApiList(ShopOrderMstDto param, String json) {
        block24: {
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            try {
                try {
                    String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/returnRequests/%s/stoppedShipment";
                    String acessKey = param.getAuthkey1();
                    String secretKey = param.getAuthKey2();
                    String vendorid = param.getVendorId();
                    URL2 = String.format(URL2, vendorid, Long.valueOf(param.getReceiptid()));
                    URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                    String authorization = Hmac.generate((String)"PATCH", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                    uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                    StringEntity params = new StringEntity(json, "UTF-8");
                    client = HttpClients.createDefault();
                    HttpPatch requestPatch = new HttpPatch(uriBuilder.build().toString());
                    requestPatch.addHeader("Authorization", authorization);
                    requestPatch.addHeader("content-type", "application/json");
                    requestPatch.setEntity((HttpEntity)params);
                    ApiRateLimiter.waitForPermit();
                    response = client.execute((HttpUriRequest)requestPatch);
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    String msg = this.jsonElementNullStr(resObject.get("message"));
                    param.setResult_code("-1");
                    param.setResult_text(msg);
                    if (response.getStatusLine().getStatusCode() == 200 && this.jsonElementNullStr(resObject.get("code")).equals("200")) {
                        param.setResult_code("1");
                    }
                }
                catch (Exception e) {
                    param.setResult_code("-1");
                    param.setResult_text("\ucd9c\uace0\uc911\uc9c0 \uc694\uccad \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4 [" + e.getMessage() + "]");
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
        }
        return param;
    }

    private static class OrderStoppedShipmentRequestBody {
        private String vendorId;
        private Long receiptId;
        private Long cancelCount;

        private OrderStoppedShipmentRequestBody() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public Long getReceiptId() {
            return this.receiptId;
        }

        public void setReceiptId(Long receiptId) {
            this.receiptId = receiptId;
        }

        public Long getCancelCount() {
            return this.cancelCount;
        }

        public void setCancelCount(Long cancelCount) {
            this.cancelCount = cancelCount;
        }
    }
}

