/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.IShopOrderAlwayzCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AlwayzOrderNewCommand
extends IShopOrderAlwayzCommand {
    private static IShopOrderCommand instance = new AlwayzOrderNewCommand();
    private boolean isBasic = false;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AlwayzOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        try {
            String inputLine;
            ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
            ShopOrderMstDto dto = param.get(0);
            this.isBasic = dto.getSpecificStatus() == null || dto.getSpecificStatus().equals("");
            String token = AlwayzAccessToken.get().getAccessToken(dto.getShop_userid(), dto.getShopPw());
            URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers/orders/status");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
            connection.setRequestProperty("x-access-token", token);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(response.toString());
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                String[] newOrderState = this.getOrderStatus(dto.getSpecificStatus());
                if (newOrderState.length == 0) {
                    return ret;
                }
                String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
                String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
                JsonArray dataArray = (JsonArray)jsonObject.get("data");
                int i = 0;
                while (i < dataArray.size()) {
                    JsonArray orderArrays;
                    JsonObject obj = (JsonObject)dataArray.get(i);
                    String dataStatus = obj.get("status").getAsString();
                    if (Arrays.asList(newOrderState).contains(dataStatus) && (orderArrays = (JsonArray)obj.get("topKOrders")).size() > 0) {
                        List<Object> orderList = new ArrayList();
                        if (!this.isBasic) {
                            JsonArray comparedOrderArrays = new JsonArray();
                            for (JsonElement ele : orderArrays) {
                                JsonObject object = ele.getAsJsonObject();
                                String preShippingTimeStamp = object.get("preShippingTimeStamp").getAsString().substring(0, 10);
                                if (enddt.compareTo(preShippingTimeStamp) < 0) continue;
                                if (startdt.compareTo(preShippingTimeStamp) > 0) break;
                                comparedOrderArrays.add((JsonElement)object);
                            }
                            if (comparedOrderArrays.size() > 0) {
                                orderList = this.setData(comparedOrderArrays, dto, this.getOrderStat(dataStatus));
                                orderList.forEach(d -> d.setResult_code("1"));
                            }
                        } else {
                            orderList = this.setData(orderArrays, dto, this.getOrderStat(dataStatus));
                            orderList.forEach(d -> d.setResult_code("1"));
                        }
                        ret.addAll(orderList);
                    }
                    ++i;
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String[] getOrderStatus(String specificStatus) {
        if (this.isBasic) {
            return new String[]{"pre-shipping-pre-excel", "pre-shipping-post-excel", "pre-shipping-pre-excel-delayed", "pre-shipping-post-excel-delayed"};
        }
        switch (specificStatus) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return new String[]{"pre-shipping-pre-excel", "pre-shipping-pre-excel-delayed"};
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                return new String[]{"pre-shipping-post-excel", "pre-shipping-post-excel-delayed"};
            }
            case "\ubc30\uc1a1\uc911": {
                return new String[]{"shipping-sending", "shipping"};
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return new String[]{"arrived"};
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return new String[]{"reviewed"};
            }
            case "\ucde8\uc18c": {
                return new String[]{"canceling-pre-shipping-post-excel", "canceled-pre-shipping"};
            }
            case "\ubc18\ud488": {
                return new String[]{"refunding", "canceling-shipping", "refunded", "canceled-shipping"};
            }
        }
        return new String[0];
    }

    private String getOrderStat(String alwayzStat) {
        String orderStat = "";
        switch (alwayzStat) {
            case "pre-shipping-pre-excel-delayed": 
            case "pre-shipping-pre-excel": {
                orderStat = "100";
                break;
            }
            case "pre-shipping-post-excel": 
            case "pre-shipping-post-excel-delayed": {
                orderStat = "100";
                break;
            }
            case "shipping-sending": 
            case "shipping": {
                orderStat = "403";
                break;
            }
            case "arrived": 
            case "reviewed": {
                orderStat = "410";
                break;
            }
            case "canceling-pre-shipping-post-excel": {
                orderStat = "C01";
                break;
            }
            case "canceled-pre-shipping": {
                orderStat = "C02";
                break;
            }
            case "refunding": 
            case "canceling-shipping": {
                orderStat = "R01";
                break;
            }
            case "refunded": 
            case "canceled-shipping": {
                orderStat = "R02";
            }
        }
        return orderStat;
    }

    private List<ShopOrderMstDto> setData(JsonArray orderArrys, ShopOrderMstDto ordDto, String orderStatus) throws Exception {
        ArrayList<ShopOrderMstDto> orderList = new ArrayList<ShopOrderMstDto>();
        try {
            for (JsonElement ele : orderArrys) {
                JsonObject object = ele.getAsJsonObject();
                String orderId = this.jsonElementNullStr(object.get("_id"));
                if (this.isBasic && ShopOrderDao.get().isOrdered(orderId)) continue;
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_status(orderStatus);
                dto.setShopid(ordDto.getShopid());
                dto.setShop_userid(ordDto.getShop_userid());
                dto.setDelivery_method_str2("\ubb34\ub8cc");
                dto.setDelv_cost("0");
                dto.setCompno(ordDto.getCompno());
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                JsonObject itemInfo = object.get("itemInfo").getAsJsonObject();
                dto.setP_product_name(itemInfo.get("itemTitle").getAsString());
                dto.setOrder_date(this.dateFormat(object.get("preShippingTimeStamp").getAsString()));
                dto.setOrder_id(orderId);
                dto.setProduct_name(itemInfo.get("itemTitle").getAsString());
                JsonObject selectedOption = object.get("selectedOption").getAsJsonObject();
                dto.setP_sku_value(this.setOption(object, itemInfo, selectedOption));
                dto.setSku_value(dto.getP_sku_value());
                dto.setSale_cnt(object.get("quantity").getAsString());
                dto.setUser_name("");
                JsonObject addressInfo = object.get("addressInfo").getAsJsonObject();
                dto.setReceive_name(addressInfo.get("recipient").getAsString());
                dto.setReceive_zipcode(addressInfo.get("postcode").getAsString());
                dto.setReceive_addr(addressInfo.get("postcodeAddress").getAsString() + " " + addressInfo.get("detailAddress").getAsString());
                double amount = object.get("totalPrice").getAsDouble();
                double commissionRate = 0.035;
                int price2 = (int)Math.round(amount - amount * commissionRate);
                dto.setMall_won_cost(String.valueOf(price2));
                dto.setTotal_cost(object.get("totalPrice").getAsString());
                dto.setPay_cost(object.get("totalPrice").getAsString());
                dto.setSale_cost(selectedOption.get("teamPurchasePrice").getAsString());
                dto.setMall_product_id(itemInfo.get("itemId").getAsString());
                dto.setMall_exp_cd(selectedOption.get("optionCode").isJsonNull() ? "" : selectedOption.get("optionCode").getAsString());
                dto.setP_sku_id(dto.getSku_value());
                String recipientPhoneNumber = this.formatPhoneNumber(addressInfo.get("recipientPhoneNumber").getAsString());
                dto.setReceive_tel(recipientPhoneNumber);
                dto.setReceive_cel(recipientPhoneNumber);
                String receivingMethod = addressInfo.get("receivingMethod").getAsString();
                String frontDoorPassword = addressInfo.get("frontDoorPassword").getAsString();
                StringBuilder sb = new StringBuilder();
                if (receivingMethod.equals("door")) {
                    sb.append("\ubb38 \uc55e");
                } else if (receivingMethod.equals("etc")) {
                    sb.append(addressInfo.get("detailForReceivingMethod").getAsString());
                }
                if (!frontDoorPassword.equals("")) {
                    sb.append(", \uacf5\ub3d9\ud604\uad00 \ube44\ubc00\ubc88\ud638 : ").append(frontDoorPassword);
                }
                dto.setDelv_msg(sb.toString());
                dto.setReceive_email("");
                if (!this.isBasic) {
                    try {
                        String optionCode = this.jsonElementNullStr(selectedOption.get("optionCode"));
                        if (optionCode.contains("_")) {
                            optionCode = optionCode.split("_")[0];
                        }
                        dto.setCompayny_goods_cd(optionCode);
                    }
                    catch (Exception exception) {
                        dto.setCompayny_goods_cd("");
                    }
                } else {
                    dto.setCompayny_goods_cd(this.getCompanyGoodsCd(dto.getMall_product_id(), ordDto.getShopid()));
                }
                if (object.has("shippingInfo")) {
                    JsonObject shippingInfo = object.get("shippingInfo").getAsJsonObject();
                    dto.setDeliveryName(this.jsonElementNullStr(shippingInfo.get("shippingCompanyName")));
                    dto.setDelivery_id(this.jsonElementNullStr(shippingInfo.get("shippingCompanyCode")));
                    dto.setInvoice_no(this.jsonElementNullStr(shippingInfo.get("shippingNumber")));
                }
                dto.setResult_code("1");
                dto.setAuthkey1(ordDto.getAuthkey1());
                orderList.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \uc2e0\uaddc \uc8fc\ubb38 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return orderList;
    }

    private String getCompanyGoodsCd(String itemId, String shopId) {
        String company_goods_cd = "";
        try {
            company_goods_cd = ShopCommonDao.get().getCompanyGoodsCd(itemId, shopId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return company_goods_cd;
    }

    private String setOption(JsonObject object, JsonObject itemInfo, JsonObject selectedOption) {
        JsonObject optionsInfo = (JsonObject)itemInfo.get("optionsInfo");
        JsonArray optionNames = (JsonArray)optionsInfo.get("optionNames");
        JsonArray totalOptions = (JsonArray)optionsInfo.get("totalOptions");
        Object option2 = "";
        int selectedValue1 = 0;
        if (optionNames.size() == 2) {
            List optionNameList = IntStream.range(0, optionNames.size()).mapToObj(arg_0 -> ((JsonArray)optionNames).get(arg_0)).map(element -> element.getAsString()).collect(Collectors.toList());
            ArrayList option1 = new ArrayList();
            ArrayList option22 = new ArrayList();
            JsonArray totalOptionsArray1 = totalOptions.get(0).getAsJsonArray();
            IntStream.range(0, totalOptionsArray1.size()).forEach(t -> {
                boolean bl = option1.add(totalOptionsArray1.get(t).getAsJsonObject().get("name").getAsString());
            });
            JsonArray totalOptionsArray2 = totalOptions.get(1).getAsJsonArray();
            IntStream.range(0, totalOptionsArray2.size()).forEach(q -> {
                boolean bl = option22.add(totalOptionsArray2.get(q).getAsJsonObject().get("name").getAsString());
            });
            selectedValue1 = selectedOption.get("0").getAsInt();
            int selectedValue2 = selectedOption.get("1").getAsInt();
            String optionValue1 = (String)option1.get(selectedValue1);
            String optionValue2 = (String)option22.get(selectedValue2);
            option2 = "0. " + (String)optionNameList.get(0) + ": " + optionValue1 + "\n1. " + (String)optionNameList.get(1) + ": " + optionValue2;
        } else if (optionNames.size() == 1) {
            selectedValue1 = selectedOption.get("0").getAsInt();
            String optionName = optionNames.get(0).getAsString();
            String optionValue = totalOptions.get(0).getAsJsonArray().get(selectedValue1).getAsJsonObject().get("name").getAsString();
            option2 = "0. " + optionName + ": " + optionValue;
        }
        return option2;
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    private String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber.length() == 11) {
            String part1 = phoneNumber.substring(0, 3);
            String part2 = phoneNumber.substring(3, 7);
            String part3 = phoneNumber.substring(7);
            return part1 + "-" + part2 + "-" + part3;
        }
        return "Invalid phone number length!";
    }
}

