/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopOrderColumn;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopUserData;
import com.kdjsystem.mlink.shop.data.gsshop.IShopOrderGsShopCommand;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class GsShopOrderExpressCommand
extends IShopOrderGsShopCommand {
    private static GsShopOrderExpressCommand instance = new GsShopOrderExpressCommand();

    public static GsShopOrderExpressCommand getInstance() {
        return instance;
    }

    private GsShopOrderExpressCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        Map<String, String> cookies = this.getLoginCookie(param);
        for (ShopOrderMstDto dto : param) {
            String invoiceNo = dto.getInvoice_no();
            String deliveryCompanyCode = dto.getDelivery_id();
            if (invoiceNo.isEmpty() || deliveryCompanyCode.isEmpty()) continue;
            try {
                GsShopRows rows = GsShopApiClient.search(this.getUrl(dto), cookies);
                if (rows.getTotalCount() > 0) {
                    Connection con = Jsoup.connect((String)"https://withgs.gsshop.com/dlv/dirdlvOrdMng/saveRelsFsh?dirdlvRelsInfoImprovTgtYn=N").cookies(cookies).header("Accept", "*/*").header("Content-Type", "application/x-www-form-urlencoded").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true);
                    this.applyGsOrderFormData(con, rows, deliveryCompanyCode, invoiceNo);
                    Connection.Response rs = con.execute();
                    if (rs.statusCode() == 200) {
                        dto.setOrder_status("403");
                        dto.setResult_code("1");
                        dto.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \ubc1c\uc1a1\ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    } else {
                        dto.setResult_code("-1");
                        dto.setResult_text("\ubc1c\uc1a1\ucc98\ub9ac\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    }
                    retList.add(dto);
                    continue;
                }
                YDMAStringUtil.Print("\uc9c0\uc5d0\uc2a4\uc0f5 \uc8fc\ubb38 \uc5c6\uc74c Continue");
            }
            catch (Exception exception) {
                YDMAStringUtil.Print("\uc9c0\uc5d0\uc2a4\uc0f5 \ubc1c\uc1a1 \uc804 \uc870\ud68c\uc911 \uc5d0\ub7ec \ubc1c\uc0dd Continue");
            }
        }
        return retList;
    }

    private String getUrl(ShopOrderMstDto dto) throws Exception {
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/dlv/dirdlvOrdMng/list").addParameter("flag", "").addParameter("ecDirdlvOboxYn", "").addParameter("dirdlvRelsInfoImprovTgtYn", "N").addParameter("downPsblYn", "null").addParameter("intgSrchLinkOrdNo", "").addParameter("dateTime", YDMATimeUtil.getCurrentTimeByYDFormat()).addParameter("soldOut", "").addParameter("prdCd", "").addParameter("itemCd", "").addParameter("sendFlag", "").addParameter("rcvfromDtm", "").addParameter("rcvToDtm", "").addParameter("rcvQryTerm", "").addParameter("rcvSrchCond", "").addParameter("chkOrgSupCd", dto.getShop_userid()).addParameter("chkSupCd", dto.getShop_userid()).addParameter("userDownLoadYn", "0").addParameter("mobilCpnAutoRfnSupYn", "N").addParameter("ansimCelphnSupYn", "N").addParameter("srchPrdCd", "").addParameter("giftPkgSupYn", "N").addParameter("hisOrdNo", "").addParameter("allMaskingYn", "N").addParameter("relsSchdDtEntYn", "0").addParameter("qryTerm", "A").addParameter("fromSearchDtm", start).addParameter("toSearchDtm", end).addParameter("prdCdType", "A").addParameter("searchPrdCd", "").addParameter("srchCond", "C").addParameter("srchText", dto.getOrder_id()).addParameter("ordTyp", "0").addParameter("dlvGbn", "0").addParameter("ordCnfYn", "0").addParameter("ordSt", "1").addParameter("ordSt", "2").addParameter("fileDownGbn", "1").addParameter("fileDownGbnDtl", "1").addParameter("pageIdx", "1").addParameter("rowsPerPage", "50").addParameter("pageRange", "10");
        URI uri = builder.build();
        return uri.toString();
    }

    private void applyGsOrderFormData(Connection con, GsShopRows rows, String deliveryCompanyCode, String invoiceNo) {
        GsShopRow row = rows.getRows().get(0);
        List<GsShopUserData> userData = rows.getUserdataList();
        con.data("0_gr_id", row.getCell(GsShopOrderColumn.GR_ID.idx)).data("0_checked", "1").data("0_dlvGbnNm", row.getCell(GsShopOrderColumn.DLV_GBN_NM.idx)).data("0_dtctRelsTgt", row.getCell(GsShopOrderColumn.DTCT_RELS_TGT.idx)).data("0_ordSt", row.getCell(GsShopOrderColumn.ORD_ST.idx)).data("0_exchRtpYn", row.getCell(GsShopOrderColumn.EXCH_RTP_YN.idx)).data("0_ordCnf", row.getCell(GsShopOrderColumn.ORD_CNF.idx)).data("0_sordDt", row.getCell(GsShopOrderColumn.SORD_DT.idx)).data("0_sordTime", row.getCell(GsShopOrderColumn.SORD_TIME.idx)).data("0_relsObeyDt", row.getCell(GsShopOrderColumn.RELS_OBEY_DT.idx)).data("0_relsObeyTime", row.getCell(GsShopOrderColumn.RELS_OBEY_TIME.idx)).data("0_dlvObeyDt", row.getCell(GsShopOrderColumn.DLV_OBEY_DT.idx)).data("0_sordNo", row.getCell(GsShopOrderColumn.SORD_NO.idx)).data("0_ordTyp", row.getCell(GsShopOrderColumn.ORD_TYP.idx)).data("0_shtprdRegrId", row.getCell(GsShopOrderColumn.SHTPRD_REGR_ID.idx)).data("0_shtprdRegDtm", row.getCell(GsShopOrderColumn.SHTPRD_REG_DTM.idx)).data("0_ordNo", row.getCell(GsShopOrderColumn.ORD_NO.idx)).data("0_ecSupOrdNo", row.getCell(GsShopOrderColumn.EC_SUP_ORD_NO.idx)).data("0_supPrdCd", row.getCell(GsShopOrderColumn.SUP_PRD_CD.idx)).data("0_supAttrPrdCd", row.getCell(GsShopOrderColumn.SUP_ATTR_PRD_CD.idx)).data("0_supOrdNo", row.getCell(GsShopOrderColumn.SUP_ORD_NO.idx)).data("0_ordItemNo", row.getCell(GsShopOrderColumn.ORD_ITEM_NO.idx)).data("0_dealNo", row.getCell(GsShopOrderColumn.DEAL_NO.idx)).data("0_orgOrdNo", row.getCell(GsShopOrderColumn.ORG_ORD_NO.idx)).data("0_ordDt", row.getCell(GsShopOrderColumn.ORD_DT.idx)).data("0_ordCnlDtm", row.getCell(GsShopOrderColumn.ORD_CNL_DTM.idx)).data("0_rcvr", row.getCell(GsShopOrderColumn.RCVR.idx)).data("0_rcvrCelphn", row.getCell(GsShopOrderColumn.RCVR_CELPHN.idx)).data("0_rcvrTelno", row.getCell(GsShopOrderColumn.RCVR_TELNO.idx)).data("0_zipcd", row.getCell(GsShopOrderColumn.ZIPCD.idx)).data("0_rcvrAddr", row.getCell(GsShopOrderColumn.RCVR_ADDR.idx)).data("0_ordPrsn", row.getCell(GsShopOrderColumn.ORD_PRSN.idx)).data("0_ordPrsnCustNo", row.getCell(GsShopOrderColumn.ORD_PRSN_CUST_NO.idx)).data("0_ordPrsnTelno", row.getCell(GsShopOrderColumn.ORD_PRSN_TELNO.idx)).data("0_ordPrsnCelphn", row.getCell(GsShopOrderColumn.ORD_PRSN_CELPHN.idx)).data("0_dlvMsg", row.getCell(GsShopOrderColumn.DLV_MSG.idx)).data("0_ordmadMnfcReqCntnt", row.getCell(GsShopOrderColumn.ORDMAD_MNFC_REQ_CNTNT.idx)).data("0_giftPkgOpt", row.getCell(GsShopOrderColumn.GIFT_PKG_OPT.idx)).data("0_dlvsCoCd", deliveryCompanyCode).data("0_invNo", invoiceNo).data("0_relsExtndPsblDdcntDt", row.getCell(GsShopOrderColumn.RELS_EXTND_PSBL_DDCNT_DT.idx)).data("0_relsSchdDt", row.getCell(GsShopOrderColumn.RELS_SCHD_DT.idx)).data("0_dlyRsn", row.getCell(GsShopOrderColumn.DLY_RSN.idx)).data("0_hcSt", row.getCell(GsShopOrderColumn.HC_ST.idx)).data("0_hcCntnt", row.getCell(GsShopOrderColumn.HC_CNTNT.idx)).data("0_hcPrgPlan", row.getCell(GsShopOrderColumn.HC_PRG_PLAN.idx)).data("0_befHcDt", row.getCell(GsShopOrderColumn.BEF_HC_DT.idx)).data("0_relsInvRegDt", row.getCell(GsShopOrderColumn.RELS_INV_REG_DT.idx)).data("0_relsFshDt", row.getCell(GsShopOrderColumn.RELS_FSH_DT.idx)).data("0_dlvFshDt", row.getCell(GsShopOrderColumn.DLV_FSH_DT.idx)).data("0_dlvFshEntSubj", row.getCell(GsShopOrderColumn.DLV_FSH_ENT_SUBJ.idx)).data("0_saleAwareDt", row.getCell(GsShopOrderColumn.SALE_AWARE_DT.idx)).data("0_orgprdDlvFshDt", row.getCell(GsShopOrderColumn.ORGPRD_DLV_FSH_DT.idx)).data("0_chanlNm", row.getCell(GsShopOrderColumn.CHANL_NM.idx)).data("0_attrPrdCd", row.getCell(GsShopOrderColumn.ATTR_PRD_CD.idx)).data("0_prdNm", row.getCell(GsShopOrderColumn.PRD_NM.idx)).data("0_attrPrdNm", row.getCell(GsShopOrderColumn.ATTR_PRD_NM.idx)).data("0_pmoSntnc", row.getCell(GsShopOrderColumn.PMO_SNTNC.idx)).data("0_intrntPrdNm", row.getCell(GsShopOrderColumn.INTRNT_PRD_NM.idx)).data("0_prSntnc", row.getCell(GsShopOrderColumn.PR_SNTNC.idx)).data("0_sordQty", row.getCell(GsShopOrderColumn.SORD_QTY.idx)).data("0_supAttrPrdNm", row.getCell(GsShopOrderColumn.SUP_ATTR_PRD_NM.idx)).data("0_autoRfnRt", row.getCell(GsShopOrderColumn.AUTO_RFN_RT.idx)).data("0_smlchgShrRt", row.getCell(GsShopOrderColumn.SMLCHG_SHR_RT.idx)).data("0_cpnValidDtm", row.getCell(GsShopOrderColumn.CPN_VALID_DTM.idx)).data("0_saleTmp", row.getCell(GsShopOrderColumn.SALE_TMP.idx)).data("0_custPayAmt", row.getCell(GsShopOrderColumn.CUST_PAY_AMT.idx)).data("0_supGivAmt", row.getCell(GsShopOrderColumn.SUP_GIV_AMT.idx)).data("0_chrDlvYn", row.getCell(GsShopOrderColumn.CHR_DLV_YN.idx)).data("0_dlvc", row.getCell(GsShopOrderColumn.DLVC.idx)).data("0_addDlvcPrdYn", row.getCell(GsShopOrderColumn.ADD_DLVC_PRD_YN.idx)).data("0_addDlvcPayYn", row.getCell(GsShopOrderColumn.ADD_DLVC_PAY_YN.idx)).data("0_dlvcCd", row.getCell(GsShopOrderColumn.DLVC_CD.idx)).data("0_oboxYn", row.getCell(GsShopOrderColumn.OBOX_YN.idx)).data("0_rfnTyp", row.getCell(GsShopOrderColumn.RFN_TYP.idx)).data("0_rfnTime", row.getCell(GsShopOrderColumn.RFN_TIME.idx)).data("0_entrstYn", row.getCell(GsShopOrderColumn.ENTRST_YN.idx)).data("0_custReqMatr", row.getCell(GsShopOrderColumn.CUST_REQ_MATR.idx)).data("0_clerncUniqSignVal", row.getCell(GsShopOrderColumn.CLERNC_UNIQ_SIGN_VAL.idx)).data("0_giftMsg", row.getCell(GsShopOrderColumn.GIFT_MSG.idx)).data("0_prchTyp", row.getCell(GsShopOrderColumn.PRCH_TYP.idx)).data("0_gsSordNo", row.getCell(GsShopOrderColumn.GS_SORD_NO.idx)).data("0_relsSchdDtChk", row.getCell(GsShopOrderColumn.RELS_SCHD_DT_CHK.idx)).data("0_dlyRsnCdChk", row.getCell(GsShopOrderColumn.DLY_RSN_CD_CHK.idx)).data("0_dlvReqAgncy", row.getCell(GsShopOrderColumn.DLV_REQ_AGNCY.idx)).data("0_rsrvOrdYn", row.getCell(GsShopOrderColumn.RSRV_ORD_YN.idx)).data("0_charCpnRcvr", row.getCell(GsShopOrderColumn.CHAR_CPN_RCVR.idx)).data("0_charCpnRcvCelphn", row.getCell(GsShopOrderColumn.CHAR_CPN_RCV_CELPHN.idx)).data("0_charCpnSndCelphn", row.getCell(GsShopOrderColumn.CHAR_CPN_SND_CELPHN.idx)).data("0_instlPrdYn", row.getCell(GsShopOrderColumn.INSTL_PRD_YN.idx)).data("0_suply", row.getCell(GsShopOrderColumn.SUPLY.idx)).data("0_rsrvConslCntcTelno", row.getCell(GsShopOrderColumn.RSRV_CONSL_CNTC_TELNO.idx)).data("0_prdCd", row.getCell(GsShopOrderColumn.PRD_CD.idx)).data("0_dlvNoNeed", row.getCell(GsShopOrderColumn.DLV_NO_NEED.idx)).data("0_ordCnfDtm", row.getCell(GsShopOrderColumn.ORD_CNF_DTM.idx)).data("0_ordItemId", row.getCell(GsShopOrderColumn.ORD_ITEM_ID.idx)).data("0_dpoCnfDtm", row.getCell(GsShopOrderColumn.DPO_CNF_DTM.idx)).data("0_gftTypCd", row.getCell(GsShopOrderColumn.GFT_TYP_CD.idx)).data("0_relsSchdDtExtndLimitYn", row.getCell(GsShopOrderColumn.RELS_SCHD_DT_EXTND_LIMIT_YN.idx)).data("0_tranAddr", row.getCell(GsShopOrderColumn.TRAN_ADDR.idx)).data("0_subSupCd", row.getCell(GsShopOrderColumn.SUB_SUP_CD.idx)).data("0_subSupNm", row.getCell(GsShopOrderColumn.SUB_SUP_NM.idx)).data("0_prdTypCd", row.getCell(GsShopOrderColumn.PRD_TYP_CD.idx)).data("0_lineNum", row.getCell(GsShopOrderColumn.LINE_NUM.idx)).data("0_osdStCd", row.getCell(GsShopOrderColumn.OSD_ST_CD.idx)).data("0_custNo", row.getCell(GsShopOrderColumn.CUST_NO.idx)).data("0_orderMedia", row.getCell(GsShopOrderColumn.ORDER_MEDIA.idx)).data("0_ordDtm", row.getCell(GsShopOrderColumn.ORD_DTM.idx)).data("0_chanlCd", row.getCell(GsShopOrderColumn.CHANL_CD.idx)).data("0_sordItemNo", row.getCell(GsShopOrderColumn.SORD_ITEM_NO.idx)).data("0_currSordNo", row.getCell(GsShopOrderColumn.CURR_SORD_NO.idx)).data("0_currSordItemNo", row.getCell(GsShopOrderColumn.CURR_SORD_ITEM_NO.idx)).data("0_dirdlvMngAgncyYn", row.getCell(GsShopOrderColumn.DIRDLV_MNG_AGNCY_YN.idx)).data("0_sordStCd", row.getCell(GsShopOrderColumn.SORD_ST_CD.idx)).data("0_dlvPickMthodCd", row.getCell(GsShopOrderColumn.DLV_PICK_MTHOD_CD.idx)).data("0_supNtcApplyYn", row.getCell(GsShopOrderColumn.SUP_NTC_APPLY_YN.idx)).data("0_prdClsCheckYn", row.getCell(GsShopOrderColumn.PRD_CLS_CHECK_YN.idx)).data("0_prdClsCd", row.getCell(GsShopOrderColumn.PRD_CLS_CD.idx)).data("0_chrDlvInfo", row.getCell(GsShopOrderColumn.CHR_DLV_INFO.idx)).data("0_jejuChrDlvInfo", row.getCell(GsShopOrderColumn.JEJU_CHR_DLV_INFO.idx)).data("0_ilndChrDlvInfo", row.getCell(GsShopOrderColumn.ILND_CHR_DLV_INFO.idx)).data("0_apntDtDlvYn", row.getCell(GsShopOrderColumn.APNT_DT_DLV_YN.idx)).data("0_apntDtDlvTyp", row.getCell(GsShopOrderColumn.APNT_DT_DLV_TYP.idx)).data("0_hopeDlvDt", row.getCell(GsShopOrderColumn.HOPE_DLV_DT.idx)).data("0_hopeDlvYn", row.getCell(GsShopOrderColumn.HOPE_DLV_YN.idx)).data("0_cmmFrontPasswd", row.getCell(GsShopOrderColumn.CMM_FRONT_PASSWD.idx)).data("0_!nativeeditor_status", "updated").data("0_noProcNoCnfCnt", userData.get(0).getValue()).data("0_noProcCnfCnt", userData.get(1).getValue()).data("0_noProcDlyCnt", userData.get(2).getValue()).data("0_ordCnlCnt", userData.get(3).getValue()).data("0_relsFshCnt", userData.get(4).getValue()).data("0_dlvFshCnt", userData.get(5).getValue()).data("0_relsInvRegCnt", userData.get(6).getValue()).data("0_ordShtitmCnt", userData.get(7).getValue()).data("ids", "0");
    }
}

