/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopOrderColumn;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.shop.data.gsshop.IShopOrderGsShopCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class GsShopOrderNewCommand
extends IShopOrderGsShopCommand {
    private static GsShopOrderNewCommand instance = new GsShopOrderNewCommand();

    public static GsShopOrderNewCommand getInstance() {
        return instance;
    }

    private GsShopOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        Map<String, String> cookies = this.getLoginCookie(param);
        this.getNewOrder(dto, retList, this.getUrl(dto, false), cookies);
        this.getDelvieredOrder(dto, retList, this.getUrl(dto, true), cookies);
        return retList;
    }

    private String getUrl(ShopOrderMstDto dto, boolean isDelivered) throws URISyntaxException {
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/dlv/dirdlvOrdMng/list").addParameter("flag", "").addParameter("ecDirdlvOboxYn", "").addParameter("dirdlvRelsInfoImprovTgtYn", "N").addParameter("downPsblYn", "null").addParameter("intgSrchLinkOrdNo", "").addParameter("dateTime", YDMATimeUtil.getCurrentTimeByYDFormat()).addParameter("soldOut", "").addParameter("prdCd", "").addParameter("itemCd", "").addParameter("sendFlag", "").addParameter("rcvfromDtm", "").addParameter("rcvToDtm", "").addParameter("rcvQryTerm", "").addParameter("rcvSrchCond", "").addParameter("chkOrgSupCd", dto.getShop_userid()).addParameter("chkSupCd", dto.getShop_userid()).addParameter("userDownLoadYn", "0").addParameter("mobilCpnAutoRfnSupYn", "N").addParameter("ansimCelphnSupYn", "N").addParameter("srchPrdCd", "").addParameter("giftPkgSupYn", "N").addParameter("hisOrdNo", "").addParameter("allMaskingYn", "N").addParameter("relsSchdDtEntYn", "0").addParameter("qryTerm", "A").addParameter("fromSearchDtm", start).addParameter("toSearchDtm", end).addParameter("prdCdType", "A").addParameter("searchPrdCd", "").addParameter("srchCond", "A").addParameter("srchText", "").addParameter("ordTyp", "0").addParameter("dlvGbn", "0").addParameter("ordCnfYn", "0");
        if (isDelivered) {
            builder.addParameter("ordSt", "6").addParameter("fileDownGbn", "1").addParameter("fileDownGbnDtl", "1").addParameter("pageIdx", "1").addParameter("rowsPerPage", "50").addParameter("pageRange", "10");
        } else {
            builder.addParameter("saleAwareCk", "0").addParameter("ordSt", "1").addParameter("ordSt", "2").addParameter("fileDownGbn", "1").addParameter("fileDownGbnDtl", "1").addParameter("pageIdx", "1").addParameter("rowsPerPage", "50").addParameter("pageRange", "10");
        }
        URI uri = builder.build();
        return uri.toString();
    }

    private void getNewOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String url, Map<String, String> cookies) throws Exception {
        GsShopRows rows = GsShopApiClient.search(url, cookies);
        if (rows.getTotalCount() > 0) {
            List<ShopOrderMstDto> orderList = this.setData(rows, dto);
            orderList.forEach(d -> d.setResult_code("1"));
            retList.addAll(orderList);
        }
    }

    private void getDelvieredOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String url, Map<String, String> cookies) throws Exception {
        GsShopRows rows = GsShopApiClient.search(url, cookies);
        if (rows.getTotalCount() > 0) {
            List<ShopOrderMstDto> orderList = this.setData(rows, dto);
            orderList.forEach(d -> d.setResult_code("1"));
            retList.addAll(orderList);
        }
    }

    private List<ShopOrderMstDto> setData(GsShopRows rows, ShopOrderMstDto ordDto) {
        ArrayList<ShopOrderMstDto> orderList = new ArrayList<ShopOrderMstDto>();
        for (GsShopRow row : rows.getRows()) {
            try {
                String orderId = row.getCell(GsShopOrderColumn.ORD_NO.idx);
                if (ShopOrderDao.get().isOrdered(orderId)) continue;
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setShopid(ordDto.getShopid());
                dto.setShop_userid(ordDto.getShop_userid());
                dto.setCompno(ordDto.getCompno());
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setOrder_status(this.getStatus(row.getCell(GsShopOrderColumn.ORD_ST.idx)));
                dto.setOrder_date(row.getCell(GsShopOrderColumn.ORD_DT.idx));
                dto.setOrder_id(orderId);
                dto.setUser_name(row.getCell(GsShopOrderColumn.ORD_PRSN.idx));
                dto.setUser_tel(row.getCell(GsShopOrderColumn.ORD_PRSN_TELNO.idx));
                dto.setUser_cel(row.getCell(GsShopOrderColumn.ORD_PRSN_CELPHN.idx));
                dto.setReceive_name(row.getCell(GsShopOrderColumn.RCVR.idx));
                dto.setReceive_zipcode(row.getCell(GsShopOrderColumn.ZIPCD.idx));
                dto.setReceive_addr(row.getCell(GsShopOrderColumn.RCVR_ADDR.idx));
                dto.setReceive_tel(row.getCell(GsShopOrderColumn.RCVR_TELNO.idx));
                dto.setReceive_cel(row.getCell(GsShopOrderColumn.RCVR_CELPHN.idx));
                dto.setDelv_msg(row.getCell(GsShopOrderColumn.DLV_MSG.idx));
                dto.setDelivery_method_str2(row.getCell(GsShopOrderColumn.CHR_DLV_YN.idx));
                dto.setP_product_name(row.getCell(GsShopOrderColumn.INTRNT_PRD_NM.idx));
                dto.setProduct_name(row.getCell(GsShopOrderColumn.INTRNT_PRD_NM.idx));
                dto.setP_sku_value(row.getCell(GsShopOrderColumn.ATTR_PRD_NM.idx));
                dto.setSku_value(row.getCell(GsShopOrderColumn.ATTR_PRD_NM.idx));
                dto.setCompayny_goods_cd(row.getCell(GsShopOrderColumn.SUP_PRD_CD.idx));
                dto.setMall_product_id(row.getCell(GsShopOrderColumn.PRD_CD.idx));
                dto.setMall_exp_cd(row.getCell(GsShopOrderColumn.ATTR_PRD_CD.idx));
                dto.setSale_cnt(row.getCell(GsShopOrderColumn.SORD_QTY.idx));
                dto.setMall_won_cost(row.getCell(GsShopOrderColumn.SUP_GIV_AMT.idx));
                dto.setTotal_cost(row.getCell(GsShopOrderColumn.SALE_TMP.idx));
                dto.setDelv_cost(row.getCell(GsShopOrderColumn.DLVC.idx));
                dto.setPay_cost(row.getCell(GsShopOrderColumn.CUST_PAY_AMT.idx));
                dto.setResult_code("1");
                orderList.add(dto);
            }
            catch (Exception exception) {}
        }
        return orderList;
    }

    private String getStatus(String stat) {
        switch (stat) {
            case "\ubbf8\ucc98\ub9ac(\uc9c0\uc5f0)": 
            case "\ubbf8\ucc98\ub9ac": 
            case "\ubbf8\ud655\uc778": 
            case "\uc8fc\ubb38\ud655\uc778": {
                return "100";
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return "410";
            }
        }
        return "100";
    }
}

