/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class NaverStoreOrderConfirmCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderConfirmCommand();
    JsonParser jsonparser = new JsonParser();
    OkHttpClient client = new OkHttpClient();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderConfirmCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto shopDto = param.get(0);
        if (shopDto.getVendorId().equals("N")) {
            Map<String, String> cookies = super.getCookies(shopDto);
            for (ShopOrderMstDto dto : param) {
                String json = "{\"productOrderIds\":\"" + dto.getMall_exp_cd() + "\",\"onlyValidation\":true,\"patch\":\"placeOrder\",\"validationSuccess\":true}";
                Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/oa/delivery/placeOrder").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
                boolean success = jsonobject.get("bSuccess").getAsBoolean();
                if (success) {
                    dto.setOrder_status("100");
                    dto.setResult_code("1");
                    dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                } else {
                    dto.setResult_code("-1");
                    try {
                        JsonObject returnValue = jsonobject.get("htReturnValue").getAsJsonObject();
                        JsonObject firstResultMessage = returnValue.get("firstResultMessage").getAsJsonObject();
                        String message = firstResultMessage.get("message").getAsString();
                        dto.setResult_text(message);
                    }
                    catch (Exception exception) {}
                }
                retList.add(dto);
            }
        }
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        String clientId = shopDto.getEDITAUTHKEY1();
        String clientSecret = shopDto.getEDITAPIKEY();
        for (ShopOrderMstDto dto : param) {
            String productId = dto.getMall_exp_cd();
            Long timestamp = System.currentTimeMillis();
            String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
            String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
            boolean success = this.orderConfirmation(accessToken, productId);
            if (success) {
                dto.setOrder_status("100");
                dto.setResult_code("1");
                dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                dto.setResult_code("-1");
            }
            retList.add(dto);
        }
        return retList;
    }

    private boolean orderConfirmation(String accessToken, String productId) throws Exception {
        boolean success;
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":[" + productId + "]}"));
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/confirm").post(requestBody).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Throwable throwable = null;
            Object var7_9 = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonObject jsonobject;
                JsonObject object;
                success = response.isSuccessful() ? (object = (jsonobject = this.jsonparser.parse(response.body().string()).getAsJsonObject()).getAsJsonObject("data")).getAsJsonArray("successProductOrderInfos").size() > 0 : false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return success;
    }
}

