/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.IShopProductCategory;
import com.kdjsystem.mlink.shop.common.ProductCategoryService;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopSSGAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SSGProductModifyService
extends IProductModifyStatusApi {
    private static final String Host = "https://eapi.ssgadm.com";
    List<ShopOptionDto> shopOptionDtos;
    ResponseOption responseOption;

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    private void Basic(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductupdateItemBasic.Om_updateItemBase.ItemBasic itemBasic) throws Exception {
        try {
            String value = IProduct.formatProductNameByCode(dtllist.getProdoutput(), dto);
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(dtllist.getProdnmlast());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 100);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? (value.length() > 100 ? value.substring(0, 100) : value) : value;
            itemBasic.itemNm = sellerProductName;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    protected String setBrandSearch(String brandnm, ShoppingMallDetailDto shoppingMallDetailDto) {
        String brandid = "";
        new ObjectMapper();
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request2 = new Request.Builder().url(Host.concat("/venInfo/0.1/listBrand.ssg?omBrandYn=Y" + brandnm)).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
            new ArrayList();
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (Response response = client.newCall(request2).execute();){
                    String body = response.body().string().toString();
                    JsonParser parser = new JsonParser();
                    JsonObject jsonObject = (JsonObject)parser.parse(body);
                    JsonObject result = (JsonObject)jsonObject.get("result");
                    JsonArray brands = (JsonArray)result.get("brands");
                    int i = 0;
                    while (i < brands.size()) {
                        JsonObject brand;
                        try {
                            brand = (JsonObject)brands.get(i);
                            brandid = brand.get("brandId") != null ? brand.get("brandId").getAsString() : "";
                        }
                        catch (Exception exception) {
                            brand = (JsonArray)brands.get(i);
                            brandid = brand.get(0).getAsJsonObject().get("brandId") != null ? brand.get(0).getAsJsonObject().get("brandId").getAsString() : "";
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                brandid = "";
            }
        }
        catch (Exception exception) {
            brandid = "";
        }
        return brandid;
    }

    private void ItemBasic(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductupdateItemBasic.Om_updateItemBase.ItemBasic itemBasic, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            if (dtllist.getBrandyn().equals("N")) {
                itemBasic.brandId = "";
            } else if (dtllist.getBrandprdnaddi().equals("Y")) {
                String brandnm = dto.getBrand_nm();
                String brandid = this.setBrandSearch("&brandNm=" + brandnm, shoppingMallDetailDto);
                if (brandid.equals("")) {
                    if (dtllist.getBrandprdfail().equals("Y")) {
                        throw new Exception("\ube0c\ub79c\ub4dc\uac00 \uac80\uc0c9\ub418\uc9c0 \uc54a\uc544 \uc2e4\ud328\ucc98\ub9ac\ud569\ub2c8\ub2e4. \ubd80\uac00\uc815\ubcf4\uc758 \ube0c\ub79c\ub4dc \ud56d\ubaa9\uc744 \ud655\uc778\ud574\uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                    }
                    itemBasic.brandId = "";
                } else {
                    itemBasic.brandId = brandid;
                }
            } else {
                itemBasic.brandId = dtllist.getBrandid();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        try {
            itemBasic.mdlNm = dto.getCompayny_goods_cd();
        }
        catch (Exception exception) {
            throw new Exception("\ubaa8\ub378\uba85 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            itemBasic.itemChrctDivCd = dtllist.getItemchrctdivcd();
            itemBasic.itemChrctDtlCd = dtllist.getItemchrctdtlcd();
            itemBasic.exusItemDivCd = dtllist.getExusitemdivcd();
            itemBasic.exusItemDtlCd = dtllist.getExusitemdtlcd();
            itemBasic.adultItemTypeCd = dtllist.getAdultitemtypecd();
            itemBasic.itemStatTypeCd = dtllist.getItemstattypecd();
            itemBasic.itemSellWayCd = dtllist.getItemsellwaycd();
            itemBasic.palimpItemYn = dtllist.getPalimpitemyn();
            itemBasic.giftPsblYn = dtllist.getGiftpsblyn();
            itemBasic.whinNotiYn = dtllist.getWhinnotiyn();
            itemBasic.asMemoCntt = "";
            itemBasic.asTelno = "";
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ud0c0 \ub4f1\ub85d \uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            ArrayList<String> search = new ArrayList<String>();
            search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            if (search.size() > 5) {
                ArrayList<String> items = new ArrayList<String>();
                int i = 0;
                while (i < 5) {
                    items.add((String)search.get(i));
                    ++i;
                }
                itemBasic.itemSrchwdNm = items.stream().collect(Collectors.joining(","));
            } else {
                itemBasic.itemSrchwdNm = search.stream().collect(Collectors.joining(","));
            }
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ud0c0 \ub4f1\ub85d \uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        itemBasic.minOnetOrdPsblQty = dtllist.getMinonetordpsblqty().equals("0") ? "1" : dtllist.getMinonetordpsblqty();
        itemBasic.maxOnetOrdPsblQty = dtllist.getMaxonetordpsblqty().equals("0") ? "1000" : dtllist.getMaxonetordpsblqty();
        itemBasic.max1dyOrdPsblQty = dtllist.getMax1dyordpsblqty().equals("0") ? "1000" : dtllist.getMax1dyordpsblqty();
    }

    private void Category(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductupdateItemBasic.Om_updateItemBase.ItemBasic itemBasic, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            if (dtllist.getIsCategory().equals("1")) {
                itemBasic.stdCtgId = dtllist.getShopcatno();
            } else if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                String cateNum;
                ProductCategoryService service = new ProductCategoryService(IShopProductCategory.getSearchBean(dto.getShopcd()));
                itemBasic.stdCtgId = cateNum = service.excute(dto, null, shoppingMallDetailDto);
            } else {
                itemBasic.stdCtgId = dto.getShopCid();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void BasicShipping(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductupdateDelivery.Om_updateDelivery.Delivery delivery, ShoppingMallDetailDto shoppingMallDetailDto, String itemId) throws Exception {
        try {
            delivery.itemId = itemId;
            delivery.shppMthdCd = dtllist.getShppmthdcd();
            delivery.shppItemDivCd = dtllist.getShppitemdivcd();
            delivery.ctvatInclYn = dtllist.getCtvatlnclyn();
            delivery.exprtCntryId = dtllist.getExprtcntryid();
            delivery.shppRqrmDcnt = dtllist.getShpprqrmdcnt();
            delivery.retExchPsblYn = dtllist.getRetexchpsblyn();
            delivery.tdShppPsblYn = dtllist.getTdshpppsblyn();
            delivery.tdWhoutClsgHm = dtllist.getTdwhoutclsghm().equals("") ? null : dtllist.getTdwhoutclsghm();
            delivery.doffLst = dtllist.getDofflst().equals("N") ? "" : "SAT";
            delivery.whoutShppcstId = dtllist.getWhoutshppcstid();
            delivery.retShppcstId = dtllist.getRetshppcstid();
            delivery.whoutAddrId = dtllist.getWhoutaddrid();
            delivery.snbkAddrId = dtllist.getSnbkaddrid();
            delivery.mareaShppYn = dtllist.getMareashppyn();
            delivery.jejuShppDisabYn = dtllist.getJejushppdisabyn();
            delivery.ismtarShppDisabYn = dtllist.getIsmtarshppdisabyn();
            delivery.frgShppPsblYn = "N";
            delivery.ismtarAddShppcstId = dtllist.getIsmtaraddshppcstid();
            delivery.jejuAddShppcstId = dtllist.getJejuaddshppcstid();
        }
        catch (Exception e) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
    }

    private void DetailImgNRemark(ShopProductDto dto, ShopSSGAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, ProductupdateDescription.Om_updateDescription.Description description, List<String> strImages, String itemId) throws Exception {
        Object addDetailPlus = "";
        if (dtllist.getDetailkeywordb().equals("Y")) {
            addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
        }
        if (dtllist.getDetailproductcodeb().equals("Y")) {
            addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
        }
        if (dtllist.getDetailproductnameb().equals("Y")) {
            addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
        }
        description.itemId = itemId;
        description.promNm = "";
        description.itemDescription = new ProductupdateDescription.Om_updateDescription.Description.ItemDescription();
        description.itemDescription.htmlCntt = (String)addDetailPlus + dto.getGoods_remarks();
        description.itemImages = new ArrayList<ProductupdateDescription.Om_updateDescription.Description.ItemImages>();
        try {
            ProductupdateDescription.Om_updateDescription.Description.ItemImages itemimages = new ProductupdateDescription.Om_updateDescription.Description.ItemImages();
            ProductupdateDescription.Om_updateDescription.Description.ItemImages.ItemImage itemimage = new ProductupdateDescription.Om_updateDescription.Description.ItemImages.ItemImage();
            itemimage.dataSeq = 1;
            itemimage.dataFileNm = strImages.get(0);
            this.setRplcTextNm(dtllist, 0, itemimage);
            itemimage.uitemImgAssoUseYn = "N";
            itemimages.setItemImage(itemimage);
            description.itemImages.add(itemimages);
        }
        catch (Exception exception) {
            throw new Exception("\uc774\ubbf8\uc9c0 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setRplcTextNm(ShopSSGAdditionDto dtllist, int i, ProductupdateDescription.Om_updateDescription.Description.ItemImages.ItemImage itemimage) {
        switch (i) {
            case 0: {
                itemimage.rplcTextNm = dtllist.getRplctextnm1().equals("") ? "\uc774\ubbf8\uc9c01" : dtllist.getRplctextnm1();
                break;
            }
            case 1: {
                itemimage.rplcTextNm = dtllist.getRplctextnm2().equals("") ? "\uc774\ubbf8\uc9c02" : dtllist.getRplctextnm2();
                break;
            }
            case 2: {
                itemimage.rplcTextNm = dtllist.getRplctextnm3().equals("") ? "\uc774\ubbf8\uc9c03" : dtllist.getRplctextnm3();
                break;
            }
            case 3: {
                itemimage.rplcTextNm = dtllist.getRplctextnm4().equals("") ? "\uc774\ubbf8\uc9c04" : dtllist.getRplctextnm4();
                break;
            }
            case 4: {
                itemimage.rplcTextNm = dtllist.getRplctextnm5().equals("") ? "\uc774\ubbf8\uc9c05" : dtllist.getRplctextnm5();
                break;
            }
            default: {
                itemimage.rplcTextNm = "\uc774\ubbf8\uc9c0" + (i + 1);
            }
        }
    }

    private List<ProductAppeCertProps.Result.ItemAppeCerts.ItemAppeCert> getCertification(ShoppingMallDetailDto shoppingMallDetailDto, ObjectMapper mapper, String stdCtgid) throws Exception {
        List<ProductAppeCertProps.Result.ItemAppeCerts.ItemAppeCert> itemAppeCert = new ArrayList<ProductAppeCertProps.Result.ItemAppeCerts.ItemAppeCert>();
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
        Request request2 = new Request.Builder().url(Host.concat("/attribute/itemAppeCert/getItemAppeCertProps.ssg?stdCtgId=" + stdCtgid)).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Response response = client.newCall(request2).execute();){
                ProductAppeCertProps productAppeCertProps = (ProductAppeCertProps)mapper.readValue(response.body().string().toString(), ProductAppeCertProps.class);
                if (productAppeCertProps.getResult().getItemAppeCerts().size() > 0) {
                    for (ProductAppeCertProps.Result.ItemAppeCerts itemAppeCerts : productAppeCertProps.getResult().getItemAppeCerts()) {
                        if (itemAppeCerts.getItemAppeCert().size() <= 0) continue;
                        itemAppeCert = itemAppeCerts.getItemAppeCert().stream().filter(d -> d.getMndtyYn().equals("Y")).collect(Collectors.toList());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
        return itemAppeCert;
    }

    private ProductAppePropDtlList getAttributeProps(ShoppingMallDetailDto shoppingMallDetailDto, ObjectMapper mapper) throws Exception {
        ProductAppePropDtlList productAppePropDtlList;
        block22: {
            productAppePropDtlList = new ProductAppePropDtlList();
            OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
            Request request2 = new Request.Builder().url(Host.concat("/itemAttr/0.1/getItemAppePropTgtList.ssg")).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Response response = client.newCall(request2).execute();){
                    ProductAppePropTgtList productAppePropTgtList = (ProductAppePropTgtList)mapper.readValue(response.body().string().toString(), ProductAppePropTgtList.class);
                    if (productAppePropTgtList.getResult().getItemAppeProps().size() <= 0) break block22;
                    String code = "{\"itemAppePropId\":\"" + productAppePropTgtList.getResult().getItemAppeProps().get(0).getItemAppeProp().getItemAppePropId() + "\"}";
                    MediaType mediaType = MediaType.parse((String)"");
                    RequestBody body = RequestBody.create((MediaType)mediaType, (String)code);
                    OkHttpClient client1 = new OkHttpClient().newBuilder().build();
                    Request request1 = new Request.Builder().url(Host.concat("/itemAttr/0.1/getItemAppePropDtlList.ssg")).method("POST", body).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
                    try {
                        Throwable throwable2 = null;
                        Object var16_21 = null;
                        try (Response response1 = client1.newCall(request1).execute();){
                            productAppePropDtlList = (ProductAppePropDtlList)mapper.readValue(response1.body().string().toString(), ProductAppePropDtlList.class);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
            }
        }
        return productAppePropDtlList;
    }

    private String getStdCtgattr(ShoppingMallDetailDto shoppingMallDetailDto, String stdCtgId) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
        Request request2 = new Request.Builder().url(Host.concat("/item/om/itemmng/category/getStdCtgAttr.ssg?stdCtgId=" + stdCtgId)).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Response response = client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject jsonObject = (JsonObject)parser.parse(response.body().string().toString());
                JsonObject result = (JsonObject)jsonObject.get("result");
                if (result.get("resultCode").getAsString().equals("00")) {
                    JsonObject stdCtgAttr = (JsonObject)result.get("stdCtgAttr");
                    return stdCtgAttr.get("itemMngPropClsId").getAsString();
                }
                throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + result.get("resultDesc").getAsString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private List<List<String>> listItemMngProp(ShoppingMallDetailDto shoppingMallDetailDto, String stdCtgId, String itemMngPropClsId) throws Exception {
        ArrayList<List<String>> contents;
        block14: {
            OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
            contents = new ArrayList<List<String>>();
            Request request2 = new Request.Builder().url(Host.concat("/common/0.1/listItemMngProp.ssg?itemMngPropClsId=" + itemMngPropClsId + "&stdCtgId=" + stdCtgId)).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (Response response = client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject jsonObject = (JsonObject)parser.parse(response.body().string().toString());
                    JsonObject result = (JsonObject)jsonObject.get("result");
                    if (result.get("resultCode").getAsString().equals("00")) {
                        JsonArray itemMngProps = (JsonArray)result.get("itemMngProps");
                        JsonObject datas = (JsonObject)itemMngProps.get(0);
                        JsonArray itemMngProp = (JsonArray)datas.get("itemMngProp");
                        int i = 0;
                        while (i < itemMngProp.size()) {
                            JsonObject data2 = (JsonObject)itemMngProp.get(i);
                            if (data2.get("mndtyYn").getAsString().equals("Y")) {
                                ArrayList<String> list = new ArrayList<String>();
                                list.add(data2.get("itemMngPropId").getAsString());
                                list.add(data2.get("itemMngPropNm").getAsString());
                                list.add(data2.get("iptMthdCd").getAsString());
                                contents.add(list);
                            }
                            ++i;
                        }
                        break block14;
                    }
                    throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + result.get("resultDesc").getAsString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception("API\ud1b5\uc2e0\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
            }
        }
        return contents;
    }

    private void Notice(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateNotification.Om_updateNotification.Notification notification, ShoppingMallDetailDto shoppingMallDetailDto, List<List<String>> gosi, String itemMngPropClsId) throws Exception {
        try {
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            notification.itemMngPropClsId = itemMngPropClsId;
            notification.manufcoNm = dto.getMaker();
            notification.prodManufCntryId = dtllist.getProdmanufcntryid().equals("") ? (dto.getOrigin().contains("\uad6d\ub0b4") ? "2000000078" : (dto.getOrigin().contains("\ud574\uc678") ? "4000000000" : (dto.getOrigin().contains("\uae30\ud0c0") ? "1000000990" : "1000000000"))) : dtllist.getProdmanufcntryid();
            notification.notificationProps = new ArrayList<ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps>();
            ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps props = new ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps();
            ArrayList<ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps.NotificationProp> propslist = new ArrayList<ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps.NotificationProp>();
            for (List<String> gosinum : gosi) {
                ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps.NotificationProp prop = new ProductUpdateNotification.Om_updateNotification.Notification.NotificationProps.NotificationProp();
                prop.itemMngPropId = gosinum.get(0);
                if (!gosinum.get(2).equals("10")) {
                    prop.itemMngCntt = "N";
                } else if (dtllist.getNoticebatchyn().equals("Y")) {
                    prop.itemMngCntt = dtllist.getNoticetitleyn().equals("Y") ? gosinum.get(1) + " : \uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0";
                } else {
                    ShopProdAttrnmDto shopProdAttrnmDto = dto.getShopProdAttrnmDtos().stream().filter(d -> d.getAttrnm().contains((CharSequence)gosinum.get(1))).findAny().orElse(null);
                    prop.itemMngCntt = dtllist.getNoticetitleyn().equals("Y") ? (shopProdAttrnmDto == null ? gosinum.get(1) + " : \uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : (shopProdAttrnmDto.getProp_val().equals("") ? gosinum.get(1) + " : \uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : gosinum.get(1) + " : " + shopProdAttrnmDto.getProp_val())) : (shopProdAttrnmDto == null ? "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : (shopProdAttrnmDto.getProp_val().equals("") ? "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : shopProdAttrnmDto.getProp_val()));
                }
                propslist.add(prop);
            }
            props.setNotificationProp(propslist);
            notification.notificationProps.add(props);
        }
        catch (Exception exception) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Option(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateOption.Om_updateOption om_updateOption, String itemId) throws Exception {
        this.shopOptionDtos = this.getProductOptions(dto);
        List<ShopOptionDto> option_s_in = this.getProductInOptions(dto);
        ArrayList<ShopOptionDto> sendOptions = new ArrayList<ShopOptionDto>();
        for (ShopOptionDto optDto : this.shopOptionDtos) {
            ShopOptionDto inDto = option_s_in.stream().filter(d -> d.getOptcompanycd().equals(optDto.getOptcompanycd())).findAny().orElse(null);
            if (inDto != null) {
                optDto.setSellerProductItemId(inDto.getSellerProductItemId());
            }
            sendOptions.add(optDto);
        }
        om_updateOption.option = new ProductUpdateOption.Om_updateOption.Option();
        om_updateOption.option.itemId = itemId;
        try {
            om_updateOption.option.txnDivCd = dto.getTax_yn().equals("0") ? "10" : "20";
            om_updateOption.option.splVenItemId = dto.getCompayny_goods_cd();
        }
        catch (Exception e) {
            throw new Exception("\uacfc\uc138 \ubc0f \uc0c1\ud488\ucf54\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            om_updateOption.option.sellprc = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        String addOptionLeftNm = "";
        String addOptionRightNm = "";
        try {
            if (sendOptions.size() > 0) {
                if (dtllist.getAddoptionlb().equals("Y")) {
                    addOptionLeftNm = dtllist.getAddOptionL();
                }
                if (dtllist.getAddoptionrb().equals("Y")) {
                    addOptionRightNm = dtllist.getAddOptionR();
                }
                om_updateOption.option.itemSellTypeCd = "20";
                om_updateOption.option.uitemOptnTypeNm1 = dto.getChar_1_nm();
                om_updateOption.option.uitemOptnTypeNm2 = dto.getChar_2_nm();
                om_updateOption.option.optionNms = new ArrayList<ProductUpdateOption.Om_updateOption.Option.OptionNms>();
                ProductUpdateOption.Om_updateOption.Option.OptionNms options = new ProductUpdateOption.Om_updateOption.Option.OptionNms();
                ArrayList<ProductUpdateOption.Om_updateOption.Option.OptionNms.OptionNm> optionnms = new ArrayList<ProductUpdateOption.Om_updateOption.Option.OptionNms.OptionNm>();
                for (ShopOptionDto shopOptionDto : sendOptions) {
                    int optprice;
                    int price2;
                    ProductUpdateOption.Om_updateOption.Option.OptionNms.OptionNm optionnm = new ProductUpdateOption.Om_updateOption.Option.OptionNms.OptionNm();
                    Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                    int deliveryFee = 0;
                    if (dtllist.getFreedelivery().equals("T")) {
                        if (dtllist.getExpprc() == 9999) {
                            if (!dto.getDelv_cost().equals("0")) {
                                deliveryFee = Integer.parseInt(dto.getDelv_cost());
                            } else {
                                ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                            }
                        } else {
                            deliveryFee = dtllist.getExpprc();
                        }
                        salePrice = salePrice + (long)deliveryFee;
                    }
                    YDMAStringUtil.convertToInt(shopOptionDto.getAmt());
                    salePrice = YDMAStringUtil.convertToLong(dto.getGoods_price()) + YDMAStringUtil.convertToLong(shopOptionDto.getAmt());
                    int limit_price = YDMAStringUtil.convertToInt(shopOptionDto.getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    }
                    if (dtllist.getOptzeropriceyn().equals("Y") && (price2 = YDMAStringUtil.convertToInt(dto.getGoods_cost())) < (optprice = YDMAStringUtil.convertToInt(optionprice.getConsumer_if_sale_price()))) continue;
                    Integer.parseInt(optionprice.getConsumer_if_sale_price());
                    List<String> names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
                    if (names.size() > 1) {
                        optionnm.uitemId = shopOptionDto.getSellerProductItemId() == null ? "" : shopOptionDto.getSellerProductItemId();
                        optionnm.uitemOptnNm1 = addOptionLeftNm + names.get(0) + addOptionRightNm;
                        optionnm.uitemOptnNm2 = addOptionLeftNm + names.get(1) + addOptionRightNm;
                    } else {
                        optionnm.uitemId = shopOptionDto.getSellerProductItemId() == null ? "" : shopOptionDto.getSellerProductItemId();
                        optionnm.uitemOptnNm1 = addOptionLeftNm + names.get(0) + addOptionRightNm;
                    }
                    optionnm.splVenItemId = shopOptionDto.getOptcompanycd();
                    optionnm.useYn = "Y";
                    optionnm.sellprc = String.valueOf(salePrice);
                    optionnms.add(optionnm);
                }
                options.setOptionNm(optionnms);
                om_updateOption.option.optionNms.add(options);
            } else {
                om_updateOption.option.itemSellTypeCd = "10";
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void updateAttribute(ProductAppePropDtlList productAppePropDtlList, List<ProductAppeCertProps.Result.ItemAppeCerts.ItemAppeCert> itemAppeCert, ProductUpdateAttribute productUpdateAttribute) throws Exception {
        try {
            Object prop;
            Object props;
            if (itemAppeCert.size() > 0) {
                productUpdateAttribute.om_updateAttribute.attribute.certificationProps = new ArrayList<ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps>();
                props = new ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps();
                prop = new ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps.Prop();
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps.Prop)prop).itemAppePropClsId = "";
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps.Prop)prop).itemAppePropId = "";
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps.Prop)prop).itemAppePropCntt = "";
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps)props).setProp((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps.Prop)prop);
                productUpdateAttribute.om_updateAttribute.attribute.certificationProps.add((ProductUpdateAttribute.Om_updateAttribute.Attribute.CertificationProps)props);
            }
            if (productAppePropDtlList.getResult() != null && productAppePropDtlList.getResult().getItemAppePropDtls().size() > 0) {
                productUpdateAttribute.om_updateAttribute.attribute.attributeProps = new ArrayList<ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps>();
                props = new ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps();
                prop = new ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps.Prop();
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps.Prop)prop).itemAppePropId = "";
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps.Prop)prop).itemAppePropCntt = "";
                ((ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps)props).setProp((ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps.Prop)prop);
                productUpdateAttribute.om_updateAttribute.attribute.attributeProps.add((ProductUpdateAttribute.Om_updateAttribute.Attribute.AttributeProps)props);
            }
        }
        catch (Exception e) {
            throw new Exception("\uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
    }

    private void RewardsSetting(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateRewards.Om_updateRewards.Rewards rewards, String itemId) throws Exception {
        try {
            rewards.itemId = itemId;
            rewards.promMarketingAgreeYn = dtllist.getPromotionaplyn();
            rewards.buyConfirmPoint = new ProductUpdateRewards.Om_updateRewards.Rewards.BuyConfirmPoint();
            rewards.buyConfirmPoint.aplYn = dtllist.getBuyaplyn();
            rewards.buyConfirmPoint.aplStrtDt = YDMATimeUtil.getCurrentTimeBySSGFormat();
            if (dtllist.getBuyaplyn().equals("Y")) {
                rewards.buyConfirmPoint.aplEndDt = dtllist.getBuyaplenddt().equals("") ? "9999/12/31 23:59:59" : YDMATimeUtil.getSaleEndDtSSGFormat(dtllist.getBuyaplenddt());
                rewards.buyConfirmPoint.bascPrvdPrftTypeCd = dtllist.getBascprvdprfttypecd();
                rewards.buyConfirmPoint.bascPrvdPrftVal = dtllist.getBascprvdprftval();
                rewards.buyConfirmPoint.addPrvdPrftTypeCd = dtllist.getAddprvdprftval().equals("0") ? null : dtllist.getAddprvdprfttypecd();
                rewards.buyConfirmPoint.addPrvdPrftVal = dtllist.getAddprvdprftval().equals("0") ? null : dtllist.getAddprvdprftval();
            } else {
                rewards.buyConfirmPoint.aplEndDt = "9999/12/31 23:59:59";
            }
            rewards.reviewPoint = new ProductUpdateRewards.Om_updateRewards.Rewards.ReviewPoint();
            rewards.reviewPoint.aplYn = dtllist.getReviewaplyn();
            rewards.reviewPoint.aplStrtDt = YDMATimeUtil.getCurrentTimeBySSGFormat();
            if (dtllist.getReviewaplyn().equals("Y")) {
                rewards.reviewPoint.aplEndDt = dtllist.getReviewaplenddt().equals("") ? "9999/12/31 23:59:59" : YDMATimeUtil.getSaleEndDtSSGFormat(dtllist.getReviewaplenddt());
                rewards.reviewPoint.textPrvdPrftTypeCd = "10";
                rewards.reviewPoint.textPrvdPrftVal = dtllist.getTextprvdprftval();
                rewards.reviewPoint.photoPrvdPrftTypeCd = dtllist.getPhotoprvdprftval().equals("0") ? null : "10";
                rewards.reviewPoint.photoPrvdPrftVal = dtllist.getPhotoprvdprftval().equals("0") ? null : dtllist.getPhotoprvdprftval();
            } else {
                rewards.reviewPoint.aplEndDt = "9999/12/31 23:59:59";
            }
        }
        catch (Exception e) {
            throw new Exception("\uad6c\ub9e4\ud655\uc815 \uc801\ub9bd\uae08 \ubc0f \ub9ac\ubdf0\ub4f1\ub85d \uc801\ub9bd\uae08 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void setStopProduct(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateInventory.Om_updateInventory.Inventory inventory, String itemId, ResponseOption responseOption) throws Exception {
        this.getProductOptions(dto);
        try {
            inventory.itemId = itemId;
            inventory.dispStrtDt = YDMATimeUtil.getCurrentTimeBySSGFormat();
            inventory.dispEndDt = "9999/12/31 23:59:00";
            inventory.sellStatCd = "90";
            inventory.sellFrmCd = "10";
        }
        catch (Exception e) {
            throw new Exception("\uc7ac\uace0\uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void InventorySetting(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateInventory.Om_updateInventory.Inventory inventory, String itemId, ResponseOption responseOption) throws Exception {
        List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
        try {
            inventory.itemId = itemId;
            inventory.dispStrtDt = YDMATimeUtil.getCurrentTimeBySSGFormat();
            inventory.dispEndDt = dtllist.getReserveyn().equals("Y") ? (dtllist.getReservedate().equals("") ? "9999/12/31 23:59:00" : dtllist.getReservedate().replaceAll("-", "/") + " 23:59:00") : "9999/12/31 23:59:00";
            inventory.sellStatCd = "20";
            inventory.sellFrmCd = "10";
            if (responseOption.getResult().getOption().getOptionNms().size() > 0) {
                for (ResponseOption.Result.Option.OptionNms optionNms : responseOption.getResult().getOption().getOptionNms()) {
                    if (optionNms.getOptionNm().size() > 0) {
                        inventory.optionInvs = new ArrayList<ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs>();
                        ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs optionNmsset = new ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs();
                        ArrayList<ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs.OptionInv> optionNmset = new ArrayList<ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs.OptionInv>();
                        int i = 0;
                        while (i < optionNms.getOptionNm().size()) {
                            int idx = i;
                            ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs.OptionInv optionInv = new ProductUpdateInventory.Om_updateInventory.Inventory.OptionInvs.OptionInv();
                            optionInv.setUitemId(optionNms.getOptionNm().get(i).getUitemId());
                            ShopOptionDto optDto = shopOptionDtos.stream().filter(d -> d.getOptcompanycd().equals(optionNms.getOptionNm().get(idx).getSplVenItemId())).findAny().orElse(null);
                            if (optDto == null) {
                                optionInv.sellStatCd = "80";
                            } else {
                                optionInv.usablInvQty = optDto.getCnt().equals("0") ? null : optDto.getCnt();
                                optionInv.sellStatCd = optDto.getCnt().equals("0") ? "80" : "20";
                            }
                            optionNmset.add(optionInv);
                            ++i;
                        }
                        optionNmsset.setOptionInv(optionNmset);
                        inventory.optionInvs.add(optionNmsset);
                        continue;
                    }
                    inventory.usablInvQty = "999";
                }
            } else {
                inventory.usablInvQty = "999";
            }
        }
        catch (Exception e) {
            throw new Exception("\uc7ac\uace0\uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void CompositeSetting(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateComposite.Om_updateComposite.Composite composite, String itemId) throws Exception {
        try {
            composite.itemId = itemId;
            if (dtllist.getFrebieinclyn().equals("Y") && dtllist.getFrebieinclprdnaddi().equals("N")) {
                composite.frebie = new ProductUpdateComposite.Om_updateComposite.Composite.Frebie();
                composite.frebie.itemNm = dtllist.getFreegiftnm();
                composite.frebie.invMngYn = dtllist.getInvmngyn();
                if (dtllist.getInvmngyn().equals("Y")) {
                    composite.frebie.usablInvQty = dtllist.getInvqty();
                }
                composite.frebie.useYn = "Y";
                composite.frebie.frebiePrvdStrtDt = YDMATimeUtil.getCurrentTimeBySSGFormat();
                composite.frebie.frebiePrvdEndDt = YDMATimeUtil.getSaleEndDtSSGFormat(dtllist.getFreegiftaplenddt());
            }
        }
        catch (Exception e) {
            throw new Exception("\uc0ac\uc740\ud488 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void AlianceSetting(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdateAliance.Om_updateAlliance.Alliance alliance, String itemId) throws Exception {
        try {
            alliance.itemId = itemId;
            alliance.epLnkg = new ProductUpdateAliance.Om_updateAlliance.Alliance.EpLnkg();
            alliance.epLnkg.epLnkgYn = dtllist.getEplnkgyn();
            alliance.epLnkg.dcExpsrYn = dtllist.getDcexpsryn();
        }
        catch (Exception e) {
            throw new Exception("\uac00\uaca9\ube44\uad50\uc0ac\uc774\ud2b8\uc5f0\ub3d9\uc5ec\ubd80 \ubc0f \ud560\uc778\uac00 \ub178\ucd9c\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void PromotionReq(ShopProductDto dto, ShopSSGAdditionDto dtllist, ProductUpdatePromReq.OmPromReq omPromReq, String itemId, String offerKindCd) throws Exception {
        try {
            omPromReq.offerKindCd = offerKindCd;
            if (offerKindCd.equals("250")) {
                omPromReq.tgtList = new ArrayList<ProductUpdatePromReq.OmPromReq.TgtList>();
                ProductUpdatePromReq.OmPromReq.TgtList item = new ProductUpdatePromReq.OmPromReq.TgtList();
                item.promEditReqProcTypeCd = "10";
                item.tgtId = itemId;
                item.enfcStrtDts = YDMATimeUtil.getCurrentTime();
                item.enfcEndDts = dtllist.getMultibuydiscountisapldate().equals("Y") ? YDMATimeUtil.getSaleEndDt(dtllist.getMultibuydiscountenddt()).replaceAll("-", "") + "235959" : "99991231235959";
                item.prvdPrftTypeCd = dtllist.getMultibuydiscountpricetypecd();
                item.prvdPrftVal = dtllist.getMultibuydiscount();
                item.offerAplCritnCd = dtllist.getMultibuydiscounttypecd();
                item.minCritnVal = dtllist.getMultibuydiscounttgt();
                omPromReq.tgtList.add(item);
            } else {
                omPromReq.tgtList = new ArrayList<ProductUpdatePromReq.OmPromReq.TgtList>();
                ProductUpdatePromReq.OmPromReq.TgtList item = new ProductUpdatePromReq.OmPromReq.TgtList();
                item.promEditReqProcTypeCd = "10";
                item.tgtId = itemId;
                item.enfcStrtDts = YDMATimeUtil.getCurrentTime();
                item.enfcEndDts = dtllist.getImmdiscountisapldate().equals("Y") ? YDMATimeUtil.getSaleEndDt(dtllist.getImmdiscountenddt()).replaceAll("-", "") + "235959" : "99991231235959";
                item.prvdPrftTypeCd = dtllist.getImmdiscounttypecd();
                item.prvdPrftVal = dtllist.getImmdiscount();
                omPromReq.tgtList.add(item);
            }
        }
        catch (Exception e) {
            throw new Exception("\ubcf5\uc218\uad6c\ub9e4\ud560\uc778 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private void PromotionReqDelete(ShopProductDto dto, ShopSSGAdditionDto ssgdtllist, ProductUpdatePromReq.OmPromReq omPromReq, String itemId, String offerKindCd) throws Exception {
        try {
            omPromReq.offerKindCd = offerKindCd;
            if (offerKindCd.equals("250")) {
                omPromReq.tgtList = new ArrayList<ProductUpdatePromReq.OmPromReq.TgtList>();
                ProductUpdatePromReq.OmPromReq.TgtList item = new ProductUpdatePromReq.OmPromReq.TgtList();
                item.promEditReqProcTypeCd = "20";
                item.tgtId = itemId;
                item.enfcStrtDts = YDMATimeUtil.getCurrentTime();
                item.enfcEndDts = ssgdtllist.getMultibuydiscountisapldate().equals("Y") ? YDMATimeUtil.getSaleEndDt(ssgdtllist.getMultibuydiscountenddt()).replaceAll("-", "") + "235959" : "99991231235959";
                item.prvdPrftTypeCd = ssgdtllist.getMultibuydiscountpricetypecd();
                item.prvdPrftVal = ssgdtllist.getMultibuydiscount();
                item.offerAplCritnCd = ssgdtllist.getMultibuydiscounttypecd();
                item.minCritnVal = ssgdtllist.getMultibuydiscounttgt();
                omPromReq.tgtList.add(item);
            } else {
                omPromReq.tgtList = new ArrayList<ProductUpdatePromReq.OmPromReq.TgtList>();
                ProductUpdatePromReq.OmPromReq.TgtList item = new ProductUpdatePromReq.OmPromReq.TgtList();
                item.promEditReqProcTypeCd = "10";
                item.tgtId = itemId;
                item.enfcStrtDts = YDMATimeUtil.getCurrentTime();
                item.enfcEndDts = ssgdtllist.getImmdiscountisapldate().equals("Y") ? YDMATimeUtil.getSaleEndDt(ssgdtllist.getImmdiscountenddt()).replaceAll("-", "") + "235959" : "99991231235959";
                item.prvdPrftTypeCd = ssgdtllist.getImmdiscounttypecd();
                item.prvdPrftVal = ssgdtllist.getImmdiscount();
                omPromReq.tgtList.add(item);
            }
        }
        catch (Exception e) {
            throw new Exception("\ubcf5\uc218\uad6c\ub9e4\ud560\uc778 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    private ResponseProductPromotion productPromotionRegSend(String json, ShoppingMallDetailDto shoppingMallDetailDto, String url) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        YDMAStringUtil.Print(json);
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var10_13 = null;
                try (Response response = client.newCall(request2).execute();){
                    ResponseProductPromotion productResult = (ResponseProductPromotion)mapper.readValue(response.body().string().toString(), ResponseProductPromotion.class);
                    if (productResult.getResult().getResultCode().equals("00")) {
                        return productResult;
                    }
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + productResult.getResult().getResultDesc());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private ResponseOption sendProductupdateOption(String json, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String errorMassage = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        YDMAStringUtil.Print(json);
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/item/om/itemedit/option/0.1/updateOption.ssg")).method("POST", body).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (Response response = client.newCall(request2).execute();){
                    ResponseOption responseOption = (ResponseOption)mapper.readValue(response.body().string().toString(), ResponseOption.class);
                    if (responseOption.getResult().getResultCode().equals("00")) {
                        return responseOption;
                    }
                    errorMassage = responseOption.getResult().getResultDesc();
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new Exception(errorMassage);
            }
        }
        catch (Exception exception) {
            throw new Exception(errorMassage);
        }
    }

    private String productRegSend(String json, ShoppingMallDetailDto shoppingMallDetailDto, String url) throws Exception {
        String errorMassage = "";
        ObjectMapper mapper = new ObjectMapper();
        YDMAStringUtil.Print(json);
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var11_12 = null;
                try (Response response = client.newCall(request2).execute();){
                    ProductResult productResult = (ProductResult)mapper.readValue(response.body().string().toString(), ProductResult.class);
                    if (productResult.getResult().getResultCode().equals("00")) {
                        String code = productResult.getResult().getItemId();
                        return code;
                    }
                    errorMassage = productResult.getResult().getResultDesc();
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new Exception(errorMassage);
            }
        }
        catch (Exception exception) {
            throw new Exception(errorMassage);
        }
    }

    private List<ShopProductOptionDto> getMallItemInfo(String shopprodno, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        ArrayList<ShopProductOptionDto> list = new ArrayList<ShopProductOptionDto>();
        try {
            if (this.responseOption.getResult() != null && this.responseOption.getResult().getOption().getOptionNms().size() > 0) {
                for (ResponseOption.Result.Option.OptionNms optionNms : this.responseOption.getResult().getOption().getOptionNms()) {
                    if (optionNms.getOptionNm().size() <= 0) continue;
                    for (ResponseOption.Result.Option.OptionNms.OptionNm optionNm : optionNms.getOptionNm()) {
                        ShopOptionDto cfr_ignored_0 = this.shopOptionDtos.stream().filter(d -> d.getOptcompanycd().equals(optionNm.getSplVenItemId())).findAny().orElse(null);
                        ShopProductOptionDto dto = new ShopProductOptionDto();
                        String itemnm = String.format("%s%s", optionNm.getUitemOptnNm1(), optionNm.getUitemOptnNm2() == null ? "" : " - " + optionNm.getUitemOptnNm2());
                        dto.setShopprodno(shopprodno);
                        dto.setShopprodsku(optionNm.getUitemId());
                        dto.setOptspecdes(itemnm);
                        dto.setOptvertstock("999");
                        dto.setOptsafestock("999");
                        dto.setOptaddamt(Integer.parseInt(optionNm.getSellprc()));
                        list.add(dto);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc1fc\ud551\ubab0\uc5d0 \uc0c1\ud488\uc740 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.[" + shopprodno + "]\nDB\uc5d0 \uc635\uc158 \uc800\uc7a5\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return list;
    }

    private String setProductReg(ShopProductDto dto, ShopSSGAdditionDto ssgdtllist, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> loginCookie, List<String> strImages) throws Exception {
        ProductUpdatePromReq productUpdatePromReq;
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ProductupdateItemBasic productBasic = new ProductupdateItemBasic();
        productBasic.om_updateItemBase = new ProductupdateItemBasic.Om_updateItemBase();
        productBasic.om_updateItemBase.itemBasic = new ProductupdateItemBasic.Om_updateItemBase.ItemBasic();
        productBasic.om_updateItemBase.itemBasic.itemId = dto.getShopprodno();
        this.Basic(dto, ssgdtllist, productBasic.om_updateItemBase.itemBasic);
        this.Category(dto, ssgdtllist, productBasic.om_updateItemBase.itemBasic, shoppingMallDetailDto);
        this.ItemBasic(dto, ssgdtllist, productBasic.om_updateItemBase.itemBasic, shoppingMallDetailDto);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productBasic);
        String itemId = this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/itemBasic/0.1/updateItemBasic.ssg");
        ProductupdateDelivery productupdateDelivery = new ProductupdateDelivery();
        productupdateDelivery.om_updateDelivery = new ProductupdateDelivery.Om_updateDelivery();
        productupdateDelivery.om_updateDelivery.delivery = new ProductupdateDelivery.Om_updateDelivery.Delivery();
        this.BasicShipping(dto, ssgdtllist, productupdateDelivery.om_updateDelivery.delivery, shoppingMallDetailDto, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productupdateDelivery);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/delivery/0.1/updateDelivery.ssg");
        ProductupdateDescription productupdateDescription = new ProductupdateDescription();
        productupdateDescription.om_updateDescription = new ProductupdateDescription.Om_updateDescription();
        productupdateDescription.om_updateDescription.description = new ProductupdateDescription.Om_updateDescription.Description();
        this.DetailImgNRemark(dto, ssgdtllist, shoppingMallDetailDto, productupdateDescription.om_updateDescription.description, strImages, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productupdateDescription);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/description/0.1/updateDescription.ssg");
        ProductAppePropDtlList productAppePropDtlList = this.getAttributeProps(shoppingMallDetailDto, mapper);
        List<ProductAppeCertProps.Result.ItemAppeCerts.ItemAppeCert> itemAppeCert = this.getCertification(shoppingMallDetailDto, mapper, productBasic.om_updateItemBase.itemBasic.getStdCtgId());
        ProductUpdateAttribute productUpdateAttribute = new ProductUpdateAttribute();
        productUpdateAttribute.om_updateAttribute = new ProductUpdateAttribute.Om_updateAttribute();
        productUpdateAttribute.om_updateAttribute.attribute = new ProductUpdateAttribute.Om_updateAttribute.Attribute();
        productUpdateAttribute.om_updateAttribute.attribute.itemId = itemId;
        this.updateAttribute(productAppePropDtlList, itemAppeCert, productUpdateAttribute);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateAttribute);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/attribute/0.1/updateAttribute.ssg");
        String itemMngPropClsId = this.getStdCtgattr(shoppingMallDetailDto, productBasic.om_updateItemBase.itemBasic.getStdCtgId());
        List<List<String>> gosi = this.listItemMngProp(shoppingMallDetailDto, productBasic.om_updateItemBase.itemBasic.getStdCtgId(), itemMngPropClsId);
        ProductUpdateNotification productUpdateNotification = new ProductUpdateNotification();
        productUpdateNotification.om_updateNotification = new ProductUpdateNotification.Om_updateNotification();
        productUpdateNotification.om_updateNotification.notification = new ProductUpdateNotification.Om_updateNotification.Notification();
        productUpdateNotification.om_updateNotification.notification.itemId = itemId;
        this.Notice(dto, ssgdtllist, productUpdateNotification.om_updateNotification.notification, shoppingMallDetailDto, gosi, itemMngPropClsId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateNotification);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/notification/0.1/updateNotification.ssg");
        ProductUpdateOption productUpdateOption = new ProductUpdateOption();
        productUpdateOption.om_updateOption = new ProductUpdateOption.Om_updateOption();
        this.Option(dto, ssgdtllist, productUpdateOption.om_updateOption, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateOption);
        this.responseOption = this.sendProductupdateOption(json, shoppingMallDetailDto);
        ProductUpdateInventory productUpdateInventory = new ProductUpdateInventory();
        productUpdateInventory.om_updateInventory = new ProductUpdateInventory.Om_updateInventory();
        productUpdateInventory.om_updateInventory.inventory = new ProductUpdateInventory.Om_updateInventory.Inventory();
        this.InventorySetting(dto, ssgdtllist, productUpdateInventory.om_updateInventory.inventory, itemId, this.responseOption);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateInventory);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/inventory/0.1/updateInventory.ssg");
        ProductUpdateRewards productUpdateRewards = new ProductUpdateRewards();
        productUpdateRewards.om_updateRewards = new ProductUpdateRewards.Om_updateRewards();
        productUpdateRewards.om_updateRewards.rewards = new ProductUpdateRewards.Om_updateRewards.Rewards();
        this.RewardsSetting(dto, ssgdtllist, productUpdateRewards.om_updateRewards.rewards, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateRewards);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/rewards/0.1/updateRewards.ssg");
        ProductUpdateComposite productUpdateComposite = new ProductUpdateComposite();
        productUpdateComposite.om_updateComposite = new ProductUpdateComposite.Om_updateComposite();
        productUpdateComposite.om_updateComposite.composite = new ProductUpdateComposite.Om_updateComposite.Composite();
        this.CompositeSetting(dto, ssgdtllist, productUpdateComposite.om_updateComposite.composite, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateComposite);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/composite/0.1/updateComposite.ssg");
        ProductUpdateAliance productUpdateAliance = new ProductUpdateAliance();
        productUpdateAliance.om_updateAlliance = new ProductUpdateAliance.Om_updateAlliance();
        productUpdateAliance.om_updateAlliance.alliance = new ProductUpdateAliance.Om_updateAlliance.Alliance();
        this.AlianceSetting(dto, ssgdtllist, productUpdateAliance.om_updateAlliance.alliance, itemId);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)productUpdateAliance);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/alliance/0.1/updateAlliance.ssg");
        if (ssgdtllist.getMultibuydiscountyn().equals("Y")) {
            productUpdatePromReq = new ProductUpdatePromReq();
            productUpdatePromReq.omPromReq = new ProductUpdatePromReq.OmPromReq();
            this.PromotionReq(dto, ssgdtllist, productUpdatePromReq.omPromReq, itemId, "250");
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productUpdatePromReq);
            this.productPromotionRegSend(json, shoppingMallDetailDto, "/prom/om/item/0.1/updatePromotion");
        } else {
            productUpdatePromReq = new ProductUpdatePromReq();
            productUpdatePromReq.omPromReq = new ProductUpdatePromReq.OmPromReq();
            this.PromotionReqDelete(dto, ssgdtllist, productUpdatePromReq.omPromReq, itemId, "250");
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productUpdatePromReq);
            this.productPromotionRegSend(json, shoppingMallDetailDto, "/prom/om/item/0.1/updatePromotion");
        }
        if (ssgdtllist.getImmdiscountyn().equals("Y")) {
            productUpdatePromReq = new ProductUpdatePromReq();
            productUpdatePromReq.omPromReq = new ProductUpdatePromReq.OmPromReq();
            this.PromotionReq(dto, ssgdtllist, productUpdatePromReq.omPromReq, itemId, "205");
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productUpdatePromReq);
            this.productPromotionRegSend(json, shoppingMallDetailDto, "/prom/om/item/0.1/updatePromotion");
        } else {
            productUpdatePromReq = new ProductUpdatePromReq();
            productUpdatePromReq.omPromReq = new ProductUpdatePromReq.OmPromReq();
            this.PromotionReqDelete(dto, ssgdtllist, productUpdatePromReq.omPromReq, itemId, "205");
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productUpdatePromReq);
            this.productPromotionRegSend(json, shoppingMallDetailDto, "/prom/om/item/0.1/updatePromotion");
        }
        dto.setResult_code("1");
        dto.setShopprodno(itemId);
        return json;
    }

    private boolean setProductStop(String status2, ShoppingMallDetailDto shoppingMallDetailDto, ShopProductDto dto, ShopSSGAdditionDto ssgdtllist, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ProductUpdateInventory productUpdateInventory = new ProductUpdateInventory();
        productUpdateInventory.om_updateInventory = new ProductUpdateInventory.Om_updateInventory();
        productUpdateInventory.om_updateInventory.inventory = new ProductUpdateInventory.Om_updateInventory.Inventory();
        this.setStopProduct(dto, ssgdtllist, productUpdateInventory.om_updateInventory.inventory, dto.getShopprodno(), this.responseOption);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        String json = mapper.writeValueAsString((Object)productUpdateInventory);
        this.productRegSend(json, shoppingMallDetailDto, "/item/om/itemedit/inventory/0.1/updateInventory.ssg");
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 8] lbl57 : CaseStatement: default:\u000a, @NONE, blocks:[0, 8] lbl57 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        if (dto.getShopprodno() == null) return false;
        if (dto.getShopprodno().isEmpty()) {
            return false;
        }
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(3000L, TimeUnit.SECONDS).writeTimeout(3000L, TimeUnit.SECONDS).readTimeout(3000L, TimeUnit.SECONDS).build();
        Request request2 = new Request.Builder().url("https://eapi.ssgadm.com/item/om/itemmng/itemList/getOmItemList.ssg?page=1&pageSize=1&sellStatCd=20&itemId=" + dto.getShopprodno()).method("GET", null).addHeader("Authorization", shoppingMallDetailDto.getApikey()).addHeader("Accept", "application/json").build();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Response response = client.newCall(request2).execute();){
                String data2 = response.body().string().toString();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
                JsonObject result = (JsonObject)jsonObject.get("result");
                String code = result.get("resultCode").getAsString();
                if (!code.equals("00")) throw new Exception(result.get("resultMessage").getAsString());
                JsonArray items = (JsonArray)result.get("items");
                if (!items.get(0).isJsonObject()) throw new Exception("\uc0c1\ud488\ubc88\ud638[" + dto.getShopprodno() + "]\uac74\uc73c\ub85c \uac80\uc0c9\ub41c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                String itemid = items.get(0).getAsJsonObject().get("item").getAsJsonObject().get("itemId").getAsString();
                if (!dto.getShopprodno().equals(itemid)) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\ubc88\ud638 \uc870\ud68c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + String.valueOf(e));
        }
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    public static class ProductAppeCertProps {
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        private static class Result {
            private String resultCode;
            private String resultMessage;
            private String resultDesc;
            List<ItemAppeCerts> itemAppeCerts;

            private Result() {
            }

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public List<ItemAppeCerts> getItemAppeCerts() {
                return this.itemAppeCerts;
            }

            public void setItemAppeCerts(List<ItemAppeCerts> itemAppeCerts) {
                this.itemAppeCerts = itemAppeCerts;
            }

            private static class ItemAppeCerts {
                private List<ItemAppeCert> itemAppeCert;

                private ItemAppeCerts() {
                }

                public List<ItemAppeCert> getItemAppeCert() {
                    return this.itemAppeCert;
                }

                public void setItemAppeCert(List<ItemAppeCert> itemAppeCert) {
                    this.itemAppeCert = itemAppeCert;
                }

                private static class ItemAppeCert {
                    private String itemAppePropClsId;
                    private String itemAppePropClsNm;
                    private String itemAppePropId;
                    private String itemAppePropNm;
                    private String itemAppePropTypeCd;
                    private String itemAppePropDtlTypeCd;
                    private String refPropTypeCd;
                    private String refPropCntt;
                    private String maxIptVal;
                    private String mndtyYn;
                    private String prcdAppePropId;
                    private String prcdAppePropCntt;

                    private ItemAppeCert() {
                    }

                    public String getItemAppePropClsId() {
                        return this.itemAppePropClsId;
                    }

                    public void setItemAppePropClsId(String itemAppePropClsId) {
                        this.itemAppePropClsId = itemAppePropClsId;
                    }

                    public String getItemAppePropClsNm() {
                        return this.itemAppePropClsNm;
                    }

                    public void setItemAppePropClsNm(String itemAppePropClsNm) {
                        this.itemAppePropClsNm = itemAppePropClsNm;
                    }

                    public String getItemAppePropId() {
                        return this.itemAppePropId;
                    }

                    public void setItemAppePropId(String itemAppePropId) {
                        this.itemAppePropId = itemAppePropId;
                    }

                    public String getItemAppePropNm() {
                        return this.itemAppePropNm;
                    }

                    public void setItemAppePropNm(String itemAppePropNm) {
                        this.itemAppePropNm = itemAppePropNm;
                    }

                    public String getItemAppePropTypeCd() {
                        return this.itemAppePropTypeCd;
                    }

                    public void setItemAppePropTypeCd(String itemAppePropTypeCd) {
                        this.itemAppePropTypeCd = itemAppePropTypeCd;
                    }

                    public String getItemAppePropDtlTypeCd() {
                        return this.itemAppePropDtlTypeCd;
                    }

                    public void setItemAppePropDtlTypeCd(String itemAppePropDtlTypeCd) {
                        this.itemAppePropDtlTypeCd = itemAppePropDtlTypeCd;
                    }

                    public String getRefPropTypeCd() {
                        return this.refPropTypeCd;
                    }

                    public void setRefPropTypeCd(String refPropTypeCd) {
                        this.refPropTypeCd = refPropTypeCd;
                    }

                    public String getRefPropCntt() {
                        return this.refPropCntt;
                    }

                    public void setRefPropCntt(String refPropCntt) {
                        this.refPropCntt = refPropCntt;
                    }

                    public String getMaxIptVal() {
                        return this.maxIptVal;
                    }

                    public void setMaxIptVal(String maxIptVal) {
                        this.maxIptVal = maxIptVal;
                    }

                    public String getMndtyYn() {
                        return this.mndtyYn;
                    }

                    public void setMndtyYn(String mndtyYn) {
                        this.mndtyYn = mndtyYn;
                    }

                    public String getPrcdAppePropId() {
                        return this.prcdAppePropId;
                    }

                    public void setPrcdAppePropId(String prcdAppePropId) {
                        this.prcdAppePropId = prcdAppePropId;
                    }

                    public String getPrcdAppePropCntt() {
                        return this.prcdAppePropCntt;
                    }

                    public void setPrcdAppePropCntt(String prcdAppePropCntt) {
                        this.prcdAppePropCntt = prcdAppePropCntt;
                    }
                }
            }
        }
    }

    public static class ProductAppePropDtlList {
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        private static class Result {
            private String resultCode;
            private String resultMessage;
            private String resultDesc;
            List<ItemAppePropDtls> itemAppePropDtls;

            private Result() {
            }

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public List<ItemAppePropDtls> getItemAppePropDtls() {
                return this.itemAppePropDtls;
            }

            public void setItemAppePropDtls(List<ItemAppePropDtls> itemAppePropDtls) {
                this.itemAppePropDtls = itemAppePropDtls;
            }

            private static class ItemAppePropDtls {
                private ItemAppePropDtl itemAppePropDtl;

                private ItemAppePropDtls() {
                }

                public ItemAppePropDtl getItemAppePropDtl() {
                    return this.itemAppePropDtl;
                }

                public void setItemAppePropDtl(ItemAppePropDtl itemAppePropDtl) {
                    this.itemAppePropDtl = itemAppePropDtl;
                }

                private static class ItemAppePropDtl {
                    private String itemAppePropId;
                    private String itemAppePropDtlId;
                    private String itemAppePropDtlNm;
                    private String itemAppePropDtlEngNm;

                    private ItemAppePropDtl() {
                    }

                    public String getItemAppePropId() {
                        return this.itemAppePropId;
                    }

                    public void setItemAppePropId(String itemAppePropId) {
                        this.itemAppePropId = itemAppePropId;
                    }

                    public String getItemAppePropDtlId() {
                        return this.itemAppePropDtlId;
                    }

                    public void setItemAppePropDtlId(String itemAppePropDtlId) {
                        this.itemAppePropDtlId = itemAppePropDtlId;
                    }

                    public String getItemAppePropDtlNm() {
                        return this.itemAppePropDtlNm;
                    }

                    public void setItemAppePropDtlNm(String itemAppePropDtlNm) {
                        this.itemAppePropDtlNm = itemAppePropDtlNm;
                    }

                    public String getItemAppePropDtlEngNm() {
                        return this.itemAppePropDtlEngNm;
                    }

                    public void setItemAppePropDtlEngNm(String itemAppePropDtlEngNm) {
                        this.itemAppePropDtlEngNm = itemAppePropDtlEngNm;
                    }
                }
            }
        }
    }

    public static class ProductAppePropTgtList {
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        private static class Result {
            private String resultCode;
            private String resultMessage;
            private String resultDesc;
            @JsonDeserialize(using=SSGInpAppeCertDeserializer.class)
            List<ItemAppeProps> itemAppeProps;

            private Result() {
            }

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public List<ItemAppeProps> getItemAppeProps() {
                return this.itemAppeProps;
            }

            public void setItemAppeProps(List<ItemAppeProps> itemAppeProps) {
                this.itemAppeProps = itemAppeProps;
            }

            private static class ItemAppeProps {
                private ItemAppeProp itemAppeProp;

                private ItemAppeProps() {
                }

                public ItemAppeProp getItemAppeProp() {
                    return this.itemAppeProp;
                }

                public void setItemAppeProp(ItemAppeProp itemAppeProp) {
                    this.itemAppeProp = itemAppeProp;
                }

                private static class ItemAppeProp {
                    private String itemAppePropId;
                    private String itemAppePropNm;
                    private String maxIptVal;
                    private String useYn;

                    private ItemAppeProp() {
                    }

                    public String getItemAppePropId() {
                        return this.itemAppePropId;
                    }

                    public void setItemAppePropId(String itemAppePropId) {
                        this.itemAppePropId = itemAppePropId;
                    }

                    public String getItemAppePropNm() {
                        return this.itemAppePropNm;
                    }

                    public void setItemAppePropNm(String itemAppePropNm) {
                        this.itemAppePropNm = itemAppePropNm;
                    }

                    public String getMaxIptVal() {
                        return this.maxIptVal;
                    }

                    public void setMaxIptVal(String maxIptVal) {
                        this.maxIptVal = maxIptVal;
                    }

                    public String getUseYn() {
                        return this.useYn;
                    }

                    public void setUseYn(String useYn) {
                        this.useYn = useYn;
                    }
                }
            }
        }
    }

    public static class ProductResult {
        public Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public static class Result {
            public String resultCode;
            public String resultMessage;
            public String resultDesc;
            public String itemId;

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public String getItemId() {
                return this.itemId;
            }

            public void setItemId(String itemId) {
                this.itemId = itemId;
            }
        }
    }

    public static class ProductUpdateAliance {
        private Om_updateAlliance om_updateAlliance;

        public Om_updateAlliance getOm_updateAlliance() {
            return this.om_updateAlliance;
        }

        public void setOm_updateAlliance(Om_updateAlliance om_updateAlliance) {
            this.om_updateAlliance = om_updateAlliance;
        }

        public static class Om_updateAlliance {
            private Alliance alliance;

            public Alliance getAlliance() {
                return this.alliance;
            }

            public void setAlliance(Alliance alliance) {
                this.alliance = alliance;
            }

            public static class Alliance {
                private String itemId;
                private EpLnkg epLnkg;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public EpLnkg getEpLnkg() {
                    return this.epLnkg;
                }

                public void setEpLnkg(EpLnkg epLnkg) {
                    this.epLnkg = epLnkg;
                }

                public static class EpLnkg {
                    private String epLnkgYn;
                    private String dcExpsrYn;

                    public String getEpLnkgYn() {
                        return this.epLnkgYn;
                    }

                    public void setEpLnkgYn(String epLnkgYn) {
                        this.epLnkgYn = epLnkgYn;
                    }

                    public String getDcExpsrYn() {
                        return this.dcExpsrYn;
                    }

                    public void setDcExpsrYn(String dcExpsrYn) {
                        this.dcExpsrYn = dcExpsrYn;
                    }
                }
            }
        }
    }

    public static class ProductUpdateAttribute {
        private Om_updateAttribute om_updateAttribute;

        public Om_updateAttribute getOm_updateAttribute() {
            return this.om_updateAttribute;
        }

        public void setOm_updateAttribute(Om_updateAttribute om_updateAttribute) {
            this.om_updateAttribute = om_updateAttribute;
        }

        private static class Om_updateAttribute {
            private Attribute attribute;

            private Om_updateAttribute() {
            }

            public Attribute getAttribute() {
                return this.attribute;
            }

            public void setAttribute(Attribute attribute) {
                this.attribute = attribute;
            }

            public static class Attribute {
                private String itemId;
                List<CertificationProps> certificationProps;
                List<AttributeProps> attributeProps;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public List<CertificationProps> getCertificationProps() {
                    return this.certificationProps;
                }

                public void setCertificationProps(List<CertificationProps> certificationProps) {
                    this.certificationProps = certificationProps;
                }

                public List<AttributeProps> getAttributeProps() {
                    return this.attributeProps;
                }

                public void setAttributeProps(List<AttributeProps> attributeProps) {
                    this.attributeProps = attributeProps;
                }

                private static class AttributeProps {
                    private Prop prop;

                    private AttributeProps() {
                    }

                    public Prop getProp() {
                        return this.prop;
                    }

                    public void setProp(Prop prop) {
                        this.prop = prop;
                    }

                    private static class Prop {
                        private String itemAppePropId;
                        private String itemAppePropCntt;

                        private Prop() {
                        }

                        public String getItemAppePropId() {
                            return this.itemAppePropId;
                        }

                        public void setItemAppePropId(String itemAppePropId) {
                            this.itemAppePropId = itemAppePropId;
                        }

                        public String getItemAppePropCntt() {
                            return this.itemAppePropCntt;
                        }

                        public void setItemAppePropCntt(String itemAppePropCntt) {
                            this.itemAppePropCntt = itemAppePropCntt;
                        }
                    }
                }

                private static class CertificationProps {
                    private Prop prop;

                    private CertificationProps() {
                    }

                    public Prop getProp() {
                        return this.prop;
                    }

                    public void setProp(Prop prop) {
                        this.prop = prop;
                    }

                    private static class Prop {
                        private String itemAppePropClsId;
                        private String itemAppePropId;
                        private String itemAppePropCntt;

                        private Prop() {
                        }

                        public String getItemAppePropClsId() {
                            return this.itemAppePropClsId;
                        }

                        public void setItemAppePropClsId(String itemAppePropClsId) {
                            this.itemAppePropClsId = itemAppePropClsId;
                        }

                        public String getItemAppePropId() {
                            return this.itemAppePropId;
                        }

                        public void setItemAppePropId(String itemAppePropId) {
                            this.itemAppePropId = itemAppePropId;
                        }

                        public String getItemAppePropCntt() {
                            return this.itemAppePropCntt;
                        }

                        public void setItemAppePropCntt(String itemAppePropCntt) {
                            this.itemAppePropCntt = itemAppePropCntt;
                        }
                    }
                }
            }
        }
    }

    public static class ProductUpdateComposite {
        private Om_updateComposite om_updateComposite;

        public Om_updateComposite getOm_updateComposite() {
            return this.om_updateComposite;
        }

        public void setOm_updateComposite(Om_updateComposite om_updateComposite) {
            this.om_updateComposite = om_updateComposite;
        }

        public static class Om_updateComposite {
            private Composite composite;

            public Composite getComposite() {
                return this.composite;
            }

            public void setComposite(Composite composite) {
                this.composite = composite;
            }

            public static class Composite {
                private String itemId;
                private Frebie frebie;
                private List<AddComposites> addComposites;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public Frebie getFrebie() {
                    return this.frebie;
                }

                public void setFrebie(Frebie frebie) {
                    this.frebie = frebie;
                }

                public List<AddComposites> getAddComposites() {
                    return this.addComposites;
                }

                public void setAddComposites(List<AddComposites> addComposites) {
                    this.addComposites = addComposites;
                }

                public static class AddComposites {
                    private List<AddComposite> addComposite;

                    public List<AddComposite> getAddComposite() {
                        return this.addComposite;
                    }

                    public void setAddComposite(List<AddComposite> addComposite) {
                        this.addComposite = addComposite;
                    }

                    public static class AddComposite {
                        private String addCmptItemId;
                        private String addCmptItemGrpNm;
                        private String cmptSellprc;
                        private String useYn;

                        public String getAddCmptItemId() {
                            return this.addCmptItemId;
                        }

                        public void setAddCmptItemId(String addCmptItemId) {
                            this.addCmptItemId = addCmptItemId;
                        }

                        public String getAddCmptItemGrpNm() {
                            return this.addCmptItemGrpNm;
                        }

                        public void setAddCmptItemGrpNm(String addCmptItemGrpNm) {
                            this.addCmptItemGrpNm = addCmptItemGrpNm;
                        }

                        public String getCmptSellprc() {
                            return this.cmptSellprc;
                        }

                        public void setCmptSellprc(String cmptSellprc) {
                            this.cmptSellprc = cmptSellprc;
                        }

                        public String getUseYn() {
                            return this.useYn;
                        }

                        public void setUseYn(String useYn) {
                            this.useYn = useYn;
                        }
                    }
                }

                public static class Frebie {
                    private String itemNm;
                    private String invMngYn;
                    private String usablInvQty;
                    private String useYn;
                    private String frebiePrvdStrtDt;
                    private String frebiePrvdEndDt;

                    public String getItemNm() {
                        return this.itemNm;
                    }

                    public void setItemNm(String itemNm) {
                        this.itemNm = itemNm;
                    }

                    public String getInvMngYn() {
                        return this.invMngYn;
                    }

                    public void setInvMngYn(String invMngYn) {
                        this.invMngYn = invMngYn;
                    }

                    public String getUsablInvQty() {
                        return this.usablInvQty;
                    }

                    public void setUsablInvQty(String usablInvQty) {
                        this.usablInvQty = usablInvQty;
                    }

                    public String getUseYn() {
                        return this.useYn;
                    }

                    public void setUseYn(String useYn) {
                        this.useYn = useYn;
                    }

                    public String getFrebiePrvdStrtDt() {
                        return this.frebiePrvdStrtDt;
                    }

                    public void setFrebiePrvdStrtDt(String frebiePrvdStrtDt) {
                        this.frebiePrvdStrtDt = frebiePrvdStrtDt;
                    }

                    public String getFrebiePrvdEndDt() {
                        return this.frebiePrvdEndDt;
                    }

                    public void setFrebiePrvdEndDt(String frebiePrvdEndDt) {
                        this.frebiePrvdEndDt = frebiePrvdEndDt;
                    }
                }
            }
        }
    }

    public static class ProductUpdateInventory {
        private Om_updateInventory om_updateInventory;

        public Om_updateInventory getOm_updateInventory() {
            return this.om_updateInventory;
        }

        public void setOm_updateInventory(Om_updateInventory om_updateInventory) {
            this.om_updateInventory = om_updateInventory;
        }

        public static class Om_updateInventory {
            private Inventory inventory;

            public Inventory getInventory() {
                return this.inventory;
            }

            public void setInventory(Inventory inventory) {
                this.inventory = inventory;
            }

            public static class Inventory {
                private String itemId;
                private String dispStrtDt;
                private String dispEndDt;
                private String sellStatCd;
                private String sellFrmCd;
                private String rstctStrtDt;
                private String rstctEndDt;
                private String whoutStrtDt;
                private String usablInvQty;
                private String rstctInvQty;
                private List<OptionInvs> optionInvs;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getDispStrtDt() {
                    return this.dispStrtDt;
                }

                public void setDispStrtDt(String dispStrtDt) {
                    this.dispStrtDt = dispStrtDt;
                }

                public String getDispEndDt() {
                    return this.dispEndDt;
                }

                public void setDispEndDt(String dispEndDt) {
                    this.dispEndDt = dispEndDt;
                }

                public String getSellStatCd() {
                    return this.sellStatCd;
                }

                public void setSellStatCd(String sellStatCd) {
                    this.sellStatCd = sellStatCd;
                }

                public String getSellFrmCd() {
                    return this.sellFrmCd;
                }

                public void setSellFrmCd(String sellFrmCd) {
                    this.sellFrmCd = sellFrmCd;
                }

                public String getRstctStrtDt() {
                    return this.rstctStrtDt;
                }

                public void setRstctStrtDt(String rstctStrtDt) {
                    this.rstctStrtDt = rstctStrtDt;
                }

                public String getRstctEndDt() {
                    return this.rstctEndDt;
                }

                public void setRstctEndDt(String rstctEndDt) {
                    this.rstctEndDt = rstctEndDt;
                }

                public String getWhoutStrtDt() {
                    return this.whoutStrtDt;
                }

                public void setWhoutStrtDt(String whoutStrtDt) {
                    this.whoutStrtDt = whoutStrtDt;
                }

                public String getUsablInvQty() {
                    return this.usablInvQty;
                }

                public void setUsablInvQty(String usablInvQty) {
                    this.usablInvQty = usablInvQty;
                }

                public String getRstctInvQty() {
                    return this.rstctInvQty;
                }

                public void setRstctInvQty(String rstctInvQty) {
                    this.rstctInvQty = rstctInvQty;
                }

                public List<OptionInvs> getOptionInvs() {
                    return this.optionInvs;
                }

                public void setOptionInvs(List<OptionInvs> optionInvs) {
                    this.optionInvs = optionInvs;
                }

                public static class OptionInvs {
                    private List<OptionInv> optionInv;

                    public List<OptionInv> getOptionInv() {
                        return this.optionInv;
                    }

                    public void setOptionInv(List<OptionInv> optionInv) {
                        this.optionInv = optionInv;
                    }

                    public static class OptionInv {
                        private String uitemId;
                        private String usablInvQty;
                        private String rstctInvQty;
                        private String sellStatCd;

                        public String getUitemId() {
                            return this.uitemId;
                        }

                        public void setUitemId(String uitemId) {
                            this.uitemId = uitemId;
                        }

                        public String getUsablInvQty() {
                            return this.usablInvQty;
                        }

                        public void setUsablInvQty(String usablInvQty) {
                            this.usablInvQty = usablInvQty;
                        }

                        public String getRstctInvQty() {
                            return this.rstctInvQty;
                        }

                        public void setRstctInvQty(String rstctInvQty) {
                            this.rstctInvQty = rstctInvQty;
                        }

                        public String getSellStatCd() {
                            return this.sellStatCd;
                        }

                        public void setSellStatCd(String sellStatCd) {
                            this.sellStatCd = sellStatCd;
                        }
                    }
                }
            }
        }
    }

    public static class ProductUpdateNotification {
        private Om_updateNotification om_updateNotification;

        public Om_updateNotification getOm_updateNotification() {
            return this.om_updateNotification;
        }

        public void setOm_updateNotification(Om_updateNotification om_updateNotification) {
            this.om_updateNotification = om_updateNotification;
        }

        private static class Om_updateNotification {
            private Notification notification;

            private Om_updateNotification() {
            }

            public Notification getNotification() {
                return this.notification;
            }

            public void setNotification(Notification notification) {
                this.notification = notification;
            }

            public static class Notification {
                private String itemId;
                private String itemMngPropClsId;
                private String manufcoNm;
                private String prodManufCntryId;
                List<NotificationProps> notificationProps;
                private String sellCapaUnitCd;
                private String sellTotCapa;
                private String sellUnitCapa;
                private String sellUnitQty;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getItemMngPropClsId() {
                    return this.itemMngPropClsId;
                }

                public void setItemMngPropClsId(String itemMngPropClsId) {
                    this.itemMngPropClsId = itemMngPropClsId;
                }

                public String getManufcoNm() {
                    return this.manufcoNm;
                }

                public void setManufcoNm(String manufcoNm) {
                    this.manufcoNm = manufcoNm;
                }

                public String getProdManufCntryId() {
                    return this.prodManufCntryId;
                }

                public void setProdManufCntryId(String prodManufCntryId) {
                    this.prodManufCntryId = prodManufCntryId;
                }

                public List<NotificationProps> getNotificationProps() {
                    return this.notificationProps;
                }

                public void setNotificationProps(List<NotificationProps> notificationProps) {
                    this.notificationProps = notificationProps;
                }

                public String getSellCapaUnitCd() {
                    return this.sellCapaUnitCd;
                }

                public void setSellCapaUnitCd(String sellCapaUnitCd) {
                    this.sellCapaUnitCd = sellCapaUnitCd;
                }

                public String getSellTotCapa() {
                    return this.sellTotCapa;
                }

                public void setSellTotCapa(String sellTotCapa) {
                    this.sellTotCapa = sellTotCapa;
                }

                public String getSellUnitCapa() {
                    return this.sellUnitCapa;
                }

                public void setSellUnitCapa(String sellUnitCapa) {
                    this.sellUnitCapa = sellUnitCapa;
                }

                public String getSellUnitQty() {
                    return this.sellUnitQty;
                }

                public void setSellUnitQty(String sellUnitQty) {
                    this.sellUnitQty = sellUnitQty;
                }

                public static class NotificationProps {
                    List<NotificationProp> notificationProp;

                    public List<NotificationProp> getNotificationProp() {
                        return this.notificationProp;
                    }

                    public void setNotificationProp(List<NotificationProp> notificationProp) {
                        this.notificationProp = notificationProp;
                    }

                    public static class NotificationProp {
                        private String itemMngPropId;
                        private String itemMngCntt;

                        public String getItemMngPropId() {
                            return this.itemMngPropId;
                        }

                        public void setItemMngPropId(String itemMngPropId) {
                            this.itemMngPropId = itemMngPropId;
                        }

                        public String getItemMngCntt() {
                            return this.itemMngCntt;
                        }

                        public void setItemMngCntt(String itemMngCntt) {
                            this.itemMngCntt = itemMngCntt;
                        }
                    }
                }
            }
        }
    }

    public static class ProductUpdateOption {
        private Om_updateOption om_updateOption;
        private String uitemCacWayCd;
        private UitemEaitemOptn uitemEaitemOptn;

        public Om_updateOption getOm_updateOption() {
            return this.om_updateOption;
        }

        public void setOm_updateOption(Om_updateOption om_updateOption) {
            this.om_updateOption = om_updateOption;
        }

        private static class Om_updateOption {
            private Option option;

            private Om_updateOption() {
            }

            public Option getOption() {
                return this.option;
            }

            public void setOption(Option option2) {
                this.option = option2;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class Option {
                private String itemId;
                private String itemSellTypeCd;
                private String txnDivCd;
                private String uitemOptnTypeCd1;
                private String uitemOptnTypeNm1;
                private String uitemOptnTypeCd2;
                private String uitemOptnTypeNm2;
                private String uitemOptnTypeCd3;
                private String uitemOptnTypeNm3;
                private String uitemOptnTypeCd4;
                private String uitemOptnTypeNm4;
                private String uitemOptnAddtIptCd;
                private String splVenItemId;
                private String sellprc;
                List<OptionNms> optionNms;
                private String uitemOptnChoiTypeCd1;
                private String uitemOptnChoiTypeCd2;
                private String uitemOptnChoiTypeCd3;
                private String uitemOptnChoiTypeCd4;

                public String getUitemOptnChoiTypeCd1() {
                    return this.uitemOptnChoiTypeCd1;
                }

                public void setUitemOptnChoiTypeCd1(String uitemOptnChoiTypeCd1) {
                    this.uitemOptnChoiTypeCd1 = uitemOptnChoiTypeCd1;
                }

                public String getUitemOptnChoiTypeCd2() {
                    return this.uitemOptnChoiTypeCd2;
                }

                public void setUitemOptnChoiTypeCd2(String uitemOptnChoiTypeCd2) {
                    this.uitemOptnChoiTypeCd2 = uitemOptnChoiTypeCd2;
                }

                public String getUitemOptnChoiTypeCd3() {
                    return this.uitemOptnChoiTypeCd3;
                }

                public void setUitemOptnChoiTypeCd3(String uitemOptnChoiTypeCd3) {
                    this.uitemOptnChoiTypeCd3 = uitemOptnChoiTypeCd3;
                }

                public String getUitemOptnChoiTypeCd4() {
                    return this.uitemOptnChoiTypeCd4;
                }

                public void setUitemOptnChoiTypeCd4(String uitemOptnChoiTypeCd4) {
                    this.uitemOptnChoiTypeCd4 = uitemOptnChoiTypeCd4;
                }

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getItemSellTypeCd() {
                    return this.itemSellTypeCd;
                }

                public void setItemSellTypeCd(String itemSellTypeCd) {
                    this.itemSellTypeCd = itemSellTypeCd;
                }

                public String getTxnDivCd() {
                    return this.txnDivCd;
                }

                public void setTxnDivCd(String txnDivCd) {
                    this.txnDivCd = txnDivCd;
                }

                public String getUitemOptnTypeCd1() {
                    return this.uitemOptnTypeCd1;
                }

                public void setUitemOptnTypeCd1(String uitemOptnTypeCd1) {
                    this.uitemOptnTypeCd1 = uitemOptnTypeCd1;
                }

                public String getUitemOptnTypeNm1() {
                    return this.uitemOptnTypeNm1;
                }

                public void setUitemOptnTypeNm1(String uitemOptnTypeNm1) {
                    this.uitemOptnTypeNm1 = uitemOptnTypeNm1;
                }

                public String getUitemOptnTypeCd2() {
                    return this.uitemOptnTypeCd2;
                }

                public void setUitemOptnTypeCd2(String uitemOptnTypeCd2) {
                    this.uitemOptnTypeCd2 = uitemOptnTypeCd2;
                }

                public String getUitemOptnTypeNm2() {
                    return this.uitemOptnTypeNm2;
                }

                public void setUitemOptnTypeNm2(String uitemOptnTypeNm2) {
                    this.uitemOptnTypeNm2 = uitemOptnTypeNm2;
                }

                public String getUitemOptnTypeCd3() {
                    return this.uitemOptnTypeCd3;
                }

                public void setUitemOptnTypeCd3(String uitemOptnTypeCd3) {
                    this.uitemOptnTypeCd3 = uitemOptnTypeCd3;
                }

                public String getUitemOptnTypeNm3() {
                    return this.uitemOptnTypeNm3;
                }

                public void setUitemOptnTypeNm3(String uitemOptnTypeNm3) {
                    this.uitemOptnTypeNm3 = uitemOptnTypeNm3;
                }

                public String getUitemOptnTypeCd4() {
                    return this.uitemOptnTypeCd4;
                }

                public void setUitemOptnTypeCd4(String uitemOptnTypeCd4) {
                    this.uitemOptnTypeCd4 = uitemOptnTypeCd4;
                }

                public String getUitemOptnTypeNm4() {
                    return this.uitemOptnTypeNm4;
                }

                public void setUitemOptnTypeNm4(String uitemOptnTypeNm4) {
                    this.uitemOptnTypeNm4 = uitemOptnTypeNm4;
                }

                public String getUitemOptnAddtIptCd() {
                    return this.uitemOptnAddtIptCd;
                }

                public void setUitemOptnAddtIptCd(String uitemOptnAddtIptCd) {
                    this.uitemOptnAddtIptCd = uitemOptnAddtIptCd;
                }

                public String getSplVenItemId() {
                    return this.splVenItemId;
                }

                public void setSplVenItemId(String splVenItemId) {
                    this.splVenItemId = splVenItemId;
                }

                public String getSellprc() {
                    return this.sellprc;
                }

                public void setSellprc(String sellprc) {
                    this.sellprc = sellprc;
                }

                public List<OptionNms> getOptionNms() {
                    return this.optionNms;
                }

                public void setOptionNms(List<OptionNms> optionNms) {
                    this.optionNms = optionNms;
                }

                public static class OptionNms {
                    List<OptionNm> optionNm;

                    public List<OptionNm> getOptionNm() {
                        return this.optionNm;
                    }

                    public void setOptionNm(List<OptionNm> optionNm) {
                        this.optionNm = optionNm;
                    }

                    public static class OptionNm {
                        private String uitemId;
                        private String uitemOptnNm1;
                        private String uitemOptnNm2;
                        private String uitemOptnNm3;
                        private String uitemOptnNm4;
                        private String uitemOptnAddt;
                        private String splVenItemId;
                        private String useYn;
                        private String sellprc;

                        public String getUitemId() {
                            return this.uitemId;
                        }

                        public void setUitemId(String uitemId) {
                            this.uitemId = uitemId;
                        }

                        public String getUitemOptnNm1() {
                            return this.uitemOptnNm1;
                        }

                        public void setUitemOptnNm1(String uitemOptnNm1) {
                            this.uitemOptnNm1 = uitemOptnNm1;
                        }

                        public String getUitemOptnNm2() {
                            return this.uitemOptnNm2;
                        }

                        public void setUitemOptnNm2(String uitemOptnNm2) {
                            this.uitemOptnNm2 = uitemOptnNm2;
                        }

                        public String getUitemOptnNm3() {
                            return this.uitemOptnNm3;
                        }

                        public void setUitemOptnNm3(String uitemOptnNm3) {
                            this.uitemOptnNm3 = uitemOptnNm3;
                        }

                        public String getUitemOptnNm4() {
                            return this.uitemOptnNm4;
                        }

                        public void setUitemOptnNm4(String uitemOptnNm4) {
                            this.uitemOptnNm4 = uitemOptnNm4;
                        }

                        public String getUitemOptnAddt() {
                            return this.uitemOptnAddt;
                        }

                        public void setUitemOptnAddt(String uitemOptnAddt) {
                            this.uitemOptnAddt = uitemOptnAddt;
                        }

                        public String getSplVenItemId() {
                            return this.splVenItemId;
                        }

                        public void setSplVenItemId(String splVenItemId) {
                            this.splVenItemId = splVenItemId;
                        }

                        public String getUseYn() {
                            return this.useYn;
                        }

                        public void setUseYn(String useYn) {
                            this.useYn = useYn;
                        }

                        public String getSellprc() {
                            return this.sellprc;
                        }

                        public void setSellprc(String sellprc) {
                            this.sellprc = sellprc;
                        }
                    }
                }
            }
        }

        public static class UitemEaitemOptn {
            private String eaitemOptnCacNm1;
            private String eaitemMinCacUnitVal1;
            private String eaitemMaxCacUnitVal1;
            private String cmakeMesurUnitCd1;
            private String eaitemOptnCacNm2;
            private String eaitemMinCacUnitVal2;
            private String eaitemMaxCacUnitVal2;
            private String cmakeMesurUnitCd2;
            private String purchUnitQty;
            private String punitSellprc;
            List<AddOrdOptns> addOrdOptns;

            public String getEaitemOptnCacNm1() {
                return this.eaitemOptnCacNm1;
            }

            public void setEaitemOptnCacNm1(String eaitemOptnCacNm1) {
                this.eaitemOptnCacNm1 = eaitemOptnCacNm1;
            }

            public String getEaitemMinCacUnitVal1() {
                return this.eaitemMinCacUnitVal1;
            }

            public void setEaitemMinCacUnitVal1(String eaitemMinCacUnitVal1) {
                this.eaitemMinCacUnitVal1 = eaitemMinCacUnitVal1;
            }

            public String getEaitemMaxCacUnitVal1() {
                return this.eaitemMaxCacUnitVal1;
            }

            public void setEaitemMaxCacUnitVal1(String eaitemMaxCacUnitVal1) {
                this.eaitemMaxCacUnitVal1 = eaitemMaxCacUnitVal1;
            }

            public String getCmakeMesurUnitCd1() {
                return this.cmakeMesurUnitCd1;
            }

            public void setCmakeMesurUnitCd1(String cmakeMesurUnitCd1) {
                this.cmakeMesurUnitCd1 = cmakeMesurUnitCd1;
            }

            public String getEaitemOptnCacNm2() {
                return this.eaitemOptnCacNm2;
            }

            public void setEaitemOptnCacNm2(String eaitemOptnCacNm2) {
                this.eaitemOptnCacNm2 = eaitemOptnCacNm2;
            }

            public String getEaitemMinCacUnitVal2() {
                return this.eaitemMinCacUnitVal2;
            }

            public void setEaitemMinCacUnitVal2(String eaitemMinCacUnitVal2) {
                this.eaitemMinCacUnitVal2 = eaitemMinCacUnitVal2;
            }

            public String getEaitemMaxCacUnitVal2() {
                return this.eaitemMaxCacUnitVal2;
            }

            public void setEaitemMaxCacUnitVal2(String eaitemMaxCacUnitVal2) {
                this.eaitemMaxCacUnitVal2 = eaitemMaxCacUnitVal2;
            }

            public String getCmakeMesurUnitCd2() {
                return this.cmakeMesurUnitCd2;
            }

            public void setCmakeMesurUnitCd2(String cmakeMesurUnitCd2) {
                this.cmakeMesurUnitCd2 = cmakeMesurUnitCd2;
            }

            public String getPurchUnitQty() {
                return this.purchUnitQty;
            }

            public void setPurchUnitQty(String purchUnitQty) {
                this.purchUnitQty = purchUnitQty;
            }

            public String getPunitSellprc() {
                return this.punitSellprc;
            }

            public void setPunitSellprc(String punitSellprc) {
                this.punitSellprc = punitSellprc;
            }

            public static class AddOrdOptns {
                List<AddOrdOptn> addOrdOptn;

                public List<AddOrdOptn> getAddOrdOptn() {
                    return this.addOrdOptn;
                }

                public void setAddOrdOptn(List<AddOrdOptn> addOrdOptn) {
                    this.addOrdOptn = addOrdOptn;
                }

                public static class AddOrdOptn {
                    private String addOrdOptnSeq;
                    private String addOrdOptnNm;
                    private String addOrdOptnMndtyYn;
                    private String useYn;

                    public String getAddOrdOptnSeq() {
                        return this.addOrdOptnSeq;
                    }

                    public void setAddOrdOptnSeq(String addOrdOptnSeq) {
                        this.addOrdOptnSeq = addOrdOptnSeq;
                    }

                    public String getAddOrdOptnNm() {
                        return this.addOrdOptnNm;
                    }

                    public void setAddOrdOptnNm(String addOrdOptnNm) {
                        this.addOrdOptnNm = addOrdOptnNm;
                    }

                    public String getAddOrdOptnMndtyYn() {
                        return this.addOrdOptnMndtyYn;
                    }

                    public void setAddOrdOptnMndtyYn(String addOrdOptnMndtyYn) {
                        this.addOrdOptnMndtyYn = addOrdOptnMndtyYn;
                    }

                    public String getUseYn() {
                        return this.useYn;
                    }

                    public void setUseYn(String useYn) {
                        this.useYn = useYn;
                    }
                }
            }
        }
    }

    public static class ProductUpdatePromReq {
        private OmPromReq omPromReq;

        public OmPromReq getOmPromReq() {
            return this.omPromReq;
        }

        public void setOmPromReq(OmPromReq omPromReq) {
            this.omPromReq = omPromReq;
        }

        public static class OmPromReq {
            private String offerKindCd;
            private List<TgtList> tgtList;

            public String getOfferKindCd() {
                return this.offerKindCd;
            }

            public void setOfferKindCd(String offerKindCd) {
                this.offerKindCd = offerKindCd;
            }

            public List<TgtList> getTgtList() {
                return this.tgtList;
            }

            public void setTgtList(List<TgtList> tgtList) {
                this.tgtList = tgtList;
            }

            public static class TgtList {
                private String promEditReqProcTypeCd;
                private String tgtId;
                private String enfcStrtDts;
                private String enfcEndDts;
                private String prvdPrftTypeCd;
                private String prvdPrftVal;
                private String offerAplCritnCd;
                private String minCritnVal;

                public String getPromEditReqProcTypeCd() {
                    return this.promEditReqProcTypeCd;
                }

                public void setPromEditReqProcTypeCd(String promEditReqProcTypeCd) {
                    this.promEditReqProcTypeCd = promEditReqProcTypeCd;
                }

                public String getTgtId() {
                    return this.tgtId;
                }

                public void setTgtId(String tgtId) {
                    this.tgtId = tgtId;
                }

                public String getEnfcStrtDts() {
                    return this.enfcStrtDts;
                }

                public void setEnfcStrtDts(String enfcStrtDts) {
                    this.enfcStrtDts = enfcStrtDts;
                }

                public String getEnfcEndDts() {
                    return this.enfcEndDts;
                }

                public void setEnfcEndDts(String enfcEndDts) {
                    this.enfcEndDts = enfcEndDts;
                }

                public String getPrvdPrftTypeCd() {
                    return this.prvdPrftTypeCd;
                }

                public void setPrvdPrftTypeCd(String prvdPrftTypeCd) {
                    this.prvdPrftTypeCd = prvdPrftTypeCd;
                }

                public String getPrvdPrftVal() {
                    return this.prvdPrftVal;
                }

                public void setPrvdPrftVal(String prvdPrftVal) {
                    this.prvdPrftVal = prvdPrftVal;
                }

                public String getOfferAplCritnCd() {
                    return this.offerAplCritnCd;
                }

                public void setOfferAplCritnCd(String offerAplCritnCd) {
                    this.offerAplCritnCd = offerAplCritnCd;
                }

                public String getMinCritnVal() {
                    return this.minCritnVal;
                }

                public void setMinCritnVal(String minCritnVal) {
                    this.minCritnVal = minCritnVal;
                }
            }
        }
    }

    public static class ProductUpdateRewards {
        private Om_updateRewards om_updateRewards;

        public Om_updateRewards getOm_updateRewards() {
            return this.om_updateRewards;
        }

        public void setOm_updateRewards(Om_updateRewards om_updateRewards) {
            this.om_updateRewards = om_updateRewards;
        }

        private static class Om_updateRewards {
            private Rewards rewards;

            private Om_updateRewards() {
            }

            public Rewards getRewards() {
                return this.rewards;
            }

            public void setRewards(Rewards rewards) {
                this.rewards = rewards;
            }

            public static class Rewards {
                private String itemId;
                private String promMarketingAgreeYn;
                private BuyConfirmPoint buyConfirmPoint;
                private ReviewPoint reviewPoint;

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getPromMarketingAgreeYn() {
                    return this.promMarketingAgreeYn;
                }

                public void setPromMarketingAgreeYn(String promMarketingAgreeYn) {
                    this.promMarketingAgreeYn = promMarketingAgreeYn;
                }

                public BuyConfirmPoint getBuyConfirmPoint() {
                    return this.buyConfirmPoint;
                }

                public void setBuyConfirmPoint(BuyConfirmPoint buyConfirmPoint) {
                    this.buyConfirmPoint = buyConfirmPoint;
                }

                public ReviewPoint getReviewPoint() {
                    return this.reviewPoint;
                }

                public void setReviewPoint(ReviewPoint reviewPoint) {
                    this.reviewPoint = reviewPoint;
                }

                public static class BuyConfirmPoint {
                    private String aplYn;
                    private String aplStrtDt;
                    private String aplEndDt;
                    private String bascPrvdPrftTypeCd;
                    private String bascPrvdPrftVal;
                    private String addPrvdPrftTypeCd;
                    private String addPrvdPrftVal;

                    public String getAplYn() {
                        return this.aplYn;
                    }

                    public void setAplYn(String aplYn) {
                        this.aplYn = aplYn;
                    }

                    public String getAplStrtDt() {
                        return this.aplStrtDt;
                    }

                    public void setAplStrtDt(String aplStrtDt) {
                        this.aplStrtDt = aplStrtDt;
                    }

                    public String getAplEndDt() {
                        return this.aplEndDt;
                    }

                    public void setAplEndDt(String aplEndDt) {
                        this.aplEndDt = aplEndDt;
                    }

                    public String getBascPrvdPrftTypeCd() {
                        return this.bascPrvdPrftTypeCd;
                    }

                    public void setBascPrvdPrftTypeCd(String bascPrvdPrftTypeCd) {
                        this.bascPrvdPrftTypeCd = bascPrvdPrftTypeCd;
                    }

                    public String getBascPrvdPrftVal() {
                        return this.bascPrvdPrftVal;
                    }

                    public void setBascPrvdPrftVal(String bascPrvdPrftVal) {
                        this.bascPrvdPrftVal = bascPrvdPrftVal;
                    }

                    public String getAddPrvdPrftTypeCd() {
                        return this.addPrvdPrftTypeCd;
                    }

                    public void setAddPrvdPrftTypeCd(String addPrvdPrftTypeCd) {
                        this.addPrvdPrftTypeCd = addPrvdPrftTypeCd;
                    }

                    public String getAddPrvdPrftVal() {
                        return this.addPrvdPrftVal;
                    }

                    public void setAddPrvdPrftVal(String addPrvdPrftVal) {
                        this.addPrvdPrftVal = addPrvdPrftVal;
                    }
                }

                public static class ReviewPoint {
                    private String aplYn;
                    private String aplStrtDt;
                    private String aplEndDt;
                    private String textPrvdPrftTypeCd;
                    private String textPrvdPrftVal;
                    private String photoPrvdPrftTypeCd;
                    private String photoPrvdPrftVal;

                    public String getAplYn() {
                        return this.aplYn;
                    }

                    public void setAplYn(String aplYn) {
                        this.aplYn = aplYn;
                    }

                    public String getAplStrtDt() {
                        return this.aplStrtDt;
                    }

                    public void setAplStrtDt(String aplStrtDt) {
                        this.aplStrtDt = aplStrtDt;
                    }

                    public String getAplEndDt() {
                        return this.aplEndDt;
                    }

                    public void setAplEndDt(String aplEndDt) {
                        this.aplEndDt = aplEndDt;
                    }

                    public String getTextPrvdPrftTypeCd() {
                        return this.textPrvdPrftTypeCd;
                    }

                    public void setTextPrvdPrftTypeCd(String textPrvdPrftTypeCd) {
                        this.textPrvdPrftTypeCd = textPrvdPrftTypeCd;
                    }

                    public String getTextPrvdPrftVal() {
                        return this.textPrvdPrftVal;
                    }

                    public void setTextPrvdPrftVal(String textPrvdPrftVal) {
                        this.textPrvdPrftVal = textPrvdPrftVal;
                    }

                    public String getPhotoPrvdPrftTypeCd() {
                        return this.photoPrvdPrftTypeCd;
                    }

                    public void setPhotoPrvdPrftTypeCd(String photoPrvdPrftTypeCd) {
                        this.photoPrvdPrftTypeCd = photoPrvdPrftTypeCd;
                    }

                    public String getPhotoPrvdPrftVal() {
                        return this.photoPrvdPrftVal;
                    }

                    public void setPhotoPrvdPrftVal(String photoPrvdPrftVal) {
                        this.photoPrvdPrftVal = photoPrvdPrftVal;
                    }
                }
            }
        }
    }

    public static class ProductupdateDelivery {
        private Om_updateDelivery om_updateDelivery;

        public Om_updateDelivery getOm_updateDelivery() {
            return this.om_updateDelivery;
        }

        public void setOm_updateDelivery(Om_updateDelivery om_updateDelivery) {
            this.om_updateDelivery = om_updateDelivery;
        }

        private static class Om_updateDelivery {
            private Delivery delivery;

            private Om_updateDelivery() {
            }

            public Delivery getDelivery() {
                return this.delivery;
            }

            public void setDelivery(Delivery delivery) {
                this.delivery = delivery;
            }

            private static class Delivery {
                private String itemId;
                private String shppMthdCd;
                private String shppItemDivCd;
                private String ctvatInclYn;
                private String exprtCntryId;
                private String shppRqrmDcnt;
                private String retExchPsblYn;
                private String tdShppPsblYn;
                private String tdWhoutClsgHm;
                private String doffLst;
                private String whoutShppcstId;
                private String retShppcstId;
                private String whoutAddrId;
                private String snbkAddrId;
                private String mareaShppYn;
                private String jejuShppDisabYn;
                private String ismtarShppDisabYn;
                private String frgShppPsblYn;
                private String ismtarAddShppcstId;
                private String jejuAddShppcstId;

                private Delivery() {
                }

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getShppMthdCd() {
                    return this.shppMthdCd;
                }

                public void setShppMthdCd(String shppMthdCd) {
                    this.shppMthdCd = shppMthdCd;
                }

                public String getShppItemDivCd() {
                    return this.shppItemDivCd;
                }

                public void setShppItemDivCd(String shppItemDivCd) {
                    this.shppItemDivCd = shppItemDivCd;
                }

                public String getCtvatInclYn() {
                    return this.ctvatInclYn;
                }

                public void setCtvatInclYn(String ctvatInclYn) {
                    this.ctvatInclYn = ctvatInclYn;
                }

                public String getExprtCntryId() {
                    return this.exprtCntryId;
                }

                public void setExprtCntryId(String exprtCntryId) {
                    this.exprtCntryId = exprtCntryId;
                }

                public String getShppRqrmDcnt() {
                    return this.shppRqrmDcnt;
                }

                public void setShppRqrmDcnt(String shppRqrmDcnt) {
                    this.shppRqrmDcnt = shppRqrmDcnt;
                }

                public String getRetExchPsblYn() {
                    return this.retExchPsblYn;
                }

                public void setRetExchPsblYn(String retExchPsblYn) {
                    this.retExchPsblYn = retExchPsblYn;
                }

                public String getTdShppPsblYn() {
                    return this.tdShppPsblYn;
                }

                public void setTdShppPsblYn(String tdShppPsblYn) {
                    this.tdShppPsblYn = tdShppPsblYn;
                }

                public String getTdWhoutClsgHm() {
                    return this.tdWhoutClsgHm;
                }

                public void setTdWhoutClsgHm(String tdWhoutClsgHm) {
                    this.tdWhoutClsgHm = tdWhoutClsgHm;
                }

                public String getDoffLst() {
                    return this.doffLst;
                }

                public void setDoffLst(String doffLst) {
                    this.doffLst = doffLst;
                }

                public String getWhoutShppcstId() {
                    return this.whoutShppcstId;
                }

                public void setWhoutShppcstId(String whoutShppcstId) {
                    this.whoutShppcstId = whoutShppcstId;
                }

                public String getRetShppcstId() {
                    return this.retShppcstId;
                }

                public void setRetShppcstId(String retShppcstId) {
                    this.retShppcstId = retShppcstId;
                }

                public String getWhoutAddrId() {
                    return this.whoutAddrId;
                }

                public void setWhoutAddrId(String whoutAddrId) {
                    this.whoutAddrId = whoutAddrId;
                }

                public String getSnbkAddrId() {
                    return this.snbkAddrId;
                }

                public void setSnbkAddrId(String snbkAddrId) {
                    this.snbkAddrId = snbkAddrId;
                }

                public String getMareaShppYn() {
                    return this.mareaShppYn;
                }

                public void setMareaShppYn(String mareaShppYn) {
                    this.mareaShppYn = mareaShppYn;
                }

                public String getJejuShppDisabYn() {
                    return this.jejuShppDisabYn;
                }

                public void setJejuShppDisabYn(String jejuShppDisabYn) {
                    this.jejuShppDisabYn = jejuShppDisabYn;
                }

                public String getIsmtarShppDisabYn() {
                    return this.ismtarShppDisabYn;
                }

                public void setIsmtarShppDisabYn(String ismtarShppDisabYn) {
                    this.ismtarShppDisabYn = ismtarShppDisabYn;
                }

                public String getFrgShppPsblYn() {
                    return this.frgShppPsblYn;
                }

                public void setFrgShppPsblYn(String frgShppPsblYn) {
                    this.frgShppPsblYn = frgShppPsblYn;
                }

                public String getIsmtarAddShppcstId() {
                    return this.ismtarAddShppcstId;
                }

                public void setIsmtarAddShppcstId(String ismtarAddShppcstId) {
                    this.ismtarAddShppcstId = ismtarAddShppcstId;
                }

                public String getJejuAddShppcstId() {
                    return this.jejuAddShppcstId;
                }

                public void setJejuAddShppcstId(String jejuAddShppcstId) {
                    this.jejuAddShppcstId = jejuAddShppcstId;
                }
            }
        }
    }

    public static class ProductupdateDescription {
        private Om_updateDescription om_updateDescription;

        public Om_updateDescription getOm_updateDescription() {
            return this.om_updateDescription;
        }

        public void setOm_updateDescription(Om_updateDescription om_updateDescription) {
            this.om_updateDescription = om_updateDescription;
        }

        private static class Om_updateDescription {
            private Description description;

            private Om_updateDescription() {
            }

            public Description getDescription() {
                return this.description;
            }

            public void setDescription(Description description) {
                this.description = description;
            }

            private static class Description {
                private String itemId;
                private String promNm;
                private ItemDescription itemDescription;
                private List<ItemImages> itemImages;
                private ItemVod itemVod;

                private Description() {
                }

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getPromNm() {
                    return this.promNm;
                }

                public void setPromNm(String promNm) {
                    this.promNm = promNm;
                }

                public ItemDescription getItemDescription() {
                    return this.itemDescription;
                }

                public void setItemDescription(ItemDescription itemDescription) {
                    this.itemDescription = itemDescription;
                }

                public List<ItemImages> getItemImages() {
                    return this.itemImages;
                }

                public void setItemImages(List<ItemImages> itemImages) {
                    this.itemImages = itemImages;
                }

                public ItemVod getItemVod() {
                    return this.itemVod;
                }

                public void setItemVod(ItemVod itemVod) {
                    this.itemVod = itemVod;
                }

                private static class ItemDescription {
                    private String htmlCntt;

                    private ItemDescription() {
                    }

                    public String getHtmlCntt() {
                        return this.htmlCntt;
                    }

                    public void setHtmlCntt(String htmlCntt) {
                        this.htmlCntt = htmlCntt;
                    }
                }

                private static class ItemImages {
                    private ItemImage itemImage;

                    private ItemImages() {
                    }

                    public ItemImage getItemImage() {
                        return this.itemImage;
                    }

                    public void setItemImage(ItemImage itemImage) {
                        this.itemImage = itemImage;
                    }

                    private static class ItemImage {
                        private int dataSeq;
                        private String dataFileNm;
                        private String rplcTextNm;
                        private String uitemImgAssoUseYn;
                        List<AssoItems> assoItems;

                        private ItemImage() {
                        }

                        public int getDataSeq() {
                            return this.dataSeq;
                        }

                        public void setDataSeq(int dataSeq) {
                            this.dataSeq = dataSeq;
                        }

                        public String getDataFileNm() {
                            return this.dataFileNm;
                        }

                        public void setDataFileNm(String dataFileNm) {
                            this.dataFileNm = dataFileNm;
                        }

                        public String getRplcTextNm() {
                            return this.rplcTextNm;
                        }

                        public void setRplcTextNm(String rplcTextNm) {
                            this.rplcTextNm = rplcTextNm;
                        }

                        public String getUitemImgAssoUseYn() {
                            return this.uitemImgAssoUseYn;
                        }

                        public void setUitemImgAssoUseYn(String uitemImgAssoUseYn) {
                            this.uitemImgAssoUseYn = uitemImgAssoUseYn;
                        }

                        public List<AssoItems> getAssoItems() {
                            return this.assoItems;
                        }

                        public void setAssoItems(List<AssoItems> assoItems) {
                            this.assoItems = assoItems;
                        }

                        private static class AssoItems {
                            private AssoItem assoItem;

                            private AssoItems() {
                            }

                            public AssoItem getAssoItem() {
                                return this.assoItem;
                            }

                            public void setAssoItem(AssoItem assoItem) {
                                this.assoItem = assoItem;
                            }

                            private static class AssoItem {
                                private String itemId;
                                private String dispOrdr;
                                private String xcorVal;
                                private String ycorVal;
                                private String spbuTagDireNm;
                                private String useYn;
                                private String dispYn;

                                private AssoItem() {
                                }

                                public String getItemId() {
                                    return this.itemId;
                                }

                                public void setItemId(String itemId) {
                                    this.itemId = itemId;
                                }

                                public String getDispOrdr() {
                                    return this.dispOrdr;
                                }

                                public void setDispOrdr(String dispOrdr) {
                                    this.dispOrdr = dispOrdr;
                                }

                                public String getXcorVal() {
                                    return this.xcorVal;
                                }

                                public void setXcorVal(String xcorVal) {
                                    this.xcorVal = xcorVal;
                                }

                                public String getYcorVal() {
                                    return this.ycorVal;
                                }

                                public void setYcorVal(String ycorVal) {
                                    this.ycorVal = ycorVal;
                                }

                                public String getSpbuTagDireNm() {
                                    return this.spbuTagDireNm;
                                }

                                public void setSpbuTagDireNm(String spbuTagDireNm) {
                                    this.spbuTagDireNm = spbuTagDireNm;
                                }

                                public String getUseYn() {
                                    return this.useYn;
                                }

                                public void setUseYn(String useYn) {
                                    this.useYn = useYn;
                                }

                                public String getDispYn() {
                                    return this.dispYn;
                                }

                                public void setDispYn(String dispYn) {
                                    this.dispYn = dispYn;
                                }
                            }
                        }
                    }
                }

                private static class ItemVod {
                    private String dataFileNm;
                    private String vodExtnlPathUrl;
                    private String rplcTextNm;

                    private ItemVod() {
                    }

                    public String getDataFileNm() {
                        return this.dataFileNm;
                    }

                    public void setDataFileNm(String dataFileNm) {
                        this.dataFileNm = dataFileNm;
                    }

                    public String getVodExtnlPathUrl() {
                        return this.vodExtnlPathUrl;
                    }

                    public void setVodExtnlPathUrl(String vodExtnlPathUrl) {
                        this.vodExtnlPathUrl = vodExtnlPathUrl;
                    }

                    public String getRplcTextNm() {
                        return this.rplcTextNm;
                    }

                    public void setRplcTextNm(String rplcTextNm) {
                        this.rplcTextNm = rplcTextNm;
                    }
                }
            }
        }
    }

    public static class ProductupdateItemBasic {
        private Om_updateItemBase om_updateItemBase;

        public Om_updateItemBase getOm_updateItemBase() {
            return this.om_updateItemBase;
        }

        public void setOm_updateItemBase(Om_updateItemBase om_updateItemBase) {
            this.om_updateItemBase = om_updateItemBase;
        }

        private static class Om_updateItemBase {
            private ItemBasic itemBasic;

            private Om_updateItemBase() {
            }

            public ItemBasic getItemBasic() {
                return this.itemBasic;
            }

            public void setItemBasic(ItemBasic itemBasic) {
                this.itemBasic = itemBasic;
            }

            private static class ItemBasic {
                private String itemId;
                private String itemNm;
                List<MtlglItemNms> mtlglItemNms;
                private String stdCtgId;
                private String brandId;
                private String mdlNm;
                private String itemChrctDivCd;
                private String itemChrctDtlCd;
                private String exusItemDivCd;
                private String exusItemDtlCd;
                private String adultItemTypeCd;
                private String itemStatTypeCd;
                private String itemSellWayCd;
                private String palimpItemYn;
                private String giftPsblYn;
                private String whinNotiYn;
                private String asMemoCntt;
                private String asTelno;
                private String itemSrchwdNm;
                private String minOnetOrdPsblQty;
                private String maxOnetOrdPsblQty;
                private String max1dyOrdPsblQty;

                private ItemBasic() {
                }

                public String getItemId() {
                    return this.itemId;
                }

                public void setItemId(String itemId) {
                    this.itemId = itemId;
                }

                public String getItemNm() {
                    return this.itemNm;
                }

                public void setItemNm(String itemNm) {
                    this.itemNm = itemNm;
                }

                public List<MtlglItemNms> getMtlglItemNms() {
                    return this.mtlglItemNms;
                }

                public void setMtlglItemNms(List<MtlglItemNms> mtlglItemNms) {
                    this.mtlglItemNms = mtlglItemNms;
                }

                public String getStdCtgId() {
                    return this.stdCtgId;
                }

                public void setStdCtgId(String stdCtgId) {
                    this.stdCtgId = stdCtgId;
                }

                public String getBrandId() {
                    return this.brandId;
                }

                public void setBrandId(String brandId) {
                    this.brandId = brandId;
                }

                public String getMdlNm() {
                    return this.mdlNm;
                }

                public void setMdlNm(String mdlNm) {
                    this.mdlNm = mdlNm;
                }

                public String getItemChrctDivCd() {
                    return this.itemChrctDivCd;
                }

                public void setItemChrctDivCd(String itemChrctDivCd) {
                    this.itemChrctDivCd = itemChrctDivCd;
                }

                public String getItemChrctDtlCd() {
                    return this.itemChrctDtlCd;
                }

                public void setItemChrctDtlCd(String itemChrctDtlCd) {
                    this.itemChrctDtlCd = itemChrctDtlCd;
                }

                public String getExusItemDivCd() {
                    return this.exusItemDivCd;
                }

                public void setExusItemDivCd(String exusItemDivCd) {
                    this.exusItemDivCd = exusItemDivCd;
                }

                public String getExusItemDtlCd() {
                    return this.exusItemDtlCd;
                }

                public void setExusItemDtlCd(String exusItemDtlCd) {
                    this.exusItemDtlCd = exusItemDtlCd;
                }

                public String getAdultItemTypeCd() {
                    return this.adultItemTypeCd;
                }

                public void setAdultItemTypeCd(String adultItemTypeCd) {
                    this.adultItemTypeCd = adultItemTypeCd;
                }

                public String getItemStatTypeCd() {
                    return this.itemStatTypeCd;
                }

                public void setItemStatTypeCd(String itemStatTypeCd) {
                    this.itemStatTypeCd = itemStatTypeCd;
                }

                public String getItemSellWayCd() {
                    return this.itemSellWayCd;
                }

                public void setItemSellWayCd(String itemSellWayCd) {
                    this.itemSellWayCd = itemSellWayCd;
                }

                public String getPalimpItemYn() {
                    return this.palimpItemYn;
                }

                public void setPalimpItemYn(String palimpItemYn) {
                    this.palimpItemYn = palimpItemYn;
                }

                public String getGiftPsblYn() {
                    return this.giftPsblYn;
                }

                public void setGiftPsblYn(String giftPsblYn) {
                    this.giftPsblYn = giftPsblYn;
                }

                public String getWhinNotiYn() {
                    return this.whinNotiYn;
                }

                public void setWhinNotiYn(String whinNotiYn) {
                    this.whinNotiYn = whinNotiYn;
                }

                public String getAsMemoCntt() {
                    return this.asMemoCntt;
                }

                public void setAsMemoCntt(String asMemoCntt) {
                    this.asMemoCntt = asMemoCntt;
                }

                public String getAsTelno() {
                    return this.asTelno;
                }

                public void setAsTelno(String asTelno) {
                    this.asTelno = asTelno;
                }

                public String getItemSrchwdNm() {
                    return this.itemSrchwdNm;
                }

                public void setItemSrchwdNm(String itemSrchwdNm) {
                    this.itemSrchwdNm = itemSrchwdNm;
                }

                public String getMinOnetOrdPsblQty() {
                    return this.minOnetOrdPsblQty;
                }

                public void setMinOnetOrdPsblQty(String minOnetOrdPsblQty) {
                    this.minOnetOrdPsblQty = minOnetOrdPsblQty;
                }

                public String getMaxOnetOrdPsblQty() {
                    return this.maxOnetOrdPsblQty;
                }

                public void setMaxOnetOrdPsblQty(String maxOnetOrdPsblQty) {
                    this.maxOnetOrdPsblQty = maxOnetOrdPsblQty;
                }

                public String getMax1dyOrdPsblQty() {
                    return this.max1dyOrdPsblQty;
                }

                public void setMax1dyOrdPsblQty(String max1dyOrdPsblQty) {
                    this.max1dyOrdPsblQty = max1dyOrdPsblQty;
                }

                private static class MtlglItemNms {
                    private MtlglItemNm mtlglItemNm;

                    private MtlglItemNms() {
                    }

                    public MtlglItemNm getMtlglItemNm() {
                        return this.mtlglItemNm;
                    }

                    public void setMtlglItemNm(MtlglItemNm mtlglItemNm) {
                        this.mtlglItemNm = mtlglItemNm;
                    }

                    private static class MtlglItemNm {
                        private String langDivCd;
                        private String mtlglItemNm;

                        private MtlglItemNm() {
                        }

                        public String getLangDivCd() {
                            return this.langDivCd;
                        }

                        public void setLangDivCd(String langDivCd) {
                            this.langDivCd = langDivCd;
                        }

                        public String getMtlglItemNm() {
                            return this.mtlglItemNm;
                        }

                        public void setMtlglItemNm(String mtlglItemNm) {
                            this.mtlglItemNm = mtlglItemNm;
                        }
                    }
                }
            }
        }
    }

    public static class ResponseOption {
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        private static class Result {
            private String resultCode;
            private String resultMessage;
            private String resultDesc;
            private Option option;

            private Result() {
            }

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public Option getOption() {
                return this.option;
            }

            public void setOption(Option option2) {
                this.option = option2;
            }

            public static class Option {
                private String txnDivCd;
                private String itemSellTypeCd;
                private String uitemOptnTypeCd1;
                private String uitemOptnTypeNm1;
                private String uitemOptnTypeCd2;
                private String uitemOptnTypeNm2;
                private String uitemOptnTypeCd3;
                private String uitemOptnTypeNm3;
                private String uitemOptnTypeCd4;
                private String uitemOptnTypeNm4;
                private String uitemOptnAddtIptCd;
                private String splVenItemId;
                private String sellprc;
                @JsonDeserialize(using=SSGInpOptionNmsDeserializer.class)
                List<OptionNms> optionNms;
                private String uitemCacWayCd;
                List<UitemEaitemOptn> uitemEaitemOptn;
                List<AddOrdOptns> addOrdOptns;

                public String getItemSellTypeCd() {
                    return this.itemSellTypeCd;
                }

                public void setItemSellTypeCd(String itemSellTypeCd) {
                    this.itemSellTypeCd = itemSellTypeCd;
                }

                public String getTxnDivCd() {
                    return this.txnDivCd;
                }

                public void setTxnDivCd(String txnDivCd) {
                    this.txnDivCd = txnDivCd;
                }

                public String getUitemOptnTypeCd1() {
                    return this.uitemOptnTypeCd1;
                }

                public void setUitemOptnTypeCd1(String uitemOptnTypeCd1) {
                    this.uitemOptnTypeCd1 = uitemOptnTypeCd1;
                }

                public String getUitemOptnTypeNm1() {
                    return this.uitemOptnTypeNm1;
                }

                public void setUitemOptnTypeNm1(String uitemOptnTypeNm1) {
                    this.uitemOptnTypeNm1 = uitemOptnTypeNm1;
                }

                public String getUitemOptnTypeCd2() {
                    return this.uitemOptnTypeCd2;
                }

                public void setUitemOptnTypeCd2(String uitemOptnTypeCd2) {
                    this.uitemOptnTypeCd2 = uitemOptnTypeCd2;
                }

                public String getUitemOptnTypeNm2() {
                    return this.uitemOptnTypeNm2;
                }

                public void setUitemOptnTypeNm2(String uitemOptnTypeNm2) {
                    this.uitemOptnTypeNm2 = uitemOptnTypeNm2;
                }

                public String getUitemOptnTypeCd3() {
                    return this.uitemOptnTypeCd3;
                }

                public void setUitemOptnTypeCd3(String uitemOptnTypeCd3) {
                    this.uitemOptnTypeCd3 = uitemOptnTypeCd3;
                }

                public String getUitemOptnTypeNm3() {
                    return this.uitemOptnTypeNm3;
                }

                public void setUitemOptnTypeNm3(String uitemOptnTypeNm3) {
                    this.uitemOptnTypeNm3 = uitemOptnTypeNm3;
                }

                public String getUitemOptnTypeCd4() {
                    return this.uitemOptnTypeCd4;
                }

                public void setUitemOptnTypeCd4(String uitemOptnTypeCd4) {
                    this.uitemOptnTypeCd4 = uitemOptnTypeCd4;
                }

                public String getUitemOptnTypeNm4() {
                    return this.uitemOptnTypeNm4;
                }

                public void setUitemOptnTypeNm4(String uitemOptnTypeNm4) {
                    this.uitemOptnTypeNm4 = uitemOptnTypeNm4;
                }

                public String getUitemOptnAddtIptCd() {
                    return this.uitemOptnAddtIptCd;
                }

                public void setUitemOptnAddtIptCd(String uitemOptnAddtIptCd) {
                    this.uitemOptnAddtIptCd = uitemOptnAddtIptCd;
                }

                public String getSplVenItemId() {
                    return this.splVenItemId;
                }

                public void setSplVenItemId(String splVenItemId) {
                    this.splVenItemId = splVenItemId;
                }

                public String getSellprc() {
                    return this.sellprc;
                }

                public void setSellprc(String sellprc) {
                    this.sellprc = sellprc;
                }

                public List<OptionNms> getOptionNms() {
                    return this.optionNms;
                }

                public void setOptionNms(List<OptionNms> optionNms) {
                    this.optionNms = optionNms;
                }

                public String getUitemCacWayCd() {
                    return this.uitemCacWayCd;
                }

                public void setUitemCacWayCd(String uitemCacWayCd) {
                    this.uitemCacWayCd = uitemCacWayCd;
                }

                public List<UitemEaitemOptn> getUitemEaitemOptn() {
                    return this.uitemEaitemOptn;
                }

                public void setUitemEaitemOptn(List<UitemEaitemOptn> uitemEaitemOptn) {
                    this.uitemEaitemOptn = uitemEaitemOptn;
                }

                public List<AddOrdOptns> getAddOrdOptns() {
                    return this.addOrdOptns;
                }

                public void setAddOrdOptns(List<AddOrdOptns> addOrdOptns) {
                    this.addOrdOptns = addOrdOptns;
                }

                public static class AddOrdOptns {
                    List<AddOrdOptn> addOrdOptn;

                    public static class AddOrdOptn {
                        private String addOrdOptnSeq;
                        private String addOrdOptnNm;
                        private String addOrdOptnMndtyYn;
                        private String useYn;

                        public String getAddOrdOptnSeq() {
                            return this.addOrdOptnSeq;
                        }

                        public void setAddOrdOptnSeq(String addOrdOptnSeq) {
                            this.addOrdOptnSeq = addOrdOptnSeq;
                        }

                        public String getAddOrdOptnNm() {
                            return this.addOrdOptnNm;
                        }

                        public void setAddOrdOptnNm(String addOrdOptnNm) {
                            this.addOrdOptnNm = addOrdOptnNm;
                        }

                        public String getAddOrdOptnMndtyYn() {
                            return this.addOrdOptnMndtyYn;
                        }

                        public void setAddOrdOptnMndtyYn(String addOrdOptnMndtyYn) {
                            this.addOrdOptnMndtyYn = addOrdOptnMndtyYn;
                        }

                        public String getUseYn() {
                            return this.useYn;
                        }

                        public void setUseYn(String useYn) {
                            this.useYn = useYn;
                        }
                    }
                }

                public static class OptionNms {
                    List<OptionNm> optionNm;

                    public List<OptionNm> getOptionNm() {
                        return this.optionNm;
                    }

                    public void setOptionNm(List<OptionNm> optionNm) {
                        this.optionNm = optionNm;
                    }

                    public static class OptionNm {
                        private String uitemId;
                        private String uitemOptnNm1;
                        private String uitemOptnNm2;
                        private String uitemOptnNm3;
                        private String uitemOptnNm4;
                        private String uitemOptnAddt;
                        private String splVenItemId;
                        private String useYn;
                        private String sellprc;

                        public String getUitemId() {
                            return this.uitemId;
                        }

                        public void setUitemId(String uitemId) {
                            this.uitemId = uitemId;
                        }

                        public String getUitemOptnNm1() {
                            return this.uitemOptnNm1;
                        }

                        public void setUitemOptnNm1(String uitemOptnNm1) {
                            this.uitemOptnNm1 = uitemOptnNm1;
                        }

                        public String getUitemOptnNm2() {
                            return this.uitemOptnNm2;
                        }

                        public void setUitemOptnNm2(String uitemOptnNm2) {
                            this.uitemOptnNm2 = uitemOptnNm2;
                        }

                        public String getUitemOptnNm3() {
                            return this.uitemOptnNm3;
                        }

                        public void setUitemOptnNm3(String uitemOptnNm3) {
                            this.uitemOptnNm3 = uitemOptnNm3;
                        }

                        public String getUitemOptnNm4() {
                            return this.uitemOptnNm4;
                        }

                        public void setUitemOptnNm4(String uitemOptnNm4) {
                            this.uitemOptnNm4 = uitemOptnNm4;
                        }

                        public String getUitemOptnAddt() {
                            return this.uitemOptnAddt;
                        }

                        public void setUitemOptnAddt(String uitemOptnAddt) {
                            this.uitemOptnAddt = uitemOptnAddt;
                        }

                        public String getSplVenItemId() {
                            return this.splVenItemId;
                        }

                        public void setSplVenItemId(String splVenItemId) {
                            this.splVenItemId = splVenItemId;
                        }

                        public String getUseYn() {
                            return this.useYn;
                        }

                        public void setUseYn(String useYn) {
                            this.useYn = useYn;
                        }

                        public String getSellprc() {
                            return this.sellprc;
                        }

                        public void setSellprc(String sellprc) {
                            this.sellprc = sellprc;
                        }
                    }
                }

                public static class UitemEaitemOptn {
                    private String eaitemOptnCacNm1;
                    private String eaitemMinCacUnitVal1;
                    private String eaitemMaxCacUnitVal1;
                    private String cmakeMesurUnitCd1;
                    private String eaitemOptnCacNm2;
                    private String eaitemMinCacUnitVal2;
                    private String eaitemMaxCacUnitVal2;
                    private String cmakeMesurUnitCd2;
                    private String purchUnitQty;
                    private String punitSellprc;

                    public String getEaitemOptnCacNm1() {
                        return this.eaitemOptnCacNm1;
                    }

                    public void setEaitemOptnCacNm1(String eaitemOptnCacNm1) {
                        this.eaitemOptnCacNm1 = eaitemOptnCacNm1;
                    }

                    public String getEaitemMinCacUnitVal1() {
                        return this.eaitemMinCacUnitVal1;
                    }

                    public void setEaitemMinCacUnitVal1(String eaitemMinCacUnitVal1) {
                        this.eaitemMinCacUnitVal1 = eaitemMinCacUnitVal1;
                    }

                    public String getEaitemMaxCacUnitVal1() {
                        return this.eaitemMaxCacUnitVal1;
                    }

                    public void setEaitemMaxCacUnitVal1(String eaitemMaxCacUnitVal1) {
                        this.eaitemMaxCacUnitVal1 = eaitemMaxCacUnitVal1;
                    }

                    public String getCmakeMesurUnitCd1() {
                        return this.cmakeMesurUnitCd1;
                    }

                    public void setCmakeMesurUnitCd1(String cmakeMesurUnitCd1) {
                        this.cmakeMesurUnitCd1 = cmakeMesurUnitCd1;
                    }

                    public String getEaitemOptnCacNm2() {
                        return this.eaitemOptnCacNm2;
                    }

                    public void setEaitemOptnCacNm2(String eaitemOptnCacNm2) {
                        this.eaitemOptnCacNm2 = eaitemOptnCacNm2;
                    }

                    public String getEaitemMinCacUnitVal2() {
                        return this.eaitemMinCacUnitVal2;
                    }

                    public void setEaitemMinCacUnitVal2(String eaitemMinCacUnitVal2) {
                        this.eaitemMinCacUnitVal2 = eaitemMinCacUnitVal2;
                    }

                    public String getEaitemMaxCacUnitVal2() {
                        return this.eaitemMaxCacUnitVal2;
                    }

                    public void setEaitemMaxCacUnitVal2(String eaitemMaxCacUnitVal2) {
                        this.eaitemMaxCacUnitVal2 = eaitemMaxCacUnitVal2;
                    }

                    public String getCmakeMesurUnitCd2() {
                        return this.cmakeMesurUnitCd2;
                    }

                    public void setCmakeMesurUnitCd2(String cmakeMesurUnitCd2) {
                        this.cmakeMesurUnitCd2 = cmakeMesurUnitCd2;
                    }

                    public String getPurchUnitQty() {
                        return this.purchUnitQty;
                    }

                    public void setPurchUnitQty(String purchUnitQty) {
                        this.purchUnitQty = purchUnitQty;
                    }

                    public String getPunitSellprc() {
                        return this.punitSellprc;
                    }

                    public void setPunitSellprc(String punitSellprc) {
                        this.punitSellprc = punitSellprc;
                    }
                }
            }
        }
    }

    public static class ResponseProductPromotion {
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public static class Result {
            private String resultCode;
            private String resultMessage;
            private String resultDesc;
            private String promId;
            private String offerId;
            private String tgtIds;

            public String getTgtIds() {
                return this.tgtIds;
            }

            public void setTgtIds(String tgtIds) {
                this.tgtIds = tgtIds;
            }

            public String getResultCode() {
                return this.resultCode;
            }

            public void setResultCode(String resultCode) {
                this.resultCode = resultCode;
            }

            public String getResultMessage() {
                return this.resultMessage;
            }

            public void setResultMessage(String resultMessage) {
                this.resultMessage = resultMessage;
            }

            public String getResultDesc() {
                return this.resultDesc;
            }

            public void setResultDesc(String resultDesc) {
                this.resultDesc = resultDesc;
            }

            public String getPromId() {
                return this.promId;
            }

            public void setPromId(String promId) {
                this.promId = promId;
            }

            public String getOfferId() {
                return this.offerId;
            }

            public void setOfferId(String offerId) {
                this.offerId = offerId;
            }
        }
    }

    public static class SSGInpAppeCertDeserializer
    extends JsonDeserializer<List<ProductAppePropTgtList.Result.ItemAppeProps>> {
        public List<ProductAppePropTgtList.Result.ItemAppeProps> deserialize(com.fasterxml.jackson.core.JsonParser p, DeserializationContext arg1) throws IOException, JsonProcessingException {
            if (p.getCurrentToken() == null) {
                return new ArrayList<ProductAppePropTgtList.Result.ItemAppeProps>();
            }
            if (p.getCurrentToken() == JsonToken.START_ARRAY) {
                if (!p.readValueAsTree().isObject()) {
                    return new ArrayList<ProductAppePropTgtList.Result.ItemAppeProps>();
                }
                return (List)p.readValueAs((TypeReference)new TypeReference<List<ProductAppePropTgtList.Result.ItemAppeProps>>(){});
            }
            HashMap datas = (HashMap)p.readValueAs(HashMap.class);
            ArrayList<ProductAppePropTgtList.Result.ItemAppeProps> items = new ArrayList<ProductAppePropTgtList.Result.ItemAppeProps>();
            Gson gson = new Gson();
            if (datas != null) {
                ProductAppePropTgtList.Result.ItemAppeProps orplc = (ProductAppePropTgtList.Result.ItemAppeProps)gson.fromJson(datas.toString(), ProductAppePropTgtList.Result.ItemAppeProps.class);
                items.add(orplc);
            }
            return items;
        }
    }

    public static class SSGInpOptionDeserializer
    extends JsonDeserializer<List<ResponseOption.Result.Option.OptionNms.OptionNm>> {
        public List<ResponseOption.Result.Option.OptionNms.OptionNm> deserialize(com.fasterxml.jackson.core.JsonParser p, DeserializationContext arg1) throws IOException, JsonProcessingException {
            if (p.getCurrentToken() == JsonToken.START_ARRAY) {
                return (List)p.readValueAs((TypeReference)new TypeReference<List<ResponseOption.Result.Option.OptionNms.OptionNm>>(){});
            }
            HashMap datas = (HashMap)p.readValueAs(HashMap.class);
            ArrayList<ResponseOption.Result.Option.OptionNms.OptionNm> items = new ArrayList<ResponseOption.Result.Option.OptionNms.OptionNm>();
            Gson gson = new Gson();
            if (datas != null) {
                ResponseOption.Result.Option.OptionNms.OptionNm orplc = (ResponseOption.Result.Option.OptionNms.OptionNm)gson.fromJson(datas.toString(), ResponseOption.Result.Option.OptionNms.OptionNm.class);
                items.add(orplc);
            }
            return items;
        }
    }

    public static class SSGInpOptionNmsDeserializer
    extends JsonDeserializer<List<ResponseOption.Result.Option.OptionNms>> {
        public List<ResponseOption.Result.Option.OptionNms> deserialize(com.fasterxml.jackson.core.JsonParser p, DeserializationContext arg1) throws IOException, JsonProcessingException {
            ArrayList<ResponseOption.Result.Option.OptionNms> items = new ArrayList<ResponseOption.Result.Option.OptionNms>();
            if (p.getCurrentToken() == JsonToken.START_ARRAY) {
                if (p.nextToken() == JsonToken.VALUE_STRING) {
                    return new ArrayList<ResponseOption.Result.Option.OptionNms>();
                }
                HashMap datas = (HashMap)p.readValueAs(HashMap.class);
                Gson gson = new Gson();
                String json = gson.toJson((Object)datas);
                ResponseOption.Result.Option.OptionNms aa = new ResponseOption.Result.Option.OptionNms();
                ArrayList<ResponseOption.Result.Option.OptionNms.OptionNm> items1 = new ArrayList<ResponseOption.Result.Option.OptionNms.OptionNm>();
                ObjectMapper mapper = new ObjectMapper();
                JsonParser parser = new JsonParser();
                JsonObject jsonObject = (JsonObject)parser.parse(json);
                try {
                    JsonArray jsonArray = (JsonArray)jsonObject.get("optionNm");
                    int i = 0;
                    while (i < jsonArray.size()) {
                        try {
                            ResponseOption.Result.Option.OptionNms.OptionNm item = (ResponseOption.Result.Option.OptionNms.OptionNm)mapper.readValue(jsonArray.get(i).toString(), ResponseOption.Result.Option.OptionNms.OptionNm.class);
                            items1.add(item);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    JsonObject jsonObject1 = (JsonObject)jsonObject.get("optionNm");
                    try {
                        ResponseOption.Result.Option.OptionNms.OptionNm item = (ResponseOption.Result.Option.OptionNms.OptionNm)mapper.readValue(jsonObject1.toString(), ResponseOption.Result.Option.OptionNms.OptionNm.class);
                        items1.add(item);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                aa.setOptionNm(items1);
                items.add(aa);
            }
            return items;
        }
    }
}

