/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingOrderConfirmCommand
extends IShopOrderTossShoppingCommand {
    private static IShopOrderCommand instance = new TossShoppingOrderConfirmCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderConfirmCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        String id = param.get(0).getShop_userid();
        String pw = param.get(0).getShopPw();
        String merchantId = param.get(0).getApikey();
        cookies = is.getTossCookiesExistMerchantID(id, pw, merchantId);
        for (ShopOrderMstDto dto : param) {
            String requestBody = this.getOrderConfirmStringParam(merchantId, dto.getMall_order_id());
            JsonParser jsonParser = new JsonParser();
            Connection.Response response = Jsoup.connect((String)"https://api-public.toss.im/api-public/v3/shopping-order/order/status-update").method(Connection.Method.PUT).header("Content-Type", "application/json").cookies(cookies).requestBody(requestBody).ignoreContentType(true).execute();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(response.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (resultType.toUpperCase().equals("SUCCESS")) {
                dto.setOrder_status("100");
                dto.setResult_code("1");
                dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                dto.setResult_code("-1");
            }
            retList.add(dto);
        }
        return retList;
    }

    public String getOrderConfirmStringParam(String merchantId, String productId) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        JsonArray orderProductIds = new JsonArray();
        orderProductIds.add(productId);
        json.add("orderProductIds", (JsonElement)orderProductIds);
        json.addProperty("status", "\uc0c1\ud488\uc900\ube44\uc911");
        return json.toString();
    }
}

