/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.common.OrderStatus;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.liteOrder.DisplayColumnSettingDto;
import com.kdjsystem.mlink.shop.liteOrder.LiteOrderManagerDao;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.MainView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LiteOrderManagerHelper {
    private static Map<String, List<ShopDeliveryDto>> deliveryMap = new HashMap<String, List<ShopDeliveryDto>>();

    public static void setDefaultGridColumns(YDMAGridColumnList col_list, String classNm) {
        try {
            LiteOrderManagerDao.get().initializeMasterDataIfEmpty(classNm);
            if (LiteOrderManagerDao.get().isUserSetting(classNm)) {
                List<DisplayColumnSettingDto> columnList = LiteOrderManagerDao.get().getUserSetting(classNm, "Y");
                for (DisplayColumnSettingDto column : columnList) {
                    col_list.add(column.getUser_seq() - 1, column.getMap_field(), column.getItem_nm(), column.getUser_width());
                }
            } else {
                List<DisplayColumnSettingDto> columnList = LiteOrderManagerDao.get().getDefaultSetting(classNm, "Y");
                for (DisplayColumnSettingDto column : columnList) {
                    col_list.add(column.getDefault_seq() - 1, column.getMap_field(), column.getItem_nm(), column.getDefault_width());
                }
            }
        }
        catch (Exception exception) {}
    }

    public static void setCombo(final List<ShoppingMallDetailDto> activeShops, final Combo cb_shop, final Combo cb_shoppingID) {
        List shopcdList = activeShops.stream().map(ShoppingMallDetailDto::getShopcd).distinct().collect(Collectors.toList());
        if (shopcdList.size() > 0) {
            for (String shopcd : shopcdList) {
                cb_shop.add(ShopCommon.getShoppingMallName(shopcd));
            }
            cb_shop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = cb_shop.getSelectionIndex();
                    if (index > 0) {
                        List shoppingIdList = activeShops.stream().filter(dto -> ShopCommon.getShopCd(cb_shop.getItem(index)).equals(dto.getShopcd())).map(dto -> dto.getShoppingid() + " - " + dto.getNicknm1()).collect(Collectors.toList());
                        cb_shoppingID.removeAll();
                        cb_shoppingID.add("\uc1fc\ud551\ubab0 ID \uc804\uccb4");
                        for (String shoppingID : shoppingIdList) {
                            cb_shoppingID.add(shoppingID);
                        }
                        cb_shoppingID.select(0);
                    } else {
                        cb_shoppingID.removeAll();
                        cb_shoppingID.add("\uc1fc\ud551\ubab0 ID \uc804\uccb4");
                        cb_shoppingID.select(0);
                    }
                }
            });
        }
    }

    public static String[] setDefaultDate(DateTime dateTime_to, DateTime dateTime_from) {
        String[] days = null;
        try {
            ShopPreferencesDto dto = ShopCommonDao.get().getSystemConf();
            days = YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
            int yearCurrnet = Integer.valueOf(days[0].substring(0, 4));
            int monCurrnet = Integer.valueOf(days[0].substring(4, 6));
            int dayCurrnet = Integer.valueOf(days[0].substring(6, 8));
            dateTime_to.setYear(yearCurrnet);
            dateTime_to.setMonth(monCurrnet - 1);
            dateTime_to.setDay(dayCurrnet);
            Calendar calender_dateTime_from = Calendar.getInstance();
            if (dto.getCompno() != null) {
                calender_dateTime_from.add(5, -(Integer.parseInt(dto.getOrdperiod()) - 1));
            }
            Date date_from = calender_dateTime_from.getTime();
            String str_date_from = new SimpleDateFormat("yyyyMMdd").format(date_from);
            dateTime_from.setYear(Integer.parseInt(str_date_from.substring(0, 4)));
            dateTime_from.setMonth(Integer.parseInt(str_date_from.substring(4, 6)) - 1);
            dateTime_from.setDay(Integer.parseInt(str_date_from.substring(6, 8)));
        }
        catch (Exception exception) {}
        return days;
    }

    public static String[] setDefaultDate(String data2, DateTime dateTime_to, DateTime dateTime_from) {
        String[] days = YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
        int yearCurrnet = Integer.valueOf(days[0].substring(0, 4));
        int monCurrnet = Integer.valueOf(days[0].substring(4, 6));
        int dayCurrnet = Integer.valueOf(days[0].substring(6, 8));
        dateTime_to.setYear(yearCurrnet);
        dateTime_to.setMonth(monCurrnet - 1);
        dateTime_to.setDay(dayCurrnet);
        switch (data2) {
            case "\uc624\ub298": {
                SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
                Date currentTime = new Date();
                String mTime = mSimpleDateFormat.format(currentTime);
                dateTime_from.setYear(Integer.parseInt(mTime.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(mTime.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(mTime.substring(6, 8)));
                break;
            }
            case "\uc5b4\uc81c": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                dateTime_to.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_to.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_to.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "week1": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -7);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month1": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -1);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month3": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -3);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month6": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -6);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
            }
        }
        return days;
    }

    public static void copyClickedCellToClipboard(Shell shell, GridTableViewer gridTableViewer, YDMAGridColumnList col_list) {
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        GridItem[] gridItem = gridTableViewer.getGrid().getSelection();
        List col_idxs = Arrays.asList(gridTableViewer.getGrid().getCellSelection()).stream().map(p -> p.x).distinct().collect(Collectors.toList());
        List list = Arrays.stream(gridItem).map(d -> (ShopOrderMstNewDto)d.getData()).collect(Collectors.toList());
        StringBuilder sbText = new StringBuilder();
        for (ShopOrderMstNewDto dto : list) {
            ArrayList<String> col_values = new ArrayList<String>();
            for (Integer idx : col_idxs) {
                String value = col_list.getFieldValue(dto, col_list.getFieldName(idx));
                col_values.add(value);
            }
            sbText.append(String.join((CharSequence)"\t", col_values));
            sbText.append("\r\n");
        }
        String plainText = sbText.toString();
        String rtfText = String.format("{\\rtf1\\b %s}", sbText.toString());
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFTransfer rftTransfer = RTFTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{plainText, rtfText}, new Transfer[]{textTransfer, rftTransfer});
        clipboard.dispose();
    }

    public static void setMenuTree(Tree tree, List<ShoppingMallDetailDto> activeShops) {
        ArrayList<CodeItem> urlItem = new ArrayList<CodeItem>();
        TreeItem item = new TreeItem(tree, 0);
        item.setText(new String[]{"\uc804\uccb4", "A", "", "", "", "", "", ""});
        try {
            Map<String, Map<String, List<ShoppingMallDetailDto>>> mapList = activeShops.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
            List items = ShopCommon.getCommonCodeList("PRODUCT_SHOP").stream().map(p -> p.getCode()).collect(Collectors.toList());
            Collections.sort(items);
            for (String shopid : items) {
                LinkedHashMap map = new LinkedHashMap();
                if (mapList.get(shopid) == null) continue;
                mapList.get(shopid).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                    List list = map.put((String)x.getKey(), (List)x.getValue());
                });
                TreeItem subItem = new TreeItem(item, 0);
                for (String shopUserID : map.keySet()) {
                    List listdto = (List)map.get(shopUserID);
                    subItem.setText(new String[]{((ShoppingMallDetailDto)listdto.get(0)).getShopnm(), "C", ((ShoppingMallDetailDto)listdto.get(0)).getShopcd(), "", "", "", "", ""});
                    for (ShoppingMallDetailDto dto : listdto) {
                        TreeItem subsubItem = new TreeItem(subItem, 0);
                        String shoppingid = dto.getNicknm1() == null || dto.getNicknm1().trim().length() == 0 ? dto.getShoppingid() : dto.getNicknm1().concat("-").concat(dto.getShoppingid());
                        subsubItem.setText(new String[]{shoppingid, "U", dto.getShopcd(), dto.getShopnm(), dto.getShopseq(), dto.getShoppingid()});
                        String code = String.format("%s,%s,%s,%s,%s", dto.getShopUrl(), dto.getShoppingid(), dto.getPassword(), dto.getShopcd(), dto.getAuthkey1());
                        urlItem.add(new CodeItem(code, ((ShoppingMallDetailDto)listdto.get(0)).getShopnm() + "(" + dto.getShoppingid() + ")"));
                    }
                }
            }
            TreeItem[] treeItemArray = tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem i = treeItemArray[n2];
                TreeItem[] treeItemArray2 = i.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem s = treeItemArray2[n4];
                    TreeItem[] treeItemArray3 = s.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem g = treeItemArray3[n6];
                        i.setExpanded(true);
                        s.setExpanded(false);
                        g.setExpanded(false);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public static List<ShopOrderMstDto> convertShoppingMallToShopOrderList(List<ShoppingMallDetailDto> list, String dateFrom, String dateTo, String status2) {
        List<ShopOrderMstDto> params = list.stream().map(dto -> {
            ShopOrderMstDto order = new ShopOrderMstDto();
            order.setShopid(dto.getShopcd());
            order.setShop_userid(dto.getShoppingid());
            order.setShopnm(dto.getShopnm());
            order.setShopPw(dto.getPassword());
            order.setApikey(dto.getApikey());
            order.setAuthkey1(dto.getAuthkey1());
            order.setAuthKey2(dto.getAuthkey2());
            order.setVendorId(dto.getVendorId());
            order.setShopseq(dto.getShopseq());
            order.setSuppstditem(dto.getSuppstditem());
            order.setSuppstdrati(dto.getSuppstdrati());
            order.setNickname(dto.getNicknm1());
            order.setStartDt(dateFrom);
            order.setEndDt(dateTo);
            order.setEDITAUTHKEY1(dto.getEditauthkey1());
            order.setEDITAPIKEY(dto.getEditapikey());
            order.setSpecificStatus(status2);
            return order;
        }).collect(Collectors.toList());
        return params;
    }

    public static List<ShopOrderMstNewDto> convertShoppingMallToShopOrderList_v2(List<ShoppingMallDetailDto> list, String dateFrom, String dateTo, String status2) {
        List<ShopOrderMstNewDto> params = list.stream().map(dto -> {
            ShopOrderMstNewDto order = new ShopOrderMstNewDto();
            order.setShopid(dto.getShopcd());
            order.setShop_userid(dto.getShoppingid());
            order.setShopnm(dto.getShopnm());
            order.setShopPw(dto.getPassword());
            order.setApikey(dto.getApikey());
            order.setAuthkey1(dto.getAuthkey1());
            order.setAuthKey2(dto.getAuthkey2());
            order.setVendorId(dto.getVendorId());
            order.setShopseq(dto.getShopseq());
            order.setSuppstditem(dto.getSuppstditem());
            order.setSuppstdrati(dto.getSuppstdrati());
            order.setNickname(dto.getNicknm1());
            order.setStartDt(dateFrom);
            order.setEndDt(dateTo);
            order.setEDITAUTHKEY1(dto.getEditauthkey1());
            order.setEDITAPIKEY(dto.getEditapikey());
            order.setSpecificStatus(status2);
            return order;
        }).collect(Collectors.toList());
        return params;
    }

    public static void populateShopOrderMstDtoList(List<ShopOrderMstDto> resultList, ShopOrderMstDto dto) {
        resultList.forEach(result -> {
            result.setShopPw(dto.getShopPw());
            result.setApikey(dto.getApikey());
            result.setAuthkey1(dto.getAuthkey1());
            result.setAuthKey2(dto.getAuthKey2());
            result.setVendorId(dto.getVendorId());
            result.setShopseq(dto.getShopseq());
            result.setSuppstditem(dto.getSuppstditem());
            result.setSuppstdrati(dto.getSuppstdrati());
            result.setNickname(dto.getNickname());
            result.setEDITAUTHKEY1(dto.getEDITAUTHKEY1());
            result.setEDITAPIKEY(dto.getEDITAPIKEY());
        });
    }

    public static void populateShopOrderMstDtoList_v2(List<ShopOrderMstNewDto> resultList, ShopOrderMstNewDto dto) {
        resultList.forEach(result -> {
            result.setShopPw(dto.getShopPw());
            result.setApikey(dto.getApikey());
            result.setAuthkey1(dto.getAuthkey1());
            result.setAuthKey2(dto.getAuthKey2());
            result.setVendorId(dto.getVendorId());
            result.setShopseq(dto.getShopseq());
            result.setSuppstditem(dto.getSuppstditem());
            result.setSuppstdrati(dto.getSuppstdrati());
            result.setNickname(dto.getNickname());
            result.setEDITAUTHKEY1(dto.getEDITAUTHKEY1());
            result.setEDITAPIKEY(dto.getEDITAPIKEY());
            result.setSale_cost_add_opt_add_cost(String.valueOf(YDMAStringUtil.convertToInt(dto.getSale_cost()) + YDMAStringUtil.convertToInt(dto.getOpt_add_cost())));
        });
    }

    public static List<ShopOrderMstDto> convertShopOrderMstDtoByNewDto(List<ShopOrderMstNewDto> list) {
        List<ShopOrderMstDto> params = list.stream().map(dto -> {
            ShopOrderMstDto order = new ShopOrderMstDto();
            order.setShopid(dto.getShopid());
            order.setShop_userid(dto.getShop_userid());
            order.setShopnm(dto.getShopnm());
            order.setShopPw(dto.getShopPw());
            order.setApikey(dto.getApikey());
            order.setAuthkey1(dto.getAuthkey1());
            order.setAuthKey2(dto.getAuthKey2());
            order.setVendorId(dto.getVendorId());
            order.setShopseq(dto.getShopseq());
            order.setSuppstditem(dto.getSuppstditem());
            order.setSuppstdrati(dto.getSuppstdrati());
            order.setNickname(dto.getNickname());
            order.setStartDt(dto.getStartDt());
            order.setEndDt(dto.getEndDt());
            order.setEDITAUTHKEY1(dto.getEDITAUTHKEY1());
            order.setEDITAPIKEY(dto.getEDITAPIKEY());
            order.setCompayny_goods_cd(dto.getCompayny_goods_cd());
            order.setOrder_id(dto.getOrder_id());
            order.setMall_product_id(dto.getMall_product_id());
            order.setMall_exp_cd(dto.getMall_exp_cd());
            order.setDelivery_id(dto.getDelivery_id());
            order.setInvoice_no(dto.getInvoice_no());
            order.setLabel(dto.getLabel());
            order.setSku_value(dto.getSku_value());
            order.setSku_id(dto.getSku_id());
            order.setCopy_idx(dto.getCopy_idx());
            order.setExchangeid(dto.getExchangeid());
            order.setReceiptid(dto.getReceiptid());
            order.setSale_cnt(dto.getSale_cnt());
            order.setMall_order_id(dto.getMall_order_id());
            order.setReceive_name(dto.getReceive_name());
            order.setUser_name(dto.getUser_name());
            order.setUser_cel(dto.getUser_cel());
            order.setTotal_cost(LiteOrderManagerHelper.cleanComma(dto.getTotal_cost()));
            order.setP_product_name(dto.getP_product_name());
            return order;
        }).collect(Collectors.toList());
        return params;
    }

    private static String cleanComma(String value) {
        if (value == null) {
            return null;
        }
        return value.contains(",") ? value.replace(",", "") : value;
    }

    public static void setLabelBind(List<ShopOrderMstDto> dtolist) {
        String message = "\t\uc774 \ud398\uc774\uc9c0\uc758 \ud569\uacc4 : %s\uac74  \uc815\uc0b0\uc608\uc815\uac00: %s\uc6d0    \ud310\ub9e4\uac00: %s\uc6d0     \ubc30\uc1a1\ube44 : %s\uc6d0";
        Integer mallWon_cost = 0;
        Integer mallsale_cost = 0;
        Integer delvery_cost = 0;
        for (ShopOrderMstDto dto : dtolist) {
            try {
                mallWon_cost = mallWon_cost + YDMAStringUtil.convertToInt(dto.getMall_won_cost());
            }
            catch (Exception exception) {
                mallWon_cost = mallWon_cost + 0;
            }
            try {
                mallsale_cost = mallsale_cost + YDMAStringUtil.convertToInt(dto.getTotal_cost());
            }
            catch (Exception exception) {
                mallsale_cost = mallsale_cost + 0;
            }
            try {
                delvery_cost = delvery_cost + YDMAStringUtil.convertToInt(dto.getDelv_cost());
            }
            catch (Exception exception) {
                delvery_cost = delvery_cost + 0;
            }
        }
        message = String.format(message, dtolist.size(), mallWon_cost, mallsale_cost, delvery_cost);
        MainView.statusBar.getStatusLineManager().setMessage(message);
    }

    public static void setLabelBind_v2(List<ShopOrderMstNewDto> dtolist) {
        String message = "\t\uc774 \ud398\uc774\uc9c0\uc758 \ud569\uacc4 : %s\uac74  \uc815\uc0b0\uc608\uc815\uac00: %s\uc6d0    \ud310\ub9e4\uac00: %s\uc6d0     \ubc30\uc1a1\ube44 : %s\uc6d0";
        Integer mallWon_cost = 0;
        Integer mallsale_cost = 0;
        Integer delvery_cost = 0;
        for (ShopOrderMstNewDto dto : dtolist) {
            try {
                mallWon_cost = mallWon_cost + YDMAStringUtil.convertToInt(dto.getMall_won_cost());
            }
            catch (Exception exception) {
                mallWon_cost = mallWon_cost + 0;
            }
            try {
                mallsale_cost = mallsale_cost + YDMAStringUtil.convertToInt(dto.getTotal_cost());
            }
            catch (Exception exception) {
                mallsale_cost = mallsale_cost + 0;
            }
            try {
                delvery_cost = delvery_cost + YDMAStringUtil.convertToInt(dto.getDelv_cost());
            }
            catch (Exception exception) {
                delvery_cost = delvery_cost + 0;
            }
        }
        message = String.format(message, dtolist.size(), mallWon_cost, mallsale_cost, delvery_cost);
        MainView.statusBar.getStatusLineManager().setMessage(message);
    }

    public static String getValueByFieldValue(ShopOrderMstDto dto, int seq, YDMAGridColumnList col_list) {
        String value = "";
        switch (col_list.getFieldName(seq)) {
            case "order_status": {
                value = OrderStatus.getInstance().findCode(dto.getOrder_status());
                if (!value.equals("")) break;
                value = dto.getOrder_status();
                break;
            }
            case "order_date": {
                if (dto.getOrder_date().equals("")) break;
                value = dto.getOrder_date().substring(0, 10);
                break;
            }
            case "shopid": {
                value = ShopCommon.getShoppingMallName(dto.getShopid());
                break;
            }
            case "delivery_id": {
                try {
                    if (dto.getDeliveryName() != null && !dto.getDeliveryName().equals("")) {
                        value = dto.getDeliveryName();
                        break;
                    }
                    value = LiteOrderManagerHelper.getDeliveryCompanynameBydlvId(dto.getShopid(), dto.getDelivery_id());
                    dto.setDeliveryName(value);
                }
                catch (Exception exception) {
                    value = "";
                }
                break;
            }
            case "delivery_tracking": {
                value = "\ubc30\uc1a1\uc870\ud68c";
                break;
            }
            case "settlement_view": {
                value = "\uc815\uc0b0\ubcf4\uae30";
                break;
            }
            case "user_tel_num": {
                dto.getUser_tel().equals("");
                break;
            }
            default: {
                value = col_list.getFieldValue(dto, col_list.getFieldName(seq));
            }
        }
        if (value != null && value.equals("null")) {
            value = "";
        }
        return value;
    }

    public static String getValueByFieldValue_v2(ShopOrderMstNewDto dto, int seq, YDMAGridColumnList col_list) {
        Object value = "";
        try {
            switch (col_list.getFieldName(seq)) {
                case "order_status": {
                    value = OrderStatus.getInstance().findCode(dto.getOrder_status());
                    if (!((String)value).equals("")) break;
                    value = dto.getOrder_status();
                    break;
                }
                case "order_date": {
                    if (dto.getOrder_date().equals("")) break;
                    value = dto.getOrder_date().substring(0, 10);
                    break;
                }
                case "order_date_num": {
                    if (dto.getOrder_date().equals("")) break;
                    value = dto.getOrder_date().substring(0, 10).replaceAll("-", "");
                    break;
                }
                case "order_date_simply": {
                    if (dto.getOrder_date().equals("")) break;
                    value = dto.getOrder_date().substring(2, 4) + "." + dto.getOrder_date().substring(5, 7) + "." + dto.getOrder_date().substring(8, 10);
                    break;
                }
                case "shopid": {
                    value = ShopCommon.getShoppingMallName(dto.getShopid());
                    break;
                }
                case "delivery_id": {
                    try {
                        if (dto.getDeliveryName() != null && !dto.getDeliveryName().equals("")) {
                            value = dto.getDeliveryName();
                            break;
                        }
                        value = LiteOrderManagerHelper.getDeliveryCompanynameBydlvId(dto.getShopid(), dto.getDelivery_id());
                        dto.setDeliveryName((String)value);
                    }
                    catch (Exception exception) {
                        value = "";
                    }
                    break;
                }
                case "delivery_tracking": {
                    value = "\ubc30\uc1a1\uc870\ud68c";
                    break;
                }
                case "settlement_view": {
                    value = "\uc815\uc0b0\ubcf4\uae30";
                    break;
                }
                case "user_tel_num": {
                    if (dto.getUser_tel() == null) break;
                    dto.getUser_tel().equals("");
                    break;
                }
                case "csmemo": {
                    value = "cs\uba54\ubaa8";
                    break;
                }
                case "p_sku_value2": {
                    value = "";
                    break;
                }
                case "mlink_order_code": 
                case "mall_action_button1": 
                case "mall_action_button2": 
                case "mall_action_button3": 
                case "mall_action_button4": {
                    value = "\uc900\ube44\uc911";
                    break;
                }
                default: {
                    value = col_list.getFieldValue(dto, col_list.getFieldName(seq));
                }
            }
            if (value != null && ((String)value).equals("null")) {
                value = "";
            }
        }
        catch (Exception exception) {
            value = "";
        }
        return value;
    }

    public static boolean headerClickSort(String headerName, boolean flag, List<ShopOrderMstDto> toplist) {
        switch (headerName) {
            case "\uc1fc\ud551\ubab0ID": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getShop_userid, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\uc77c\uc2dc": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getOrder_date, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc1fc\ud551\ubab0": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getShopid, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\ub2c9\ub124\uc784": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getNickname, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\ubc88\ud638": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getOrder_id, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\uc790": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getUser_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc218\ub839\uc790": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getReceive_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc0c1\ud488\ubc88\ud638": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getMall_product_id, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getCompayny_goods_cd, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc0c1\ud488\uba85": {
                Comparator<ShopOrderMstDto> cmp = Comparator.comparing(ShopOrderMstDto::getP_product_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
        }
        return flag;
    }

    public static boolean headerClickSort_v2(String headerName, boolean flag, List<ShopOrderMstNewDto> toplist) {
        switch (headerName) {
            case "\uc1fc\ud551\ubab0ID": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getShop_userid, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\uc77c\uc2dc": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getOrder_date, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc1fc\ud551\ubab0": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getShopid, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\ub2c9\ub124\uc784": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getNickname, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\ubc88\ud638": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getOrder_id, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\ubb38\uc790": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getUser_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc218\ub839\uc790": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getReceive_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc0c1\ud488\ubc88\ud638": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getMall_product_id, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getCompayny_goods_cd, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc0c1\ud488\uba85": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getP_product_name, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc0c1\ud0dc": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getOrder_status, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\ubc1c\uc1a1\ub9c8\uac10\uc77c": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getExpress_deadline, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\ub2e8\uac00": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getPay_cost, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getMall_fee, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
            case "\uc8fc\uc18c": {
                Comparator<ShopOrderMstNewDto> cmp = Comparator.comparing(ShopOrderMstNewDto::getReceive_addr, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                toplist.sort(flag ? cmp : cmp.reversed());
                return !flag;
            }
        }
        return flag;
    }

    public static String getDelvId(String shopId, String delv) {
        try {
            List<ShopDeliveryDto> datasource;
            if (deliveryMap.get(shopId) != null) {
                datasource = deliveryMap.get(shopId);
            } else {
                datasource = ShopCommonDao.get().getExpress(shopId);
                deliveryMap.put(shopId, datasource);
            }
            String cleanedDelv = delv.replaceAll("\\s+", "");
            ShopDeliveryDto delvname = !(!"shop0003".equals(shopId) && !"shop00031".equals(shopId) || !"\ud3b8\uc758\uc810\ud0dd\ubc30".equals(delv) && !"CU\ud3b8\uc758\uc810\ud0dd\ubc30".equals(delv)) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").equals(cleanedDelv)).findAny().orElse(null) : ("shop0075".equals(shopId) && "CJ\ub300\ud55c\ud1b5\uc6b4".equals(delv) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null) : ("shop9984".equals(shopId) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDivNM().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null) : ("\uc77c\uc591\ub85c\uc9c0\uc2a4".equals(delv) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains("\uc77c\uc591\ud0dd\ubc30")).findAny().orElse(null) : (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null))));
            return delvname.getDlvID();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getDeliveryCompanynameBydlvId(String shopid, String delv) {
        try {
            List<ShopDeliveryDto> datasource;
            if (deliveryMap.get(shopid) != null) {
                datasource = deliveryMap.get(shopid);
            } else {
                datasource = ShopCommonDao.get().getExpress(shopid);
                deliveryMap.put(shopid, datasource);
            }
            String deliveryCompanyName = datasource.stream().filter(d -> d.getDlvID().equals(delv)).map(ShopDeliveryDto::getDivNM).findFirst().orElse(null);
            return deliveryCompanyName;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

