/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.zentrade;

import com.kdjsystem.mlink.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.shop.zentrade.ProductItemZentradeDto;
import com.kdjsystem.mlink.shop.zentrade.ZentradeOrderDto;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ZentradeCommon {
    public static ZentradeCommon instance = new ZentradeCommon();

    private ZentradeCommon() {
    }

    public static ZentradeCommon get() {
        return instance;
    }

    public static String getXml(String url) {
        StringBuffer sb;
        block12: {
            InputStream is = null;
            InputStreamReader isr = null;
            sb = new StringBuffer();
            try {
                try {
                    int c;
                    is = new URL(url).openStream();
                    isr = new InputStreamReader(is, "euc-kr");
                    while ((c = isr.read()) != -1) {
                        sb.append((char)c);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        isr.close();
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    isr.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                isr.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public List<ShopOrderMstDto> ZentradeOrderSearch(List<ShopOrderMstDto> orderList, ShoppingMallDetailDto shopDto, YDMAProgressBar console, boolean isAll) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        int page = 0;
        for (ShopOrderMstDto dto : orderList) {
            if (!dto.getCompayny_goods_cd().substring(0, 3).equals("ZEN")) {
                throw new Exception("\uc820\ud2b8\ub808\uc774\ub4dc \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
            }
            String orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
            String url = "https://www.zentrade.co.kr/shop/proc/order_api.php?&id=" + shopDto.getShoppingid() + "&m_skey=" + shopDto.getApikey() + "&ordno=" + orderCode;
            String sb = ZentradeCommon.getXml(url);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ZentradeOrderDto.ResponseOrderSearch.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                StringReader sr = new StringReader(sb.toString());
                ZentradeOrderDto.ResponseOrderSearch result1 = (ZentradeOrderDto.ResponseOrderSearch)jaxbUnmarshaller.unmarshal((Reader)sr);
                String domeShopOrderNum = result1.ord_info.ordno;
                String receiverName = result1.ord_info.nameReceiver.trim();
                String devStat = "";
                devStat = result1.ord_info.deli_info.delicom.equals("") && result1.ord_info.deli_info.delinum.equals("") ? "\ubc30\uc1a1\uc900\ube44\uc911" : "\ubc30\uc1a1\uc911";
                if (!dto.getReceive_name().equals(receiverName) || !orderCode.equals(domeShopOrderNum)) continue;
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                switch (devStat) {
                    case "\ubc30\uc1a1\uc900\ube44\uc911": {
                        dto.setOrder_status("501");
                        dto.setDs_order_status("\uc820\ud2b8\uc900\ube44");
                        break;
                    }
                    case "\ubc30\uc1a1\uc911": {
                        List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                        String delv = result1.ord_info.deli_info.delicom;
                        ShopDeliveryDto delvname = MLinkDomeOrderCollectConnection.get().findDelvName(dto, delv, datasource);
                        dto.setDs_order_status("\ubc1c\uc1a1\uc644\ub8cc");
                        dto.setDelivery_id(delvname.getDlvID());
                        dto.setInvoice_no(result1.ord_info.deli_info.delinum.equals("") ? "" : result1.ord_info.deli_info.delinum);
                        dto.setOrder_status("402");
                    }
                    default: {
                        dto.setDs_order_status(devStat);
                    }
                }
                ++page;
                if (dto.getInvoice_no().equals("")) {
                    MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", false, console);
                } else {
                    MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", true, console);
                }
                dto.setResult_code("1");
                ret.add(dto);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setValue(console, "\ud22c\ube44\uc988\uc628 \ub3d9\uae30\ud654 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]", page);
            }
        }
        if (!isAll) {
            this.setValue(console, "---------------------------------------------------------------------------------------", page);
            this.setValue(console, String.format("[\uacb0\uacfc] \ub3d9\uae30\ud654 %s\uac74 \uc785\ub2c8\ub2e4.", page), page);
        }
        return ret;
    }

    public ProductResultDto getProductMapping(String response) throws Exception {
        ProductResultDto productResult;
        block8: {
            productResult = new ProductResultDto();
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProductItemZentradeDto.class});
                Unmarshaller unMarshaller = context.createUnmarshaller();
                ProductItemZentradeDto param = (ProductItemZentradeDto)unMarshaller.unmarshal((Reader)new StringReader(response));
                ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
                if (param.product == null || param.product.size() <= 0) break block8;
                for (ProductItemZentradeDto.Product dto : param.product) {
                    ProductItemDto item = new ProductItemDto();
                    item.setSearch("shop9995");
                    item.setIcode("ZEN" + dto.code.trim());
                    item.setCid(dto.scategory.esellers_catecode.trim());
                    item.setCateg_nm(dto.dome_category.dome_catename.trim());
                    item.setCate_depth("");
                    item.setIname_del("");
                    item.setPa_auction("");
                    item.setEs_auction("");
                    item.setPa_gmarket("");
                    item.setEs_gmarket("");
                    item.setPa_11st("");
                    item.setEs_11st("");
                    item.setPa_interpark("");
                    item.setEs_interpark("");
                    item.setPa_storefarm("");
                    item.setEs_storefarm("");
                    item.setPa(dto.scategory.emp_catecode.trim());
                    item.setEs(dto.scategory.esellers_catecode.trim());
                    item.setEs_wemarket("");
                    item.setEs_tmon("");
                    item.setEs_coupang("");
                    item.setEsm_gmarket("");
                    item.setEsm_auction("");
                    item.setGosi_code(dto.scategory.classcode.trim());
                    item.setGosi1("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi1("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi2("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi3("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi4("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi5("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi6("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi7("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi8("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi9("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi10("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi11("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi12("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi13("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi14("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi15("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi16("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi17("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi18("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi19("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi20("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi21("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setGosi22("\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870");
                    item.setIname(dto.prdtname.trim());
                    item.setIcountry(dto.baseinfo.madein.trim());
                    item.setMaker(dto.baseinfo.productcom.trim());
                    item.setBrand(dto.baseinfo.brand.trim());
                    item.setPrice(dto.price.buyprice.trim());
                    item.setPrice_consumer(dto.price.buyprice.trim());
                    item.setLimit_price(dto.price.consumerprice.trim());
                    item.setIslimit(dto.price.consumerprice.trim().equals("0") ? "0" : "1");
                    item.setTax(dto.price.taxmode.trim().equals("Y") ? "0" : "1");
                    String[] image = new String[]{dto.listimg.url1.trim(), dto.listimg.url2.trim(), dto.listimg.url3.trim(), dto.listimg.url4.trim(), dto.listimg.url5.trim()};
                    item.setImg(image);
                    if (dto.option != null && !dto.option.opt1nm.equals("")) {
                        StringBuffer sb = new StringBuffer();
                        if (!dto.option.opt2nm.trim().equals("")) {
                            sb.append("[" + dto.option.opt1nm.trim().concat("=").concat(dto.option.opt2nm.trim()) + "]\n");
                            values = dto.option.optvalue.trim().split("\\\u2191=\\\u2191");
                            i = 0;
                            while (i < values.length) {
                                value = values[i].split("\\^\\|\\^");
                                sb.append(value[0].concat("=").concat(value[1]).concat("=").concat(String.valueOf(Integer.parseInt(value[2])).concat("=0=0=").concat(value[3].equals("0") ? "1" : "0")).concat("\n"));
                                ++i;
                            }
                        } else {
                            sb.append("[" + dto.option.opt1nm.trim() + "]\n");
                            values = dto.option.optvalue.trim().split("\\\u2191=\\\u2191");
                            i = 0;
                            while (i < values.length) {
                                value = values[i].trim().split("\\^\\|\\^");
                                sb.append(value[0].trim().concat("==").concat(String.valueOf(Integer.parseInt(value[1].trim())).concat("=").concat(value[2].trim()).concat("=0=").concat(dto.option.optcnt.trim().equals("0") ? "1" : "0")).concat("\n"));
                                ++i;
                            }
                        }
                        item.setSelect_option(sb.toString());
                        item.setText_option("");
                    }
                    item.setContent(dto.content.trim());
                    item.setKeyword(dto.keyword.trim());
                    item.setStatus(dto.status.runout.trim());
                    item.setReg_datetime(dto.status.opendate);
                    item.setDelivery_amount("0");
                    item.setDelivery_type("0");
                    item.setR_delivery_amount("0");
                    item.setNotice("");
                    item.setAdult("0");
                    item.setIsreturn("1");
                    item.setUp_datetime(YDMATimeUtil.getCurrentTimeByYDFormat());
                    item.setItype("0");
                    item.setCert_type("0");
                    item.setDelivery_qty("0");
                    items.add(item);
                }
                productResult.items = items;
                productResult.total_count = Integer.toString(items.size());
                productResult.total_page = "1";
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return productResult;
    }

    public ProductResultDto getProductUploadMapping(Map<Integer, HashMap<String, String>> readExcelManager) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        for (Integer key : readExcelManager.keySet()) {
            String prodcd;
            HashMap<String, String> data2;
            if (key == 0 || (data2 = readExcelManager.get(key)).get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d") != null && !data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d").isEmpty() || data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85") != null && !data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85").isEmpty() || data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4") != null && !data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4").isEmpty() || (prodcd = data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc")).length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            new ShopOrderMstDto();
            dto.setIcode(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setVender_code(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setFolder(data2.get("\ud3f4\ub354\uba85"));
            dto.setCid(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*"));
            dto.setIname(data2.get("\uc0c1\ud488\uba85*"));
            dto.setPrice(data2.get("\ud310\ub9e4\uac00*"));
            dto.setQty(data2.get("\uc218\ub7c9*"));
            dto.setLimitQty(data2.get("\ucd5c\ub300\uad6c\ub9e4\uc218\ub7c9"));
            dto.setLowLimitQty(data2.get("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9"));
            dto.setIcountry(data2.get("\uc6d0\uc0b0\uc9c0*"));
            dto.setOrigin(data2.get("G\ub9c8\ucf13,\uc625\uc158 \uc6d0\uc0b0\uc9c0 \uc720\ud615"));
            dto.setMaker(data2.get("\uc218\uc785\uc0ac"));
            String[] imgList = (String[])Arrays.asList(data2.get("\ubaa9\ub85d \uc774\ubbf8\uc9c0*"), data2.get("\uc774\ubbf8\uc9c01(\ub300\ud45c/\uae30\ubcf8\uc774\ubbf8\uc9c0)*"), data2.get("\uc774\ubbf8\uc9c02"), data2.get("\uc774\ubbf8\uc9c03"), data2.get("\uc774\ubbf8\uc9c04"), data2.get("\uc774\ubbf8\uc9c05")).toArray();
            dto.setImg(imgList);
            dto.setContent(data2.get("\uc0c1\uc138\uc124\uba85*"));
            dto.setEsm_auction(data2.get("ESM \ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc124\uba85"));
            dto.setEsm_auction(data2.get("ESM \uad11\uace0\ud64d\ubcf4 \uc0c1\uc138\uc124\uba85"));
            dto.setSelect_option(data2.get("\uc120\ud0dd\uc0ac\ud56d \ud0c0\uc785"));
            dto.setSelect_option_name(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc635\uc158\uba85"));
            dto.setSelect_option_config(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc0c1\uc138\uc815\ubcf4"));
            dto.setSelect_option_use(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc7ac\uace0 \uc0ac\uc6a9\uc5ec\ubd80"));
            dto.setText_option(data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d"));
            dto.setText_option_name(data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85"));
            dto.setText_option_config(data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4"));
            dto.setBrand(data2.get("\ube0c\ub79c\ub4dc"));
            dto.setModel(data2.get("\ubaa8\ub378\uba85"));
            dto.setMaker(data2.get("\uc81c\uc870\uc0ac"));
            dto.setTax(data2.get("\uacfc\uc138\uc5ec\ubd80").equals("\uacfc\uc138") ? "0" : "1");
            dto.setAdult(data2.get("\ub098\uc774\uc81c\ud55c"));
            dto.setMake_datetime(data2.get("\uc81c\uc870\uc77c\uc790"));
            dto.setUse_datetime(data2.get("\uc720\ud6a8\uc77c\uc790"));
            dto.setHongbo(data2.get("\ud64d\ubcf4\ubb38\uad6c"));
            dto.setItype(data2.get("\uc0c1\ud488\uc0c1\ud0dc"));
            dto.setCost(data2.get("\uc6d0\uac00"));
            dto.setPrice_consumer(data2.get("\uacf5\uae09\uac00"));
            dto.setLimit_price(data2.get("\ub3c4\uc11c\uc815\uac00"));
            dto.setIsbn(data2.get("ISBN"));
            dto.setMoonhwa(data2.get("\ubb38\ud654\ube44 \uc18c\ub4dd\uacf5\uc81c"));
            dto.setKeyword(data2.get("\uac80\uc0c9\uc5b4(\ud0dc\uadf8)"));
            dto.setCert(data2.get("\uc778\uc99d\uc815\ubcf4"));
            dto.setGosi_code(data2.get("\uc694\uc57d\uc815\ubcf4 \uc0c1\ud488\uad70 \ucf54\ub4dc*"));
            dto.setGosi1(data2.get("\uac121"));
            dto.setGosi2(data2.get("\uac122"));
            dto.setGosi3(data2.get("\uac123"));
            dto.setGosi4(data2.get("\uac124"));
            dto.setGosi5(data2.get("\uac125"));
            dto.setGosi6(data2.get("\uac126"));
            dto.setGosi7(data2.get("\uac127"));
            dto.setGosi8(data2.get("\uac128"));
            dto.setGosi9(data2.get("\uac129"));
            dto.setGosi10(data2.get("\uac1210"));
            dto.setGosi11(data2.get("\uac1211"));
            dto.setGosi12(data2.get("\uac1212"));
            dto.setGosi13(data2.get("\uac1213"));
            dto.setGosi14(data2.get("\uac1214"));
            dto.setGosi15(data2.get("\uac1215"));
            dto.setGosi16(data2.get("\uac1216"));
            dto.setGosi17(data2.get("\uac1217"));
            dto.setGosi18(data2.get("\uac1218"));
            dto.setGosi19(data2.get("\uac1219"));
            dto.setGosi20(data2.get("\uac1220"));
            dto.setGosi21(data2.get("\uac1221"));
            dto.setGosi22(data2.get("\uac1222"));
            dto.setGosi23(data2.get("\uac1223"));
            dto.setGosi24(data2.get("\uac1224"));
            dto.setGosi25(data2.get("\uac1225"));
            dto.setGosi26(data2.get("\uac1226"));
            dto.setGosi27(data2.get("\uac1227"));
            dto.setGosi28(data2.get("\uac1228"));
            dto.setGosi29(data2.get("\uac1229"));
            dto.setErr_message(data2.get("\uae30\ubcf8\uc815\ubcf4 \uc624\ub958\uba54\uc2dc\uc9c0"));
            dto.setDelivery_amount(data2.get("\ubc30\uc1a1\ube44"));
            dto.setStatus("0");
            String id = data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*");
            ShopProductDao.get();
            String cate_list = ShopProductDao.getCategoryInfo(id);
            dto.setCategoryInfo(cate_list);
            dto.setCateg_nm(CaffeineCategoryCache.getInstance().getFullCategoryName(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*")));
            dto.seteSellersExcelYN("Y");
            dto.setSearch("shop9995");
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add((CallSite)((Object)(key + "=" + value)));
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    public String ConvertDictionaryTLisyoParameter(List<List<String>> contents) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        int i = 0;
        while (i < contents.size()) {
            String value = contents.get(i).get(1);
            if (!value.equals("") && !value.equals("0")) {
                list.add((CallSite)((Object)(contents.get(i).get(0) + ":" + value)));
            }
            ++i;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    private void setValue(YDMAProgressBar console, String message, int page) {
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, page);
    }
}

