/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageDownloader {
    private static final int TIMEOUT_MS = 10000;
    private static final int MAX_RETRY = 3;

    public static byte[] downloadImage(String imageUrl) throws IOException {
        IOException lastException = null;
        int attempt = 1;
        while (attempt <= 3) {
            try {
                return ImageDownloader.tryDownload(imageUrl);
            }
            catch (IOException e) {
                lastException = e;
                if (attempt < 3) {
                    System.err.printf("[\uc7ac\uc2dc\ub3c4 %d/%d] %s%n", attempt, 3, e.getMessage());
                    try {
                        Thread.sleep(1000 * attempt);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++attempt;
            }
        }
        throw new IOException("\uc774\ubbf8\uc9c0 \ub2e4\uc6b4\ub85c\ub4dc \uc2e4\ud328: " + imageUrl, lastException);
    }

    /*
     * Loose catch block
     */
    private static byte[] tryDownload(String imageUrl) throws IOException {
        URL url = new URL(imageUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36");
        connection.setRequestProperty("Referer", "https://www.google.com/");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setInstanceFollowRedirects(true);
        int status2 = connection.getResponseCode();
        if (status2 != 200) {
            throw new IOException("HTTP \uc751\ub2f5 \ucf54\ub4dc: " + status2 + " (" + imageUrl + ")");
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream out;
            InputStream in;
            block18: {
                block17: {
                    int len;
                    in = connection.getInputStream();
                    out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    byArray = out.toByteArray();
                    if (out == null) break block17;
                    out.close();
                }
                if (in == null) break block18;
                in.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

