/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.cloudinary.Transformation;
import com.kdjsystem.mlink.shop.ImageUpload.CloudinaryUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.FtpUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UploadException;
import com.kdjsystem.mlink.shop.ImageUpload.UploadResult;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedUploadManager {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedUploadManager.class);
    private final CloudinaryUploadService cloudSvc = CloudinaryUploadService.get();
    private final FtpUploadService ftpSvc = new FtpUploadService();

    public String upload(Path localFile) throws UploadException {
        if (localFile == null) {
            throw new IllegalArgumentException("Local file path must not be null");
        }
        if (this.cloudSvc.isEnabled()) {
            try {
                return this.cloudSvc.upload(localFile);
            }
            catch (UploadException e) {
                logger.warn("Cloudinary upload failed, falling back to FTP.", (Throwable)e);
            }
        }
        return this.ftpSvc.upload(localFile);
    }

    public List<String> processAndUploadImages(ImageTransformParams params) throws Exception {
        if (params == null || params.getShopProductDto() == null) {
            throw new IllegalArgumentException("Invalid ImageTransformParams");
        }
        ShopProductDto dto = params.getShopProductDto();
        List<String> imageInputs = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
        List<String> imageUrls = imageInputs.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
        if (this.cloudSvc.isEnabled()) {
            return this.processWithCloudinary(dto, imageUrls, params);
        }
        return this.processLocally(dto, imageUrls, params);
    }

    private List<String> processWithCloudinary(ShopProductDto dto, List<String> imageUrls, ImageTransformParams params) throws Exception {
        ArrayList<String> urls = new ArrayList<String>(imageUrls.size());
        boolean requiresDownload = params.requiresDownload(dto.getShopcd(), dto.getGoods_keyword());
        int i = 0;
        while (i < imageUrls.size()) {
            String src = imageUrls.get(i);
            if (i == 0 && params.requiresTransform()) {
                UploadResult res = this.prepareUploadResult(src);
                src = this.applyCombinedTransforms(res.getPublicId(), res.getVersion(), params, dto.getShopcd());
                if (params.isRemoveImgTextYN()) {
                    String noTextLocal = this.downloadAndRemoveText(src, dto, i);
                    src = params.needsReuploadAfterRemove(dto.getShopcd()) ? this.cloudSvc.upload(Paths.get(noTextLocal, new String[0])) : noTextLocal;
                }
            }
            if (requiresDownload) {
                String noTextLocal = this.generateCloudinaryFetchUrl(src, dto, i);
                src = params.handleDownloadAndReupload(dto.getShopcd()) ? this.cloudSvc.upload(Paths.get(noTextLocal, new String[0])) : noTextLocal;
            }
            urls.add(src);
            ++i;
        }
        return urls;
    }

    private String applyTransforms(UploadResult res, ImageTransformParams params, String shopCd) throws UploadException {
        String url = res.getSecureUrl();
        if (params.isImageresize() && params.requiresTransformWithMax1000("1000")) {
            url = this.resizeImage(url);
        } else if (params.isMirror()) {
            url = this.flipImage(url);
        } else if (params.isChangeSize()) {
            url = this.cropRotateZoomImage(url, params);
        } else if (params.isImgThreeOnFour()) {
            url = this.resize34Image(url, shopCd);
        }
        return url;
    }

    public String applyCombinedTransforms(String publicId, long version, ImageTransformParams params, String shopCd) {
        Transformation t = new Transformation();
        String outFormat = "jpg";
        if (params.isImageresize() && params.requiresTransformWithMax1000("1000")) {
            t.crop("fill").width((Object)1000).height((Object)1000);
        }
        if (params.isChangeSize()) {
            this.resetDefaultParams(params);
            int x = Integer.parseInt(params.getChangeSizeX());
            int y = Integer.parseInt(params.getChangeSizeY());
            int w = Integer.parseInt(params.getChangeSizeW());
            int h = Integer.parseInt(params.getChangeSizeH());
            int angle = (int)Math.round(params.getAngle());
            double zoom = params.getScalePercent();
            t.crop("crop").x((Object)x).y((Object)y).width((Object)w).height((Object)h).angle(angle).zoom(zoom);
        }
        if (params.isMirror()) {
            t.angle(new String[]{"hflip"});
        }
        if (params.isImgThreeOnFour()) {
            int rh;
            int rw;
            if (ShopCommon.isHighResThumbnailShop(shopCd)) {
                rw = 600;
                rh = 800;
            } else {
                rw = 450;
                rh = 600;
            }
            t.crop("fill").width((Object)rw).height((Object)rh);
        }
        return this.cloudSvc.generateUrlWithTransformation(publicId, version, t, outFormat);
    }

    private String downloadAndRemoveText(String src, ShopProductDto dto, int i) {
        try {
            String savePath = this.buildLocalPath(dto, i);
            src = CloudinaryUploadService.downloadByUrl(src, savePath);
            List<String> images = this.setImgRemoveText(dto, Collections.singletonList(src));
            src = images.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return src;
    }

    private String generateCloudinaryFetchUrl(String src, ShopProductDto dto, int index) {
        String trimmed = src.trim();
        try {
            boolean isCloudinary;
            URI uri = new URI(trimmed);
            boolean isHttp = "http".equals(uri.getScheme()) || "https".equals(uri.getScheme());
            boolean bl = isCloudinary = isHttp && uri.getHost().endsWith("res.cloudinary.com");
            if (isHttp) {
                String savePath = this.buildLocalPath(dto, index);
                if (isCloudinary) {
                    return CloudinaryUploadService.downloadByUrl(trimmed, savePath);
                }
                return ShopCommon.downloadImgFileJPG(trimmed, 600, 600, dto, index);
            }
        }
        catch (Exception e) {
            logger.warn("downloadIfNeeded \uc2e4\ud328 ({}): {}", (Object)src, (Object)e.getMessage());
        }
        return trimmed;
    }

    private void resetDefaultParams(ImageTransformParams params) {
        if (params.getScalePercent() <= 0.0) {
            params.setScalePercent(100.0);
        }
        if (params.getAngle() < 0.0) {
            params.setAngle(0.0);
        }
    }

    private String buildLocalPath(ShopProductDto dto, int index) throws Exception {
        String base = ShopCommon.getImgPath();
        String name = dto.getCompayny_goods_cd() + "_" + index + ".jpg";
        return Paths.get(base, name).toString();
    }

    public String resizeImage(String src) throws UploadException {
        UploadResult res = this.prepareUploadResult(src);
        return this.cloudSvc.getResize1000Url(res.getPublicId(), res.getVersion());
    }

    public String flipImage(String src) throws UploadException {
        UploadResult res = this.prepareUploadResult(src);
        return this.cloudSvc.getFlippedUrl(res.getPublicId(), res.getVersion());
    }

    public String cropRotateZoomImage(String src, ImageTransformParams params) throws UploadException {
        UploadResult res = this.prepareUploadResult(src);
        return this.cloudSvc.getCropRotateZoomUrl(res.getPublicId(), res.getVersion(), Integer.parseInt(params.getChangeSizeX()), Integer.parseInt(params.getChangeSizeY()), Integer.parseInt(params.getChangeSizeW()), Integer.parseInt(params.getChangeSizeH()), params.getAngle(), params.getScalePercent());
    }

    public String resize34Image(String src, String shopCd) throws UploadException {
        int height;
        int width;
        if (ShopCommon.isHighResThumbnailShop(shopCd)) {
            width = 600;
            height = 800;
        } else {
            width = 450;
            height = 600;
        }
        UploadResult res = this.prepareUploadResult(src);
        return this.cloudSvc.getResize34Url(res.getPublicId(), res.getVersion(), width, height);
    }

    private UploadResult prepareUploadResult(String src) throws UploadException {
        if (src.startsWith("http") && !src.contains("res.cloudinary.com")) {
            return this.cloudSvc.uploadImageWithFallback(src);
        }
        if (src.startsWith("http") && src.contains("res.cloudinary.com")) {
            return this.cloudSvc.uploadImageWithFallback(src);
        }
        src = this.cloudSvc.upload(Paths.get(src, new String[0]));
        String publicId = this.cloudSvc.extractFileName(src);
        long version = CloudinaryUploadService.extractVersion(src);
        return new UploadResult(publicId, src, version);
    }

    private List<String> processLocally(ShopProductDto dto, List<String> imageInputs, ImageTransformParams params) throws Exception {
        List<String> localEdited = this.editProductImage(dto, imageInputs, params);
        boolean needFtp = ShopCommon.requiresFtpUpload(dto.getShopcd());
        ArrayList<String> result = new ArrayList<String>(localEdited.size());
        int i = 0;
        while (i < localEdited.size()) {
            boolean isHttp;
            String raw = localEdited.get(i).trim();
            boolean bl = isHttp = raw.startsWith("http://") || raw.startsWith("https://");
            if (isHttp) {
                result.add(raw);
            } else if (needFtp) {
                Path localFile = Paths.get(raw, new String[0]);
                result.add(this.ftpSvc.upload(localFile));
                try {
                    result.add(this.ftpSvc.upload(localFile));
                }
                catch (UploadException e) {
                    logger.error("FTP \uc5c5\ub85c\ub4dc \uc2e4\ud328: " + String.valueOf(localFile), (Throwable)e);
                    result.add(raw);
                }
            } else {
                result.add(raw);
            }
            ++i;
        }
        return result;
    }

    private List<String> editProductImage(ShopProductDto dto, List<String> imgs, ImageTransformParams params) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        boolean reqDown = params.requiresDownload(dto.getShopcd(), dto.getGoods_keyword());
        int i = 0;
        while (i < imgs.size()) {
            String img = imgs.get(i);
            if (i == 0 && params.requiresTransform()) {
                img = params.isImageresize() && params.requiresTransformWithMax1000("1000") ? ShopCommon.downloadImgFileJPG(imgs.get(i), 1000, 1000, dto, i) : ShopCommon.downloadImgFileJPG(imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    if (params.isMirror()) {
                        img = this.cropImageWithmirrored(img);
                    }
                    if (params.isChangeSize()) {
                        this.resetDefaultParams(params);
                        img = this.cropImage(img, Integer.parseInt(params.getChangeSizeX()), Integer.parseInt(params.getChangeSizeY()), Integer.parseInt(params.getChangeSizeW()), Integer.parseInt(params.getChangeSizeH()), params.getAngle(), params.getScalePercent());
                    }
                    if (params.isImgThreeOnFour()) {
                        img = ShopCommon.isHighResThumbnailShop(dto.getShopcd()) ? ShopCommon.downloadImgFileJPG(img, 600, 800, dto, i) : ShopCommon.downloadImgFileJPG(img, 450, 600, dto, i);
                    }
                    if (params.isRemoveImgTextYN()) {
                        List<String> images = this.setImgRemoveText(dto, Collections.singletonList(img));
                        img = images.get(0);
                    }
                    if (params.needsReuploadAfterRemove(dto.getShopcd())) {
                        img = this.ftpSvc.upload(Paths.get(img, new String[0]));
                    }
                    ret.add(img);
                }
            } else {
                if (reqDown) {
                    String noTextLocal = this.generateFtpFetchUrl(img, dto, i);
                    img = params.handleDownloadAndReupload(dto.getShopcd()) ? this.ftpSvc.upload(Paths.get(noTextLocal, new String[0])) : noTextLocal;
                }
                ret.add(img);
            }
            ++i;
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    private String generateFtpFetchUrl(String src, ShopProductDto dto, int index) {
        String trimmed = src.trim();
        try {
            boolean isHttp;
            URI uri = new URI(trimmed);
            boolean bl = isHttp = "http".equals(uri.getScheme()) || "https".equals(uri.getScheme());
            if (isHttp) {
                return ShopCommon.downloadImgFileJPG(trimmed, 600, 600, dto, index);
            }
        }
        catch (Exception e) {
            logger.warn("downloadIfNeeded \uc2e4\ud328 ({}): {}", (Object)src, (Object)e.getMessage());
        }
        return trimmed;
    }

    public String cropImageWithmirrored(String img) {
        File filePath = new File(img);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedImage originalImgage = ImageIO.read(filePath);
            int width = originalImgage.getWidth();
            int height = originalImgage.getHeight();
            BufferedImage mirrored = new BufferedImage(width, height, originalImgage.getType());
            Graphics2D g2d = mirrored.createGraphics();
            g2d.scale(-1.0, 1.0);
            g2d.translate(-originalImgage.getWidth(), 0);
            g2d.drawImage((Image)originalImgage, 0, 0, null);
            g2d.dispose();
            sb.append(img);
            int p = img.indexOf(".jpg");
            sb.insert(p, "m");
            File targetfilePath = new File(sb.toString());
            ImageIO.write((RenderedImage)mirrored, "jpg", targetfilePath);
            return targetfilePath.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String cropImage(String img, int x, int y, int w, int h, double angle, double scalePercent) {
        x = 0;
        y = 0;
        File filePath = new File(img);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedImage originalImage = ImageIO.read(filePath);
            if (w > originalImage.getWidth()) {
                w = originalImage.getWidth();
            }
            if (h > originalImage.getHeight()) {
                h = originalImage.getHeight();
            }
            AffineTransform rotateTransform = new AffineTransform();
            rotateTransform.rotate(Math.toRadians(angle), (double)originalImage.getWidth() / 2.0, (double)originalImage.getHeight() / 2.0);
            BufferedImage rotatedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
            Graphics2D rotatedGraphics = rotatedImage.createGraphics();
            rotatedGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            rotatedGraphics.transform(rotateTransform);
            rotatedGraphics.drawImage((Image)originalImage, 0, 0, null);
            rotatedGraphics.dispose();
            double scaledWidth = (double)rotatedImage.getWidth() * scalePercent / 100.0;
            double scaledHeight = (double)rotatedImage.getHeight() * scalePercent / 100.0;
            AffineTransform scaleTransform = new AffineTransform();
            scaleTransform.scale(scaledWidth / (double)rotatedImage.getWidth(), scaledHeight / (double)rotatedImage.getHeight());
            BufferedImage scaledImage = new BufferedImage((int)scaledWidth, (int)scaledHeight, 2);
            Graphics2D scaledGraphics = scaledImage.createGraphics();
            scaledGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            scaledGraphics.drawImage(rotatedImage, scaleTransform, null);
            scaledGraphics.dispose();
            int cropX = Math.max(0, (scaledImage.getWidth() - w) / 2);
            int cropY = Math.max(0, (scaledImage.getHeight() - h) / 2);
            BufferedImage croppedImage = scaledImage.getSubimage(cropX, cropY, w, h);
            sb.append(img);
            int p = img.indexOf(".jpg");
            sb.insert(p, "c");
            File targetfilePath = new File(sb.toString());
            ImageIO.write((RenderedImage)croppedImage, "png", targetfilePath);
            return targetfilePath.getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List<String> setImgRemoveText(ShopProductDto dto, List<String> listImages) throws Exception {
        List<Object> ret = new ArrayList();
        try {
            String exePath;
            String exeDirectory = exePath = ShopCommon.getImgPathLocalThumnail();
            String exeFile = exeDirectory + File.separator + YDMAProperties.getInstance().getAppProperty("Product.imageChangeFile");
            String[] orgImages = listImages.toArray(new String[listImages.size()]);
            String[] convImages = ShopCommon.writeImageLocalFolder(dto.getCompayny_goods_cd(), orgImages, exeDirectory);
            Process activeProcess = this.execImgConvert(convImages, exeFile, exeDirectory);
            this.waitResult(activeProcess);
            ret = this.returnFolderInConverImage(orgImages, convImages, exeDirectory, activeProcess);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    public Process execImgConvert(String[] convImages, String exeFile, String exeDirectory) throws IOException {
        String imagesToProcess = String.join((CharSequence)",", convImages);
        String commandImagesArg = String.format("\"1,%s\"", imagesToProcess);
        ProcessBuilder builder = new ProcessBuilder(exeFile, "-l", commandImagesArg);
        builder.directory(new File(exeDirectory));
        builder.redirectErrorStream(true);
        return builder.start();
    }

    public void waitResult(Process activeProcess) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(activeProcess.getInputStream()));){
            while (reader.readLine() != null) {
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<String> returnFolderInConverImage(String[] orgImages, String[] convImages, String exeDirectory, Process activeProcess) throws Exception {
        ArrayList<String> processedList = new ArrayList<String>();
        int exitCode = activeProcess.waitFor();
        if (exitCode == 0) {
            int i = 0;
            while (i < orgImages.length) {
                String outputImagePath = exeDirectory + File.separator + "out_" + convImages[i];
                if (new File(outputImagePath).exists()) {
                    processedList.add(outputImagePath);
                } else {
                    processedList.add(orgImages[i]);
                }
                new File(exeDirectory + File.separator + convImages[i]).delete();
                ++i;
            }
        }
        return processedList;
    }
}

