/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.Observer;
import com.kdjsystem.mlink.shop.common.Observerable;
import com.kdjsystem.mlink.shop.common.QueueCapacityCalculator;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopWorkDataQueue
implements Observerable {
    private static final Logger logger = LoggerFactory.getLogger(ShopWorkDataQueue.class);
    private final List<DataFlatMap> dataFlatMaps = new CopyOnWriteArrayList<DataFlatMap>();
    private final BlockingDeque<ShopProductSendDto> queue;
    private final List<Observer> observers = new CopyOnWriteArrayList<Observer>();
    private static final ShopWorkDataQueue instance = new ShopWorkDataQueue();

    private ShopWorkDataQueue() {
        int queueCapacity = QueueCapacityCalculator.calculateQueueCapacity();
        logger.info("Initializing work queue with capacity (based on JVM heap): {}", (Object)queueCapacity);
        this.queue = new LinkedBlockingDeque<ShopProductSendDto>(queueCapacity);
    }

    public static ShopWorkDataQueue get() {
        return instance;
    }

    public void add(ShopProductSendDto sendDto) {
        if (this.isExistGrp(sendDto.getWorkgrp())) {
            return;
        }
        this.queue.offerLast(sendDto);
        for (ShopProductDto d : sendDto.getShopProductDto()) {
            this.dataFlatMaps.add(new DataFlatMap(d.getShopcd(), d.getShopseq(), d.getProdseq(), sendDto.getWorkgrp()));
        }
        this.notifyObservers();
    }

    public boolean isExistGrp(String grp) {
        return this.queue.stream().anyMatch(dto -> dto.getWorkgrp().equals(grp));
    }

    public void delete(String grp) {
        this.queue.removeIf(dto -> dto.getWorkgrp().equals(grp));
        this.dataFlatMaps.removeIf(df -> df.grp.equals(grp));
    }

    public boolean isExistsDataQueue() {
        return !this.queue.isEmpty();
    }

    public boolean isExistsDataQueueWithSchedule(String prodseq) {
        return this.dataFlatMaps.stream().anyMatch(df -> df.prodseq.equals(prodseq));
    }

    public boolean isExistsDataQueue(String shopcd, String shopseq, String prodseq) {
        return this.dataFlatMaps.stream().anyMatch(df -> df.shopcd.equals(shopcd) && df.shopseq.equals(shopseq) && df.prodseq.equals(prodseq));
    }

    public List<WorkMngDto> getAllData() {
        return this.queue.stream().map(ShopProductSendDto::getWorkMngDto).collect(Collectors.toList());
    }

    private ShopProductSendDto fetchNext(String code) {
        for (ShopProductSendDto dto : this.queue) {
            WorkMngDto wm = dto.getWorkMngDto();
            if (!wm.getWorkcd().equals(code) || !wm.getWork_status().equals("W01")) continue;
            wm.setWork_status("W08");
            wm.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
            return dto;
        }
        return null;
    }

    public ShopProductSendDto getWaitData() {
        return this.fetchNext("100");
    }

    public ShopProductSendDto getModifyData() {
        return this.fetchNext("200");
    }

    public ShopProductSendDto getModifySoldOutData() {
        return this.fetchNext("500");
    }

    public ShopProductSendDto getModifyDeleteData() {
        return this.fetchNext("600");
    }

    public ShopProductSendDto getSaleEndData() {
        return this.fetchNext("700");
    }

    public ShopProductSendDto getSaleResumeData() {
        return this.fetchNext("800");
    }

    @Override
    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    @Override
    public void notifyObservers() {
        for (Observer o : this.observers) {
            o.update(this);
        }
    }

    public void notifyCompleteObservers() {
        for (Observer o : this.observers) {
            o.updateComplete(this);
        }
    }

    private static class DataFlatMap {
        private final String shopcd;
        private final String shopseq;
        private final String prodseq;
        private final String grp;

        public DataFlatMap(String shopcd, String shopseq, String prodseq, String grp) {
            this.shopcd = shopcd;
            this.shopseq = shopseq;
            this.prodseq = prodseq;
            this.grp = grp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataFlatMap)) {
                return false;
            }
            DataFlatMap that = (DataFlatMap)o;
            return this.shopcd.equals(that.shopcd) && this.shopseq.equals(that.shopseq) && this.prodseq.equals(that.prodseq) && this.grp.equals(that.grp);
        }

        public int hashCode() {
            int result = this.shopcd.hashCode();
            result = 31 * result + this.shopseq.hashCode();
            result = 31 * result + this.prodseq.hashCode();
            result = 31 * result + this.grp.hashCode();
            return result;
        }
    }
}

