/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GsShopAdditionalCommand {
    private static GsShopAdditionalCommand instance = new GsShopAdditionalCommand();
    IShopCommonLogin i = new IShopCommonLogin(){};
    JsonParser jsonParser = new JsonParser();

    public static GsShopAdditionalCommand get() {
        return instance;
    }

    public Map<String, String> getLoginCookies(String loginID, String loginPw, String authkey1) {
        Map<String, String> cookies = new HashMap<String, String>();
        try {
            cookies = this.i.loginCookie(loginID, loginPw, "shop0007", true, authkey1);
        }
        catch (Exception exception) {
            return cookies;
        }
        return cookies;
    }

    public List<ShopCategoryDto> getDisplayStoreGroup(Map<String, String> loginCookie) throws Exception {
        ArrayList<ShopCategoryDto> shopCategoryDto = new ArrayList<ShopCategoryDto>();
        Document doc = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M?gMenuId=A1900").cookies(loginCookie).ignoreContentType(true).get();
        Elements liList = doc.select("#sectGrp > li");
        for (Element li : liList) {
            ShopCategoryDto shopCateDto = new ShopCategoryDto();
            shopCateDto.setShopcd("shop0007");
            shopCateDto.setCatlrgcd(li.attr("shopgrpcd"));
            shopCateDto.setCatlrgnm(li.selectFirst("a").text().trim());
            shopCategoryDto.add(shopCateDto);
        }
        return shopCategoryDto;
    }

    public List<ShopCategoryDto> getDisplayStoreByGroup(Map<String, String> loginCookie, String groupCd) {
        ArrayList<ShopCategoryDto> shopCategoryDto = new ArrayList<ShopCategoryDto>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/listRegSect1ByGrp").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").data("sectid", "").data("sectprstid", "").data("suppCode", "").data("sectGubun", "").data("sectid1", "").data("sectid2", "").data("sectid3", "").data("sectid4", "").data("sectid5", "").data("shopAttrCd", "S").data("shopGrpCd", groupCd).method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    ShopCategoryDto shopCateDto = new ShopCategoryDto();
                    shopCateDto.setShopcd("shop0007");
                    shopCateDto.setCatlrgcd(ele.getAsJsonObject().get("sectid").getAsString());
                    if (ele.getAsJsonObject().get("prdDispYn").getAsString().equals("Y")) {
                        shopCateDto.setCatlrgnm("(Y)" + ele.getAsJsonObject().get("name").getAsString());
                    } else {
                        shopCateDto.setCatlrgnm(ele.getAsJsonObject().get("name").getAsString());
                    }
                    shopCategoryDto.add(shopCateDto);
                }
            }
        }
        catch (Exception exception) {}
        return shopCategoryDto;
    }

    public List<ShopCategoryDto> getDisplayStoreByOther(Map<String, String> loginCookie, String sectprstid) {
        ArrayList<ShopCategoryDto> shopCategoryDto = new ArrayList<ShopCategoryDto>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/listRegSect2").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").data("sectid", "").data("sectprstid", sectprstid).data("suppCode", "").data("sectGubun", "").data("sectid1", "").data("sectid2", "").data("sectid3", "").data("sectid4", "").data("sectid5", "").data("shopAttrCd", "S").data("shopGrpCd", "").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    ShopCategoryDto shopCateDto = new ShopCategoryDto();
                    shopCateDto.setShopcd("shop0007");
                    shopCateDto.setCatlrgcd(ele.getAsJsonObject().get("sectid").getAsString());
                    if (ele.getAsJsonObject().get("prdDispYn").getAsString().equals("Y")) {
                        shopCateDto.setCatlrgnm("(Y)" + ele.getAsJsonObject().get("name").getAsString());
                    } else {
                        shopCateDto.setCatlrgnm(ele.getAsJsonObject().get("name").getAsString());
                    }
                    shopCategoryDto.add(shopCateDto);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return shopCategoryDto;
    }

    public Map<String, String> getMD(Map<String, String> loginCookie, String mdId) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/prd/ajaxPrdRegMdid_P").addParameter("suppCode", "").addParameter("mdid", mdId).addParameter("rpEmplNm", "N").addParameter("emplNumb", "").addParameter("prdGroupNm", "").addParameter("emplName", "");
        URI uri = builder.build();
        GsShopRows rows = GsShopApiClient.search(uri.toString(), loginCookie);
        List<GsShopRow> rowList = rows.getRows();
        if (rowList.size() > 0) {
            for (GsShopRow row : rowList) {
                if (mdId.isEmpty()) {
                    map.put(row.getCell(3), row.getCell(1));
                    continue;
                }
                map.put(row.getCell(0), row.getCell(2));
            }
        }
        return map;
    }

    public Map<String, String> getBrand(Map<String, String> loginCookie, String name) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/prd/prdReg_M/getBrandInfo").addParameter("brandName", name).addParameter("brandNameType", "A");
        URI uri = builder.build();
        GsShopRows rows = GsShopApiClient.search(uri.toString(), loginCookie);
        List<GsShopRow> rowList = rows.getRows();
        if (rowList.size() > 0) {
            for (GsShopRow row : rowList) {
                map.put(row.getCell(2), row.getCell(0));
            }
        }
        return map;
    }

    public Map<String, String> getCommonCodeList(Map<String, String> loginCookie, String cmmGrpCd, String cdSubtypVal) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/getCmmCdList").data("cmmGrpCd", cmmGrpCd).data("cmmCd", "").data("cdVal", "").data("cdSubtypVal", cdSubtypVal).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    map.put(ele.getAsJsonObject().get("cmmCd").getAsString(), ele.getAsJsonObject().get("cdVal").getAsString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map<String, String> getDeliveryCompanys(Map<String, String> loginCookie) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/listDeliCompany").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    map.put(ele.getAsJsonObject().get("deliCompCd").getAsString(), ele.getAsJsonObject().get("deliCompNm").getAsString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public List<Map<String, String>> getShippingOriginNReturnCode(Map<String, String> loginCookie, String loginId) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, CallSite> map = new LinkedHashMap<String, CallSite>();
        LinkedHashMap<String, CallSite> map2 = new LinkedHashMap<String, CallSite>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/listGsScmShipAddr").data("suppCode", loginId).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    obj = ele.getAsJsonObject();
                    String key = obj.get("addrCd").getAsString();
                    String value = obj.get("addrDesc").getAsString() + ": " + obj.get("cntrAddr1").getAsString() + obj.get("cntrAddr2").getAsString();
                    if (obj.get("dirdlvRelspYn").getAsString().equals("Y")) {
                        map.put(key, (CallSite)((Object)value));
                    }
                    if (!obj.get("dirdlvRetpYn").getAsString().equals("Y")) continue;
                    map2.put(key, (CallSite)((Object)value));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        list.add(map);
        list.add(map2);
        return list;
    }

    public Map<String, String> getRelsOrdTime(Map<String, String> loginCookie) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/listRelsOrdTime").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(loginCookie).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                for (JsonElement ele : output) {
                    map.put(ele.getAsJsonObject().get("cmmCd").getAsString(), ele.getAsJsonObject().get("cdVal").getAsString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }
}

