/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ownerclan;

import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.ownerclan.IShopOrderOwnerClanCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class OwnerClanOrderSearchCommand
extends IShopOrderOwnerClanCommand
implements IShopCommonLogin {
    Map<String, String> cookie;
    private static IShopOrderCommand instance = new OwnerClanOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    OwnerClanOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        HashMap<String, String> cookies = new HashMap();
        ShopOrderMstDto dto = param.get(0);
        String startDate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String endDate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        try {
            cookies = is.loginCookie(dto.getShop_userid(), dto.getShopPw(), dto.getShopid(), true, dto.getAuthkey1());
            StringBuffer commonBody = new StringBuffer();
            commonBody.append("code=&excel_type=&gbn_mode=&deli_gbn3=&deli_gbnr=&orderby=b.ordercode+DESC&orderbyWhere=b.ordercode+DESC&search_start=");
            commonBody.append(startDate);
            commonBody.append("&search_end=");
            commonBody.append(endDate);
            this.orderSync(param, retList, commonBody.toString() + "&deli_gbn%5B5%5D=D&deli_gbn%5B4%5D=C&s_check=rn&search=&x=20&y=10&searchtype=", cookies);
            this.orderSync(param, retList, commonBody.toString() + "&deli_gbn%5B6%5D=B&deli_gbn%5B9%5D=B&deli_gbn%5B7%5D=Z&s_check=rn&search=&x=12&y=9&searchtype=", cookies);
            this.orderSync(param, retList, commonBody.toString() + "&deli_gbn%5B11%5D=B&deli_gbn%5B12%5D=B&deli_gbn%5B13%5D=Z&s_check=rn&search=&x=16&y=11&searchtype=", cookies);
            this.orderSync(param, retList, commonBody.toString() + "&deli_gbn%5B8%5D=Y&s_check=rn&search=&x=26&y=9&searchtype=", cookies);
        }
        catch (Exception exception) {
            throw new Exception("\uc624\ub108\ud074\ub79c \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return retList;
    }

    private void orderSync(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String body, Map<String, String> cookies) throws IOException, CloneNotSupportedException {
        try {
            Connection.Response rs = Jsoup.connect((String)"https://ownerclan.com/vender/order_list.php").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(body).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("[class='trRow']");
            if (data2.size() == 0) {
                return;
            }
            String commonStartSelector = "body > table > tbody > tr > td > table > tbody >";
            String commonEndSelecotr = "> td > table > tbody > tr";
            int i = 0;
            while (i < data2.size()) {
                String orderId = ((Element)data2.get(i)).attr("name").substring(3);
                rs = Jsoup.connect((String)("https://ownerclan.com/vender/order_detail.php?ordercode=" + orderId)).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                doc = Jsoup.parseBodyFragment((String)rs.body());
                Elements orderHistory = doc.select(commonStartSelector + " tr:nth-child(15) " + commonEndSelecotr);
                Elements orderProductInfo = doc.select(commonStartSelector + " tr:nth-child(19) > td > table tbody > tr:nth-child(2)");
                String mallid = orderProductInfo.select("td:nth-child(2)").text();
                if (!mallid.equals("")) {
                    String status2 = this.getStatus(orderHistory.select("tr:nth-of-type(1) > td:nth-of-type(2)").text());
                    for (ShopOrderMstDto dto : param) {
                        String orddt;
                        ShopOrderMstDto temp;
                        if (!this.orderCheck(dto, orderId, mallid, "0")) continue;
                        dto.setOrder_status(status2);
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("C02")) {
                            temp = dto.clone("C02");
                            try {
                                orddt = doc.select("body > table > tbody > tr > td > table > tbody > tr:nth-child(41) > td > table > tbody > tr:nth-child(2) > td:nth-child(2)").text();
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        if (dto.getOrder_status().equals("R02")) {
                            temp = dto.clone("R02");
                            try {
                                orddt = doc.select("body > table > tbody > tr > td > table > tbody > tr:nth-child(40) > td > table > tbody > tr:nth-child(2) > td:nth-child(2)").text();
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        if (dto.getOrder_status().equals("E02")) {
                            temp = dto.clone("E02");
                            try {
                                orddt = doc.select("body > table > tbody > tr > td > table > tbody > tr:nth-child(40) > td > table > tbody > tr:nth-child(2) > td:nth-child(2)").text();
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                }
                i += 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean orderCheck(ShopOrderMstDto dto, String orderid, String mallid, String expid) {
        return dto.getOrder_id().equals(orderid) && dto.getMall_product_id().equals(mallid) && dto.getMall_exp_cd().equals(expid);
    }

    private String getStatus(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (text.contains("\ucde8\uc18c\uc694\uccad")) {
            return "C01";
        }
        if (text.contains("\uc8fc\ubb38\ucde8\uc18c")) {
            return "C02";
        }
        if (text.contains("\ubc18\ud488\uc694\uccad") || text.contains("\ubc18\ud488\uc9c4\ud589")) {
            return "R01";
        }
        if (text.contains("\ubc18\ud488\uc644\ub8cc")) {
            return "R02";
        }
        if (text.contains("\uad50\ud658\uc694\uccad") || text.contains("\uad50\ud658\uc9c4\ud589")) {
            return "E01";
        }
        if (text.contains("\uad50\ud658\uc644\ub8cc")) {
            return "E02";
        }
        if (text.contains("\ubc30\uc1a1\uc644\ub8cc")) {
            return "410";
        }
        return "";
    }
}

