/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.ssgmarket.IShopSSGOrderCommand;
import com.kdjsystem.mlink.shop.data.ssgmarket.SSGOrderDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SSGOrderSearchCommand
extends IShopSSGOrderCommand {
    private static IShopOrderCommand instance = new SSGOrderSearchCommand();
    private static final String Host = "https://eapi.ssgadm.com";
    ConnectionPool connectionPool = new ConnectionPool();
    private final OkHttpClient client = new OkHttpClient().newBuilder().connectionPool(this.connectionPool).build();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private SSGOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            String startdt = param.get(0).getStartDt().substring(0, 8);
            String enddt = param.get(0).getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            int num = (int)range % 7 == 0 ? (int)range / 7 : (int)range / 7 + 1;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            if (num > 1) {
                cal2.add(5, 6);
                enddt = formatter.format(cal2.getTime());
            }
            int i = 0;
            while (i < num) {
                this.orderList(param, dtolist, startdt, enddt);
                this.cancleList(param, dtolist, startdt, enddt);
                this.returnList(param, dtolist, startdt, enddt);
                if (i == num - 2) {
                    enddt = param.get(0).getEndDt().substring(0, 8);
                } else {
                    cal2.add(5, 7);
                    enddt = formatter.format(cal2.getTime());
                }
                cal1.add(5, 7);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG\ub2f7\ucef4 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private void exChangeList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startDate, String endDate) throws Exception {
    }

    private void returnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startDate, String endDate) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = this.setReturnDeliveryRequestParams(startDate, endDate);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/listExchangeTarget.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    SSGOrderDto.ResponseExchangeTarget Responsereturndelivery = (SSGOrderDto.ResponseExchangeTarget)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseExchangeTarget.class);
                    if (Responsereturndelivery.getResult().getResultCode().equals("00") && Responsereturndelivery.getResult().exchangeTargets != null) {
                        for (SSGOrderDto.ResponseExchangeTarget.Result.ExchangeTarget dto : Responsereturndelivery.getResult().exchangeTargets) {
                            String ordNum = dto.getOrordNo();
                            String exp_cd = dto.getOrdItemSeq();
                            String product_id = dto.getItemId();
                            for (ShopOrderMstDto orderMstDto : param) {
                                ShopOrderMstDto temp;
                                if (!orderMstDto.getOrder_id().equals(ordNum) || !orderMstDto.getMall_exp_cd().equals(exp_cd) || !orderMstDto.getMall_product_id().equals(product_id)) continue;
                                if (dto.getShppDivDtlCd().equals("21") && dto.getLastShppProgStatDtlNm().equals("\ud68c\uc218\uc9c0\uc2dc")) {
                                    orderMstDto.setOrder_status("R01");
                                    orderMstDto.setResult_code("1");
                                    dtolist.add(orderMstDto);
                                    continue;
                                }
                                if (dto.getShppDivDtlCd().equals("21") && dto.getLastShppProgStatDtlNm().equals("\ud68c\uc218\uc644\ub8cc")) {
                                    orderMstDto.setOrder_status("R02");
                                    orderMstDto.setResult_code("1");
                                    temp = orderMstDto.clone("R02");
                                    temp.setOrder_date(dto.getRcovCmplDt());
                                    dtolist.add(temp);
                                    dtolist.add(orderMstDto);
                                    continue;
                                }
                                if (dto.getShppDivDtlCd().equals("22") && dto.getLastShppProgStatDtlNm().equals("\ud68c\uc218\uc9c0\uc2dc")) {
                                    orderMstDto.setOrder_status("E01");
                                    orderMstDto.setResult_code("1");
                                    dtolist.add(orderMstDto);
                                    continue;
                                }
                                if (!dto.getShppDivDtlCd().equals("22") || !dto.getLastShppProgStatDtlNm().equals("\ud68c\uc218\uc644\ub8cc")) continue;
                                orderMstDto.setOrder_status("E02");
                                orderMstDto.setResult_code("1");
                                temp = orderMstDto.clone("E02");
                                temp.setOrder_date(dto.getRcovCmplDt());
                                dtolist.add(temp);
                                dtolist.add(orderMstDto);
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG\ub2f7\ucef4 \ubc18\ud488\uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<ShopOrderMstDto> cancleList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startDate, String endDate) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Request request2 = new Request.Builder().url(Host.concat("/api/claim/v2/cancel/requests?perdStrDts=" + startDate + "&perdEndDts=" + endDate)).method("GET", null).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    SSGOrderDto.ResponseCancelProcess ResponseCancelProcess2 = (SSGOrderDto.ResponseCancelProcess)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseCancelProcess.class);
                    if (ResponseCancelProcess2.getResult().getResultCode().equals("00") && ResponseCancelProcess2.getResult().getResultData() != null) {
                        for (SSGOrderDto.ResponseCancelProcess.Result.resultData dto : ResponseCancelProcess2.getResult().getResultData()) {
                            String ordNum = dto.getOrdNo();
                            String exp_cd = dto.getOrdItemSeq();
                            String product_id = dto.getItemId();
                            for (ShopOrderMstDto orderMstDto : param) {
                                if (!orderMstDto.getOrder_id().equals(ordNum) || !orderMstDto.getMall_exp_cd().equals(exp_cd) || !orderMstDto.getMall_product_id().equals(product_id)) continue;
                                orderMstDto.setOrder_status("C01");
                                orderMstDto.setResult_code("1");
                                dtolist.add(orderMstDto);
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            String url = "/api/clm/cncl/ord/inquiry.ssg";
            String json = this.setCancelRequestParams(startDate, endDate);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request1 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Object object = null;
                Object var13_18 = null;
                try (Response response = this.client.newCall(request1).execute();){
                    SSGOrderDto.ResponseCancelProcess1 ResponseCancelProcess3 = (SSGOrderDto.ResponseCancelProcess1)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseCancelProcess1.class);
                    if (ResponseCancelProcess3.getResult().getResultCode().equals("00") && ResponseCancelProcess3.getResult().getData() != null) {
                        for (SSGOrderDto.ResponseCancelProcess1.Result.Data dto : ResponseCancelProcess3.getResult().getData()) {
                            String ordNum = dto.getOrordNo();
                            String exp_cd = dto.getOrdItemSeq();
                            String product_id = dto.getItemId();
                            int returnqty = Integer.parseInt(dto.getCnclItemQty());
                            for (ShopOrderMstDto orderMstDto : param) {
                                if (!orderMstDto.getOrder_id().equals(ordNum) || !orderMstDto.getMall_exp_cd().equals(exp_cd) || !orderMstDto.getMall_product_id().equals(product_id)) continue;
                                if (dto.getOrdItemStatNm().equals("\uc8fc\ubb38\ucde8\uc18c")) {
                                    orderMstDto.setOrder_status("C02");
                                    orderMstDto.setResult_code("1");
                                    ShopOrderMstDto temp = orderMstDto.clone("C02");
                                    temp.setCopy_idx("");
                                    temp.setOrder_date(dto.getOrdCnclDts());
                                    if (YDMAStringUtil.convertToInt(orderMstDto.getSale_cnt()) > returnqty) {
                                        int cost = YDMAStringUtil.convertToInt(orderMstDto.getSale_cost()) * -1;
                                        int cnt = returnqty * -1;
                                        int woncost = YDMAStringUtil.convertToInt(orderMstDto.getWon_cost()) / YDMAStringUtil.convertToInt(orderMstDto.getSale_cnt()) * returnqty;
                                        temp.setSale_cnt(String.valueOf(cnt));
                                        temp.setSale_cost(String.valueOf(cost));
                                        temp.setTotal_cost(String.valueOf(cost));
                                        temp.setWon_cost(String.valueOf(woncost));
                                    }
                                    dtolist.add(temp);
                                }
                                dtolist.add(orderMstDto);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG\ub2f7\ucef4 \ucde8\uc18c \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> orderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt) throws Exception {
        String shppNo;
        String ordNo;
        String shppSeq;
        Object responseShppDirection;
        Object var11_15;
        MediaType mediaType;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = this.setListDeliveryRequestParams(param);
            mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/listNonDelivery.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                var11_15 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    responseShppDirection = (SSGOrderDto.DeliveryListReponseBody)mapper.readValue(response.body().string().toString(), SSGOrderDto.DeliveryListReponseBody.class);
                    if (((SSGOrderDto.DeliveryListReponseBody)responseShppDirection).result.resultCode.equals("00")) {
                        for (SSGOrderDto.DeliveryListReponseBody.Result.NonDelivery nonDelivery : ((SSGOrderDto.DeliveryListReponseBody)responseShppDirection).result.nonDeliverys) {
                            shppSeq = nonDelivery.shppSeq;
                            ordNo = nonDelivery.ordNo;
                            shppNo = nonDelivery.shppNo;
                            for (ShopOrderMstDto shopOrderDto : param) {
                                if (!shopOrderDto.getMall_exp_cd().equals(shppSeq) || !shopOrderDto.getOrder_id().equals(ordNo) || !shopOrderDto.getCopy_idx().equals(shppNo)) continue;
                                shopOrderDto.setOrder_status("403");
                                shopOrderDto.setResult_code("1");
                                shopOrderDto.setDelivery_id(nonDelivery.delicoVenId);
                                shopOrderDto.setInvoice_no(nonDelivery.wblNo);
                                dtolist.add(shopOrderDto);
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG \ubc30\uc1a1 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        String completionJson = this.setListDeliveryCompletionRequestParams(param);
        mediaType = MediaType.parse((String)"");
        RequestBody completionBody = RequestBody.create((MediaType)mediaType, (String)completionJson);
        Request completionRequest = new Request.Builder().url(Host.concat("/api/pd/1/listDeliveryEnd.ssg")).method("POST", completionBody).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
        try {
            Throwable e = null;
            var11_15 = null;
            try (Response completionResponse = this.client.newCall(completionRequest).execute();){
                responseShppDirection = (SSGOrderDto.DeliveryCompletionListReponseBody)mapper.readValue(completionResponse.body().string().toString(), SSGOrderDto.DeliveryCompletionListReponseBody.class);
                if (((SSGOrderDto.DeliveryCompletionListReponseBody)responseShppDirection).result.resultCode.equals("00")) {
                    for (SSGOrderDto.DeliveryCompletionListReponseBody.Result.DeliveryEnd deliveryEnd : ((SSGOrderDto.DeliveryCompletionListReponseBody)responseShppDirection).result.deliveryEnds) {
                        shppSeq = deliveryEnd.shppSeq;
                        ordNo = deliveryEnd.ordNo;
                        shppNo = deliveryEnd.shppNo;
                        for (ShopOrderMstDto shopOrderDto : param) {
                            if (!shopOrderDto.getMall_exp_cd().equals(shppSeq) || !shopOrderDto.getOrder_id().equals(ordNo) || !shopOrderDto.getCopy_idx().equals(shppNo) || !deliveryEnd.lastShppProgStatDtlCd.equals("51")) continue;
                            shopOrderDto.setOrder_status("410");
                            shopOrderDto.setResult_code("1");
                            dtolist.add(shopOrderDto);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return dtolist;
    }

    private String setRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqShppDirection reqShppDirection = new SSGOrderDto.ReqShppDirection();
            reqShppDirection.requestShppDirection = new SSGOrderDto.ReqShppDirection.RequestShppDirection();
            reqShppDirection.requestShppDirection.perdType = "02";
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + "-" + ((String)startDate).substring(4, 6) + "-" + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + "-" + ((String)endDate).substring(4, 6) + "-" + ((String)endDate).substring(6, 8);
            reqShppDirection.requestShppDirection.perdStrDts = startDate;
            reqShppDirection.requestShppDirection.perdEndDts = endDate;
            reqShppDirection.requestShppDirection.shppStatCd = "10";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqShppDirection);
        }
        catch (Exception exception) {}
        return json;
    }

    private String setCancelRequestParams(String startDate, String endDate) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqCancelProcess ReqCancelProcess2 = new SSGOrderDto.ReqCancelProcess();
            ReqCancelProcess2.request = new SSGOrderDto.ReqCancelProcess.Request();
            ReqCancelProcess2.getRequest().perdStrDts = startDate;
            ReqCancelProcess2.getRequest().perdEndDts = endDate;
            ReqCancelProcess2.getRequest().orordNo = "";
            ReqCancelProcess2.getRequest().orordItemSeqs = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)ReqCancelProcess2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private String setCancelRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            String date;
            SSGOrderDto.ReqCancelProcess ReqCancelProcess2 = new SSGOrderDto.ReqCancelProcess();
            ReqCancelProcess2.request = new SSGOrderDto.ReqCancelProcess.Request();
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + ((String)startDate).substring(4, 6) + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + ((String)endDate).substring(4, 6) + ((String)endDate).substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            ReqCancelProcess2.getRequest().perdStrDts = date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            ReqCancelProcess2.getRequest().perdEndDts = endDate;
            ReqCancelProcess2.getRequest().orordNo = "";
            ReqCancelProcess2.getRequest().orordItemSeqs = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)ReqCancelProcess2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private String setListDeliveryRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + ((String)startDate).substring(4, 6) + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + ((String)endDate).substring(4, 6) + ((String)endDate).substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            SSGOrderDto.ReqDeliveryParameter reqDeliveryParameter = new SSGOrderDto.ReqDeliveryParameter();
            reqDeliveryParameter.requestNonDelivery = new SSGOrderDto.ReqDeliveryParameter.RequestNonDelivery();
            reqDeliveryParameter.requestNonDelivery.perdType = "01";
            reqDeliveryParameter.requestNonDelivery.perdStrDts = date;
            reqDeliveryParameter.requestNonDelivery.perdEndDts = endDate;
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqDeliveryParameter);
        }
        catch (Exception exception) {}
        return json;
    }

    private String setReturnDeliveryRequestParams(String startDate, String endDate) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqReturnDeliveryParameter reqReturnDeliveryParameter = new SSGOrderDto.ReqReturnDeliveryParameter();
            reqReturnDeliveryParameter.requestExchangeTarget = new SSGOrderDto.ReqReturnDeliveryParameter.RequestExchangeTarget();
            reqReturnDeliveryParameter.requestExchangeTarget.perdType = "01";
            reqReturnDeliveryParameter.requestExchangeTarget.perdStrDts = startDate;
            reqReturnDeliveryParameter.requestExchangeTarget.perdEndDts = endDate;
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqReturnDeliveryParameter);
        }
        catch (Exception exception) {}
        return json;
    }

    private String setReturnDeliveryRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + ((String)startDate).substring(4, 6) + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + ((String)endDate).substring(4, 6) + ((String)endDate).substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            SSGOrderDto.ReqReturnDeliveryParameter reqReturnDeliveryParameter = new SSGOrderDto.ReqReturnDeliveryParameter();
            reqReturnDeliveryParameter.requestExchangeTarget = new SSGOrderDto.ReqReturnDeliveryParameter.RequestExchangeTarget();
            reqReturnDeliveryParameter.requestExchangeTarget.perdType = "01";
            reqReturnDeliveryParameter.requestExchangeTarget.perdStrDts = date;
            reqReturnDeliveryParameter.requestExchangeTarget.perdEndDts = endDate;
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqReturnDeliveryParameter);
        }
        catch (Exception exception) {}
        return json;
    }

    private String setListDeliveryCompletionRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + ((String)startDate).substring(4, 6) + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + ((String)endDate).substring(4, 6) + ((String)endDate).substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            SSGOrderDto.ReqDeliveryCompletionParameter reqDeliveryCompletionParameter = new SSGOrderDto.ReqDeliveryCompletionParameter();
            reqDeliveryCompletionParameter.requestDeliveryEnd = new SSGOrderDto.ReqDeliveryCompletionParameter.RequestDeliveryEnd();
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdType = "01";
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdStrDts = date;
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdEndDts = endDate;
            reqDeliveryCompletionParameter.requestDeliveryEnd.commType = "";
            reqDeliveryCompletionParameter.requestDeliveryEnd.commValue = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqDeliveryCompletionParameter);
        }
        catch (Exception exception) {}
        return json;
    }
}

