/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jobLog;

import com.kdjsystem.mlink.shop.jobLog.JobLogBatchDTO;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.cloudinary.json.JSONObject;

public class JobLogInterfaceDao {
    private static final JobLogInterfaceDao INSTANCE = new JobLogInterfaceDao();
    private static final String USER_ID = YDMASessonUtil.getCompnoInfo().getUserId();
    private static final String HOST = "http://api.kdjsystem.com:8080";

    private JobLogInterfaceDao() {
    }

    public static JobLogInterfaceDao get() {
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<JobLogBatchDTO> getPendingJobLogGroups(Timestamp cutoff) throws Exception {
        ArrayList<JobLogBatchDTO> result = new ArrayList<JobLogBatchDTO>();
        String sql = "SELECT LEFT(JOBDATE, 10) AS JOBDATE,        JOBTYPE, JOBMAIN, JOBSUB,        COUNT(*) AS JOBLOG_COUNT   FROM joblog  WHERE JOBDATE < ?    AND INTERFACE_FLAG = 'N'  GROUP BY LEFT(JOBDATE, 10), JOBTYPE, JOBMAIN, JOBSUB";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Connection connection = DBCPInit.getInstance().getConnection();
            try {
                try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                    String cutoffStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(cutoff);
                    pstmt.setString(1, cutoffStr);
                    YDMAStringUtil.Print("[getPendingJobLogGroups]" + pstmt.toString());
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (ResultSet rs = pstmt.executeQuery();){
                        while (rs.next()) {
                            JobLogBatchDTO batch = new JobLogBatchDTO();
                            batch.setUserId(USER_ID);
                            batch.setJobDate(rs.getString("JOBDATE"));
                            batch.setJobType(rs.getString("JOBTYPE"));
                            batch.setJobMain(rs.getString("JOBMAIN"));
                            batch.setJobSub(rs.getString("JOBSUB"));
                            batch.setJobLogCount(rs.getInt("JOBLOG_COUNT"));
                            result.add(batch);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (connection == null) return result;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
            return result;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public int markJobLogsAsInterfaced(Timestamp cutoff) throws Exception {
        String sql = "UPDATE joblog    SET INTERFACE_FLAG = 'Y'  WHERE JOBDATE < ?";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            int n;
            PreparedStatement pstmt;
            Connection connection;
            block16: {
                block15: {
                    connection = DBCPInit.getInstance().getConnection();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setTimestamp(1, cutoff);
                    YDMAStringUtil.Print("[markJobLogsAsInterfaced]" + pstmt.toString());
                    n = pstmt.executeUpdate();
                    if (pstmt == null) break block15;
                    pstmt.close();
                }
                if (connection == null) break block16;
                connection.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public int callUserJoblogApi(JobLogBatchDTO batch) throws IOException {
        HttpURLConnection conn = null;
        int result = 0;
        try {
            InputStream is;
            URL url = new URL(HOST.concat("/api/v1/upsertUserJobLog"));
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            String jsonBody = "{" + "\"userId\":\"" + this.escapeJson(batch.getUserId()) + "\"," + "\"jobDate\":\"" + this.escapeJson(batch.getJobDate()) + "\"," + "\"jobType\":\"" + this.escapeJson(batch.getJobType()) + "\"," + "\"jobMain\":\"" + this.escapeJson(batch.getJobMain()) + "\"," + "\"jobSub\":\"" + this.escapeJson(batch.getJobSub()) + "\"," + "\"jobLogCount\":" + batch.getJobLogCount() + "}";
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStream os = conn.getOutputStream();){
                byte[] bodyBytes = jsonBody.getBytes(StandardCharsets.UTF_8);
                os.write(bodyBytes);
                os.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = conn.getResponseCode();
            InputStream inputStream = is = responseCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            if (is != null) {
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                String responseStr = baos.toString("UTF-8");
                System.out.println("Raw Response: " + responseStr);
                JSONObject json = new JSONObject(responseStr);
                result = json.getInt("returnCode");
                String returnMessage = json.getString("returnMessage");
                System.out.println("API \uacb0\uacfc \ucf54\ub4dc: " + result);
                System.out.println("API \uba54\uc2dc\uc9c0: " + returnMessage);
            }
            int n = result;
            return n;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void processPendingJobLogs() {
        Timestamp cutoff = new Timestamp(System.currentTimeMillis());
        try {
            List<JobLogBatchDTO> batches = this.getPendingJobLogGroups(cutoff);
            for (JobLogBatchDTO batch : batches) {
                try {
                    int result = this.callUserJoblogApi(batch);
                    if (result == 1) continue;
                    System.err.println("user_joblog API \uc2e4\ud328: " + String.valueOf(batch));
                }
                catch (IOException e) {
                    System.err.println("user_joblog API \ud638\ucd9c \uc624\ub958: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            int updated = this.markJobLogsAsInterfaced(cutoff);
            System.out.println("INTERFACE_FLAG='Y' \uc5c5\ub370\uc774\ud2b8 \uac74\uc218: " + updated);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

