/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.HomeWorkDataQueue;
import com.kdjsystem.mlink.shop.mlink.MLinkShopStateUpdate;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.File;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class HomeWorkBackground
extends Thread {
    private static HomeWorkBackground instance = new HomeWorkBackground();
    private ExecutorService executorService;
    private CompletionHandler<ShoppingMallDetailDto, ShoppingMallDetailDto> callback = new CompletionHandler<ShoppingMallDetailDto, ShoppingMallDetailDto>(){

        @Override
        public void completed(ShoppingMallDetailDto result, ShoppingMallDetailDto attachment) {
            try {
                HomeWorkDataQueue.get().modify(result);
                if (result.getNeworder() > 0) {
                    HomeWorkBackground.this.audio(result.getNeworder());
                }
                HomeWorkDataQueue.get().notifyObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void failed(Throwable exc, ShoppingMallDetailDto attachment) {
        }
    };

    private HomeWorkBackground() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public static HomeWorkBackground get() {
        return instance;
    }

    public void startBackground() {
        Thread.State state = this.getState();
        if (state == Thread.State.NEW) {
            this.setDaemon(true);
            this.start();
            YDMAStringUtil.Print("\uc2a4\ub808\ub4dc \uc2dc\uc791");
        }
    }

    private Runnable getRunnableRegister(ShoppingMallDetailDto shopinfo) {
        Runnable run = () -> {
            try {
                ShoppingMallDetailDto result_dto = MLinkShopStateUpdate.get().mallStatusUpdate(true, shopinfo);
                this.callback.completed(result_dto, result_dto);
            }
            catch (Exception exception) {
                this.callback.completed(shopinfo, shopinfo);
            }
        };
        return run;
    }

    public void audio(int ais) {
        try {
            String path = YDMASessonUtil.getAppPath() + "\\YDwmsData\\06.Image\\bell.wav";
            File file = new File(path);
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(file));
            clip.loop(ais);
            clip.start();
            Thread.sleep(3000L);
            clip.stop();
            clip.close();
        }
        catch (Exception exception) {}
    }

    @Override
    public void run() {
        ShopPreferencesDto dto1 = null;
        try {
            dto1 = ShopCommonDao.get().getSystemConf();
            if (dto1.getAutostat() == 0) {
                dto1.setAutostat(5000);
            }
        }
        catch (Exception exception) {}
        while (true) {
            ExecutorService executorService = HomeWorkDataQueue.get().getExecutorService();
            try {
                Thread.sleep(3000L);
                List<ShoppingMallDetailDto> shopinfolst = HomeWorkDataQueue.get().getWaitData();
                if (shopinfolst == null) continue;
                for (ShoppingMallDetailDto shopinfo : shopinfolst) {
                    executorService.submit(this.getRunnableRegister(shopinfo));
                }
                executorService.awaitTermination(dto1.getAutostat(), TimeUnit.MINUTES);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

