/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.xml;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopOptionProductInfoDao;
import com.kdjsystem.mlink.shop.dao.ShopProduct11stAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.CompInfoDao;
import com.kdjsystem.mlink.tot.data.dao.PickupDto;
import com.kdjsystem.mlink.tot.data.dao.ProductIforDao;
import com.kdjsystem.mlink.tot.data.dao.ProductMstDao;
import com.kdjsystem.mlink.tot.data.dao.ProductOptDao;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class YDWMXmlManager {
    public static void updateGetClaimListTemplate(String dateFrom, String dateTo) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.claimTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.claimTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(templateFullpath);
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        Element root = document.getDocumentElement();
        root.normalize();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        Node nodeCompayny_id = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_COMPAYNY_ID", document, XPathConstants.NODE);
        Node nodeAuth_key = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_AUTH_KEY", document, XPathConstants.NODE);
        Node nodeSendDay = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_DATE", document, XPathConstants.NODE);
        Node nodeFrom = (Node)xpath.evaluate("/SABANG_ORDER_LIST/DATA/CLM_ST_DATE", document, XPathConstants.NODE);
        Node nodeTo = (Node)xpath.evaluate("/SABANG_ORDER_LIST/DATA/CLM_ED_DATE", document, XPathConstants.NODE);
        nodeCompayny_id.setTextContent(compInfo.get(2));
        nodeAuth_key.setTextContent(compInfo.get(3));
        nodeSendDay.setTextContent(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd"));
        nodeFrom.setTextContent(dateFrom);
        nodeTo.setTextContent(dateTo);
        YDMAStringUtil.Print("claim call date in xml : " + nodeSendDay.getTextContent());
        YDMAStringUtil.Print("claim date in xml : " + dateFrom + " ~ " + dateTo);
        YDWMXmlManager.writeToXml(root, templateFullpath);
    }

    public static void updateGetOrderListTemplate(String dateFrom, String dateTo) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.orderTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.orderTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(templateFullpath);
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        Element root = document.getDocumentElement();
        root.normalize();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        Node nodeCompayny_id = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_COMPAYNY_ID", document, XPathConstants.NODE);
        Node nodeAuth_key = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_AUTH_KEY", document, XPathConstants.NODE);
        Node nodeSendDay = (Node)xpath.evaluate("/SABANG_ORDER_LIST/HEADER/SEND_DATE", document, XPathConstants.NODE);
        Node nodeFrom = (Node)xpath.evaluate("/SABANG_ORDER_LIST/DATA/ORD_ST_DATE", document, XPathConstants.NODE);
        Node nodeTo = (Node)xpath.evaluate("/SABANG_ORDER_LIST/DATA/ORD_ED_DATE", document, XPathConstants.NODE);
        Node order_status = (Node)xpath.evaluate("/SABANG_ORDER_LIST/DATA/ORDER_STATUS", document, XPathConstants.NODE);
        nodeCompayny_id.setTextContent(compInfo.get(2));
        nodeAuth_key.setTextContent(compInfo.get(3));
        nodeSendDay.setTextContent(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd"));
        nodeFrom.setTextContent(dateFrom);
        nodeTo.setTextContent(dateTo);
        order_status.setTextContent("'002");
        YDMAStringUtil.Print("order call date in xml : " + nodeSendDay.getTextContent());
        YDMAStringUtil.Print("order date in xml : " + dateFrom + " ~ " + dateTo);
        YDWMXmlManager.writeToXml(root, templateFullpath);
    }

    public static void updateSendProductListTemplate(List<List<String>> contents, boolean isNew, Shell shell) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.productTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.productTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("SABANG_GOODS_REGI");
        ROOT.normalize();
        Element HEADER = document.createElement("HEADER");
        ROOT.appendChild(HEADER);
        Element SEND_COMPAYNY_ID = document.createElement("SEND_COMPAYNY_ID");
        SEND_COMPAYNY_ID.appendChild(document.createCDATASection(compInfo.get(2)));
        HEADER.appendChild(SEND_COMPAYNY_ID);
        Element SEND_AUTH_KEY = document.createElement("SEND_AUTH_KEY");
        SEND_AUTH_KEY.appendChild(document.createCDATASection(compInfo.get(3)));
        HEADER.appendChild(SEND_AUTH_KEY);
        Element SEND_DATE = document.createElement("SEND_DATE");
        SEND_DATE.appendChild(document.createCDATASection(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd")));
        HEADER.appendChild(SEND_DATE);
        Element SEND_GOODS_CD_RT = document.createElement("SEND_GOODS_CD_RT");
        SEND_GOODS_CD_RT.appendChild(document.createCDATASection("Y"));
        HEADER.appendChild(SEND_GOODS_CD_RT);
        Element RESULT_TYPE = document.createElement("RESULT_TYPE");
        RESULT_TYPE.appendChild(document.createCDATASection("XML"));
        HEADER.appendChild(RESULT_TYPE);
        for (List<String> list : contents) {
            ProductMstDao mdao = new ProductMstDao();
            List<String> mstlist = mdao.getNumberInforMationProperty(list.get(1));
            ProductIforDao idao = new ProductIforDao();
            if (mstlist.get(1) != null && mstlist.get(0) != null) {
                List<Object> infodao = new ArrayList();
                infodao = idao.getOpen(mstlist.get(0));
                Element DATA = document.createElement("DATA");
                ROOT.appendChild(DATA);
                Element GOODS_NM = document.createElement("GOODS_NM");
                if (list.get(2).getBytes().length > 100) {
                    byte[] strByte = list.get(2).getBytes();
                    String newTitle = new String(strByte, 0, 100);
                    GOODS_NM.appendChild(document.createCDATASection(newTitle));
                } else {
                    GOODS_NM.appendChild(document.createCDATASection(list.get(2)));
                }
                DATA.appendChild(GOODS_NM);
                Element MODEL_NM = document.createElement("MODEL_NM");
                MODEL_NM.appendChild(document.createCDATASection(list.get(1)));
                DATA.appendChild(MODEL_NM);
                Element BRAND_NM = document.createElement("BRAND_NM");
                BRAND_NM.appendChild(document.createCDATASection((String)infodao.get(2)));
                DATA.appendChild(BRAND_NM);
                Element COMPAYNY_GOODS_CD = document.createElement("COMPAYNY_GOODS_CD");
                COMPAYNY_GOODS_CD.appendChild(document.createCDATASection(list.get(1)));
                DATA.appendChild(COMPAYNY_GOODS_CD);
                Element GOODS_SEARCH = document.createElement("GOODS_SEARCH");
                GOODS_SEARCH.appendChild(document.createCDATASection(list.get(12)));
                DATA.appendChild(GOODS_SEARCH);
                Element GOODS_GUBUN = document.createElement("GOODS_GUBUN");
                GOODS_GUBUN.appendChild(document.createCDATASection((String)infodao.get(3)));
                DATA.appendChild(GOODS_GUBUN);
                Element MAKER = document.createElement("MAKER");
                MAKER.appendChild(document.createCDATASection((String)infodao.get(4)));
                DATA.appendChild(MAKER);
                Element ORIGIN = document.createElement("ORIGIN");
                ORIGIN.appendChild(document.createCDATASection((String)infodao.get(19)));
                DATA.appendChild(ORIGIN);
                if (isNew) {
                    Element CLASS_CD1 = document.createElement("CLASS_CD1");
                    if (list.get(13).length() < 3) {
                        CLASS_CD1.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD1.appendChild(document.createCDATASection(list.get(13)));
                    }
                    DATA.appendChild(CLASS_CD1);
                    Element CLASS_CD2 = document.createElement("CLASS_CD2");
                    if (list.get(14).length() < 3) {
                        CLASS_CD2.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD2.appendChild(document.createCDATASection(list.get(14).substring(list.get(14).length() - 3, list.get(14).length())));
                    }
                    DATA.appendChild(CLASS_CD2);
                    Element CLASS_CD3 = document.createElement("CLASS_CD3");
                    if (list.get(15).length() < 3) {
                        CLASS_CD3.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD3.appendChild(document.createCDATASection(list.get(15).substring(list.get(15).length() - 3, list.get(15).length())));
                    }
                    DATA.appendChild(CLASS_CD3);
                    Element CLASS_CD4 = document.createElement("CLASS_CD4");
                    if (list.get(16).length() < 3) {
                        CLASS_CD4.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD4.appendChild(document.createCDATASection(list.get(16).substring(list.get(16).length() - 3, list.get(16).length())));
                    }
                    DATA.appendChild(CLASS_CD4);
                } else {
                    List<String> categ = mdao.getCategoryList(list.get(1));
                    Element CLASS_CD1 = document.createElement("CLASS_CD1");
                    if (categ.get(0).length() < 3) {
                        CLASS_CD1.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD1.appendChild(document.createCDATASection(categ.get(0)));
                    }
                    DATA.appendChild(CLASS_CD1);
                    Element CLASS_CD2 = document.createElement("CLASS_CD2");
                    if (categ.get(1).length() < 3) {
                        CLASS_CD2.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD2.appendChild(document.createCDATASection(categ.get(1).substring(categ.get(1).length() - 3, categ.get(1).length())));
                    }
                    DATA.appendChild(CLASS_CD2);
                    Element CLASS_CD3 = document.createElement("CLASS_CD3");
                    if (categ.get(2).length() < 3) {
                        CLASS_CD3.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD3.appendChild(document.createCDATASection(categ.get(2).substring(categ.get(2).length() - 3, categ.get(2).length())));
                    }
                    DATA.appendChild(CLASS_CD3);
                    Element CLASS_CD4 = document.createElement("CLASS_CD4");
                    if (categ.get(3).length() < 3) {
                        CLASS_CD4.appendChild(document.createCDATASection("NULL"));
                    } else {
                        CLASS_CD4.appendChild(document.createCDATASection(categ.get(3).substring(categ.get(3).length() - 3, categ.get(3).length())));
                    }
                    DATA.appendChild(CLASS_CD4);
                }
                Element GOODS_SEASON = document.createElement("GOODS_SEASON");
                GOODS_SEASON.appendChild(document.createCDATASection((String)infodao.get(6)));
                DATA.appendChild(GOODS_SEASON);
                Element SEX = document.createElement("SEX");
                SEX.appendChild(document.createCDATASection((String)infodao.get(7)));
                DATA.appendChild(SEX);
                Element STATUS = document.createElement("STATUS");
                STATUS.appendChild(document.createCDATASection((String)infodao.get(8)));
                DATA.appendChild(STATUS);
                Element DELIV_ABLE_REGION = document.createElement("DELIV_ABLE_REGION");
                DELIV_ABLE_REGION.appendChild(document.createCDATASection((String)infodao.get(9)));
                DATA.appendChild(DELIV_ABLE_REGION);
                Element TAX_YN = document.createElement("TAX_YN");
                TAX_YN.appendChild(document.createCDATASection((String)infodao.get(12)));
                DATA.appendChild(TAX_YN);
                Element DELV_TYPE = document.createElement("DELV_TYPE");
                DELV_TYPE.appendChild(document.createCDATASection((String)infodao.get(10)));
                DATA.appendChild(DELV_TYPE);
                Element DELV_COST = document.createElement("DELV_COST");
                DELV_COST.appendChild(document.createCDATASection("'" + (String)infodao.get(11)));
                DATA.appendChild(DELV_COST);
                Element GOODS_PRICE = document.createElement("GOODS_PRICE");
                GOODS_PRICE.appendChild(document.createCDATASection(list.get(4)));
                DATA.appendChild(GOODS_PRICE);
                Element GOODS_CONSUMER_PRICE = document.createElement("GOODS_CONSUMER_PRICE");
                GOODS_CONSUMER_PRICE.appendChild(document.createCDATASection(list.get(5)));
                DATA.appendChild(GOODS_CONSUMER_PRICE);
                Element CHAR_1_NM = document.createElement("CHAR_1_NM");
                CHAR_1_NM.appendChild(document.createCDATASection((String)infodao.get(14)));
                DATA.appendChild(CHAR_1_NM);
                Element CHAR_2_NM = document.createElement("CHAR_2_NM");
                CHAR_2_NM.appendChild(document.createCDATASection((String)infodao.get(15)));
                DATA.appendChild(CHAR_2_NM);
                Element CHAR_1_VAL = document.createElement("CHAR_1_VAL");
                Object char_2_val = "";
                String[] aaa = new String[]{"", "", "", "", "", "", "", ""};
                int num = 0;
                if (!"1".equals(infodao.get(13))) {
                    ProductOptDao dao = new ProductOptDao();
                    List<List<String>> contents_opt = dao.getProdcutOptList(list.get(1));
                    Object char_1_val = "";
                    String optsale = "";
                    int i = 0;
                    while (i < contents_opt.size()) {
                        List<String> list_opt = contents_opt.get(i);
                        if (isNew) {
                            if (list.get(17).equals("Y")) {
                                optsale = "004";
                            } else if ("1".equals(list_opt.get(5))) {
                                optsale = "002";
                            } else if ("1".equals(list_opt.get(6))) {
                                optsale = "004";
                            } else if ("1".equals(list_opt.get(7))) {
                                optsale = "005";
                            }
                        } else if (list.get(15).equals("Y")) {
                            optsale = "004";
                        } else if ("1".equals(list_opt.get(5))) {
                            optsale = "002";
                        } else if ("1".equals(list_opt.get(6))) {
                            optsale = "004";
                        } else if ("1".equals(list_opt.get(7))) {
                            optsale = "005";
                        }
                        String optprodcd = list_opt.get(1);
                        String optprodnm = list_opt.get(2);
                        String optspecdes = list_opt.get(3);
                        String optea = list_opt.get(4);
                        String optsafestock = list_opt.get(8);
                        String optvertstock = list_opt.get(9);
                        String optaddamt = list_opt.get(10);
                        String optspecdes1 = optspecdes;
                        String optspecdes2 = "";
                        boolean flagfind = false;
                        int idx = 0;
                        idx = optspecdes.indexOf(":");
                        if (idx > 0) {
                            optspecdes1 = optspecdes.substring(0, idx);
                            optspecdes2 = optspecdes.substring(idx + 1);
                            char_1_val = (String)char_1_val + optprodnm + "_" + optspecdes1 + "^^" + optvertstock + "^^" + optaddamt + "^^^^" + optea + "^^" + optsale + "^^L^^^^" + optsafestock;
                            int idx2 = 0;
                            while (idx2 < aaa.length) {
                                if (aaa[idx2].equals(optspecdes2)) {
                                    flagfind = true;
                                    break;
                                }
                                ++idx2;
                            }
                            if (!flagfind) {
                                aaa[num] = optspecdes2;
                                char_2_val = (String)char_2_val + optspecdes2 + "(" + optprodcd + ")";
                                if (i < contents_opt.size() - 1) {
                                    char_2_val = (String)char_2_val + ",";
                                }
                                ++num;
                            }
                        } else {
                            char_1_val = (String)char_1_val + optprodnm + "_" + optspecdes1 + "(" + optprodcd + ")^^" + optvertstock + "^^" + optaddamt + "^^^^" + optea + "^^" + optsale + "^^L^^^^" + optsafestock;
                        }
                        if (i < contents_opt.size() - 1) {
                            char_1_val = (String)char_1_val + ",";
                        }
                        ++i;
                    }
                    CHAR_1_VAL.appendChild(document.createCDATASection((String)char_1_val));
                } else {
                    String prodnm = list.get(2);
                    Object specdes = "";
                    if (list.get(3) != null && list.get(3).trim().length() > 0) {
                        specdes = "_" + list.get(3);
                    }
                    String prodcd = list.get(1);
                    int len = YDMAStringUtil.length(prodnm);
                    String newProdnm = prodnm;
                    if (len > 20) {
                        newProdnm = YDMAStringUtil.Char_substring(prodnm, 20);
                    }
                    String ea = list.get(7) == null ? "0" : list.get(7);
                    String useyn = "";
                    useyn = isNew ? (list.get(17).equals("Y") ? "004" : "002") : (list.get(15).equals("Y") ? "004" : "002");
                    String char_1_val = newProdnm + (String)specdes + "(" + prodcd + ")^^999^^^^^^" + ea + "^^" + useyn + "^^L^^^^";
                    YDMAStringUtil.Print(char_1_val);
                    CHAR_1_VAL.appendChild(document.createCDATASection(char_1_val));
                }
                DATA.appendChild(CHAR_1_VAL);
                Element CHAR_2_VAL = document.createElement("CHAR_2_VAL");
                CHAR_2_VAL.appendChild(document.createCDATASection((String)char_2_val));
                DATA.appendChild(CHAR_2_VAL);
                Element IMG_PATH = document.createElement("IMG_PATH");
                IMG_PATH.appendChild(document.createCDATASection(list.get(9)));
                DATA.appendChild(IMG_PATH);
                Element IMG_PATH6 = document.createElement("IMG_PATH6");
                IMG_PATH6.appendChild(document.createCDATASection(list.get(10)));
                DATA.appendChild(IMG_PATH6);
                Element IMG_PATH7 = document.createElement("IMG_PATH7");
                IMG_PATH7.appendChild(document.createCDATASection(list.get(11)));
                DATA.appendChild(IMG_PATH7);
                Element GOODS_REMARKS = document.createElement("GOODS_REMARKS");
                String remark = list.get(6);
                GOODS_REMARKS.appendChild(document.createCDATASection(remark));
                DATA.appendChild(GOODS_REMARKS);
                Element STOCK_USE_YN = document.createElement("STOCK_USE_YN");
                if (((String)infodao.get(16)).equals("1")) {
                    STOCK_USE_YN.appendChild(document.createCDATASection("N"));
                } else {
                    STOCK_USE_YN.appendChild(document.createCDATASection("Y"));
                }
                DATA.appendChild(STOCK_USE_YN);
                Element OPT_TYPE = document.createElement("OPT_TYPE");
                if (((String)infodao.get(17)).equals("1")) {
                    OPT_TYPE.appendChild(document.createCDATASection("2"));
                } else {
                    OPT_TYPE.appendChild(document.createCDATASection("9"));
                }
                DATA.appendChild(OPT_TYPE);
                Element PROP_EDIT_YN = document.createElement("PROP_EDIT_YN");
                PROP_EDIT_YN.appendChild(document.createCDATASection("Y"));
                DATA.appendChild(PROP_EDIT_YN);
                Element PROP1_CD = document.createElement("PROP1_CD");
                PROP1_CD.appendChild(document.createCDATASection(mstlist.get(1)));
                DATA.appendChild(PROP1_CD);
                List<List<String>> attrvals = idao.getSbapiSelect(mstlist.get(1));
                for (List<String> attrval : attrvals) {
                    if (attrval.get(1).equals("1") && !attrval.get(2).equals("")) {
                        Element PROP_VAL1 = document.createElement("PROP_VAL1");
                        PROP_VAL1.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL1);
                        continue;
                    }
                    if (attrval.get(1).equals("2") && !attrval.get(2).equals("")) {
                        Element PROP_VAL2 = document.createElement("PROP_VAL2");
                        PROP_VAL2.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL2);
                        continue;
                    }
                    if (attrval.get(1).equals("3") && !attrval.get(2).equals("")) {
                        Element PROP_VAL3 = document.createElement("PROP_VAL3");
                        PROP_VAL3.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL3);
                        continue;
                    }
                    if (attrval.get(1).equals("4") && !attrval.get(2).equals("")) {
                        Element PROP_VAL4 = document.createElement("PROP_VAL4");
                        PROP_VAL4.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL4);
                        continue;
                    }
                    if (attrval.get(1).equals("5") && !attrval.get(2).equals("")) {
                        Element PROP_VAL5 = document.createElement("PROP_VAL5");
                        PROP_VAL5.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL5);
                        continue;
                    }
                    if (attrval.get(1).equals("6") && !attrval.get(2).equals("")) {
                        Element PROP_VAL6 = document.createElement("PROP_VAL6");
                        PROP_VAL6.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL6);
                        continue;
                    }
                    if (attrval.get(1).equals("7") && !attrval.get(2).equals("")) {
                        Element PROP_VAL7 = document.createElement("PROP_VAL7");
                        PROP_VAL7.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL7);
                        continue;
                    }
                    if (attrval.get(1).equals("8") && !attrval.get(2).equals("")) {
                        Element PROP_VAL8 = document.createElement("PROP_VAL8");
                        PROP_VAL8.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL8);
                        continue;
                    }
                    if (attrval.get(1).equals("9") && !attrval.get(2).equals("")) {
                        Element PROP_VAL9 = document.createElement("PROP_VAL9");
                        PROP_VAL9.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL9);
                        continue;
                    }
                    if (attrval.get(1).equals("10") && !attrval.get(2).equals("")) {
                        Element PROP_VAL10 = document.createElement("PROP_VAL10");
                        PROP_VAL10.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL10);
                        continue;
                    }
                    if (attrval.get(1).equals("11") && !attrval.get(2).equals("")) {
                        Element PROP_VAL11 = document.createElement("PROP_VAL11");
                        PROP_VAL11.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL11);
                        continue;
                    }
                    if (attrval.get(1).equals("12") && !attrval.get(2).equals("")) {
                        Element PROP_VAL12 = document.createElement("PROP_VAL12");
                        PROP_VAL12.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL12);
                        continue;
                    }
                    if (attrval.get(1).equals("13") && !attrval.get(2).equals("")) {
                        Element PROP_VAL13 = document.createElement("PROP_VAL13");
                        PROP_VAL13.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL13);
                        continue;
                    }
                    if (attrval.get(1).equals("14") && !attrval.get(2).equals("")) {
                        Element PROP_VAL14 = document.createElement("PROP_VAL14");
                        PROP_VAL14.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL14);
                        continue;
                    }
                    if (attrval.get(1).equals("15") && !attrval.get(2).equals("")) {
                        Element PROP_VAL15 = document.createElement("PROP_VAL15");
                        PROP_VAL15.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL15);
                        continue;
                    }
                    if (attrval.get(1).equals("16") && !attrval.get(2).equals("")) {
                        Element PROP_VAL16 = document.createElement("PROP_VAL16");
                        PROP_VAL16.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL16);
                        continue;
                    }
                    if (attrval.get(1).equals("17") && !attrval.get(2).equals("")) {
                        Element PROP_VAL17 = document.createElement("PROP_VAL17");
                        PROP_VAL17.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL17);
                        continue;
                    }
                    if (attrval.get(1).equals("18") && !attrval.get(2).equals("")) {
                        Element PROP_VAL18 = document.createElement("PROP_VAL18");
                        PROP_VAL18.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL18);
                        continue;
                    }
                    if (attrval.get(1).equals("19") && !attrval.get(2).equals("")) {
                        Element PROP_VAL19 = document.createElement("PROP_VAL19");
                        PROP_VAL19.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL19);
                        continue;
                    }
                    if (attrval.get(1).equals("20") && !attrval.get(2).equals("")) {
                        Element PROP_VAL20 = document.createElement("PROP_VAL20");
                        PROP_VAL20.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL20);
                        continue;
                    }
                    if (attrval.get(1).equals("21") && !attrval.get(2).equals("")) {
                        Element PROP_VAL21 = document.createElement("PROP_VAL21");
                        PROP_VAL21.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL21);
                        continue;
                    }
                    if (attrval.get(1).equals("22") && !attrval.get(2).equals("")) {
                        Element PROP_VAL22 = document.createElement("PROP_VAL22");
                        PROP_VAL22.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL22);
                        continue;
                    }
                    if (attrval.get(1).equals("23") && !attrval.get(2).equals("")) {
                        Element PROP_VAL23 = document.createElement("PROP_VAL23");
                        PROP_VAL23.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL23);
                        continue;
                    }
                    if (attrval.get(1).equals("24") && !attrval.get(2).equals("")) {
                        Element PROP_VAL24 = document.createElement("PROP_VAL24");
                        PROP_VAL24.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL24);
                        continue;
                    }
                    if (attrval.get(1).equals("25") && !attrval.get(2).equals("")) {
                        Element PROP_VAL25 = document.createElement("PROP_VAL25");
                        PROP_VAL25.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL25);
                        continue;
                    }
                    if (attrval.get(1).equals("26") && !attrval.get(2).equals("")) {
                        Element PROP_VAL26 = document.createElement("PROP_VAL26");
                        PROP_VAL26.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL26);
                        continue;
                    }
                    if (attrval.get(1).equals("27") && !attrval.get(2).equals("")) {
                        Element PROP_VAL27 = document.createElement("PROP_VAL27");
                        PROP_VAL27.appendChild(document.createCDATASection(attrval.get(2)));
                        DATA.appendChild(PROP_VAL27);
                        continue;
                    }
                    if (!attrval.get(1).equals("28") || attrval.get(2).equals("")) continue;
                    Element PROP_VAL28 = document.createElement("PROP_VAL28");
                    PROP_VAL28.appendChild(document.createCDATASection(attrval.get(2)));
                    DATA.appendChild(PROP_VAL28);
                }
                continue;
            }
            MessageDialog.openInformation((Shell)shell, (String)"\uc0ac\ubc29\ub137\uc804\uc1a1", (String)"\uc815\ubcf4\ub97c \ubaa8\ub450 \uc785\ub825\ud6c4 \uc9c4\ud589\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4");
        }
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static void updateSendPickupExpressSabangNetTemplate(List<List<String>> contents, Shell shell) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("SABANG_INV_REGI");
        ROOT.normalize();
        Element HEADER = document.createElement("HEADER");
        ROOT.appendChild(HEADER);
        Element SEND_COMPAYNY_ID = document.createElement("SEND_COMPAYNY_ID");
        SEND_COMPAYNY_ID.appendChild(document.createTextNode(compInfo.get(2)));
        HEADER.appendChild(SEND_COMPAYNY_ID);
        Element SEND_AUTH_KEY = document.createElement("SEND_AUTH_KEY");
        SEND_AUTH_KEY.appendChild(document.createTextNode(compInfo.get(3)));
        HEADER.appendChild(SEND_AUTH_KEY);
        Element SEND_DATE = document.createElement("SEND_DATE");
        SEND_DATE.appendChild(document.createTextNode(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd")));
        HEADER.appendChild(SEND_DATE);
        Element SEND_GOODS_CD_RT = document.createElement("SEND_INV_EDIT_YN");
        SEND_GOODS_CD_RT.appendChild(document.createTextNode("Y"));
        HEADER.appendChild(SEND_GOODS_CD_RT);
        for (List<String> list : contents) {
            if (list.get(38).equals("") || list.get(39).equals("")) continue;
            Element DATA = document.createElement("DATA");
            ROOT.appendChild(DATA);
            Element SABANGNET_IDX = document.createElement("SABANGNET_IDX");
            SABANGNET_IDX.appendChild(document.createCDATASection(list.get(16)));
            DATA.appendChild(SABANGNET_IDX);
            Element TAK_CODE = document.createElement("TAK_CODE");
            if (!list.get(38).equals("")) {
                TAK_CODE.appendChild(document.createCDATASection(list.get(38).substring(list.get(38).length() - 3, list.get(38).length())));
            }
            DATA.appendChild(TAK_CODE);
            Element TAK_INVOICE = document.createElement("TAK_INVOICE");
            if (!list.get(39).equals("")) {
                TAK_INVOICE.appendChild(document.createCDATASection(list.get(39)));
            }
            DATA.appendChild(TAK_INVOICE);
            Element DELV_HOPE_DATE = document.createElement("DELV_HOPE_DATE");
            DELV_HOPE_DATE.appendChild(document.createCDATASection(""));
            DATA.appendChild(DELV_HOPE_DATE);
        }
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static void updateSendPickupExpressSabangNetTemplate2(List<PickupDto> contents, Shell shell) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("SABANG_INV_REGI");
        ROOT.normalize();
        Element HEADER = document.createElement("HEADER");
        ROOT.appendChild(HEADER);
        Element SEND_COMPAYNY_ID = document.createElement("SEND_COMPAYNY_ID");
        SEND_COMPAYNY_ID.appendChild(document.createTextNode(compInfo.get(2)));
        HEADER.appendChild(SEND_COMPAYNY_ID);
        Element SEND_AUTH_KEY = document.createElement("SEND_AUTH_KEY");
        SEND_AUTH_KEY.appendChild(document.createTextNode(compInfo.get(3)));
        HEADER.appendChild(SEND_AUTH_KEY);
        Element SEND_DATE = document.createElement("SEND_DATE");
        SEND_DATE.appendChild(document.createTextNode(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd")));
        HEADER.appendChild(SEND_DATE);
        Element SEND_GOODS_CD_RT = document.createElement("SEND_INV_EDIT_YN");
        SEND_GOODS_CD_RT.appendChild(document.createTextNode("Y"));
        HEADER.appendChild(SEND_GOODS_CD_RT);
        for (PickupDto list : contents) {
            String expnm = list.getExpnm();
            String inv = list.getInvno();
            if (expnm.equals("") || inv.equals("")) continue;
            Element DATA = document.createElement("DATA");
            ROOT.appendChild(DATA);
            Element SABANGNET_IDX = document.createElement("SABANGNET_IDX");
            SABANGNET_IDX.appendChild(document.createCDATASection(list.getSabordno()));
            DATA.appendChild(SABANGNET_IDX);
            Element TAK_CODE = document.createElement("TAK_CODE");
            TAK_CODE.appendChild(document.createCDATASection(expnm.substring(expnm.length() - 3, expnm.length())));
            DATA.appendChild(TAK_CODE);
            Element TAK_INVOICE = document.createElement("TAK_INVOICE");
            if (!inv.equals("")) {
                TAK_INVOICE.appendChild(document.createCDATASection(inv));
            }
            DATA.appendChild(TAK_INVOICE);
            Element DELV_HOPE_DATE = document.createElement("DELV_HOPE_DATE");
            DELV_HOPE_DATE.appendChild(document.createCDATASection(""));
            DATA.appendChild(DELV_HOPE_DATE);
        }
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static void SendQuestionTemplate(List<List<String>> contents) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.questionTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("sabang.questionTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        CompInfoDao compdao = new CompInfoDao();
        List<String> compInfo = compdao.getCompNoImage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("SABANG_CS_ANS_REGI");
        ROOT.normalize();
        Element HEADER = document.createElement("HEADER");
        ROOT.appendChild(HEADER);
        Element SEND_COMPAYNY_ID = document.createElement("SEND_COMPAYNY_ID");
        SEND_COMPAYNY_ID.appendChild(document.createCDATASection(compInfo.get(2)));
        HEADER.appendChild(SEND_COMPAYNY_ID);
        Element SEND_AUTH_KEY = document.createElement("SEND_AUTH_KEY");
        SEND_AUTH_KEY.appendChild(document.createCDATASection(compInfo.get(3)));
        HEADER.appendChild(SEND_AUTH_KEY);
        Element SEND_DATE = document.createElement("SEND_DATE");
        SEND_DATE.appendChild(document.createCDATASection(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd")));
        HEADER.appendChild(SEND_DATE);
        for (List<String> list : contents) {
            Element DATA = document.createElement("DATA");
            ROOT.appendChild(DATA);
            Element NUM = document.createElement("NUM");
            NUM.appendChild(document.createCDATASection(list.get(19)));
            DATA.appendChild(NUM);
            Element CS_RE_CONTENT = document.createElement("CS_RE_CONTENT");
            CS_RE_CONTENT.appendChild(document.createCDATASection(list.get(13)));
            DATA.appendChild(CS_RE_CONTENT);
        }
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static List<List<String>> parseResponseProduct(String respose) throws Exception {
        ArrayList<List<String>> resultContents = new ArrayList<List<String>>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        InputSource is = new InputSource(new StringReader(respose));
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(is);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile("SABANG_RESULT/DATA");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodeList.getLength()) {
            Node dataNode = nodeList.item(i);
            if (dataNode.getNodeType() == 1) {
                ArrayList<String> list = new ArrayList<String>();
                NodeList dataChildnodeList = dataNode.getChildNodes();
                int j = 0;
                while (j < dataChildnodeList.getLength()) {
                    Node dataChilNode = dataChildnodeList.item(j);
                    if (dataChilNode.getNodeType() == 1) {
                        list.add(dataChilNode.getTextContent());
                    }
                    ++j;
                }
                resultContents.add(list);
            }
            ++i;
        }
        return resultContents;
    }

    public static List<List<String>> parseResponseProduct11st(String respose, String prodcd) throws Exception {
        ArrayList<List<String>> resultContents = new ArrayList<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        InputSource is = new InputSource(new StringReader(respose));
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(is);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile("ClientMessage");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodeList.getLength()) {
            Node dataNode = nodeList.item(i);
            list.add(prodcd);
            if (dataNode.getNodeType() == 1) {
                NodeList dataChildnodeList = dataNode.getChildNodes();
                int j = 0;
                while (j < dataChildnodeList.getLength()) {
                    Node dataChilNode = dataChildnodeList.item(j);
                    if (dataChilNode.getNodeType() == 1) {
                        list.add(dataChilNode.getTextContent());
                    }
                    ++j;
                }
                resultContents.add(list);
            }
            ++i;
        }
        return resultContents;
    }

    /*
     * WARNING - void declaration
     */
    public static ShopProductDto parseResponseProductInsert11st(String respose, String prodcd, ShopProductDto dto, String shopinfo) throws Exception {
        ArrayList resultContents = new ArrayList();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            void var13_15;
            InputSource is = new InputSource(new StringReader(respose));
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile("ClientMessage");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            boolean bl = false;
            while (var13_15 < nodeList.getLength()) {
                ArrayList<String> list = new ArrayList<String>();
                NodeList child = nodeList.item((int)var13_15).getChildNodes();
                list.add(prodcd);
                int j = 0;
                while (j < child.getLength()) {
                    Node node = child.item(j);
                    list.add(node.getTextContent());
                    ++j;
                }
                resultContents.add(list);
                ++var13_15;
            }
            for (List list : resultContents) {
                if (list.size() == 5) {
                    if (((String)list.get(4)).equals("500")) {
                        dto.setResult_code("-1");
                        dto.setResult_text((String)list.get(1));
                        throw new Exception((String)list.get(1));
                    }
                    dto.setResult_code("1");
                    dto.setResult_text((String)list.get(1));
                    dto.setShopprodno((String)list.get(3));
                    YDMAProgressBar.get().setValue(shopinfo + "[" + dto.getCompayny_goods_cd() + "]-" + dto.getGoods_nm() + " \uc0c1\ud488\uc774 \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 100);
                    continue;
                }
                if (((String)list.get(3)).equals("500")) {
                    dto.setResult_code("-1");
                    dto.setResult_text((String)list.get(1));
                    throw new Exception((String)list.get(1));
                }
                dto.setResult_code("1");
                dto.setResult_text((String)list.get(1));
                dto.setShopprodno((String)list.get(3));
                YDMAProgressBar.get().setValue(shopinfo + "[" + dto.getCompayny_goods_cd() + "]-" + dto.getGoods_nm() + " \uc0c1\ud488\uc774 \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 100);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return dto;
    }

    public static void writeToXml(Element root, String filePath) throws Exception {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", "euc-kr");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(root);
        StreamResult result = new StreamResult(new File(filePath));
        transformer.transform(source, result);
    }

    public static void updateSendProductList11stTemplate(ShopProductDto dto, ShopProduct11stAdditionDto dtllist, ShoppingMallDetailDto idlist) throws Exception {
        int i;
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("11st.productListTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("11st.productListTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("Product");
        ROOT.normalize();
        Element selMthdCd = document.createElement("selMthdCd");
        selMthdCd.appendChild(document.createCDATASection(dtllist.getSelmthdcd()));
        ROOT.appendChild(selMthdCd);
        Element dispCtgrNo = document.createElement("dispCtgrNo");
        String categ = !dto.getShopCatInDto().getShopdetcatcd().equals("") ? dto.getShopCatInDto().getShopdetcatcd() : (!dto.getShopCatInDto().getShopsmlcatcd().equals("") ? dto.getShopCatInDto().getShopsmlcatcd() : (!dto.getShopCatInDto().getShopmidcatcd().equals("") ? dto.getShopCatInDto().getShopmidcatcd() : dto.getShopCatInDto().getShoplagcatcd()));
        dispCtgrNo.appendChild(document.createCDATASection(categ));
        ROOT.appendChild(dispCtgrNo);
        Element prdNm = document.createElement("prdNm");
        if (dto.getGoods_nm().getBytes().length > 50) {
            byte[] strByte = dto.getGoods_nm().getBytes();
            String newTitle = new String(strByte, 0, 50);
            prdNm.appendChild(document.createCDATASection(newTitle));
        } else {
            prdNm.appendChild(document.createCDATASection(dto.getGoods_nm()));
        }
        ROOT.appendChild(prdNm);
        Element brand = document.createElement("brand");
        brand.appendChild(document.createCDATASection(dto.getBrand_nm()));
        ROOT.appendChild(brand);
        Element mktPrdNm = document.createElement("mktPrdNm");
        if (dto.getGoods_search().getBytes().length > 50) {
            byte[] strByte = dto.getGoods_search().getBytes();
            String newTitle = new String(strByte, 0, 50);
            mktPrdNm.appendChild(document.createCDATASection(newTitle));
        } else {
            mktPrdNm.appendChild(document.createCDATASection(dto.getGoods_search()));
        }
        ROOT.appendChild(mktPrdNm);
        Element orgnTypCd = document.createElement("orgnTypCd");
        String orgin = "03";
        if (dto.getOrigin().equals("\uad6d\ub0b4\uc0b0") || dto.getOrigin().equals("\ub300\ud55c\ubbfc\uad6d")) {
            orgin = "01";
        }
        orgnTypCd.appendChild(document.createCDATASection(orgin));
        ROOT.appendChild(orgnTypCd);
        if (orgin.equals("03")) {
            Element orgnNmVal = document.createElement("orgnNmVal");
            orgnNmVal.appendChild(document.createCDATASection(dto.getOrigin()));
            ROOT.appendChild(orgnNmVal);
        }
        Element suplDtyfrPrdClfCd = document.createElement("suplDtyfrPrdClfCd");
        suplDtyfrPrdClfCd.appendChild(document.createCDATASection("0" + dto.getTax_yn()));
        ROOT.appendChild(suplDtyfrPrdClfCd);
        Element prdStatCd = document.createElement("prdStatCd");
        prdStatCd.appendChild(document.createCDATASection(dtllist.getProdstatcd()));
        ROOT.appendChild(prdStatCd);
        Element minorSelCnYn = document.createElement("minorSelCnYn");
        minorSelCnYn.appendChild(document.createCDATASection(dtllist.getMinorselcnyn()));
        ROOT.appendChild(minorSelCnYn);
        Element prdImage01 = document.createElement("prdImage01");
        prdImage01.appendChild(document.createCDATASection(dto.getImg_path()));
        ROOT.appendChild(prdImage01);
        Element prdImage02 = document.createElement("prdImage02");
        prdImage02.appendChild(document.createCDATASection(dto.getImg_path1()));
        ROOT.appendChild(prdImage02);
        Element prdImage03 = document.createElement("prdImage03");
        prdImage03.appendChild(document.createCDATASection(dto.getImg_path2()));
        ROOT.appendChild(prdImage03);
        Element htmlDetail = document.createElement("htmlDetail");
        htmlDetail.appendChild(document.createCDATASection(dto.getGoods_remarks()));
        ROOT.appendChild(htmlDetail);
        Element selTermUseYn = document.createElement("selTermUseYn");
        selTermUseYn.appendChild(document.createCDATASection(dtllist.getBndyn()));
        ROOT.appendChild(selTermUseYn);
        Element selPrdClfCd = document.createElement("selPrdClfCd");
        selPrdClfCd.appendChild(document.createCDATASection(dtllist.getProdfpselcd()));
        ROOT.appendChild(selPrdClfCd);
        Element aplBgnDy = document.createElement("aplBgnDy");
        String strCurrentDate = YDMATimeUtil.getCurrentTimeByFreeFormat("yyyy/MM/dd");
        aplBgnDy.appendChild(document.createCDATASection(strCurrentDate));
        ROOT.appendChild(aplBgnDy);
        Element selPrc = document.createElement("selPrc");
        selPrc.appendChild(document.createCDATASection(dto.getGoods_price()));
        ROOT.appendChild(selPrc);
        Element prdSelQty = document.createElement("prdSelQty");
        prdSelQty.appendChild(document.createCDATASection("1"));
        ROOT.appendChild(prdSelQty);
        Element dlvCnAreaCd = document.createElement("dlvCnAreaCd");
        String areaCd = YDMAStringUtil.leftPad(dto.getDeliv_able_region(), 2, "0");
        dlvCnAreaCd.appendChild(document.createCDATASection(areaCd));
        ROOT.appendChild(dlvCnAreaCd);
        Element dlvCstInstBasiCd = document.createElement("dlvCstInstBasiCd");
        dlvCstInstBasiCd.appendChild(document.createCDATASection(dtllist.getShiptypcd()));
        ROOT.appendChild(dlvCstInstBasiCd);
        if (dtllist.getShiptypcd().equals("03")) {
            Element PrdFrDlvBasiAmt = document.createElement("PrdFrDlvBasiAmt");
            PrdFrDlvBasiAmt.appendChild(document.createCDATASection(dtllist.getCondiprice()));
            ROOT.appendChild(PrdFrDlvBasiAmt);
        }
        if (dtllist.getShiptypcd().equals("02") || dtllist.getShiptypcd().equals("03")) {
            dlvCst1 = document.createElement("dlvCst1");
            dlvCst1.appendChild(document.createCDATASection(dtllist.getShipprc()));
            ROOT.appendChild(dlvCst1);
        } else if (dtllist.getShiptypcd().equals("04")) {
            dlvCst1 = document.createElement("dlvCst3");
            dlvCst1.appendChild(document.createCDATASection(dtllist.getShipprc()));
            ROOT.appendChild(dlvCst1);
        } else if (dtllist.getShiptypcd().equals("05")) {
            dlvCst1 = document.createElement("dlvCst4");
            dlvCst1.appendChild(document.createCDATASection(dtllist.getShipprc()));
            ROOT.appendChild(dlvCst1);
        }
        Element bndlDlvCnYn = document.createElement("bndlDlvCnYn");
        bndlDlvCnYn.appendChild(document.createCDATASection(dtllist.getBndyn()));
        ROOT.appendChild(bndlDlvCnYn);
        Element jejuDlvCst = document.createElement("jejuDlvCst");
        jejuDlvCst.appendChild(document.createCDATASection(dtllist.getJejuprc()));
        ROOT.appendChild(jejuDlvCst);
        Element islandDlvCst = document.createElement("islandDlvCst");
        islandDlvCst.appendChild(document.createCDATASection(dtllist.getIslandprc()));
        ROOT.appendChild(islandDlvCst);
        Element dlvCstPayTypCd = document.createElement("dlvCstPayTypCd");
        dlvCstPayTypCd.appendChild(document.createCDATASection(dtllist.getPrctypcd()));
        ROOT.appendChild(dlvCstPayTypCd);
        Element rtngdDlvCst = document.createElement("rtngdDlvCst");
        rtngdDlvCst.appendChild(document.createCDATASection(dtllist.getRetprc()));
        ROOT.appendChild(rtngdDlvCst);
        Element exchDlvCst = document.createElement("exchDlvCst");
        exchDlvCst.appendChild(document.createCDATASection(dtllist.getExcprc()));
        ROOT.appendChild(exchDlvCst);
        Element rtngExchDetail = document.createElement("rtngExchDetail");
        rtngExchDetail.appendChild(document.createCDATASection(dtllist.getRtexcdtl()));
        ROOT.appendChild(rtngExchDetail);
        Element dlvCstInfoCd = document.createElement("dlvCstInfoCd");
        dlvCstInfoCd.appendChild(document.createCDATASection("01"));
        ROOT.appendChild(dlvCstInfoCd);
        Element asDetail = document.createElement("asDetail");
        asDetail.appendChild(document.createCDATASection(dtllist.getAsdtl()));
        ROOT.appendChild(asDetail);
        Element company = document.createElement("company");
        company.appendChild(document.createCDATASection(dto.getMaker()));
        ROOT.appendChild(company);
        Element modelNm = document.createElement("modelNm");
        modelNm.appendChild(document.createCDATASection(dto.getModel_nm()));
        ROOT.appendChild(modelNm);
        String opt = dto.getChar_1_nm().equals("\ub2e8\ud488") ? "N" : "Y";
        Element optSelectYn = document.createElement("optSelectYn");
        optSelectYn.appendChild(document.createCDATASection(opt));
        ROOT.appendChild(optSelectYn);
        if (opt.equals("Y")) {
            List<ShopOptionDto> options = YDWMXmlManager.getProductOptions(dto);
            List items = options.stream().map(p -> p.getName().split(":")).map(p -> ((String[])p).length == 2 ? new CodeItem(p[1], p[0]) : new CodeItem("", p[0])).collect(Collectors.toList());
            if (dto.getChar_2_nm().equals("")) {
                ProductRootOption = document.createElement("ProductRootOption");
                ROOT.appendChild(ProductRootOption);
                colTitle = document.createElement("colTitle");
                colTitle.appendChild(document.createCDATASection(dto.getChar_1_nm()));
                ProductRootOption.appendChild(colTitle);
                txtColCnt = document.createElement("txtColCnt");
                txtColCnt.appendChild(document.createCDATASection("1"));
                ROOT.appendChild(txtColCnt);
                i = 0;
                while (i < items.size()) {
                    option = options.get(i);
                    ProductOption = document.createElement("ProductOption");
                    ProductRootOption.appendChild(ProductOption);
                    colOptPrice = document.createElement("colOptPrice");
                    colOptPrice.appendChild(document.createCDATASection(option.getAmt()));
                    ProductOption.appendChild(colOptPrice);
                    colValue0 = document.createElement("colValue0");
                    colValue0.appendChild(document.createCDATASection(option.getName()));
                    ProductOption.appendChild(colValue0);
                    colCount = document.createElement("colCount");
                    colCount.appendChild(document.createCDATASection(option.getCnt()));
                    ProductOption.appendChild(colCount);
                    ++i;
                }
            } else {
                ProductRootOption = document.createElement("ProductRootOption");
                ROOT.appendChild(ProductRootOption);
                colTitle = document.createElement("colTitle");
                colTitle.appendChild(document.createCDATASection(dto.getChar_1_nm() + ":" + dto.getChar_2_nm()));
                ProductRootOption.appendChild(colTitle);
                txtColCnt = document.createElement("txtColCnt");
                txtColCnt.appendChild(document.createCDATASection("1"));
                ROOT.appendChild(txtColCnt);
                i = 0;
                while (i < items.size()) {
                    option = options.get(i);
                    ProductOption = document.createElement("ProductOption");
                    ProductRootOption.appendChild(ProductOption);
                    colOptPrice = document.createElement("colOptPrice");
                    colOptPrice.appendChild(document.createCDATASection(option.getAmt()));
                    ProductOption.appendChild(colOptPrice);
                    colValue0 = document.createElement("colValue0");
                    colValue0.appendChild(document.createCDATASection(option.getName()));
                    ProductOption.appendChild(colValue0);
                    colCount = document.createElement("colCount");
                    colCount.appendChild(document.createCDATASection(option.getCnt()));
                    ProductOption.appendChild(colCount);
                    ++i;
                }
            }
        }
        Element ProductNotification2 = document.createElement("ProductNotification");
        ROOT.appendChild(ProductNotification2);
        ProductIforDao dao = new ProductIforDao();
        List<List<String>> prodattrnm = dao.getProductAttrnm(dto.getProp1_cd());
        List<List<String>> prodattrval = dao.getSelectViewList(dto.getProp1_cd());
        Element type = document.createElement("type");
        type.appendChild(document.createCDATASection(prodattrnm.get(0).get(3)));
        ProductNotification2.appendChild(type);
        i = 0;
        while (i < prodattrnm.size()) {
            if (!prodattrnm.get(i).get(4).equals("")) {
                if (prodattrnm.get(i).get(4).contains(",")) {
                    String[] attrname = prodattrnm.get(i).get(4).split(",");
                    int k = 0;
                    while (k < attrname.length) {
                        Element item = document.createElement("item");
                        ProductNotification2.appendChild(item);
                        Element code = document.createElement("code");
                        code.appendChild(document.createCDATASection(attrname[k]));
                        item.appendChild(code);
                        Element name = document.createElement("name");
                        name.appendChild(document.createCDATASection(prodattrval.get(i).get(2)));
                        item.appendChild(name);
                        ++k;
                    }
                } else {
                    Element item = document.createElement("item");
                    ProductNotification2.appendChild(item);
                    Element code = document.createElement("code");
                    code.appendChild(document.createCDATASection(prodattrnm.get(i).get(4)));
                    item.appendChild(code);
                    Element name = document.createElement("name");
                    name.appendChild(document.createCDATASection(prodattrval.get(i).get(2)));
                    item.appendChild(name);
                }
            }
            ++i;
        }
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static Hashtable getDistinct(String[] arr) {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        int j = 0;
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (ht.containsKey(val)) {
                j = 0;
                ht.put(val, ++j);
            } else {
                ht.put(val, ++j);
            }
            ++n2;
        }
        return ht;
    }

    public static void updateSendShoppingMallSearchProduct(String shopnm, String recvdtFrom, String recvdtTo, String num, String search, String type, String prodcd, Shell shell) throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("11st.productSearchTemplatePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("11st.productSearchTempateFile");
        String templateFullpath = templatePath + File.separator + templateFile;
        CompInfoDao compdao = new CompInfoDao();
        compdao.getCompNoImage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element ROOT = document.createElement("SearchProduct");
        ROOT.normalize();
        new ProductMstDao();
        Element selMthdCd = document.createElement("selMthdCd");
        selMthdCd.appendChild(document.createCDATASection("01"));
        ROOT.appendChild(selMthdCd);
        Element schBgnDt = document.createElement("schBgnDt");
        schBgnDt.appendChild(document.createCDATASection(recvdtFrom));
        ROOT.appendChild(schBgnDt);
        Element schEndDt = document.createElement("schEndDt");
        schEndDt.appendChild(document.createCDATASection(recvdtTo));
        ROOT.appendChild(schEndDt);
        Element selStatCd = document.createElement("selStatCd");
        selStatCd.appendChild(document.createCDATASection(type));
        ROOT.appendChild(selStatCd);
        if (prodcd.equals("1")) {
            Element prdNo = document.createElement("prdNo");
            prdNo.appendChild(document.createCDATASection(search));
            ROOT.appendChild(prdNo);
        } else {
            Element prdNm = document.createElement("prdNm");
            prdNm.appendChild(document.createCDATASection(search));
            ROOT.appendChild(prdNm);
        }
        Element limit = document.createElement("limit");
        limit.appendChild(document.createCDATASection(num));
        ROOT.appendChild(limit);
        YDWMXmlManager.writeToXml(ROOT, templateFullpath);
    }

    public static List<ShopOptionDto> getProductOptions(ShopProductDto dto) {
        ArrayList<ShopOptionDto> options = new ArrayList<ShopOptionDto>();
        ShopOptionProductInfoDao dao = new ShopOptionProductInfoDao();
        try {
            List<ShopProductOptionDto> list = dao.getShopOptProdInfoListByProdseq(dto.getProdseq());
            for (ShopProductOptionDto optdto : list) {
                ShopOptionDto opt = new ShopOptionDto();
                opt.setName(optdto.getOptprodnm().concat("_").concat(optdto.getOptspecdes()));
                opt.setCnt(optdto.getOptvertstock());
                opt.setAmt(Integer.toString(optdto.getOptaddamt()));
                options.add(opt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }
}

