/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.data.dao.BaseStockDao;
import com.kdjsystem.mlink.tot.data.dao.BaseStockDto;
import com.kdjsystem.mlink.tot.ui.BaseStockManager;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class BaseStockDetailDialog
extends CommandDialog {
    BaseStockManager opener;
    BaseStockDto dto;
    String TITLE = "\uc7ac\uace0\uad00\ub9ac";
    String prodcd;
    String prodnm;
    String date;
    private int qty;
    private int realqty;
    private int diffqty;
    private Text txt_prodcd;
    private Text txt_prodnm;
    private Text txt_specdes;
    private Text txt_qty;
    private Text txt_realqty;
    private Text txt_diffqty;
    private Text txt_reason;
    Button btnOk;
    Button btnCancel;
    private int brandcd;

    public BaseStockDetailDialog(Shell parentShell, BaseStockDto dto, BaseStockManager opener, String date, int brandcd) {
        super(parentShell);
        this.dto = dto;
        this.opener = opener;
        this.date = date;
        this.brandcd = brandcd;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setBounds(0, 0, 71, 20);
        lblNewLabel.setText("\uc0c1\ud488\ucf54\ub4dc");
        this.txt_prodcd = new Text(composite, 2048);
        this.txt_prodcd.setEditable(false);
        this.txt_prodcd.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        this.txt_prodcd.setBackground(SWTResourceManager.getColor(29));
        GridData gd_txt_prodcd = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txt_prodcd.widthHint = 200;
        this.txt_prodcd.setLayoutData((Object)gd_txt_prodcd);
        Label lblNewLabel_1 = new Label(composite, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText("\uc0c1\ud488\uba85");
        this.txt_prodnm = new Text(composite, 2048);
        this.txt_prodcd.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        this.txt_prodnm.setBackground(SWTResourceManager.getColor(29));
        this.txt_prodnm.setEditable(false);
        this.txt_prodnm.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_2 = new Label(composite, 0);
        lblNewLabel_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_2.setText("\uaddc\uaca9");
        this.txt_specdes = new Text(composite, 2048);
        this.txt_specdes.setEditable(false);
        this.txt_specdes.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        this.txt_specdes.setBackground(SWTResourceManager.getColor(29));
        GridData gd_txt_specdes = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txt_specdes.widthHint = 200;
        this.txt_specdes.setLayoutData((Object)gd_txt_specdes);
        Label lblNewLabel_3 = new Label(composite, 0);
        lblNewLabel_3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_3.setText("\uc7a5\ubd80\uc218\ub7c9");
        this.txt_qty = new Text(composite, 2048);
        this.txt_qty.setEditable(false);
        this.txt_qty.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        this.txt_qty.setBackground(SWTResourceManager.getColor(29));
        GridData gd_txt_qty = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txt_qty.widthHint = 200;
        this.txt_qty.setLayoutData((Object)gd_txt_qty);
        Label lblNewLabel_4 = new Label(composite, 0);
        lblNewLabel_4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_4.setText("\uc2e4\uc7ac\uace0\uc218\ub7c9");
        this.txt_realqty = new Text(composite, 2048);
        this.txt_realqty.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                char c = e.character;
                if (!(Character.isDigit(c) || e.keyCode == 8 || e.keyCode > 0x1000000 && e.keyCode < 0x1000005)) {
                    e.doit = false;
                    return;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!(e.keyCode > 47 && e.keyCode < 58 || e.keyCode == 8 || e.keyCode > 0x1000000 && e.keyCode < 0x1000005)) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        BaseStockDetailDialog.this.txt_reason.setFocus();
                    }
                    e.doit = false;
                    return;
                }
                BaseStockDetailDialog.this.realqty = Integer.parseInt(BaseStockDetailDialog.this.txt_realqty.getText());
                BaseStockDetailDialog.this.qty = Integer.parseInt(BaseStockDetailDialog.this.txt_qty.getText());
                BaseStockDetailDialog.this.txt_diffqty.setText(Integer.toString(Math.abs(BaseStockDetailDialog.this.qty) - BaseStockDetailDialog.this.realqty));
                BaseStockDetailDialog.this.txt_diffqty.update();
            }
        });
        this.txt_realqty.setTextLimit(100);
        GridData gd_txt_realqty = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txt_realqty.widthHint = 200;
        this.txt_realqty.setLayoutData((Object)gd_txt_realqty);
        Label lblNewLabel_5 = new Label(composite, 0);
        lblNewLabel_5.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_5.setText("\ucc28\uc774\uc218\ub7c9");
        this.txt_diffqty = new Text(composite, 2048);
        this.txt_diffqty.setText(Integer.toString(this.diffqty));
        this.txt_diffqty.setEditable(false);
        this.txt_diffqty.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        this.txt_diffqty.setBackground(SWTResourceManager.getColor(29));
        GridData gd_txt_diffqty = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txt_diffqty.widthHint = 200;
        this.txt_diffqty.setLayoutData((Object)gd_txt_diffqty);
        Label lblNewLabel_6 = new Label(composite, 0);
        lblNewLabel_6.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_6.setText("\uc0ac\uc720");
        this.txt_reason = new Text(composite, 2048);
        this.txt_reason.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    BaseStockDetailDialog.this.btnOk.setFocus();
                }
            }
        });
        this.txt_reason.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.dto != null) {
            this.setBaseStkInfo(this.dto);
            this.txt_realqty.setFocus();
        }
        return container;
    }

    private void setBaseStkInfo(BaseStockDto dto) {
        try {
            this.txt_prodcd.setText(dto.getProdcd());
            this.txt_prodnm.setText(dto.getProdnm());
            this.txt_specdes.setText(dto.getSpecdes());
            this.txt_qty.setText(dto.getQty());
            this.txt_realqty.setText(dto.getRealQty() == null ? "0" : dto.getRealQty());
            this.txt_diffqty.setText(dto.getDiffQty());
            if (dto.getReason() != null) {
                this.txt_reason.setText(dto.getReason());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)this.TITLE, (String)e.getMessage());
        }
    }

    protected void okPressed() {
        String prodcd = this.txt_prodcd.getText().trim();
        String prodnm = this.txt_prodnm.getText().trim();
        String specdes = this.txt_specdes.getText().trim();
        String qty = this.txt_qty.getText().trim();
        String realqty = this.txt_realqty.getText().trim();
        String diffqty = this.txt_diffqty.getText().trim();
        String reason = this.txt_reason.getText().trim();
        BaseStockDao dao = new BaseStockDao();
        try {
            if (dao.isExistBasstkmst(this.date, this.brandcd) && this.opener.lblNewLabel_final.getText().length() != 0 && dao.getRecvDtAndSeq(this.date, this.brandcd).length() != 0 && this.opener.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(this.date, this.brandcd).length()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return;
            }
            BaseStockDto dto_db = new BaseStockDto(prodcd, prodnm, specdes, qty, realqty, diffqty, reason);
            List contents = (List)this.opener.tableViewer.getInput();
            int selectedIdx = this.opener.tableViewer.getGrid().getSelectionIndex();
            BaseStockDto dto_orign = (BaseStockDto)contents.get(selectedIdx);
            dto_db.setRowno(dto_orign.getRowno());
            contents.set(selectedIdx, dto_db);
            this.opener.tableViewer.refresh();
            this.opener.tableViewer.getGrid().select(selectedIdx);
            dao.updateBaseStock(this.brandcd, dto_db, this.date);
            this.opener.sumOfQty = this.opener.getSumOfQty(contents);
            this.opener.sumOfRealQty = this.opener.getSumOfRealQty(contents);
            this.opener.sumOfDiffQty = this.opener.getSumOfDiffQty(contents);
            this.opener.updateColumnGirdHeader(this.opener.sumOfQty, this.opener.sumOfRealQty, this.opener.sumOfDiffQty);
            this.opener.tableViewer2.refresh();
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\uc0c1\ud488\uc815\ubcf4\ub97c \uc218\uc815\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            super.okPressed();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)this.TITLE, (String)e.getMessage());
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, "\uc800\uc7a5", false);
        this.btnCancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btnOk.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc800\uc7a5.png"));
        this.btnCancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(550, 350);
    }
}

