/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.OrderStatus;
import com.kdjsystem.mlink.shop.dao.ShopOptionProductInDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderStatusDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.AlimTalkChargeDao;
import com.kdjsystem.mlink.tot.data.dao.CompInfoDao;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.ProductMstDto;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ShopOrderDao {
    ChromeExtention chrome = ChromeExtention.getInstace();
    ChromeDriver driver = null;
    private static ShopOrderDao daoInstance = new ShopOrderDao();
    final OkHttpClient client = new OkHttpClient().newBuilder().build();
    public String REQ_METHOD = "POST";
    public String ACCEPT = "application/json";
    public String CONTENT_TYPE = "application/json";

    public static ShopOrderDao get() {
        return daoInstance;
    }

    public void SendMLinkAutoProcessing(int brandcd, int ordSeq, String user) throws Exception {
        Connection connection = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{call YWM_SHOPORDAUTO_PROC(?,?,?)}");
                cStmt.setInt(1, brandcd);
                cStmt.setInt(2, ordSeq);
                cStmt.setString(3, user);
                YDMAStringUtil.Print("[SendMLinkAutoProcessing]" + cStmt.toString());
                cStmt.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
    }

    public int UpdateInvoiceOrder(int ordSeq, int wonCost, int mallWonCost, String deliveryCode, String invoNo) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE shopordmst \r\n");
                sql.append("SET WON_COST=? \r\n");
                sql.append(",MALL_WON_COST=? \r\n");
                sql.append(",ORDER_STATUS =? \r\n");
                sql.append(",DELIVERY_ID=? \r\n");
                sql.append(",INVOICE_NO=? \r\n");
                sql.append("WHERE ORDSEQ=?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setInt(++rowIdx, wonCost);
                pstmt.setInt(++rowIdx, mallWonCost);
                pstmt.setString(++rowIdx, "401");
                pstmt.setString(++rowIdx, deliveryCode);
                pstmt.setString(++rowIdx, invoNo);
                pstmt.setInt(++rowIdx, ordSeq);
                YDMAStringUtil.Print("[INVOIC UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopOrderMstDto> getShopOrderList(String startdt, String enddt, String searchText, String search1, String search2, String search3) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS,  '' ) AS DS_ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DOMEORDERNO,  '' ) AS DOMEORDERNO,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '0' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '0' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("(SELECT GOODS_KEYWORD FROM SHOPPRODINFO WHERE COMPAYNY_GOODS_CD = M.COMPAYNY_GOODS_CD AND COMPNO = 4 ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS VENDORID  ,    \r\n");
                sql.append("IFNULL(D.NICKNM1,'') AS NICKNM  ,    \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID  ,    \r\n");
                sql.append("IFNULL(M.DOSINORDCD  ,'') AS DOSINORDCD  ,    \r\n");
                sql.append("IFNULL(M.DEL_YN  ,'') AS DEL_YN  ,    \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS  ,'') AS DS_ORDER_STATUS  ,    \r\n");
                sql.append("IFNULL(M.MALL_EXP_CD  ,'0') AS MALL_EXP_CD  ,    \r\n");
                sql.append("(SELECT COUNT(ORDSEQ) FROM SHOPORDCS WHERE ORDSEQ =M.ORDSEQ AND CSCLOSE='Y' ) AS CSCLOSE \r\n");
                sql.append(" FROM shopordmst AS M \r\n");
                sql.append(" LEFT JOIN shopdtl AS D \r\n");
                sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                sql.append(" AND M.SHOPSEQ = D.SHOPSEQ \r\n");
                sql.append(" WHERE M.COMPNO = ?   ");
                boolean isNum = searchText.replace(",", "").matches("-?\\d+(\\.\\d+)?");
                List<String> cols = null;
                cols = isNum ? Arrays.asList("  AND ( ", "  (SALE_CNT %s)", " OR (WON_COST %s)", " OR (MALL_WON_COST %s)", " OR (SALE_COST  %s)", " OR (ORDER_ID  %s)", " OR (MALL_PRODUCT_ID %s)", " OR (DELV_COST %s) )") : Arrays.asList("  AND ( ", "  (ORDER_STATUS %s)", " OR (SHOPID %s)", " OR (SHOP_USERID %s)", " OR (RECEIVE_NAME %s)", " OR (USER_NAME %s)", " OR (MALL_PRODUCT_ID %s)", " OR (COMPAYNY_GOODS_CD %s)", " OR (P_PRODUCT_NAME %s)", " OR (P_SKU_VALUE %s)", " OR (DELIVERY_METHOD_STR2 %s)", " OR (DELV_MSG %s)", " OR (DELIVERY_ID %s)", " OR (INVOICE_NO %s)", "OR (USER_CEL %s)", "OR (RECEIVE_CEL %s)", "OR (D.NICKNM1 %s)", " OR (ORDER_ID  %s)", " OR (LABEL %s) ) ");
                if (!searchText.contains(",")) {
                    if (!searchText.trim().equals("") && !search2.trim().equals("")) {
                        if (search1.equals("\ubd80\ubd84\uc77c\uce58")) {
                            sql.append(String.format(" AND M.%s LIKE '%s%s%s' ", search2, "%", searchText, "%"));
                        } else {
                            sql.append(String.format(" AND M.%s = '%s' ", search2, searchText));
                        }
                    } else {
                        String query = "";
                        if (search1.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " LIKE '%" + searchText + "%'")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " = '" + searchText + "'")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    }
                } else if (searchText.contains(",")) {
                    Object multi_searchText = searchText.replace(" ", "").trim();
                    if (!searchText.trim().equals("") && !search2.trim().equals("")) {
                        if (search1.equals("\ubd80\ubd84\uc77c\uce58")) {
                            multi_searchText = ((String)multi_searchText).replace(",", "+|");
                            sql.append(String.format(" AND M.%s REGEXP ('%s') ", search2, multi_searchText));
                        } else {
                            multi_searchText = "^" + ((String)multi_searchText).replace(",", "$|^") + "$";
                            sql.append(String.format(" AND M.%s REGEXP ('%s') ", search2, multi_searchText));
                        }
                    } else {
                        String query = "";
                        if (search1.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " REGEXP ('" + searchText.replace(" ", "").replace(",", "+|").trim() + "')")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " REGEXP ('^" + searchText.replace(" ", "").replace(",", "$|^").trim() + "$')")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    }
                }
                sql.append(String.format(" AND (M.%s >= ? AND  M.%s <= ?)  ORDER BY %s DESC ", search3, search3, search3));
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(startdt, false));
                pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(enddt, false));
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                Integer rowNum = 0;
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    rowNum = rowNum + 1;
                    dto.setNo(rowNum.toString());
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setDomeOrderId(rs.getString("DOMEORDERNO"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setShopPw(rs.getString("PASSWORD"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthKey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setNickname(rs.getString("NICKNM"));
                    dto.setDel_yn(rs.getString("DEL_YN"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    dto.setDosinOrder_code(rs.getString("DOSINORDCD"));
                    dto.setMall_exp_cd(rs.getString("MALL_EXP_CD"));
                    dto.setCsClose(rs.getString("CSCLOSE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderMstDto> getShopOrderID(String Shopid, String Order_id) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID      \r\n");
                sql.append(" FROM SHOPORDMST AS M \r\n");
                sql.append(" WHERE M.COMPNO = ?  ");
                sql.append("   and M.SHOPID = ?  ");
                sql.append("   and M.ORDER_ID = ?  ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, Shopid);
                pstmt.setString(3, Order_id);
                YDMAStringUtil.Print("[ShopOrderID]" + pstmt.toString());
                rs = pstmt.executeQuery();
                Integer rowNum = 0;
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    rowNum = rowNum + 1;
                    dto.setNo(rowNum.toString());
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderMstDto> getShopOrderNew(String strdt, String endDt) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                sql.append("IFNULL(D.NICKNM2 ,'') AS VENDORID,      \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID       \r\n");
                sql.append(" FROM shopordmst AS M \r\n");
                sql.append(" LEFT JOIN shopdtl AS D \r\n");
                sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                sql.append(" AND M.SHOP_USERID = D.SHOPPINGID \r\n");
                sql.append(" WHERE M.COMPNO = ?  AND (ORDER_DATE >= ? AND  ORDER_DATE <= ?) AND ORDER_STATUS='100' AND DEL_YN <>'Y'  ORDER BY REG_DATE DESC");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(strdt, false));
                pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(endDt, false));
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setShopPw(rs.getString("PASSWORD"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthKey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderMstDto> getShopOrder(String shopCd, String shopseq, String shoppingID, String strdt, String endDt) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.DOMEORDERNO,  '' ) AS DOMEORDERNO,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                sql.append("IFNULL(D.NICKNM2 ,'') AS VENDORID,      \r\n");
                sql.append("IFNULL(D.NICKNM1 ,'') AS NICKNM1,      \r\n");
                sql.append("IFNULL(M.MALL_EXP_CD ,'0') AS MALL_EXP_CD,      \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID,       \r\n");
                sql.append("IFNULL(M.DOSINORDCD  ,'') AS DOSINORDCD,     \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS  ,'') AS DS_ORDER_STATUS,     \r\n");
                sql.append("IFNULL(d.EDITAUTHKEY1, '') AS EDITAUTHKEY1,   \r\n");
                sql.append("IFNULL(d.EDITAPIKEY, '') AS EDITAPIKEY   \r\n");
                sql.append(" FROM shopordmst AS M \r\n");
                sql.append(" LEFT JOIN shopdtl AS D \r\n");
                sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                sql.append(" AND M.SHOPSEQ = D.SHOPSEQ \r\n");
                sql.append(" WHERE M.COMPNO = ?  AND M.SHOPID= ?  AND  M.SHOPSEQ = ? AND  M.SHOP_USERID = ? AND (REG_DATE >= ? AND  REG_DATE <= ?)  ORDER BY REG_DATE DESC");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopCd);
                pstmt.setString(3, shopseq);
                pstmt.setString(4, shoppingID);
                pstmt.setString(5, YDMATimeUtil.convertSabangNetOrderDateToOrddt(strdt, false));
                pstmt.setString(6, YDMATimeUtil.convertSabangNetOrderDateToOrddt(endDt, false));
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setDomeOrderId(rs.getString("PRODUCT_ID"));
                    dto.setProduct_id(rs.getString("DOMEORDERNO"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setShopPw(rs.getString("PASSWORD"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthKey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setNickname(rs.getString("NICKNM1"));
                    dto.setMall_exp_cd(rs.getString("MALL_EXP_CD"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    dto.setDosinOrder_code(rs.getString("DOSINORDCD"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setEDITAPIKEY(rs.getString("EDITAPIKEY"));
                    dto.setEDITAUTHKEY1(rs.getString("EDITAUTHKEY1"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int isShopOrderMstExits(String shoopid, String orderid, String compno, String mallExpCd, String productcode) {
        int result;
        block12: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT COUNT(ORDSEQ) AS CNT FROM shopordmst WHERE SHOPID=? AND ORDER_ID=? AND COMPNO=? AND MALL_EXP_CD=? and MALL_PRODUCT_ID = ?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, shoopid);
                    pstmt_orddtl.setString(2, orderid);
                    pstmt_orddtl.setString(3, compno);
                    pstmt_orddtl.setString(4, mallExpCd);
                    pstmt_orddtl.setString(5, productcode);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int isShopOrderMstExitsWithisClaim(String shoopid, String orderid, String isCliam) {
        int result;
        block12: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT COUNT(ORDSEQ) AS CNT FROM shopordmst WHERE SHOPID=? AND ORDER_ID=? AND ORDER_STATUS = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, shoopid);
                    pstmt_orddtl.setString(2, orderid);
                    pstmt_orddtl.setString(3, isCliam);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String isShopOrderMstCheckTmonOrderDate(String shoopid, String orderid) {
        String result;
        block12: {
            result = "";
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT ORDER_DATE FROM shopordmst WHERE SHOPID=? AND ORDER_ID=?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, shoopid);
                    pstmt_orddtl.setString(2, orderid);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("ORDER_DATE");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int isShopOrderMstCheckTmonOrderCount(String shoopid, String orderid, String p_sku_value) {
        int result;
        block12: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT COUNT(ORDSEQ) AS CNT FROM shopordmst WHERE SHOPID=? AND ORDER_ID=? AND P_SKU_VALUE=?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, shoopid);
                    pstmt_orddtl.setString(2, orderid);
                    pstmt_orddtl.setString(3, p_sku_value);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private int findIndex(List<ShopProductOptionDto> list, Predicate<ShopProductOptionDto> predicate) {
        int i = 0;
        while (i < list.size()) {
            ShopProductOptionDto dto = list.get(i);
            if (predicate.test(dto)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getCompanyOptGoodsCd(String shopid, String productId, String pSkuID, String pSkuValue) throws Exception {
        ShopOptionProductInDao dao = new ShopOptionProductInDao();
        List<String> optCompanyCodeList = this.getCompanyGoodsCd(shopid, productId);
        if (optCompanyCodeList == null || optCompanyCodeList.size() == 0) {
            return "";
        }
        List<ShopProductOptionDto> list = dao.getShopOptProdInListBySendseq(productId);
        if (list.size() > 0) {
            int index = -1;
            index = this.findIndex(list, d -> d.getShopprodsku().equals(pSkuID));
            if (index > -1) {
                return list.get(index).getOptprodcd();
            }
            index = this.findIndex(list, d -> d.getShopprodsku_nm().equals(pSkuValue));
            if (index > -1) {
                return list.get(index).getOptprodcd();
            }
        }
        YDMAStringUtil.convertToInt(optCompanyCodeList.get(0));
        return optCompanyCodeList.get(1);
    }

    private String analyze(String cellStr) {
        String result = "";
        try {
            if (cellStr != null && cellStr.length() < 5) {
                return result;
            }
            if (!cellStr.contains("(") || !cellStr.contains(")")) {
                return result;
            }
            int beginIndex = cellStr.indexOf("(");
            int endIndex = cellStr.indexOf(")");
            if (endIndex - beginIndex - 1 >= 5) {
                result = cellStr.substring(beginIndex + 1, endIndex);
            }
        }
        catch (Exception exception) {
            return "";
        }
        return result;
    }

    public List<List<String>> getPersonalOrdStatus(String dateFrom, String dateTo) {
        ArrayList<List<String>> contents;
        block12: {
            contents = new ArrayList<List<String>>();
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = " SELECT distinct ORDER_STATUS,COUNT(*) as CNT\r\n  FROM shopordmst M \r\n WHERE compno=? \r\n     AND (M.REG_DATE >= ? AND  M.REG_DATE <= ? ) \r\n GROUP BY ORDER_STATUS";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(dateFrom, false));
                    pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(dateTo, false));
                    YDMAStringUtil.Print("[getPersonalOrdStatus]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(rs.getString("ORDER_STATUS"));
                        list.add(rs.getString("CNT"));
                        contents.add(list);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    public List<String> getCompanyGoodsCd(String shoopid, String productId) {
        ArrayList<String> result;
        block12: {
            result = new ArrayList<String>();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String SQL = "SELECT SENDSEQ AS SENDSEQ, COMPAYNY_GOODS_CD AS COMPAYNY_GOODS_CD, \r\n\t\t  PRODSEQ  FROM SHOPPRODIN  \r\n WHERE COMPNO=?    AND SHOPCD=?    AND SHOPPRODNO= ?";
                    SQL = SQL.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(SQL);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, shoopid);
                    pstmt_orddtl.setString(3, productId);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("SENDSEQ"));
                        result.add(rs.getString("COMPAYNY_GOODS_CD"));
                        result.add(rs.getString("PRODSEQ"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String getSqlSave() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into shopordmst ( ");
        sb.append("COMPNO ,\r\n ");
        sb.append("REG_DATE ,\r\n ");
        sb.append("ORDER_ID ,\r\n ");
        sb.append("SHOPID ,\r\n ");
        sb.append("SHOPSEQ ,\r\n ");
        sb.append("SHOP_USERID ,\r\n ");
        sb.append("ORDER_STATUS ,\r\n ");
        sb.append("USER_ID ,\r\n ");
        sb.append("USER_NAME ,\r\n ");
        sb.append("USER_TEL ,\r\n ");
        sb.append("USER_CEL ,\r\n ");
        sb.append("USER_EMAIL ,\r\n ");
        sb.append("RECEIVE_TEL ,\r\n ");
        sb.append("RECEIVE_CEL ,\r\n ");
        sb.append("RECEIVE_EMAIL ,\r\n ");
        sb.append("DELV_MSG ,\r\n ");
        sb.append("RECEIVE_NAME ,\r\n ");
        sb.append("RECEIVE_ZIPCODE ,\r\n ");
        sb.append("RECEIVE_ADDR ,\r\n ");
        sb.append("TOTAL_COST ,\r\n ");
        sb.append("PAY_COST ,\r\n ");
        sb.append("ORDER_DATE ,\r\n ");
        sb.append("PARTNER_ID ,\r\n ");
        sb.append("DPARTNER_ID ,\r\n ");
        sb.append("MALL_PRODUCT_ID ,\r\n ");
        sb.append("PRODUCT_ID ,\r\n ");
        sb.append("SKU_ID ,\r\n ");
        sb.append("P_PRODUCT_NAME ,\r\n ");
        sb.append("P_SKU_VALUE ,\r\n ");
        sb.append("PRODUCT_NAME ,\r\n ");
        sb.append("SALE_COST ,\r\n ");
        sb.append("MALL_WON_COST ,\r\n ");
        sb.append("WON_COST ,\r\n ");
        sb.append("SKU_VALUE ,\r\n ");
        sb.append("SALE_CNT ,\r\n ");
        sb.append("DELIVERY_METHOD_STR ,\r\n ");
        sb.append("DELV_COST ,\r\n ");
        sb.append("COMPAYNY_GOODS_CD ,\r\n ");
        sb.append("SKU_ALIAS ,\r\n ");
        sb.append("BOX_EA ,\r\n ");
        sb.append("JUNG_CHK_YN ,\r\n ");
        sb.append("MALL_ORDER_SEQ ,\r\n ");
        sb.append("MALL_ORDER_ID ,\r\n ");
        sb.append("ETC_FIELD3 ,\r\n ");
        sb.append("ORDER_GUBUN ,\r\n ");
        sb.append("P_EA ,\r\n ");
        sb.append("ORD_FIELD2 ,\r\n ");
        sb.append("COPY_IDX ,\r\n ");
        sb.append("GOODS_NM_PR ,\r\n ");
        sb.append("GOODS_KEYWORD ,\r\n ");
        sb.append("ORD_CONFIRM_DATE ,\r\n ");
        sb.append("RTN_DT ,\r\n ");
        sb.append("CHNG_DT ,\r\n ");
        sb.append("DELIVERY_CONFIRM_DATE ,\r\n ");
        sb.append("CANCEL_DT ,\r\n ");
        sb.append("CLASS_CD1 ,\r\n ");
        sb.append("CLASS_CD2 ,\r\n ");
        sb.append("CLASS_CD3 ,\r\n ");
        sb.append("CLASS_CD4 ,\r\n ");
        sb.append("BRAND_NM ,\r\n ");
        sb.append("DELIVERY_ID ,\r\n ");
        sb.append("INVOICE_NO ,\r\n ");
        sb.append("HOPE_DELV_DATE ,\r\n ");
        sb.append("FLD_DSP ,\r\n ");
        sb.append("INV_SEND_MSG ,\r\n ");
        sb.append("MODEL_NO ,\r\n ");
        sb.append("SET_GUBUN ,\r\n ");
        sb.append("ETC_MSG ,\r\n ");
        sb.append("DELV_MSG1 ,\r\n ");
        sb.append("MUL_DELV_MSG ,\r\n ");
        sb.append("BARCODE ,\r\n ");
        sb.append("INV_SEND_DM ,\r\n ");
        sb.append("DELIVERY_METHOD_STR2 ,\r\n ");
        sb.append("LABEL ,\r\n ");
        sb.append("ORDER_ETC_1 ,\r\n ");
        sb.append("ORDER_ETC_2 ,\r\n ");
        sb.append("ORDER_ETC_3 ,\r\n ");
        sb.append("ORDER_ETC_4 ,\r\n ");
        sb.append("ORDER_ETC_5 ,\r\n ");
        sb.append("ORDER_ETC_6 ,\r\n ");
        sb.append("ORDER_ETC_7 ,\r\n ");
        sb.append("ORDER_ETC_8 ,\r\n ");
        sb.append("ORDER_ETC_9 ,\r\n ");
        sb.append("ORDER_ETC_10 ,\r\n ");
        sb.append("ORDER_ETC_11 ,\r\n ");
        sb.append("ORDER_ETC_12 ,\r\n ");
        sb.append("ORDER_ETC_13 ,\r\n ");
        sb.append("ORDER_ETC_14 ,\r\n ");
        sb.append("MALL_EXP_CD ,\r\n ");
        sb.append("RECEIPTID ,\r\n ");
        sb.append("EXCHANGEID, \r\n ");
        sb.append("AUTHKEY1 \r\n ");
        sb.append(") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }

    private String getSqlSaveDuplicateOrders() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into shopordmst ( ");
        sb.append("COMPNO, \r\n ");
        sb.append("REG_DATE, \r\n ");
        sb.append("USER_NAME, \r\n ");
        sb.append("RECEIVE_NAME, \r\n ");
        sb.append("ORDER_DATE, \r\n ");
        sb.append("SALE_CNT, \r\n ");
        sb.append("COMPAYNY_GOODS_CD, \r\n ");
        sb.append("DS_ORDER_STATUS, \r\n ");
        sb.append("SHOPID, \r\n ");
        sb.append("SHOP_USERID, \r\n ");
        sb.append("SHOPSEQ, \r\n ");
        sb.append("ORDER_STATUS, \r\n ");
        sb.append("ORDER_ID, \r\n ");
        sb.append("DOSINORDCD \r\n ");
        sb.append(")");
        sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    private PreparedStatement setDuplicateOrders(ShopOrderMstDto dto, ShoppingMallDetailDto shopdto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int j = 0;
        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++j, dto.getUser_name());
        pstmt.setString(++j, dto.getReceive_name());
        pstmt.setString(++j, dto.getOrder_date());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getSale_cnt()));
        pstmt.setString(++j, dto.getCompayny_goods_cd());
        pstmt.setString(++j, dto.getDs_order_status());
        pstmt.setString(++j, dto.getShopid());
        pstmt.setString(++j, shopdto.getShoppingid());
        pstmt.setString(++j, dto.getShopseq());
        pstmt.setString(++j, "500");
        pstmt.setString(++j, dto.getOrder_id());
        pstmt.setString(++j, dto.getDosinOrder_code());
        dto.setResult_code("1");
        String msg = String.format("\ub3c4\ub9e4\ubab0 \uc8fc\ubb38\ubc88\ud638 : %s\uac00 \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getDosinOrder_code());
        dto.setResult_text(msg);
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private String getSqlLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO  shopordstatuslog  \r\n");
        sb.append("(COMPNO, SHOPID, ORDER_ID, SHOPUSERID, PRODUCT_NAME, ORDER_STATUS,ORDER_STATUSNM, RESULTMESSAGE, SENDDT) \r\n");
        sb.append(" VALUES(?,?,?,?,?,?,?,?,?); \r\n");
        return sb.toString();
    }

    public void orderBackup(ShopOrderMstDto dto) {
        try {
            String path = "http://api.kdjsystem.com:8080/api/v1/orderBackup";
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            String json = mapper.writeValueAsString((Object)dto);
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(path).method("POST", body).build();
            this.client.newCall(request2).execute();
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    public int SaveOrderCreate(List<ShopOrderMstDto> parms, boolean flag) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSave().toUpperCase());
                PreparedStatement pstmtSaveLog = connection.prepareStatement(this.getSqlLog().toUpperCase());
                statementlist.add(pstmtSave);
                statementlist.add(pstmtSaveLog);
                boolean isSave = false;
                boolean isLog = false;
                for (ShopOrderMstDto dto : parms) {
                    int isOrder = 0;
                    if (!flag) {
                        isOrder = this.isShopOrderMstExits(dto.getShopid(), dto.getOrder_id(), YDMASessonUtil.getCompnoInfo().getCompno(), dto.getMall_exp_cd(), dto.getMall_product_id());
                    }
                    if (isOrder > 0) continue;
                    if (dto.getResult_code().equals("1")) {
                        String goodProdCd;
                        isSave = true;
                        if ((dto.getCompayny_goods_cd() == null || "".equals(dto.getCompayny_goods_cd())) && !(goodProdCd = this.getCompanyOptGoodsCd(dto.getShopid(), dto.getMall_product_id(), dto.getP_sku_id() == null ? "" : dto.getP_sku_id(), dto.getP_sku_value())).isEmpty()) {
                            dto.setCompayny_goods_cd(goodProdCd);
                        }
                        if (dto.getCompayny_goods_cd() == null || "".equals(dto.getCompayny_goods_cd())) {
                            String company_goods_cd = ShopOrderDao.get().prodordermatch(dto);
                            dto.setCompayny_goods_cd(company_goods_cd);
                        }
                        if (!dto.getMall_exp_cd().equals("E02")) {
                            if (dto.getWon_cost().equals("0")) {
                                dto = ShopOrderDao.get().getProdInfoWonCost(dto);
                                dto.setWon_cost(String.valueOf(Integer.parseInt(dto.getWon_cost()) * Integer.parseInt(dto.getSale_cnt())));
                            }
                            if (dto.getMall_won_cost().equals("0")) {
                                if (dto.getSuppstditem() != null && dto.getSuppstditem().equals("0")) {
                                    dto.setMall_won_cost(String.valueOf("0"));
                                } else if (dto.getSuppstditem() != null && dto.getSuppstditem().equals("1")) {
                                    int mallwoncost = (int)((float)Integer.parseInt(dto.getTotal_cost().replaceAll("[^0-9]", "")) * Float.valueOf(Float.valueOf(dto.getSuppstdrati()).floatValue() / 100.0f).floatValue());
                                    cost = Integer.parseInt(dto.getTotal_cost().replaceAll("[^0-9]", "")) - mallwoncost;
                                    dto.setMall_won_cost(String.valueOf(cost));
                                }
                            } else if (dto.getSuppstditem() != null && dto.getSuppstditem().equals("1")) {
                                int mallwoncost = (int)((float)Integer.parseInt(dto.getTotal_cost().replaceAll("[^0-9]", "")) * Float.valueOf(Float.valueOf(dto.getSuppstdrati()).floatValue() / 100.0f).floatValue());
                                cost = Integer.parseInt(dto.getTotal_cost().replaceAll("[^0-9]", "")) - mallwoncost;
                                dto.setMall_won_cost(String.valueOf(cost));
                            }
                        } else {
                            dto.setWon_cost("0");
                            dto.setMall_won_cost("0");
                        }
                        this.Save(dto, connection, statementlist, pstmtSave);
                    }
                    if (!dto.getResult_code().equals("1") && !dto.getResult_code().equals("-1")) continue;
                    isLog = true;
                    this.SaveLog(dto, connection, statementlist, pstmtSaveLog);
                }
                if (isSave) {
                    pstmtSave.executeBatch();
                    pstmtSave.clearBatch();
                }
                if (isLog) {
                    pstmtSaveLog.executeBatch();
                    pstmtSaveLog.clearBatch();
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return parms.size();
    }

    public int SaveDuplicateOrders(List<ShopOrderMstDto> parms, ShoppingMallDetailDto shopdto, boolean flag) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSaveDuplicateOrders().toUpperCase());
                PreparedStatement pstmtSaveLog = connection.prepareStatement(this.getSqlLog().toUpperCase());
                statementlist.add(pstmtSave);
                statementlist.add(pstmtSaveLog);
                boolean isSave = false;
                boolean isLog = false;
                for (ShopOrderMstDto dto : parms) {
                    String goodProdCd;
                    int isOrder = 0;
                    if (!flag) {
                        isOrder = this.isShopOrderMstExits(dto.getShopid(), dto.getOrder_id(), YDMASessonUtil.getCompnoInfo().getCompno(), dto.getMall_exp_cd(), dto.getMall_product_id());
                    }
                    if (isOrder > 0) continue;
                    isSave = true;
                    if ((dto.getCompayny_goods_cd() == null || dto.getCompayny_goods_cd().equals("")) && !(goodProdCd = this.getCompanyOptGoodsCd(dto.getShopid(), dto.getMall_product_id(), dto.getP_sku_id() == null ? "" : dto.getP_sku_id(), dto.getP_sku_value())).isEmpty()) {
                        dto.setCompayny_goods_cd(goodProdCd);
                    }
                    if (dto.getCompayny_goods_cd() == null || dto.getCompayny_goods_cd().equals("")) {
                        String company_goods_cd = ShopOrderDao.get().prodordermatch(dto);
                        dto.setCompayny_goods_cd(company_goods_cd);
                    }
                    this.setDuplicateOrders(dto, shopdto, connection, statementlist, pstmtSave);
                    if (!dto.getResult_code().equals("1") && !dto.getResult_code().equals("-1")) continue;
                    isLog = true;
                    this.SaveLog(dto, connection, statementlist, pstmtSaveLog);
                }
                if (isSave) {
                    pstmtSave.executeBatch();
                    pstmtSave.clearBatch();
                }
                if (isLog) {
                    pstmtSaveLog.executeBatch();
                    pstmtSaveLog.clearBatch();
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return parms.size();
    }

    public boolean isproductexists(String prdno) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            String sql = "select ifnull(GOODS_COST,'0'), ifnull(PARTNER_ID,'') from shopprodinfo where COMPAYNY_GOODS_CD = ? and compno = ? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, prdno);
            pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                return true;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return false;
    }

    private ShopOrderMstDto getProdInfoWonCost(ShopOrderMstDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(GOODS_COST,'0'), ifnull(PARTNER_ID,'') from shopprodinfo where COMPAYNY_GOODS_CD = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getCompayny_goods_cd());
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    new ArrayList();
                    int columnIndex = 0;
                    dto.setWon_cost(rs.getString(++columnIndex));
                    dto.setPartner_id(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    private ShopOrderMstDto getMallwonCost(ShopOrderMstDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SUPPSTDRATI,'0'),ifnull(SUPPSTDITEM,'') FROM shopdtl \tWHERE SHOPPINGID = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getShop_userid());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    new ArrayList();
                    int columnIndex = 0;
                    dto.setSuppstdrati(rs.getString(++columnIndex));
                    dto.setSuppstditem(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopOrderMstDto> setOrderRequest(List<ShopOrderMstDto> parms) {
        ArrayList<ShopOrderMstDto> removeObj = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : parms) {
            String orderID = dto.getOrder_id();
            String mallID = dto.getMall_product_id();
            String exp_cd = dto.getMall_exp_cd();
            String status2 = dto.getOrder_status();
            long count = parms.stream().filter(p -> p.getOrder_id().equals(orderID)).filter(p -> p.getMall_product_id().equals(mallID)).filter(p -> !p.getOrder_status().equals(status2)).collect(Collectors.counting());
            if (count <= 1L) continue;
            if (exp_cd.equals("R02") || exp_cd.equals("E02") || exp_cd.equals("C02")) {
                if (count <= 2L) continue;
                removeObj.add(dto);
                continue;
            }
            if (dto.getOrder_status().equals("R02") || dto.getOrder_status().equals("E02") || dto.getOrder_status().equals("C02")) continue;
            dto.setOrder_status("201");
            dto.setResult_code("1");
        }
        for (ShopOrderMstDto obj : removeObj) {
            parms.remove(obj);
        }
        return parms;
    }

    public int DeliveryCompleted(List<ShopOrderMstDto> parms) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSave().toUpperCase());
        try {
            try {
                for (ShopOrderMstDto dto : parms) {
                    this.Save(dto, connection, statementlist, pstmtSave);
                }
                pstmtSave.executeBatch();
                pstmtSave.clearBatch();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return 0;
    }

    private boolean tryDateParse(String date) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.parse(date);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public int SaveOrUpdate(List<ShopOrderMstDto> parms) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                parms = this.setOrderRequest(parms);
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                Object sqlUpdateNomal = "UPDATE SHOPORDMST \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + "SET ORDER_STATUS = ? , \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " ORDER_DATE = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " ORDER_ETC_1 = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " DS_ORDER_STATUS = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " DOSINORDCD = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " DELIVERY_ID = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " RECEIVE_CEL = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " RECEIVE_TEL = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " USER_TEL = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " RECEIVE_ZIPCODE = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " RECEIVE_ADDR = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " USER_NAME = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " RECEIVE_NAME = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " USER_CEL = ?,   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " INVOICE_NO = ? , \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " DOMEORDERNO = ? , \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " WON_COST = ? ,  \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + " ORDER_ETC_14 = ?   \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + "WHERE \r\n ";
                sqlUpdateNomal = (String)sqlUpdateNomal + "COMPNO = ? AND SHOPID = ? AND SHOP_USERID = ? AND ORDER_ID =? AND MALL_EXP_CD = ?AND ORDSEQ =?\r\n \r\n ";
                PreparedStatement pstmtUpdateNomal = connection.prepareStatement(((String)sqlUpdateNomal).toUpperCase());
                PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSave().toUpperCase());
                PreparedStatement pstmtSaveLog = connection.prepareStatement(this.getSqlLog().toUpperCase());
                statementlist.add(pstmtUpdateNomal);
                statementlist.add(pstmtSave);
                statementlist.add(pstmtSaveLog);
                boolean isUpdateNomal = false;
                boolean isSave = false;
                boolean isLog = false;
                for (ShopOrderMstDto dto : parms) {
                    if (dto.getCompayny_goods_cd().indexOf("_") != -1) {
                        dto.setCompayny_goods_cd(dto.getCompayny_goods_cd().substring(0, dto.getCompayny_goods_cd().indexOf("_")));
                    }
                    int isOrder = 0;
                    String isOrderDate = "";
                    int isTmonOrder = 0;
                    if (dto.getResult_code().equals("1")) {
                        String company_goods_cd;
                        String goodProdCd;
                        String isClaim = dto.getOrder_status();
                        isOrderDate = this.isShopOrderMstCheckTmonOrderDate(dto.getShopid(), dto.getOrder_id());
                        if (dto.getShopid().equals("shop0076") && !this.tryDateParse(isOrderDate)) {
                            this.UpdateNormal(dto, connection, statementlist, pstmtUpdateNomal);
                        }
                        isTmonOrder = this.isShopOrderMstCheckTmonOrderCount(dto.getShopid(), dto.getOrder_id(), dto.getP_sku_value());
                        if (dto.getShopid().equals("shop0076") && (isClaim.equals("R02") || isClaim.equals("E02") || isClaim.equals("C02")) && (dto.getMall_exp_cd().equals("C02") || dto.getMall_exp_cd().equals("R02") || dto.getMall_exp_cd().equals("E02")) && (isOrder = this.isShopOrderMstExitsWithisClaim(dto.getShopid(), dto.getOrder_id(), isClaim)) > 0 && isTmonOrder < 2) {
                            isSave = true;
                            goodProdCd = this.getCompanyOptGoodsCd(dto.getShopid(), dto.getMall_product_id(), dto.getP_sku_id() == null ? "" : dto.getP_sku_id(), dto.getP_sku_value());
                            if (!goodProdCd.isEmpty()) {
                                dto.setCompayny_goods_cd(goodProdCd);
                            }
                            if (dto.getCompayny_goods_cd().isEmpty()) {
                                company_goods_cd = ShopOrderDao.get().prodordermatch(dto);
                                dto.setCompayny_goods_cd(company_goods_cd);
                            }
                            this.Save(dto, connection, statementlist, pstmtSave);
                        }
                        if (isClaim.equals("R02") || isClaim.equals("E02") || isClaim.equals("C02")) {
                            if (dto.getMall_exp_cd().equals("C02") || dto.getMall_exp_cd().equals("R02") || dto.getMall_exp_cd().equals("E02")) {
                                isOrder = this.isShopOrderMstExitsWithisClaim(dto.getShopid(), dto.getOrder_id(), isClaim);
                                if (isOrder > 0) continue;
                                isSave = true;
                                goodProdCd = this.getCompanyOptGoodsCd(dto.getShopid(), dto.getMall_product_id(), dto.getP_sku_id() == null ? "" : dto.getP_sku_id(), dto.getP_sku_value());
                                if (!goodProdCd.isEmpty()) {
                                    dto.setCompayny_goods_cd(goodProdCd);
                                }
                                if (dto.getCompayny_goods_cd().isEmpty()) {
                                    company_goods_cd = ShopOrderDao.get().prodordermatch(dto);
                                    dto.setCompayny_goods_cd(company_goods_cd);
                                }
                                if (!dto.getMall_exp_cd().equals("E02")) {
                                    if (dto.getWon_cost().equals("0")) {
                                        dto = ShopOrderDao.get().getProdInfoWonCost(dto);
                                        dto.setWon_cost(String.valueOf(Integer.parseInt(dto.getWon_cost()) * Integer.parseInt(dto.getSale_cnt())));
                                    }
                                    if (dto.getMall_won_cost().equals("0")) {
                                        dto = ShopOrderDao.get().getMallwonCost(dto);
                                        int mallwoncost = (int)((float)Integer.parseInt(dto.getTotal_cost()) * Float.valueOf(Float.valueOf(dto.getMall_won_cost()).floatValue() / 100.0f).floatValue());
                                        int cost = Integer.parseInt(dto.getTotal_cost()) - mallwoncost;
                                        dto.setMall_won_cost(String.valueOf(cost));
                                    }
                                } else {
                                    dto.setWon_cost("0");
                                    dto.setMall_won_cost("0");
                                }
                                this.Save(dto, connection, statementlist, pstmtSave);
                            } else {
                                isUpdateNomal = true;
                                this.UpdateNormal(dto, connection, statementlist, pstmtUpdateNomal);
                            }
                        } else {
                            isUpdateNomal = true;
                            this.UpdateNormal(dto, connection, statementlist, pstmtUpdateNomal);
                        }
                    }
                    if (!dto.getResult_code().equals("1") && !dto.getResult_code().equals("-1")) continue;
                    isLog = true;
                    this.SaveLog(dto, connection, statementlist, pstmtSaveLog);
                }
                if (isSave) {
                    pstmtSave.executeBatch();
                    pstmtSave.clearBatch();
                }
                if (isUpdateNomal) {
                    pstmtUpdateNomal.executeBatch();
                    pstmtUpdateNomal.clearBatch();
                }
                if (isLog) {
                    pstmtSaveLog.executeBatch();
                    pstmtSaveLog.clearBatch();
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return parms.size();
    }

    private PreparedStatement UpdateNormal(ShopOrderMstDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int j = 0;
        pstmt.setString(++j, dto.getOrder_status());
        pstmt.setString(++j, dto.getOrder_date());
        pstmt.setString(++j, dto.getOrder_etc_1());
        pstmt.setString(++j, dto.getDs_order_status());
        pstmt.setString(++j, dto.getDosinOrder_code() == null ? "" : dto.getDosinOrder_code());
        pstmt.setString(++j, dto.getDelivery_id() == null ? "" : dto.getDelivery_id());
        pstmt.setString(++j, dto.getReceive_cel());
        pstmt.setString(++j, dto.getReceive_tel());
        pstmt.setString(++j, dto.getUser_tel());
        pstmt.setString(++j, dto.getReceive_zipcode());
        pstmt.setString(++j, dto.getReceive_addr());
        pstmt.setString(++j, dto.getUser_name());
        pstmt.setString(++j, dto.getReceive_name());
        pstmt.setString(++j, dto.getUser_cel());
        pstmt.setString(++j, dto.getInvoice_no() == null ? "" : dto.getInvoice_no());
        pstmt.setString(++j, dto.getDomeorderno() == null ? "" : dto.getDomeorderno());
        pstmt.setString(++j, dto.getWon_cost() == null ? "" : dto.getWon_cost());
        pstmt.setString(++j, dto.getP_sku_value2() == null ? "" : dto.getP_sku_value2());
        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++j, dto.getShopid());
        pstmt.setString(++j, dto.getShop_userid());
        pstmt.setString(++j, dto.getOrder_id());
        pstmt.setString(++j, dto.getMall_exp_cd());
        pstmt.setString(++j, dto.getOrdseq());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private PreparedStatement UpdateClaim(ShopOrderMstDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int j = 0;
        pstmt.setString(++j, dto.getOrder_status());
        pstmt.setString(++j, dto.getOrder_etc_1());
        pstmt.setString(++j, dto.getDs_order_status());
        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++j, dto.getShopid());
        pstmt.setString(++j, dto.getShop_userid());
        pstmt.setString(++j, dto.getOrder_id());
        pstmt.setString(++j, dto.getOrder_status().substring(0, 1));
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private PreparedStatement Save(ShopOrderMstDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int j = 0;
        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++j, dto.getOrder_id());
        pstmt.setString(++j, dto.getShopid());
        pstmt.setString(++j, dto.getShopseq());
        pstmt.setString(++j, dto.getShop_userid());
        pstmt.setString(++j, dto.getOrder_status());
        pstmt.setString(++j, dto.getUser_id());
        pstmt.setString(++j, dto.getUser_name());
        pstmt.setString(++j, dto.getUser_tel());
        pstmt.setString(++j, dto.getUser_cel());
        pstmt.setString(++j, dto.getUser_email());
        pstmt.setString(++j, dto.getReceive_tel());
        pstmt.setString(++j, dto.getReceive_cel());
        pstmt.setString(++j, dto.getReceive_email());
        pstmt.setString(++j, dto.getDelv_msg());
        pstmt.setString(++j, dto.getReceive_name());
        pstmt.setString(++j, dto.getReceive_zipcode());
        if (dto.getShopid().equals("shop0003") || dto.getShopid().equals("shop00031")) {
            pstmt.setString(++j, dto.getReceive_addr() + " " + dto.getReceive_detail());
        } else {
            pstmt.setString(++j, dto.getReceive_addr());
        }
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getTotal_cost()));
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getPay_cost()));
        pstmt.setString(++j, dto.getOrder_date());
        pstmt.setString(++j, dto.getPartner_id());
        pstmt.setString(++j, dto.getDpartner_id());
        pstmt.setString(++j, dto.getMall_product_id());
        pstmt.setString(++j, dto.getProduct_id());
        pstmt.setString(++j, dto.getSku_id());
        pstmt.setString(++j, dto.getP_product_name());
        pstmt.setString(++j, dto.getP_sku_value());
        pstmt.setString(++j, dto.getProduct_name());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getSale_cost()));
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getMall_won_cost()));
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getWon_cost()));
        pstmt.setString(++j, dto.getSku_value());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getSale_cnt()));
        pstmt.setString(++j, dto.getDelivery_method_str());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getDelv_cost()));
        pstmt.setString(++j, dto.getCompayny_goods_cd());
        pstmt.setString(++j, dto.getSku_alias());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getBox_ea()));
        pstmt.setString(++j, dto.getJung_chk_yn());
        pstmt.setString(++j, dto.getMall_order_seq());
        pstmt.setString(++j, dto.getMall_order_id());
        pstmt.setString(++j, dto.getEtc_field3());
        pstmt.setString(++j, dto.getOrder_gubun());
        pstmt.setInt(++j, YDMAStringUtil.convertToInt(dto.getP_ea()));
        pstmt.setString(++j, dto.getOrd_field2());
        pstmt.setString(++j, dto.getCopy_idx());
        pstmt.setString(++j, dto.getGoods_nm_pr());
        pstmt.setString(++j, dto.getGoods_keyword());
        pstmt.setString(++j, dto.getOrd_confirm_date());
        pstmt.setString(++j, dto.getRtn_dt());
        pstmt.setString(++j, dto.getChng_dt());
        pstmt.setString(++j, dto.getDelivery_confirm_date());
        pstmt.setString(++j, dto.getCancel_dt());
        pstmt.setString(++j, dto.getClass_cd1());
        pstmt.setString(++j, dto.getClass_cd2());
        pstmt.setString(++j, dto.getClass_cd3());
        pstmt.setString(++j, dto.getClass_cd4());
        pstmt.setString(++j, dto.getBrand_nm());
        pstmt.setString(++j, dto.getDelivery_id());
        pstmt.setString(++j, dto.getInvoice_no());
        pstmt.setString(++j, dto.getHope_delv_date());
        pstmt.setString(++j, dto.getFld_dsp());
        pstmt.setString(++j, dto.getInv_send_msg());
        pstmt.setString(++j, dto.getModel_no());
        pstmt.setString(++j, dto.getSet_gubun());
        pstmt.setString(++j, dto.getEtc_msg());
        pstmt.setString(++j, dto.getDelv_msg1());
        pstmt.setString(++j, dto.getMul_delv_msg());
        pstmt.setString(++j, dto.getBarcode());
        pstmt.setString(++j, dto.getInv_send_dm());
        pstmt.setString(++j, dto.getDelivery_method_str2());
        pstmt.setString(++j, dto.getLabel());
        pstmt.setString(++j, "N");
        pstmt.setString(++j, dto.getOrder_etc_2());
        pstmt.setString(++j, dto.getOrder_etc_3());
        pstmt.setString(++j, dto.getOrder_etc_4());
        pstmt.setString(++j, dto.getOrder_etc_5());
        pstmt.setString(++j, dto.getOrder_etc_6());
        pstmt.setString(++j, dto.getOrder_etc_7());
        pstmt.setString(++j, dto.getOrder_etc_8());
        pstmt.setString(++j, dto.getOrder_etc_9());
        pstmt.setString(++j, dto.getOrder_etc_10());
        pstmt.setString(++j, dto.getOrder_etc_11());
        pstmt.setString(++j, dto.getOrder_etc_12());
        pstmt.setString(++j, dto.getOrder_etc_13());
        pstmt.setString(++j, dto.getOrder_etc_14());
        pstmt.setString(++j, dto.getMall_exp_cd());
        pstmt.setString(++j, dto.getReceiptid());
        pstmt.setString(++j, dto.getExchangeid());
        pstmt.setString(++j, dto.getAuthkey1());
        dto.setResult_code("0");
        String msg = String.format("\uc0ac\uc6a9\uc790\uc544\uc774\ub514 %s \uc8fc\ubb38\ubc88\ud638 %s \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getUser_id(), dto.getOrder_id());
        dto.setResult_text(msg);
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    public PreparedStatement SaveLog(ShopOrderMstDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int j = 0;
        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++j, dto.getShopid());
        pstmt.setString(++j, dto.getOrder_id());
        pstmt.setString(++j, dto.getShop_userid());
        pstmt.setString(++j, dto.getP_product_name());
        pstmt.setString(++j, dto.getOrder_status());
        pstmt.setString(++j, OrderStatus.getInstance().findCode(dto.getOrder_status()));
        pstmt.setString(++j, dto.getResult_text());
        pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    public List<ShopOrderStatusDto> getOrderLog(String shopid, String orderID) throws Exception {
        ArrayList<ShopOrderStatusDto> list = new ArrayList<ShopOrderStatusDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT  A.SHOPID AS  SHOPID, B.SHOPNM  AS SHOPNM, A.SHOPUSERID AS  SHOPUSERID,  A.ORDER_STATUSNM AS ORDER_STATUSNM ,IFNULL(A.RESULTMESSAGE,'')  AS RESULTMESSAGE, A.SENDDT AS SENDDT\r\n  FROM SHOPORDSTATUSLOG  AS A\r\n  INNER JOIN shopinfo AS B\r\n  ON A.SHOPID = B.SHOPCD\r\n  WHERE A.COMPNO = ? AND A.SHOPID= ? AND A.ORDER_ID = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopid);
                pstmt.setString(3, orderID);
                YDMAStringUtil.Print("[getOrderLog]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ShopOrderStatusDto dto = new ShopOrderStatusDto();
                    dto.setOrdseq(++rowno);
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setShopuserid(rs.getString("SHOPUSERID"));
                    dto.setOrder_status(rs.getString("ORDER_STATUSNM"));
                    dto.setResultMessage(rs.getString("RESULTMESSAGE"));
                    dto.setSenddt(rs.getString("SENDDT"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderStatusDto> getOrderStatus(String date) throws Exception {
        ArrayList<ShopOrderStatusDto> list = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT \r\nA.ORDSEQ AS ORDSEQ, \r\nA.SEQ AS SEQ, \r\nA.COMPNO AS COMPNO,\r\nB.SHOPNM AS SHOPNM,\r\nA.SHOPID AS SHOPID, \r\nA.SHOPUSERID AS SHOPUSERID,\r\nA.ORDER_STATUS AS ORDER_STATUS,\r\nC.NAME AS STATUSNAME,\r\nRESULTMESSAGE AS RESULTMESSAGE, \r\nSENDDT AS SENDDT\r\nFROM SHOPORDSTATUSLOG AS A\r\nINNER JOIN SHOPINFO AS B\r\nON A.SHOPID = B.SHOPCD\r\nINNER JOIN shopordstatus AS C\r\nON C.SHOPID = 'shop0003'\r\nAND A.ORDER_STATUS = C.CODE \r\n WHERE A.COMPNO =? AND SENDDT > ? AND  SENDDT < ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, date.concat(" 00:00:00"));
                pstmt.setString(3, date.concat(" 23:59:00"));
                YDMAStringUtil.Print("[getOrderStatus]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    rs.beforeFirst();
                    list = new ArrayList<ShopOrderStatusDto>();
                    int rowno = 0;
                    while (rs.next()) {
                        ShopOrderStatusDto dto = new ShopOrderStatusDto();
                        dto.setOrdseq(++rowno);
                        dto.setShopnm(rs.getString("SHOPNM"));
                        dto.setShopuserid(rs.getString("SHOPUSERID"));
                        dto.setStatusname(rs.getString("STATUSNAME"));
                        dto.setOrder_status(rs.getString("ORDER_STATUS"));
                        dto.setResultMessage(rs.getString("RESULTMESSAGE"));
                        dto.setSenddt(rs.getString("SENDDT"));
                        list.add(dto);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ShopOrderMstDto getShopOrderExpressList(String ordseq) throws Exception {
        ShopOrderMstDto dto = new ShopOrderMstDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(b.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("IFNULL(c.DLVID,  '' ) AS DLVID, \r\n");
                sql.append("ifnull(c.DLVNM,'') AS DLVNM,  \r\n");
                sql.append("IFNULL(d.URL,  '' ) AS URL, \r\n");
                sql.append("IFNULL(d.USER_ID,  '' ) AS EXPID, \r\n");
                sql.append("IFNULL(d.PASSWD,  '' ) AS PASSWD,");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID       \r\n");
                sql.append(" FROM shopordmst m JOIN shopprodin b ON m.compno = b.compno \r\nAND m.MALL_PRODUCT_ID = b.SHOPPRODNO \r\nJOIN expprodmst a ON m.compno = a.compno AND b.COMPAYNY_GOODS_CD = a.PRODCD \r\nJOIN deliverys c ON a.expcd = c.DLVNM \r\nJOIN dvlinfo d ON m.COMPNO = d.compno AND c.DLVID = d.DVLID ");
                sql.append(" WHERE M.COMPNO = ? AND M.ORDSEQ= ? ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, ordseq);
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setDlvid(rs.getString("DLVID"));
                    dto.setDlvnm(rs.getString("DLVNM"));
                    dto.setUrl(rs.getString("URL"));
                    dto.setExpid(rs.getString("EXPID"));
                    dto.setPasswd(rs.getString("PASSWD"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<String> getNaverAddress(List<ShopOrderMstDto> map, Shell shell) {
        ArrayList<String> list = new ArrayList<String>();
        ChromeExtention chrome = ChromeExtention.getInstace();
        ChromeDriver driver = null;
        try {
            try {
                YDMAProgressBar.get().start("\ud0dd\ubc30\uc0ac \uc804\uc1a1\uc911\uc785\ub2c8\ub2e4.", 1);
                YDMAProgressBar.get().setValue("\ud0dd\ubc30\uc0ac\uc804\uc1a1\uc911\uc785\ub2c8\ub2e4.", 0, false);
                driver = chrome.setFileDown(false).setHeadlessMode(true).getDriver();
                String URL2 = "https://search.naver.com/search.naver";
                driver.get(URL2);
                WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
                for (ShopOrderMstDto dto : map) {
                    ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).clear();
                    ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).sendKeys(new CharSequence[]{dto.getReceive_addr()});
                    ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_search_form\"]/fieldset/button")))).click();
                    String address = ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"lcs_region_section\"]/div[2]/div[2]/div[1]/h3")))).getText();
                    list.add(address);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                driver.quit();
            }
        }
        finally {
            driver.quit();
        }
        return list;
    }

    public List<ShopOrderMstDto> sendPickupExpressCrawl(List<ShopOrderMstDto> list, Shell shell, List<String> addr) {
        ArrayList<ShopOrderMstDto> express = new ArrayList<ShopOrderMstDto>();
        ChromeExtention chrome = ChromeExtention.getInstace();
        ChromeDriver driver = null;
        try {
            try {
                driver = chrome.setFileDown(false).setHeadlessMode(false).getDriver();
                String URL2 = list.get(0).getUrl();
                WebDriverWait wait = new WebDriverWait((WebDriver)driver, 30L);
                driver.get(URL2);
                Thread.sleep(1000L);
                WebElement elementloginBox = driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{list.get(0).getExpid()});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{list.get(0).getPasswd()});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
                wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[3]/i-button")))).click();
                Thread.sleep(1000L);
                ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[2]/div[2]/ul/li[1]/a")))).click();
                driver.switchTo().frame(driver.findElement(By.id((String)"workframe_10781")));
                WebElement cfr_ignored_0 = (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/div[2]")));
                for (ShopOrderMstDto dto : list) {
                    YDMAProgressBar.get().setValue("\ud0dd\ubc30\uc0ac\uc804\uc1a1\uc911\uc785\ub2c8\ub2e4.", 1, false);
                    new ArrayList();
                    Thread.sleep(1000L);
                    new StringBuffer();
                    driver.executeScript(String.format("$('#edtAcperTel').val('%s'); ", dto.getReceive_tel().equals("") ? dto.getReceive_cel() : dto.getReceive_tel()), new Object[]{""});
                    driver.executeScript(String.format("$('#edtAcperNm').val('%s'); ", dto.getReceive_name()), new Object[]{""});
                    driver.executeScript("$('#btnAcperBadr').click(); ", new Object[]{""});
                    String strExcute = "(()=>{ " + String.format("$('#edtSrchAdrMultiPopGrid').val('%s'); \r\n", addr.get(0)) + "$('#btnAdrMultiSrchGrid').click();  \r\n setTimeout( ()=>{ \r\n     if(dsAdrMultiPopGrid.getRowCount() > 0) \r\n    { " + String.format("dsAdrMultiPopGrid.setRowPosition(dsAdrMultiPopGrid.getRows().findIndex((p)=>p.basAreaNo === '%s'  || p.zipcd === '%s')); \r\n ", dto.getReceive_zipcode(), dto.getReceive_zipcode()) + "$.popCallBack.popupCallBack_fn(dsAdrMultiPopGrid.getRow(dsAdrMultiPopGrid.getRowPosition())); \r\ndsAdrMultiPopGrid.clearData(); \r\n$('body > div:nth-child(34) > div.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix > div > button:nth-child(1)').trigger('click');}},500);})();";
                    driver.executeScript(strExcute, new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript(String.format("$('#edtAcperEtcAdr').val('%s'); ", dto.getReceive_addr().substring(addr.get(0).length(), dto.getReceive_addr().length())), new Object[]{""});
                    driver.executeScript(String.format("$('#edtGdsNm').val('%s');  ", dto.getP_product_name()), new Object[]{""});
                    driver.executeScript(String.format("$('#edtDlvMsgCont').val('%s');", dto.getDelv_msg()), new Object[]{""});
                    driver.executeScript(String.format("$('#maeQty').val('%s'); ", dto.getSale_cnt()), new Object[]{""});
                    if (dto.getDelivery_method_str().equals("\ucc29\ubd88")) {
                        driver.executeScript("$('#cboFareSctCd').val('02')", new Object[]{""});
                    } else {
                        driver.executeScript("$('#cboFareSctCd').val('03')", new Object[]{""});
                    }
                    driver.executeScript(String.format("$('#maeDlvFare').val('%s')", dto.getDelv_cost()), new Object[]{""});
                    driver.executeScript("fnSave()", new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript("$('.msgButton').click()", new Object[]{""});
                    Thread.sleep(1500L);
                    driver.executeScript("$('.msgButton').click()", new Object[]{""});
                    express.add(dto);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                YDMAProgressBar.get().end();
                driver.quit();
            }
        }
        finally {
            YDMAProgressBar.get().end();
            driver.quit();
        }
        return express;
    }

    public List<ShopOrderMstDto> getPickupExpressCrawl(List<ShopOrderMstDto> list, Shell shell) {
        ArrayList<ShopOrderMstDto> express = new ArrayList<ShopOrderMstDto>();
        try {
            try {
                this.driver = this.chrome.setFileDown(false).setHeadlessMode(false).getDriver();
                String URL2 = list.get(0).getUrl();
                WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, 30L);
                ChromeScript.get().get(this.driver, URL2);
                Thread.sleep(1000L);
                WebElement elementloginBox = this.driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{list.get(0).getExpid()});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{list.get(0).getPasswd()});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
                wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[5]/i-button")))).click();
                Thread.sleep(1000L);
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[4]/div[1]/ul/li[1]/a")))).click();
                this.driver.switchTo().frame(this.driver.findElement(By.id((String)"workframe_21847")));
                for (ShopOrderMstDto dto : list) {
                    ChromeScript.get().addScript("$('#cboSrchPrntSctCd').val('');").waitTiem(2000L).executeScripter(this.driver);
                    ChromeScript.get().addScript("$('#cboSrchCond').val('40');").waitTiem(2000L).executeScripter(this.driver);
                    ChromeScript.get().addScript(String.format("$('#edtSrchCondVal').val('%s'); ", dto.getReceive_tel().equals("") ? dto.getReceive_cel() : dto.getReceive_tel())).waitTiem(2000L).executeScripter(this.driver);
                    ChromeScript.get().until((WebDriver)this.driver, () -> this.driver.findElementByCssSelector("body > div.container-fluid.frameArea > div.frameHeader > div.panelBox.searchBox.detailSearch > div.searchBtnGroup > i-button.funcBtn.ico.iconSearch.White.searchBtn")).click();
                    Thread.sleep(1000L);
                    String invoice = ChromeScript.get().returnCallbackScripter("return grdRsrv.getRowData(0)[8];", this.driver);
                    YDMAStringUtil.Print(invoice);
                    dto.setInvoice_no(invoice);
                    express.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.driver.quit();
            }
        }
        finally {
            this.driver.quit();
        }
        return express;
    }

    public void invoiceUpdate(List<ShopOrderMstDto> sendResult) throws Exception {
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordmst set  DELIVERY_ID = ?, INVOICE_NO = ? where compno = ? and ordseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopOrderMstDto dto : sendResult) {
                    int i = 0;
                    pstmt.setString(++i, "\ub86f\ub370\ud0dd\ubc30_" + dto.getDlvid());
                    pstmt.setString(++i, dto.getInvoice_no());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, dto.getOrdseq());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[invoiceUpdate]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public int setShopOrderMstDelete(List<ShopOrderMstDto> sendResult) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopordmst  where compno = ?    and ordseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopOrderMstDto dto : sendResult) {
                    int i = 0;
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, dto.getOrdseq());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setShopOrderMstDelete]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setShopOrderMstChange(List<ShopOrderMstDto> sendResult, String ordStatus) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordmst set ORDER_STATUS = ?,ORDER_ETC_1 = ?  where compno = ?    and ordseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopOrderMstDto dto : sendResult) {
                    int i = 0;
                    pstmt.setString(++i, ordStatus);
                    pstmt.setString(++i, dto.getOrder_status());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, dto.getOrdseq());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setShopOrderMstChange]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        Object complite = "";
        int j = 0;
        while (j < split.length) {
            complite = (String)complite + split[j];
            complite = ((String)complite).trim();
            ++j;
        }
        return complite;
    }

    public List<List<String>> sendKakao(Shell shell, List<ShopOrderMstDto> list, String template, int len, String sendtelno) {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        try {
            CompInfoDao comdao = new CompInfoDao();
            List<String> comlist = comdao.getServerCompany();
            String userid = "kdjsystem";
            String real_profile_key = comlist.get(21);
            ArrayList<String> msg = new ArrayList<String>();
            ArrayList<String> tel = new ArrayList<String>();
            String url = "https://alimtalk-api.sweettracker.net/v2/" + real_profile_key + "/sendMessage";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            List<Object> templatecode = new ArrayList();
            if (!template.equals("sms")) {
                templatecode = aldao.getTemplateCodeList(comlist.get(0), template);
            }
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setRequestProperty("userid", userid);
            httpConnection.setDoOutput(true);
            StringBuffer payload = new StringBuffer();
            payload.append("[");
            int i = 0;
            while (i < list.size()) {
                long time = System.currentTimeMillis();
                if (template.equals("sms")) {
                    msg.add(i, list.get(i).getMsg());
                    tel.add(i, list.get(i).getTelno());
                    payload.append("{");
                    payload.append("\"msgid\":\"").append(time).append("\",");
                    payload.append("\"profile_key\":\"").append(real_profile_key).append("\",");
                    payload.append("\"template_code\":\"").append(templatecode.size() != 0 ? (String)templatecode.get(2) : "kdj002").append("\",");
                    payload.append("\"receiver_num\":\"").append(this.splitMark(list.get(i).getTelno())).append("\",");
                    payload.append("\"message\":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"reserved_time\":\"").append("00000000000000").append("\",");
                    payload.append("\"sms_message\":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"sms_title\":\"").append("\",");
                    if (len < 90) {
                        payload.append("\"sms_kind\":\"").append("S").append("\",");
                    } else {
                        payload.append("\"sms_kind\":\"").append("L").append("\",");
                    }
                } else {
                    msg.add(i, list.get(i).getMsg());
                    tel.add(i, list.get(i).getTelno());
                    payload.append("{");
                    payload.append("\"msgid\":\"").append(time).append("\",");
                    payload.append("\"profile_key\":\"").append(real_profile_key).append("\",");
                    payload.append("\"template_code\":\"").append((String)templatecode.get(2)).append("\",");
                    payload.append("\"receiver_num\":\"").append(this.splitMark(list.get(i).getTelno())).append("\",");
                    payload.append("\"message\":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"reserved_time\":\"").append("00000000000000").append("\",");
                    payload.append("\"sms_message\":\"").append((String)msg.get(i)).append("\",");
                    payload.append("\"sms_title\":\"").append("\",");
                    payload.append("\"sms_kind\"").append(":\"").append("N").append("\",");
                }
                payload.append("\"sender_num\"").append(":\"").append(sendtelno).append("\",");
                payload.append("\"parcel_company\"").append(":\"").append("08").append("\",");
                payload.append("\"parcel_invoice\"").append(":\"").append("").append("\"");
                payload.append("} ");
                if (i < list.size() - 1) {
                    payload.append(", ");
                }
                payload.append("\n");
                ++i;
            }
            payload.append("] ");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\uce74\uce74\uc624\ud1a1: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            JsonArray dataObject = jsonObject.getAsJsonArray();
            int i2 = 0;
            while (i2 < dataObject.getAsJsonArray().size()) {
                JsonElement jsonElement = dataObject.getAsJsonArray().get(i2);
                String result = jsonElement.getAsJsonObject().get("result").getAsString();
                if (result.equals("Y")) {
                    String msgid = jsonElement.getAsJsonObject().get("msgid").getAsString();
                    String code = jsonElement.getAsJsonObject().get("code").getAsString();
                    String error = jsonElement.getAsJsonObject().get("error").getAsString();
                    String kind = jsonElement.getAsJsonObject().get("kind").getAsString();
                    String sendtime = jsonElement.getAsJsonObject().get("sendtime").getAsString();
                    ArrayList<String> listadd = new ArrayList<String>();
                    listadd.add(result);
                    listadd.add(msgid);
                    listadd.add(code);
                    listadd.add(error);
                    listadd.add(kind);
                    listadd.add((String)tel.get(i2));
                    listadd.add((String)msg.get(i2));
                    listadd.add(sendtime);
                    responContents.add(listadd);
                } else {
                    ArrayList<String> listadd = new ArrayList<String>();
                    listadd.add(jsonElement.getAsJsonObject().get("result").getAsString());
                    listadd.add(jsonElement.getAsJsonObject().get("msgid").getAsString());
                    listadd.add(jsonElement.getAsJsonObject().get("code").getAsString());
                    listadd.add(jsonElement.getAsJsonObject().get("error").getAsString());
                    listadd.add(jsonElement.getAsJsonObject().get("kind").getAsString());
                    listadd.add(jsonElement.getAsJsonObject().get("sendtime").getAsString());
                    responContents.add(listadd);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<ShopOrderMstDto> statisticalInfo(String startdt, String enddt, String statis, String shopcd, String shopid) throws Exception {
        ArrayList<ShopOrderMstDto> contents = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " CALL YWM_SALES_STATISTICS(?, ?, ?, ?, ?, ?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, startdt);
                pstmt.setString(3, enddt);
                pstmt.setString(4, statis);
                pstmt.setString(5, shopcd);
                pstmt.setString(6, shopid);
                YDMAStringUtil.Print("[statisticalInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    int columnIndex = 0;
                    if (statis.equals("1")) {
                        dto.setCompayny_goods_cd(rs.getString(++columnIndex));
                        dto.setP_product_name(rs.getString(++columnIndex));
                        dto.setNickname(rs.getString(++columnIndex));
                    } else if (statis.equals("2") || statis.equals("3")) {
                        dto.setReg_date(rs.getString(++columnIndex));
                    } else if (statis.equals("4")) {
                        dto.setShopnm(rs.getString(++columnIndex));
                        dto.setShop_userid(rs.getString(++columnIndex));
                        dto.setNickname(rs.getString(++columnIndex));
                    } else if (statis.equals("5")) {
                        dto.setUser_name(rs.getString(++columnIndex));
                        dto.setNickname(rs.getString(++columnIndex));
                        dto.setP_product_name(rs.getString(++columnIndex));
                    }
                    dto.setOrd_cnt(rs.getString(++columnIndex));
                    dto.setSale_cnt(rs.getString(++columnIndex));
                    dto.setSale_cost(rs.getString(++columnIndex));
                    dto.setRet_cnt(rs.getString(++columnIndex));
                    dto.setRet_cost(rs.getString(++columnIndex));
                    dto.setCnc_cnt(rs.getString(++columnIndex));
                    dto.setCnc_cost(rs.getString(++columnIndex));
                    dto.setGoods_cost(rs.getString(++columnIndex));
                    dto.setMall_won_cost(rs.getString(++columnIndex));
                    dto.setDelv_cost(rs.getString(++columnIndex));
                    dto.setProfit(rs.getString(++columnIndex));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopOrderMstDto getWonCost(ShopOrderMstDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(GOODS_COST,'0'), ifnull(PARTNER_ID,'') from shopprodin where COMPAYNY_GOODS_CD = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getCompayny_goods_cd());
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    new ArrayList();
                    int columnIndex = 0;
                    dto.setWon_cost(rs.getString(++columnIndex));
                    dto.setPartner_id(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopOrderMstDto> getShopOrderOneList(List<List<String>> filteredList, String startdt, String enddt, String search3) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                int i = 0;
                while (i < filteredList.size()) {
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT \r\n");
                    sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                    sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                    sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                    sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                    sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                    sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                    sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                    sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                    sql.append("IFNULL(M.DS_ORDER_STATUS,  '' ) AS DS_ORDER_STATUS,  \r\n");
                    sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                    sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                    sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                    sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                    sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                    sql.append("IFNULL(M.DOMEORDERNO,  '' ) AS DOMEORDERNO,  \r\n");
                    sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                    sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                    sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                    sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                    sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                    sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                    sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                    sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                    sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                    sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                    sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                    sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                    sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                    sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                    sql.append("IFNULL(M.MALL_WON_COST,  '0' ) AS MALL_WON_COST,  \r\n");
                    sql.append("IFNULL(M.WON_COST,  '0' ) AS WON_COST,  \r\n");
                    sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                    sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                    sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                    sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                    sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                    sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                    sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                    sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                    sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                    sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                    sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                    sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                    sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                    sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                    sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                    sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                    sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                    sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                    sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                    sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                    sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                    sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                    sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                    sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                    sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                    sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                    sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                    sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                    sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                    sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                    sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                    sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                    sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                    sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                    sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                    sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                    sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                    sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                    sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                    sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                    sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                    sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                    sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                    sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                    sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                    sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                    sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS VENDORID  ,    \r\n");
                    sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                    sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID  ,    \r\n");
                    sql.append("IFNULL(M.DOSINORDCD  ,'') AS DOSINORDCD  ,    \r\n");
                    sql.append("(SELECT COUNT(ORDSEQ) FROM SHOPORDCS WHERE ORDSEQ =M.ORDSEQ AND CSCLOSE='Y' ) AS CSCLOSE \r\n");
                    sql.append(" FROM shopordmst AS M \r\n");
                    sql.append(" LEFT JOIN shopdtl AS D \r\n");
                    sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                    sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                    sql.append(" AND M.SHOP_USERID = D.SHOPPINGID AND M.AUTHKEY1=D.AUTHKEY1 AND M.SHOPSEQ = D.SHOPSEQ\r\n");
                    sql.append(" WHERE M.COMPNO = ?  and ORDSEQ = ? ");
                    sql.append(String.format(" AND (M.%s >= ? AND  M.%s <= ?)  ORDER BY %s DESC ", search3, search3, search3));
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, filteredList.get(i).get(0));
                    pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(startdt, false));
                    pstmt.setString(4, YDMATimeUtil.convertSabangNetOrderDateToOrddt(enddt, false));
                    YDMAStringUtil.Print(" test::" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    Integer rowNum = 0;
                    while (rs.next()) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        rowNum = rowNum + 1;
                        dto.setNo(rowNum.toString());
                        dto.setReg_date(rs.getString("REG_DATE"));
                        dto.setOrder_date(rs.getString("ORDER_DATE"));
                        dto.setOrder_status(rs.getString("ORDER_STATUS"));
                        dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                        dto.setShopid(rs.getString("SHOPID"));
                        dto.setShopseq(rs.getString("SHOPSEQ"));
                        dto.setShop_userid(rs.getString("SHOP_USERID"));
                        dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                        dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                        dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                        dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                        dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                        dto.setSale_cnt(rs.getString("SALE_CNT"));
                        dto.setWon_cost(rs.getString("WON_COST"));
                        dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                        dto.setSale_cost(rs.getString("SALE_COST"));
                        dto.setDelv_cost(rs.getString("DELV_COST"));
                        dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                        dto.setDelv_msg(rs.getString("DELV_MSG"));
                        dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                        dto.setInvoice_no(rs.getString("INVOICE_NO"));
                        dto.setLabel(rs.getString("LABEL"));
                        dto.setDomeOrderId(rs.getString("DOMEORDERNO"));
                        dto.setProduct_id(rs.getString("PRODUCT_ID"));
                        dto.setOrdseq(rs.getString("ORDSEQ"));
                        dto.setCompno(rs.getString("COMPNO"));
                        dto.setOrder_id(rs.getString("ORDER_ID"));
                        dto.setUser_id(rs.getString("USER_ID"));
                        dto.setUser_name(rs.getString("USER_NAME"));
                        dto.setUser_tel(rs.getString("USER_TEL"));
                        dto.setUser_cel(rs.getString("USER_CEL"));
                        dto.setUser_email(rs.getString("USER_EMAIL"));
                        dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                        dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                        dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                        dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                        dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                        dto.setTotal_cost(rs.getString("TOTAL_COST"));
                        dto.setPay_cost(rs.getString("PAY_COST"));
                        dto.setPartner_id(rs.getString("PARTNER_ID"));
                        dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                        dto.setSku_id(rs.getString("SKU_ID"));
                        dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                        dto.setSku_value(rs.getString("SKU_VALUE"));
                        dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                        dto.setSku_alias(rs.getString("SKU_ALIAS"));
                        dto.setBox_ea(rs.getString("BOX_EA"));
                        dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                        dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                        dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                        dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                        dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                        dto.setP_ea(rs.getString("P_EA"));
                        dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                        dto.setCopy_idx(rs.getString("COPY_IDX"));
                        dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                        dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                        dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                        dto.setRtn_dt(rs.getString("RTN_DT"));
                        dto.setChng_dt(rs.getString("CHNG_DT"));
                        dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                        dto.setCancel_dt(rs.getString("CANCEL_DT"));
                        dto.setClass_cd1(rs.getString("CLASS_CD1"));
                        dto.setClass_cd2(rs.getString("CLASS_CD2"));
                        dto.setClass_cd3(rs.getString("CLASS_CD3"));
                        dto.setClass_cd4(rs.getString("CLASS_CD4"));
                        dto.setBrand_nm(rs.getString("BRAND_NM"));
                        dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                        dto.setFld_dsp(rs.getString("FLD_DSP"));
                        dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                        dto.setModel_no(rs.getString("MODEL_NO"));
                        dto.setSet_gubun(rs.getString("SET_GUBUN"));
                        dto.setEtc_msg(rs.getString("ETC_MSG"));
                        dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                        dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                        dto.setBarcode(rs.getString("BARCODE"));
                        dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                        dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                        dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                        dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                        dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                        dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                        dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                        dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                        dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                        dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                        dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                        dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                        dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                        dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                        dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                        dto.setShopPw(rs.getString("PASSWORD"));
                        dto.setApikey(rs.getString("APIKEY"));
                        dto.setAuthkey1(rs.getString("AUTHKEY1"));
                        dto.setAuthKey2(rs.getString("AUTHKEY2"));
                        dto.setVendorId(rs.getString("VENDORID"));
                        dto.setReceiptid(rs.getString("RECEIPTID"));
                        dto.setExchangeid(rs.getString("EXCHANGEID"));
                        dto.setDosinOrder_code(rs.getString("DOSINORDCD"));
                        dto.setCsClose(rs.getString("CSCLOSE"));
                        list.add(dto);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return list;
    }

    public int OrderDetailUpdate(String order_date, String p_product_name, String delv_msg, String receive_zipcode, String receive_addr, String user_email, String user_name, String user_tel, String user_cel, String user_id, String receive_name, String receive_tel, String receive_cel, String invoice_no, String p_sku_value, String sale_cnt, String mall_won_cost, String total_cost, String won_cost, String delv_cost, String scb_delivery, String scb_express, String order_id, String compno, String shopid, String company_good_cd, String orderSeq, String dosinOrder_code) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE SHOPORDMST SET \r\n");
                sql.append("ORDER_DATE=?, \r\n");
                sql.append("P_PRODUCT_NAME =?, \r\n");
                sql.append("DELV_MSG =?, \r\n");
                sql.append("RECEIVE_ZIPCODE=?, \r\n");
                sql.append("RECEIVE_ADDR=?, \r\n");
                sql.append("USER_EMAIL=?, \r\n");
                sql.append("USER_NAME=?, \r\n");
                sql.append("USER_TEL=?, \r\n");
                sql.append("USER_CEL=?, \r\n");
                sql.append("USER_ID=?, \r\n");
                sql.append("RECEIVE_NAME=?, \r\n");
                sql.append("RECEIVE_TEL=?, \r\n");
                sql.append("RECEIVE_CEL=?, \r\n");
                sql.append("INVOICE_NO=?, \r\n");
                sql.append("P_SKU_VALUE=?, \r\n");
                sql.append("SALE_CNT=?, \r\n");
                sql.append("MALL_WON_COST=?, \r\n");
                sql.append("TOTAL_COST=?, \r\n");
                sql.append("WON_COST=?, \r\n");
                sql.append("DELV_COST=?, \r\n");
                sql.append("DELIVERY_ID=?, \r\n");
                sql.append("DELIVERY_METHOD_STR2=?, \r\n");
                sql.append("COMPAYNY_GOODS_CD=?, \r\n");
                sql.append("DOSINORDCD=?, \r\n");
                sql.append("ORDER_ID=? \r\n");
                sql.append("WHERE ORDSEQ=? AND COMPNO =? AND SHOPID =?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setString(++rowIdx, order_date);
                pstmt.setString(++rowIdx, p_product_name);
                pstmt.setString(++rowIdx, delv_msg);
                pstmt.setString(++rowIdx, receive_zipcode);
                pstmt.setString(++rowIdx, receive_addr);
                pstmt.setString(++rowIdx, user_email);
                pstmt.setString(++rowIdx, user_name);
                pstmt.setString(++rowIdx, user_tel);
                pstmt.setString(++rowIdx, user_cel);
                pstmt.setString(++rowIdx, user_id);
                pstmt.setString(++rowIdx, receive_name);
                pstmt.setString(++rowIdx, receive_tel);
                pstmt.setString(++rowIdx, receive_cel);
                pstmt.setString(++rowIdx, invoice_no);
                pstmt.setString(++rowIdx, p_sku_value);
                pstmt.setString(++rowIdx, sale_cnt);
                pstmt.setString(++rowIdx, mall_won_cost);
                pstmt.setString(++rowIdx, total_cost);
                pstmt.setString(++rowIdx, won_cost);
                pstmt.setString(++rowIdx, delv_cost);
                pstmt.setString(++rowIdx, scb_express);
                pstmt.setString(++rowIdx, scb_delivery);
                pstmt.setString(++rowIdx, company_good_cd);
                pstmt.setString(++rowIdx, dosinOrder_code);
                pstmt.setString(++rowIdx, order_id);
                pstmt.setString(++rowIdx, orderSeq);
                pstmt.setString(++rowIdx, compno);
                pstmt.setString(++rowIdx, shopid);
                System.out.print("[ORDERDETAIL UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int prodordermatch(ShopOrderMstDto dto, ProductMstDto dtoItem) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into shop_matprodinfo(COMPNO,SHOPPRODNO,SHOPCD,SHOPSEQ,SHOP_USERID,PRODSEQ )values(?,?,?,?,?,?) ON DUPLICATE KEY UPDATE PRODSEQ = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getMall_product_id());
                pstmt.setString(++rowIdx, dto.getShopid());
                pstmt.setString(++rowIdx, dto.getShopseq());
                pstmt.setString(++rowIdx, dto.getShop_userid());
                pstmt.setString(++rowIdx, dtoItem.getProdgubun());
                pstmt.setString(++rowIdx, dtoItem.getProdgubun());
                YDMAStringUtil.Print("[prodordermatch]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void prodordermatch1(ShopOrderMstDto dto, ProductMstDto dtoItem) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopordmst   set compayny_goods_cd=? ,WON_COST=? where mall_product_id =?   and compno=?   and shopid =?";
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dtoItem.getProdcd());
                pstmt.setString(++rowIdx, dto.getWon_cost());
                pstmt.setString(++rowIdx, dto.getMall_product_id());
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getShopid());
                YDMAStringUtil.Print("[COMPANY_GOODS_CD MATCH]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    private String prodordermatch(ShopOrderMstDto dto) throws Exception {
        String value = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(compayny_goods_cd,'')  from shopprodinfo as a join shop_matprodinfo as b on a.prodseq = b.prodseq   where b.compno=?   and b.shopprodno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getMall_product_id());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    value = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return value;
    }

    public List<ShopOrderMstDto> getShopOrderOutput(String strdt, String endDt) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS,  '' ) AS DS_ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.DOSINORDCD,  '' ) AS DOSINORDCD,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.MALL_EXP_CD,  '' ) AS MALL_EXP_CD,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("IFNULL(M.GOODS_KEYWORD,  '' ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                sql.append("IFNULL(D.NICKNM2 ,'') AS VENDORID,      \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID       \r\n");
                sql.append(" FROM shopordmst AS M \r\n");
                sql.append(" LEFT JOIN shopdtl AS D \r\n");
                sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                sql.append(" AND M.SHOPSEQ = D.SHOPSEQ \r\n");
                sql.append(" WHERE M.COMPNO = ?  AND (ORDER_DATE >= ? AND  ORDER_DATE <= ?) AND ORDER_STATUS='402' AND DEL_YN <>'Y'  ORDER BY REG_DATE DESC");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(strdt, false));
                pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(endDt, false));
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setMall_exp_cd(rs.getString("MALL_EXP_CD"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setDosinOrder_code(rs.getString("DOSINORDCD"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setShopPw(rs.getString("PASSWORD"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthKey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setStartDt(strdt);
                    dto.setEndDt(endDt);
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderMstDto> getPickExpTable(String dateFrom, String dateTo) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(DTL.ORDDT,''), IFNULL(DTL.ORDSEQ,''), IFNULL(DTL.SEQ,''), IFNULL(DTL.MOVESEQ,''), IFNULL(DTL.SABORDNO,''), IFNULL(EXP.EXPNM,''), IFNULL(EXP.INVNO,'') \r\n");
                sql.append(" FROM PICKUPEXP AS EXP JOIN ORDDTL AS DTL \r\n");
                sql.append(" ON EXP.COMPNO = DTL.COMPNO AND EXP.ORDDT = DTL.ASIGNDT AND EXP.ORDSEQ = DTL.ASIGNSEQ AND EXP.SEQ = DTL.ASIGNHSEQ \r\n");
                sql.append(" WHERE DTL.COMPNO = ? AND DTL.ORDDT >= ? AND DTL.ORDDT <= ? AND EXP.EXPNM <> '' AND EXP.INVNO <> '' AND EXP.EXPNM IS NOT NULL AND EXP.INVNO IS NOT NULL");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dateFrom);
                pstmt.setString(3, dateTo);
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setOrddt(rs.getString(++columnIndex));
                    dto.setOrdseq(rs.getString(++columnIndex));
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setMoveseq(rs.getString(++columnIndex));
                    dto.setSabordno(rs.getString(++columnIndex));
                    dto.setExpnm(rs.getString(++columnIndex));
                    dto.setInvno(rs.getString(++columnIndex));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopOrderMstDto> getMoveSeqList(String orddt, String ordseq, String seq) throws Exception {
        ArrayList<ShopOrderMstDto> contents = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(b.SABORDNO,'')    FROM orddtl AS a   JOIN orddtl AS b ON a.ORDDT = b.ORDDT AND a.ORDSEQ = b.ORDSEQ AND a.ASIGNHSEQ=b.MOVESEQ   where a.orddt = ?    and a.ordseq = ?    and a.seq = ?    and a.compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, seq);
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getMoveSeqList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setSabordno(rs.getString(++rowno));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopOrderMstDto getOrderMstTable(String sabordno, String expnm) throws Exception {
        ShopOrderMstDto dto = new ShopOrderMstDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(delv.DLVID,''),IFNULL(mst.ORDER_STATUS,'') FROM shopordmst AS mst JOIN shopdeliverys AS delv ON mst.SHOPID = delv.SHOPCD AND delv.DOSIN_CODE LIKE ? WHERE ordseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, "%" + expnm + "%");
                pstmt.setString(2, sabordno);
                YDMAStringUtil.Print("[getMoveSeqList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    dto.setDelivery_id(rs.getString(++rowno));
                    dto.setOrder_status(rs.getString(++rowno));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public void setDeliveryCode(List<ShopOrderMstDto> totalList) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "update shopordmst set DELIVERY_ID = ?, INVOICE_NO = ?, ORDER_STATUS = ? where ordseq = ? and compno = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopOrderMstDto dto : totalList) {
                    int i = 0;
                    pstmt.setString(++i, dto.getDelivery_id());
                    pstmt.setString(++i, dto.getInvno());
                    pstmt.setString(++i, "402");
                    pstmt.setString(++i, dto.getSabordno());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public int getProductSize(String shopcd, String shopseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(SENDSEQ) FROM shopprodin WHERE compno = ? AND shopcd = ? AND SHOPSEQ = ? AND SHOPPRODNO <> '' ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[getMoveSeqList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    result = rs.getInt(++rowno);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopOrderMstDto> getOrdMstList(String dateFrom, String dateTo) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(ORDSEQ,''),IFNULL(COMPNO,''),IFNULL(SHOPID,''),IFNULL(ORDER_STATUS,''),IFNULL(MLORDDT,''),IFNULL(MLORDSEQ,''),IFNULL(MLSEQ,'') FROM SHOPORDMST  WHERE COMPNO = ?  AND REG_DATE >= ? AND  REG_DATE <= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMATimeUtil.convertSabangNetOrderDateToOrddt(dateFrom + "000000", false));
                pstmt.setString(3, YDMATimeUtil.convertSabangNetOrderDateToOrddt(dateTo + "240000", false));
                YDMAStringUtil.Print("[getOrdMstList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    int columnIndex = 0;
                    dto.setOrdseq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setOrder_status(rs.getString(++columnIndex));
                    dto.setMlorddt(rs.getString(++columnIndex));
                    dto.setMlordseq(rs.getString(++columnIndex));
                    dto.setMlseq(rs.getString(++columnIndex));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setDeliveryUpdate(List<ShopOrderMstDto> totalList) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "update shopordmst set DELIVERY_ID = ?, INVOICE_NO = ?, ORDER_STATUS = ? where ordseq = ? and compno = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopOrderMstDto dto : totalList) {
                    int i = 0;
                    pstmt.setString(++i, dto.getDlvid());
                    pstmt.setString(++i, dto.getInvoice_no());
                    pstmt.setString(++i, "402");
                    pstmt.setString(++i, dto.getOrdseq());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public List<ShopOrderMstDto> ordDomeStatus(List<ShopOrderMstDto> list) throws Exception {
        ArrayList<ShopOrderMstDto> result = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(ORDSEQ,''),IFNULL(SHOPID,''),IFNULL(ORDER_STATUS,'') FROM SHOPORDMST  WHERE COMPNO = ? AND ORDSEQ = ?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < list.size()) {
                    ShopOrderMstDto dto1 = list.get(i);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, dto1.getOrdseq());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        int columnIndex = 0;
                        dto.setOrdseq(rs.getString(++columnIndex));
                        dto.setShopid(rs.getString(++columnIndex));
                        dto.setOrder_status(rs.getString(++columnIndex));
                        result.add(dto);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopOrderMstDto> getOrderSeq(List<ShopOrderMstDto> list) throws Exception {
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(ORDSEQ,'') FROM SHOPORDMST  WHERE COMPNO = ? AND ORDER_ID = ?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < list.size()) {
                    ShopOrderMstDto dto1 = list.get(i);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, dto1.getOrder_id());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        int columnIndex = 0;
                        dto.setOrdseq(rs.getString(++columnIndex));
                        list.add(dto);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean isOrdered(String odNo) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM SHOPORDMST WHERE COMPNO = ? AND ORDER_ID = ?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, odNo);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean bl = result = rs.getInt(1) > 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public boolean isOrdered(String odNo, String expcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM SHOPORDMST WHERE COMPNO = ? AND ORDER_ID = ? AND MALL_EXP_CD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, odNo);
                pstmt.setString(3, expcd);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean bl = result = rs.getInt(1) > 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public boolean isOrdered(String odNo, String loginId, int shopseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM SHOPORDMST WHERE COMPNO = ? AND ORDER_ID = ? AND SHOP_USERID = ? AND SHOPSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, odNo);
                pstmt.setString(3, loginId);
                pstmt.setInt(4, shopseq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean bl = result = rs.getInt(1) > 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public boolean isOrderedJustOne() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM SHOPORDMST";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean bl = result = rs.getInt(1) > 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopOrderMstDto> getShopOrderListByScheduler(String startdt, String enddt, String status2) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("IFNULL(M.ORDSEQ,  '' ) AS ORDSEQ,  \r\n");
                sql.append("IFNULL(M.COMPNO,  '' ) AS COMPNO,  \r\n");
                sql.append("IFNULL(M.REG_DATE,  '' ) AS REG_DATE,  \r\n");
                sql.append("IFNULL(M.ORDER_ID,  '' ) AS ORDER_ID,  \r\n");
                sql.append("IFNULL(M.SHOPID,  '' ) AS SHOPID,  \r\n");
                sql.append("IFNULL(M.SHOPSEQ,  '' ) AS SHOPSEQ,  \r\n");
                sql.append("IFNULL(M.SHOP_USERID,  '' ) AS SHOP_USERID,  \r\n");
                sql.append("IFNULL(M.ORDER_STATUS,  '' ) AS ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS,  '' ) AS DS_ORDER_STATUS,  \r\n");
                sql.append("IFNULL(M.USER_ID,  '' ) AS USER_ID,  \r\n");
                sql.append("IFNULL(M.USER_NAME,  '' ) AS USER_NAME,  \r\n");
                sql.append("IFNULL(M.USER_TEL,  '' ) AS USER_TEL,  \r\n");
                sql.append("IFNULL(M.USER_CEL,  '' ) AS USER_CEL,  \r\n");
                sql.append("IFNULL(M.USER_EMAIL,  '' ) AS USER_EMAIL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_TEL,  '' ) AS RECEIVE_TEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_CEL,  '' ) AS RECEIVE_CEL,  \r\n");
                sql.append("IFNULL(M.RECEIVE_EMAIL,  '' ) AS RECEIVE_EMAIL,  \r\n");
                sql.append("IFNULL(M.DOMEORDERNO,  '' ) AS DOMEORDERNO,  \r\n");
                sql.append("IFNULL(M.DELV_MSG,  '' ) AS DELV_MSG,  \r\n");
                sql.append("IFNULL(M.RECEIVE_NAME,  '' ) AS RECEIVE_NAME,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ZIPCODE,  '' ) AS RECEIVE_ZIPCODE,  \r\n");
                sql.append("IFNULL(M.RECEIVE_ADDR,  '' ) AS RECEIVE_ADDR,  \r\n");
                sql.append("IFNULL(M.TOTAL_COST,  '' ) AS TOTAL_COST,  \r\n");
                sql.append("IFNULL(M.PAY_COST,  '' ) AS PAY_COST,  \r\n");
                sql.append("IFNULL(M.ORDER_DATE,  '' ) AS ORDER_DATE,  \r\n");
                sql.append("IFNULL(M.PARTNER_ID,  '' ) AS PARTNER_ID,  \r\n");
                sql.append("IFNULL(M.DPARTNER_ID,  '' ) AS DPARTNER_ID,  \r\n");
                sql.append("IFNULL(M.MALL_PRODUCT_ID,  '' ) AS MALL_PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.PRODUCT_ID,  '' ) AS PRODUCT_ID,  \r\n");
                sql.append("IFNULL(M.SKU_ID,  '' ) AS SKU_ID,  \r\n");
                sql.append("IFNULL(M.P_PRODUCT_NAME,  '' ) AS P_PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.P_SKU_VALUE,  '' ) AS P_SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.PRODUCT_NAME,  '' ) AS PRODUCT_NAME,  \r\n");
                sql.append("IFNULL(M.SALE_COST,  '' ) AS SALE_COST,  \r\n");
                sql.append("IFNULL(M.MALL_WON_COST,  '0' ) AS MALL_WON_COST,  \r\n");
                sql.append("IFNULL(M.WON_COST,  '0' ) AS WON_COST,  \r\n");
                sql.append("IFNULL(M.SKU_VALUE,  '' ) AS SKU_VALUE,  \r\n");
                sql.append("IFNULL(M.SALE_CNT,  '' ) AS SALE_CNT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR,  '' ) AS DELIVERY_METHOD_STR,  \r\n");
                sql.append("IFNULL(M.DELV_COST,  '' ) AS DELV_COST,  \r\n");
                sql.append("IFNULL(M.COMPAYNY_GOODS_CD,  '' ) AS COMPAYNY_GOODS_CD,  \r\n");
                sql.append("IFNULL(M.SKU_ALIAS,  '' ) AS SKU_ALIAS,  \r\n");
                sql.append("IFNULL(M.BOX_EA,  '' ) AS BOX_EA,  \r\n");
                sql.append("IFNULL(M.JUNG_CHK_YN,  '' ) AS JUNG_CHK_YN,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_SEQ,  '' ) AS MALL_ORDER_SEQ,  \r\n");
                sql.append("IFNULL(M.MALL_ORDER_ID,  '' ) AS MALL_ORDER_ID,  \r\n");
                sql.append("IFNULL(M.ETC_FIELD3,  '' ) AS ETC_FIELD3,  \r\n");
                sql.append("IFNULL(M.ORDER_GUBUN,  '' ) AS ORDER_GUBUN,  \r\n");
                sql.append("IFNULL(M.P_EA,  '' ) AS P_EA,  \r\n");
                sql.append("IFNULL(M.ORD_FIELD2,  '' ) AS ORD_FIELD2,  \r\n");
                sql.append("IFNULL(M.COPY_IDX,  '' ) AS COPY_IDX,  \r\n");
                sql.append("IFNULL(M.GOODS_NM_PR,  '' ) AS GOODS_NM_PR,  \r\n");
                sql.append("(SELECT GOODS_KEYWORD FROM SHOPPRODINFO WHERE COMPAYNY_GOODS_CD = M.COMPAYNY_GOODS_CD AND COMPNO = 4 ) AS GOODS_KEYWORD,  \r\n");
                sql.append("IFNULL(M.ORD_CONFIRM_DATE,  '' ) AS ORD_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.RTN_DT,  '' ) AS RTN_DT,  \r\n");
                sql.append("IFNULL(M.CHNG_DT,  '' ) AS CHNG_DT,  \r\n");
                sql.append("IFNULL(M.DELIVERY_CONFIRM_DATE,  '' ) AS DELIVERY_CONFIRM_DATE,  \r\n");
                sql.append("IFNULL(M.CANCEL_DT,  '' ) AS CANCEL_DT,  \r\n");
                sql.append("IFNULL(M.CLASS_CD1,  '' ) AS CLASS_CD1,  \r\n");
                sql.append("IFNULL(M.CLASS_CD2,  '' ) AS CLASS_CD2,  \r\n");
                sql.append("IFNULL(M.CLASS_CD3,  '' ) AS CLASS_CD3,  \r\n");
                sql.append("IFNULL(M.CLASS_CD4,  '' ) AS CLASS_CD4,  \r\n");
                sql.append("IFNULL(M.BRAND_NM,  '' ) AS BRAND_NM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_ID,  '' ) AS DELIVERY_ID,  \r\n");
                sql.append("IFNULL(M.INVOICE_NO,  '' ) AS INVOICE_NO,  \r\n");
                sql.append("IFNULL(M.HOPE_DELV_DATE,  '' ) AS HOPE_DELV_DATE,  \r\n");
                sql.append("IFNULL(M.FLD_DSP,  '' ) AS FLD_DSP,  \r\n");
                sql.append("IFNULL(M.INV_SEND_MSG,  '' ) AS INV_SEND_MSG,  \r\n");
                sql.append("IFNULL(M.MODEL_NO,  '' ) AS MODEL_NO,  \r\n");
                sql.append("IFNULL(M.SET_GUBUN,  '' ) AS SET_GUBUN,  \r\n");
                sql.append("IFNULL(M.ETC_MSG,  '' ) AS ETC_MSG,  \r\n");
                sql.append("IFNULL(M.DELV_MSG1,  '' ) AS DELV_MSG1,  \r\n");
                sql.append("IFNULL(M.MUL_DELV_MSG,  '' ) AS MUL_DELV_MSG,  \r\n");
                sql.append("IFNULL(M.BARCODE,  '' ) AS BARCODE,  \r\n");
                sql.append("IFNULL(M.INV_SEND_DM,  '' ) AS INV_SEND_DM,  \r\n");
                sql.append("IFNULL(M.DELIVERY_METHOD_STR2,  '' ) AS DELIVERY_METHOD_STR2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_1,  '' ) AS ORDER_ETC_1,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_2,  '' ) AS ORDER_ETC_2,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_3,  '' ) AS ORDER_ETC_3,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_4,  '' ) AS ORDER_ETC_4,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_5,  '' ) AS ORDER_ETC_5,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_6,  '' ) AS ORDER_ETC_6,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_7,  '' ) AS ORDER_ETC_7,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_8,  '' ) AS ORDER_ETC_8,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_9,  '' ) AS ORDER_ETC_9,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_10,  '' ) AS ORDER_ETC_10,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_11,  '' ) AS ORDER_ETC_11,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_12,  '' ) AS ORDER_ETC_12,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_13,  '' ) AS ORDER_ETC_13,  \r\n");
                sql.append("IFNULL(M.ORDER_ETC_14,  '' ) AS ORDER_ETC_14,  \r\n");
                sql.append("IFNULL(M.LABEL,  '' ) AS LABEL,  \r\n");
                sql.append("IFNULL(D.APIKEY,  '' ) AS APIKEY,  \r\n");
                sql.append("IFNULL(D.PASSWORD,  '' ) AS PASSWORD,  \r\n");
                sql.append("IFNULL(D.AUTHKEY1,  '' ) AS AUTHKEY1,  \r\n");
                sql.append("IFNULL(D.AUTHKEY2,  '' ) AS AUTHKEY2, \r\n");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS VENDORID  ,    \r\n");
                sql.append("IFNULL(D.NICKNM1,'') AS NICKNM  ,    \r\n");
                sql.append("IFNULL(M.RECEIPTID ,'') AS RECEIPTID,      \r\n");
                sql.append("IFNULL(M.EXCHANGEID  ,'') AS EXCHANGEID  ,    \r\n");
                sql.append("IFNULL(M.DOSINORDCD  ,'') AS DOSINORDCD  ,    \r\n");
                sql.append("IFNULL(M.DEL_YN  ,'') AS DEL_YN  ,    \r\n");
                sql.append("IFNULL(M.DS_ORDER_STATUS  ,'') AS DS_ORDER_STATUS  ,    \r\n");
                sql.append("IFNULL(M.MALL_EXP_CD  ,'0') AS MALL_EXP_CD  ,    \r\n");
                sql.append("(SELECT COUNT(ORDSEQ) FROM SHOPORDCS WHERE ORDSEQ =M.ORDSEQ AND CSCLOSE='Y' ) AS CSCLOSE \r\n");
                sql.append(" FROM shopordmst AS M \r\n");
                sql.append(" LEFT JOIN shopdtl AS D \r\n");
                sql.append(" ON M.COMPNO = D.COMPNO \r\n");
                sql.append(" AND M.SHOPID = D.SHOPCD \r\n");
                sql.append(" AND M.SHOPSEQ = D.SHOPSEQ \r\n");
                sql.append(" WHERE M.COMPNO = ?   ");
                sql.append(" AND M.ORDER_STATUS IN (" + status2 + ")");
                sql.append(" AND (M.ORDER_DATE >= ? AND  M.ORDER_DATE <= ?)  ORDER BY ORDER_DATE DESC ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, startdt);
                pstmt.setString(3, enddt);
                YDMAStringUtil.Print("[ShopOrderList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                Integer rowNum = 0;
                while (rs.next()) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    rowNum = rowNum + 1;
                    dto.setNo(rowNum.toString());
                    dto.setReg_date(rs.getString("REG_DATE"));
                    dto.setOrder_date(rs.getString("ORDER_DATE"));
                    dto.setOrder_status(rs.getString("ORDER_STATUS"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShop_userid(rs.getString("SHOP_USERID"));
                    dto.setReceive_name(rs.getString("RECEIVE_NAME"));
                    dto.setMall_product_id(rs.getString("MALL_PRODUCT_ID"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setP_product_name(rs.getString("P_PRODUCT_NAME"));
                    dto.setP_sku_value(rs.getString("P_SKU_VALUE"));
                    dto.setSale_cnt(rs.getString("SALE_CNT"));
                    dto.setWon_cost(rs.getString("WON_COST"));
                    dto.setMall_won_cost(rs.getString("MALL_WON_COST"));
                    dto.setSale_cost(rs.getString("SALE_COST"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelivery_method_str2(rs.getString("DELIVERY_METHOD_STR2"));
                    dto.setDelv_msg(rs.getString("DELV_MSG"));
                    dto.setDelivery_id(rs.getString("DELIVERY_ID"));
                    dto.setInvoice_no(rs.getString("INVOICE_NO"));
                    dto.setLabel(rs.getString("LABEL"));
                    dto.setDs_order_status(rs.getString("DS_ORDER_STATUS"));
                    dto.setDomeOrderId(rs.getString("DOMEORDERNO"));
                    dto.setProduct_id(rs.getString("PRODUCT_ID"));
                    dto.setOrdseq(rs.getString("ORDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setOrder_id(rs.getString("ORDER_ID"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setUser_name(rs.getString("USER_NAME"));
                    dto.setUser_tel(rs.getString("USER_TEL"));
                    dto.setUser_cel(rs.getString("USER_CEL"));
                    dto.setUser_email(rs.getString("USER_EMAIL"));
                    dto.setReceive_tel(rs.getString("RECEIVE_TEL"));
                    dto.setReceive_cel(rs.getString("RECEIVE_CEL"));
                    dto.setReceive_email(rs.getString("RECEIVE_EMAIL"));
                    dto.setReceive_zipcode(rs.getString("RECEIVE_ZIPCODE"));
                    dto.setReceive_addr(rs.getString("RECEIVE_ADDR"));
                    dto.setTotal_cost(rs.getString("TOTAL_COST"));
                    dto.setPay_cost(rs.getString("PAY_COST"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setSku_id(rs.getString("SKU_ID"));
                    dto.setProduct_name(rs.getString("PRODUCT_NAME"));
                    dto.setSku_value(rs.getString("SKU_VALUE"));
                    dto.setDelivery_method_str(rs.getString("DELIVERY_METHOD_STR"));
                    dto.setSku_alias(rs.getString("SKU_ALIAS"));
                    dto.setBox_ea(rs.getString("BOX_EA"));
                    dto.setJung_chk_yn(rs.getString("JUNG_CHK_YN"));
                    dto.setMall_order_seq(rs.getString("MALL_ORDER_SEQ"));
                    dto.setMall_order_id(rs.getString("MALL_ORDER_ID"));
                    dto.setEtc_field3(rs.getString("ETC_FIELD3"));
                    dto.setOrder_gubun(rs.getString("ORDER_GUBUN"));
                    dto.setP_ea(rs.getString("P_EA"));
                    dto.setOrd_field2(rs.getString("ORD_FIELD2"));
                    dto.setCopy_idx(rs.getString("COPY_IDX"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setOrd_confirm_date(rs.getString("ORD_CONFIRM_DATE"));
                    dto.setRtn_dt(rs.getString("RTN_DT"));
                    dto.setChng_dt(rs.getString("CHNG_DT"));
                    dto.setOrd_confirm_date(rs.getString("DELIVERY_CONFIRM_DATE"));
                    dto.setCancel_dt(rs.getString("CANCEL_DT"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setHope_delv_date(rs.getString("HOPE_DELV_DATE"));
                    dto.setFld_dsp(rs.getString("FLD_DSP"));
                    dto.setInv_send_msg(rs.getString("INV_SEND_MSG"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setSet_gubun(rs.getString("SET_GUBUN"));
                    dto.setEtc_msg(rs.getString("ETC_MSG"));
                    dto.setDelv_msg1(rs.getString("DELV_MSG1"));
                    dto.setMul_delv_msg(rs.getString("MUL_DELV_MSG"));
                    dto.setBarcode(rs.getString("BARCODE"));
                    dto.setInv_send_dm(rs.getString("INV_SEND_DM"));
                    dto.setOrder_etc_1(rs.getString("ORDER_ETC_1"));
                    dto.setOrder_etc_2(rs.getString("ORDER_ETC_2"));
                    dto.setOrder_etc_3(rs.getString("ORDER_ETC_3"));
                    dto.setOrder_etc_4(rs.getString("ORDER_ETC_4"));
                    dto.setOrder_etc_5(rs.getString("ORDER_ETC_5"));
                    dto.setOrder_etc_6(rs.getString("ORDER_ETC_6"));
                    dto.setOrder_etc_7(rs.getString("ORDER_ETC_7"));
                    dto.setOrder_etc_8(rs.getString("ORDER_ETC_8"));
                    dto.setOrder_etc_9(rs.getString("ORDER_ETC_9"));
                    dto.setOrder_etc_10(rs.getString("ORDER_ETC_10"));
                    dto.setOrder_etc_11(rs.getString("ORDER_ETC_11"));
                    dto.setOrder_etc_12(rs.getString("ORDER_ETC_12"));
                    dto.setOrder_etc_13(rs.getString("ORDER_ETC_13"));
                    dto.setOrder_etc_14(rs.getString("ORDER_ETC_14"));
                    dto.setShopPw(rs.getString("PASSWORD"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthKey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setNickname(rs.getString("NICKNM"));
                    dto.setDel_yn(rs.getString("DEL_YN"));
                    dto.setReceiptid(rs.getString("RECEIPTID"));
                    dto.setExchangeid(rs.getString("EXCHANGEID"));
                    dto.setDosinOrder_code(rs.getString("DOSINORDCD"));
                    dto.setMall_exp_cd(rs.getString("MALL_EXP_CD"));
                    dto.setCsClose(rs.getString("CSCLOSE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String findByInsertdtInWorkmgrlog(String prodCd, String shopcd, String shoppingId, String orderDt) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select DATEDIFF(?, INSERTDT) from workmgrlog where PRODSEQ = ? and SHOPCD = ? and SHOPPINGID = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orderDt);
                pstmt.setString(2, prodCd);
                pstmt.setString(3, shopcd);
                pstmt.setString(4, shoppingId);
                YDMAStringUtil.Print("[findByInsertdtInWorkmgrlog]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int insertSch_log(String shopnm, String shopId, int newOrderCnt, int syncCnt) throws Exception {
        int result = 0;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime currentTime = LocalDateTime.now();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO sch_log (COMPNO, SHOPNM, SHOPID, NEWORDERCNT, SYNCCNT, INSERTDATE, EXECKEY)VALUES (?, ?, ?, ?, ?, ?, ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setInt(++rowIdx, Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                pstmt.setString(++rowIdx, shopnm);
                pstmt.setString(++rowIdx, shopId);
                pstmt.setInt(++rowIdx, newOrderCnt);
                pstmt.setInt(++rowIdx, syncCnt);
                pstmt.setString(++rowIdx, currentTime.format(formatter));
                pstmt.setString(++rowIdx, IShopCommonLogin.getLocalMacAddress());
                YDMAStringUtil.Print("[insertSch_logLog]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }
}

