/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAlwayzAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import gui.ava.html.image.generator.HtmlImageGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class AlwayzProductModifyService
extends IProductModifyStatusApi {
    private static final MediaType MEDIA_TYPE_OCTET = MediaType.get((String)"application/octet-stream");

    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        boolean flag = true;
        try {
            switch (status2) {
                case "9": {
                    flag = this.productResumeSale(shopProductDto, shoppingMallDetailDto);
                    if (!flag) {
                        return flag;
                    }
                    break;
                }
                case "8": {
                    flag = this.productSoldOut(shopProductDto, shoppingMallDetailDto);
                    if (!flag) {
                        return flag;
                    }
                    break;
                }
                case "0": {
                    String matched = IProduct.findFirstForbiddenKeyword(shopProductDto, shoppingMallDetailDto.getForbiddenKeywords());
                    if (matched != null) {
                        throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, shopProductDto.getGoods_nm(), shopProductDto.getGoods_search()));
                    }
                    ShopProductAlwayzAdditionDto alwayzDtllist = (ShopProductAlwayzAdditionDto)shopProductSendDto.getProductAdditionDto();
                    String loginID = shoppingMallDetailDto.getShoppingid();
                    String password = shoppingMallDetailDto.getPassword();
                    ArrayList<String> strImages = new ArrayList();
                    ImageTransformParams params = new ImageTransformParams();
                    params.setShopProductDto(shopProductDto);
                    params.setChangesize(alwayzDtllist.getChangesize());
                    params.setChangeSizeX(alwayzDtllist.getChangeSizeX());
                    params.setChangeSizeY(alwayzDtllist.getChangeSizeY());
                    params.setChangeSizeW(alwayzDtllist.getChangeSizeW());
                    params.setChangeSizeH(alwayzDtllist.getChangeSizeH());
                    params.setAngle(alwayzDtllist.getAngle());
                    params.setScalePercent(alwayzDtllist.getScalePercent());
                    params.setImgThreeOnFour(alwayzDtllist.getImgThreeOnFour());
                    params.setRemoveImgTextYN("");
                    params.setMirrorImgYN(alwayzDtllist.getMirrorImgYN());
                    params.setImageresize(alwayzDtllist.getImageResize());
                    params.setImageresize1("");
                    UnifiedUploadManager manager = new UnifiedUploadManager();
                    strImages = manager.processAndUploadImages(params);
                    this.DownLoadDetailImage(shopProductDto, alwayzDtllist);
                    String json = this.MakeProductModifyJson(alwayzDtllist, shopProductDto, loginID, password, shoppingMallDetailDto);
                    json = json.replaceAll("\"optionPrice\"", "\"optionPrices\"");
                    String token = this.ProductModifySend(json, shopProductDto, alwayzDtllist, loginID, password);
                    this.ModifyImage(strImages, shopProductDto, alwayzDtllist, token);
                    InterruptSource.Thread.sleep((long)2000L);
                    break;
                }
                case "6": 
                case "7": {
                    flag = this.DeleteProduct(shopProductDto, shoppingMallDetailDto);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    InterruptSource.Thread.sleep((long)2000L);
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return true;
    }

    private void DownLoadDetailImage(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist) throws Exception {
        Path imgDir = this.prepareImageFolder();
        String normalizedHtml = this.replaceBaseUrl(dto.getGoods_keyword(), dto.getGoods_remarks());
        dto.setGoods_remarks(normalizedHtml);
        if (StringUtils.isNotBlank((CharSequence)dtllist.getProddetailfront())) {
            this.saveHtmlAsImage(dtllist.getProddetailfront(), imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetailFront.png"));
        }
        if (StringUtils.isNotBlank((CharSequence)dtllist.getProddetailback()) && "1".equals(dtllist.getProddetailoutput())) {
            this.saveHtmlAsImage(dtllist.getProddetailback(), imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetailBack.png"));
        }
        String fullHtml = this.buildDetailTableHtml(IProduct.removeBrokenImgTag(normalizedHtml));
        this.saveHtmlAsImage(fullHtml, imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetail.png"));
    }

    private Path prepareImageFolder() throws IOException {
        String imgPath = null;
        try {
            imgPath = ShopCommon.getImgPath();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Path dir = Paths.get(imgPath, new String[0]);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                YDMAStringUtil.Print(String.format("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud3f4\ub354 \uc0dd\uc131: %s", dir));
            }
            catch (IOException e) {
                YDMAStringUtil.Print(String.format("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud3f4\ub354 \uc0dd\uc131 \uc2e4\ud328: %s,%s", dir, e));
                throw e;
            }
        }
        return dir;
    }

    private String replaceBaseUrl(String keyword, String html) {
        if (html == null) {
            return "";
        }
        switch (keyword) {
            case "shop9987": {
                return html.replace("https://www.onnme.com//", "https://cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/");
            }
            case "shop0000": {
                return html.replace("https://cbw.co.kr//", "https://cafe24.poxo.com/ec01/kdh0201/EjglQcnyYl9oLKpqUS6wZgXi8sojGAGtEWIWWXL2plRUVd7qyEd9+lcioi6YTYl8+M0/iGFZrQSxc8jTkkjqtw==/_/");
            }
            case "shop9986": {
                return html.replace("https://xn--jt2by0pl8b7va956c.kr", "https://ydinc.cafe24.com");
            }
        }
        return html;
    }

    private void saveHtmlAsImage(String html, Path outputFile) throws IOException {
        YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \ubcc0\ud658 \uc2dc\uc791: " + String.valueOf(outputFile.getFileName()));
        HtmlImageGenerator hig = new HtmlImageGenerator();
        hig.loadHtml(html);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(() -> hig.saveAsImage(outputFile.toString()));
        try {
            try {
                future.get(60L, TimeUnit.SECONDS);
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \uc131\uacf5: " + String.valueOf(outputFile));
            }
            catch (TimeoutException e) {
                future.cancel(true);
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud0c0\uc784\uc544\uc6c3: " + String.valueOf(outputFile));
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5\uc774 \uc9c0\uc815 \uc2dc\uac04(60\ucd08)\uc744 \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4.", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UncheckedIOException) {
                    throw ((UncheckedIOException)cause).getCause();
                }
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", cause);
            }
            catch (InterruptedException e) {
                InterruptSource.Thread.currentThread().interrupt();
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5\uc774 \uc778\ud130\ub7fd\ud2b8\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", e);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String buildDetailTableHtml(String html) {
        if (StringUtils.containsIgnoreCase((CharSequence)html, (CharSequence)"<img")) {
            Document doc = Jsoup.parse((String)html);
            Elements imgs = doc.select("img");
            StringBuilder sb = new StringBuilder().append("<div align=\"center\">\n").append("  <table style=\"text-align:center;margin:auto;\">\n");
            imgs.forEach(img -> {
                String src = img.attr("src");
                sb.append("    <tr><td><img src='").append(src).append("' style=\"display:block;\"></td></tr>\n");
            });
            sb.append("  </table>\n</div>");
            return sb.toString();
        }
        return html;
    }

    private String MakeProductModifyJson(ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto, String loginID, String password, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String json = "";
        try {
            int salePrice;
            int individualPurchasePrice;
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            ObjectMapper mapper = new ObjectMapper();
            AlwayzProductModify azReg = new AlwayzProductModify();
            azReg.itemInfo._id = dto.getShopprodno();
            String token = this.CategorySetting(azReg, dto, dtllist, loginID, password);
            this.ProductNameSetting(azReg, dtllist, dto);
            resultMarketPrice = this.PriceSetting(dto, dtllist, resultMarketPrice);
            int teamPurchasePrice = Integer.parseInt(dto.getGoods_price());
            if (dtllist.getTeamPurchasePriceUnit().equals("percent")) {
                individualPurchasePrice = (int)(Math.ceil((double)teamPurchasePrice / (1.0 - 0.01 * (double)dtllist.getTeamPurchasePrice()) / 10.0) * 10.0);
                salePrice = individualPurchasePrice - teamPurchasePrice;
            } else {
                salePrice = dtllist.getTeamPurchasePrice();
                individualPurchasePrice = teamPurchasePrice + salePrice;
            }
            azReg.itemInfo.individualPurchasePrice = individualPurchasePrice;
            azReg.itemInfo.teamPurchasePrice = teamPurchasePrice;
            azReg.itemInfo.discountRate = (double)salePrice / (double)individualPurchasePrice;
            TestingSkuGroupLogs testingGroupLog = new TestingSkuGroupLogs();
            this.OptionSetting(azReg, dtllist, dto, individualPurchasePrice, teamPurchasePrice, testingGroupLog);
            this.DeliverySetting(azReg, dtllist, dto);
            this.GosiSetting(azReg, dtllist, dto);
            azReg.itemInfo.soldOut = false;
            azReg.itemInfo.hurryUp = false;
            azReg.itemInfo.totalOrderQuantity = 0;
            azReg.itemInfo.totalRatingCount = 0;
            azReg.itemInfo.totalRatingScore = 0.0;
            azReg.itemInfo.hideSellerInfo = false;
            azReg.itemInfo.vectorWeights = 1;
            this.SellerInfoSetting(azReg, dtllist, dto, token);
            azReg.itemInfo.teamDealThreshold = dtllist.getTeamDealthReshold();
            azReg.itemInfo.purchaseLimits = dtllist.getPurchaseLimits();
            azReg.itemInfo.testingSkuGroup = "aperion";
            testingGroupLog.testingSkuGroup = "aperion";
            testingGroupLog.teamPurchasePrice = teamPurchasePrice;
            testingGroupLog.individualPurchasePrice = individualPurchasePrice;
            testingGroupLog.soldOut = false;
            azReg.itemInfo.testingSkuGroupLogs.add(testingGroupLog);
            azReg.itemInfo.sellerType = "inboundSeller";
            azReg.itemInfo.itemRankTestingSku = true;
            azReg.itemInfo.alfarmPhotoReviewMode = true;
            azReg.itemInfo.recommendItemCode = dto.getCompayny_goods_cd();
            if (dto.getGoods_search().equals("")) {
                azReg.itemInfo.textForQuery = "";
            } else {
                String result;
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> removetag = new ArrayList<String>();
                List<String> search = new ArrayList<String>();
                if (dto.getExcepkeywdyn().equals("Y")) {
                    if (dto.getExcepkeywd() != null && !dto.getExcepkeywd().isEmpty()) {
                        removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                    }
                    if (shoppingMallDetailDto.getForbiddenKeywords() != null && !shoppingMallDetailDto.getForbiddenKeywords().isEmpty()) {
                        removetag.addAll(Arrays.asList(shoppingMallDetailDto.getForbiddenKeywords().split(",")));
                    }
                    list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                    search = IProduct.checkSearch(list, removetag, search);
                } else {
                    search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                }
                Pattern specialCharPattern = Pattern.compile("[^\\uAC00-\\uD7A3xfe0-9a-zA-Z\\s]");
                Pattern hanjaPattern = Pattern.compile("[\\u2e80-\\u2eff\\u31c0-\\u31ef\\u3200-\\u32ff\\u3400-\\u4dbf\\u4e00-\\u9fbf\\uf900-\\ufaff]");
                ArrayList<String> cleanKeywords = new ArrayList<String>();
                for (String site : search) {
                    Matcher specialCharMatcher = specialCharPattern.matcher(site);
                    Matcher hanjaMatcher = hanjaPattern.matcher(site);
                    if (specialCharMatcher.find() || hanjaMatcher.find()) continue;
                    cleanKeywords.add(site.trim());
                }
                String[] keywords = cleanKeywords.toArray(new String[0]);
                int limit = Math.min(keywords.length, 5);
                azReg.itemInfo.textForQuery = result = String.join((CharSequence)",", Arrays.copyOfRange(keywords, 0, limit));
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            json = mapper.writeValueAsString((Object)azReg);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private String CategorySetting(AlwayzProductModify azReg, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(loginID, password);
            if (MLinkCommon.get().isNotNullEmpty(dtllist.getShopcatno())) {
                azReg.itemInfo.categoryInfo.minimumCategoryId = Integer.parseInt(dtllist.getShopcatno());
                return token;
            }
            if (MLinkCommon.get().isNotNullEmpty(dto.getShopCid())) {
                azReg.itemInfo.categoryInfo.minimumCategoryId = Integer.parseInt(dto.getShopCid());
                return token;
            }
            String[] parts = dto.getGmcategnm().split(">");
            if (parts.length == 0) {
                throw new Exception("[\ud0a4\uc6cc\ub4dc \uc5c6\uc74c]");
            }
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String inputLine;
                String element = stringArray[n2];
                URL url = new URL("https://alwayz-seller-back.ilevit.com/items/item-category/query?q=" + URLEncoder.encode(element, "UTF-8"));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
                connection.setRequestProperty("x-access-token", token);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JsonObject jsonObject = jsonParser.parse(response.toString()).getAsJsonObject();
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 == 200) {
                    JsonArray data2 = (JsonArray)jsonObject.get("data");
                    if (data2.size() != 0) {
                        int count = Math.min(data2.size(), 10);
                        int i = 0;
                        while (i < count) {
                            JsonObject obj = (JsonObject)data2.get(i);
                            if (obj.get("endNode") != null) {
                                azReg.itemInfo.categoryInfo.minimumCategoryId = obj.get("_id").getAsInt();
                                return token;
                            }
                            ++i;
                        }
                    }
                } else {
                    InterruptSource.Thread.sleep((long)500L);
                }
                ++n2;
            }
            return token;
        }
        catch (Exception e) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd" + e.getMessage());
        }
    }

    private void ProductNameSetting(AlwayzProductModify azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        String value = IProduct.formatProductNameByCode(dtllist.getProdnmoutput(), dto);
        if (!dtllist.getProdnmaddfront().equals("")) {
            value = dtllist.getProdnmaddfront().concat(value);
        }
        if (!dtllist.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(dtllist.getProdnmaddback());
        }
        if (dtllist.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (dtllist.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        azReg.itemInfo.itemTitle = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 99) : value;
    }

    private ResultMarketPrice PriceSetting(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpPrc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpPrc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcRate()).setFlatDc(dtllist.getFlatDC()).setMargin(dtllist.getMarginDC()).setCommission(dtllist.getCommDC()).calculate();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void OptionSetting(AlwayzProductModify azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto, int individualPurchasePrice, int teamPurchasePrice, TestingSkuGroupLogs testingGroupLog) throws Exception {
        ArrayList<OptionsInfo.Option> listOpt = new ArrayList<OptionsInfo.Option>();
        ArrayList<OptionsInfo.OptionPrice> ListOptPrice = new ArrayList<OptionsInfo.OptionPrice>();
        if (dto.getChar_1_nm().equals("\ub2e8\ud488")) {
            azReg.itemInfo.optionsInfo.optionNames.add("\ub2e8\ud488");
            testingGroupLog.optionsInfo.optionNames.add("\ub2e8\ud488");
            OptionsInfo.Option option2 = new OptionsInfo.Option();
            option2.name = "\ubcf8\ud488";
            option2.img = null;
            listOpt.add(option2);
            OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
            optPrice.individualPurchasePrice = individualPurchasePrice;
            optPrice.teamPurchasePrice = teamPurchasePrice;
            optPrice.aiPrice = 0;
            optPrice.stockNumber = 999;
            optPrice.sold_out = false;
            optPrice.hurry_up = false;
            optPrice.optionCode = dto.getCompayny_goods_cd();
            ListOptPrice.add(optPrice);
            azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
            testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
        } else {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            ArrayList<String> amt = new ArrayList<String>();
            ArrayList<String> option1 = new ArrayList<String>();
            ArrayList<String> option2 = new ArrayList<String>();
            ArrayList<String> limitPrice = new ArrayList<String>();
            ArrayList<String> secondOptionCheck = new ArrayList<String>();
            for (ShopOptionDto opt : shopOptionDtos) {
                if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                amt.add(opt.getAmt());
                limitPrice.add(opt.getLimit_price());
                List<String> split = Arrays.asList(opt.getOptspecdes().split(":"));
                if (split.size() > 1) {
                    if (!option1.contains(split.get(0))) {
                        option1.add(split.get(0));
                    }
                    if (!option2.contains(split.get(1))) {
                        option2.add(split.get(1));
                    }
                } else {
                    option1.add(split.get(0));
                }
                secondOptionCheck.add(opt.getOptspecdes());
            }
            if (option2.size() == 0) {
                azReg.itemInfo.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                testingGroupLog.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                int i = 0;
                while (i < option1.size()) {
                    OptionsInfo.Option option3 = new OptionsInfo.Option();
                    option3.name = (String)option1.get(i);
                    option3.img = null;
                    listOpt.add(option3);
                    OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                    if (Integer.parseInt((String)amt.get(i)) > 0) {
                        int individualPurchasePriceAddAmt = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                        int teamPurchasePriceAddAmt = dtllist.getTeamPurchasePriceUnit().equals("percent") ? individualPurchasePriceAddAmt - individualPurchasePriceAddAmt * dtllist.getTeamPurchasePrice() / 100 : individualPurchasePriceAddAmt - dtllist.getTeamPurchasePrice();
                        optPrice.individualPurchasePrice = individualPurchasePriceAddAmt;
                        optPrice.teamPurchasePrice = teamPurchasePriceAddAmt;
                    } else {
                        optPrice.individualPurchasePrice = individualPurchasePrice;
                        optPrice.teamPurchasePrice = teamPurchasePrice;
                    }
                    optPrice.aiPrice = 0;
                    optPrice.stockNumber = 999;
                    optPrice.sold_out = false;
                    optPrice.hurry_up = false;
                    optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + (i + 1);
                    ListOptPrice.add(optPrice);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
                testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
            } else {
                OptionsInfo.Option option4;
                List<String> split = Arrays.asList(shopOptionDtos.get(0).getName().split(":"));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(0));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(1));
                testingGroupLog.optionsInfo.optionNames.add(split.get(0));
                testingGroupLog.optionsInfo.optionNames.add(split.get(1));
                ArrayList<OptionsInfo.Option> listOpt2 = new ArrayList<OptionsInfo.Option>();
                azReg.itemInfo.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                testingGroupLog.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                int count = 1;
                int i = 0;
                while (i < option1.size()) {
                    option4 = new OptionsInfo.Option();
                    option4.name = (String)option1.get(i);
                    option4.img = null;
                    listOpt.add(option4);
                    ArrayList<OptionsInfo.OptionPrice> ListOptPrice2 = new ArrayList<OptionsInfo.OptionPrice>();
                    int j = 0;
                    while (j < option2.size()) {
                        OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                        if (secondOptionCheck.contains((String)option1.get(i) + ":" + (String)option2.get(j))) {
                            optPrice.stockNumber = 999;
                            optPrice.sold_out = false;
                            int index = secondOptionCheck.indexOf((String)option1.get(i) + ":" + (String)option2.get(j));
                            if (Integer.parseInt((String)amt.get(index)) > 0) {
                                int individualPurchasePriceAddAmt = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(index), (String)limitPrice.get(index));
                                int teamPurchasePriceAddAmt = dtllist.getTeamPurchasePriceUnit().equals("percent") ? individualPurchasePriceAddAmt - individualPurchasePriceAddAmt * dtllist.getTeamPurchasePrice() / 100 : individualPurchasePriceAddAmt - dtllist.getTeamPurchasePrice();
                                optPrice.individualPurchasePrice = individualPurchasePriceAddAmt;
                                optPrice.teamPurchasePrice = teamPurchasePriceAddAmt;
                            } else {
                                optPrice.individualPurchasePrice = individualPurchasePrice;
                                optPrice.teamPurchasePrice = teamPurchasePrice;
                            }
                        } else {
                            optPrice.stockNumber = 0;
                            optPrice.sold_out = true;
                            optPrice.individualPurchasePrice = individualPurchasePrice;
                            optPrice.teamPurchasePrice = teamPurchasePrice;
                        }
                        optPrice.aiPrice = 0;
                        optPrice.hurry_up = false;
                        optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + count++;
                        ListOptPrice2.add(optPrice);
                        ++j;
                    }
                    azReg.itemInfo.optionsInfo.optionPrices.add(ListOptPrice2);
                    testingGroupLog.optionsInfo.optionPrices.add(ListOptPrice2);
                    ++i;
                }
                i = 0;
                while (i < option2.size()) {
                    option4 = new OptionsInfo.Option();
                    option4.name = (String)option2.get(i);
                    option4.img = null;
                    listOpt2.add(option4);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.totalOptions.add(listOpt2);
                testingGroupLog.optionsInfo.totalOptions.add(listOpt2);
            }
        }
        azReg.itemInfo.optionsInfo.totalOptions.add(0, listOpt);
        testingGroupLog.optionsInfo.totalOptions.add(0, listOpt);
    }

    private int getPriceAfterOptionCharges(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String amt, String limitPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpPrc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpPrc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            price_cost = String.valueOf(Integer.parseInt(price_cost) + Integer.parseInt(amt));
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            ResultMarketPrice priceAfterOptionCharge = MarketPriceCalc.get().setCompliancePrice(Integer.parseInt(limitPrice)).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcRate()).setFlatDc(dtllist.getFlatDC()).setMargin(dtllist.getMarginDC()).setCommission(dtllist.getCommDC()).calculate();
            return Integer.parseInt(priceAfterOptionCharge.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ucd94\uac00\uae08\uc561 \uc138\ud305 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DeliverySetting(AlwayzProductModify azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        azReg.itemInfo.shippingInfo.freeShipping = true;
        azReg.itemInfo.shippingInfo.shippingMethod = "\uc21c\ucc28\ubc30\uc1a1";
        azReg.itemInfo.shippingInfo.shippingFee = 0;
        azReg.itemInfo.shippingInfo.shippingFeeInfo = dtllist.getShippingFeeInfo().equals("") ? "\ubb34\ub8cc\ubc30\uc1a1, \ub3c4\uc11c\uc0b0\uac04 \ucd94\uac00 \ubc30\uc1a1\ube44 -\uc81c\uc8fc \uc9c0\uc5ed: 3,000\uc6d0 -\ub3c4\uc11c\uc0b0\uac04 \uc9c0\uc5ed: 5,000\uc6d0" : dtllist.getShippingFeeInfo();
        azReg.itemInfo.shippingInfo.returnFee = dtllist.getReturnFee();
        azReg.itemInfo.shippingInfo.returnFeeInfo = dtllist.getReturnFeeInfo().equals("") ? "5,000\uc6d0 -\ub2e8, \uace0\uac1d \ub2e8\uc21c \ubcc0\uc2ec\uc758 \uacbd\uc6b0\uc5d0\ub9cc \ubc1c\uc0dd -\ub3c4\uc11c\uc0b0\uac04 \ubc0f \uc77c\ubd80 \uc9c0\uc5ed \ucd94\uac00\ube44\uc6a9 \ubc1c\uc0dd" : dtllist.getReturnFeeInfo();
        azReg.itemInfo.shippingInfo.shippingCompany = dtllist.getShippingCompany();
        azReg.itemInfo.shippingInfo.shippingDays = Integer.parseInt(dtllist.getShippingDays().replace("\uc77c", ""));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc911\uad6c \uc12c\uc9c0\uc5ed", "22386", "22388", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uac15\ud654 \uc12c\uc9c0\uc5ed", "23004", "23010", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed1", "23100", "23116", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed2", "23124", "23136", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ub2f9\uc9c4 \uc12c\uc9c0\uc5ed", "31708", "31708", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ud0dc\uc548 \uc12c\uc9c0\uc5ed", "32133", "32133", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ubcf4\ub839 \uc12c\uc9c0\uc5ed", "33411", "33411", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ubd81 \uc6b8\ub989\ub3c4 \uc804\uc9c0\uc5ed", "40200", "40240", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ubd80\uc0b0 \uac15\uc11c\uad6c \uc12c\uc9c0\uc5ed", "46768", "46771", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \uc0ac\ucc9c \uc12c\uc9c0\uc5ed", "52570", "52571", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed1", "53031", "53033", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed2", "53089", "53104", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed3", "54000", "54000", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ubd81 \ubd80\uc548 \uc12c\uc9c0\uc5ed", "56347", "56349", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc601\uad11 \uc12c\uc9c0\uc5ed", "57068", "57069", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubaa9\ud3ec \uc12c\uc9c0\uc5ed", "58760", "58762", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed1", "58800", "58810", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed2", "58816", "58818", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed3", "58826", "58826", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed4", "58828", "58866", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc9c4\ub3c4 \uc12c\uc9c0\uc5ed", "58953", "58958", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed1", "59102", "59103", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed2", "59106", "59106", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed3", "59127", "59127", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed4", "59129", "59129", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed5", "59137", "59166", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubcf4\uc131 \uc12c\uc9c0\uc5ed", "59421", "59421", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed1", "59531", "59531", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed2", "59551", "59551", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed3", "59563", "59563", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed4", "59568", "59568", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed1", "59650", "59650", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed2", "59766", "59766", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed3", "59781", "59790", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \uc6b0\ub3c4", "63365", "63365", "3000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \ucd94\uc790\uba74", "63000", "63001", "3000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uadf8 \uc678 \uc81c\uc8fc \uc804\uc9c0\uc5ed", "63000", "63644", "3000"));
    }

    private ShippingInfo.RuralAreaShippingFeeInfo CreateRuralAreaShipInfo(String ruralAreaName, String startPostNumber, String endPostNumber, String shippingFee) {
        ShippingInfo.RuralAreaShippingFeeInfo metaData = new ShippingInfo.RuralAreaShippingFeeInfo();
        metaData.ruralAreaName = ruralAreaName;
        metaData.startPostNumber = startPostNumber;
        metaData.endPostNumber = endPostNumber;
        metaData.shippingFee = shippingFee;
        return metaData;
    }

    private void GosiSetting(AlwayzProductModify azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc790", "\uc218\uc785\ud488\uc758 \uacbd\uc6b0 \uc218\uc785\uc790 \uad04\ud638\ub85c \ud568\uaed8 \ud45c\uae30", true, dto.getMaker()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uad6d(\uc6d0\uc0b0\uc9c0)", "", true, dto.getOrigin()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ucde8\uae09\uc2dc \uc8fc\uc758\uc0ac\ud56d(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc5f0\uc6d4(\uc0dd\uc0b0\uc5f0\uc6d4)", "", true, "2402"));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \ucc45\uc784\uc790", "", true, ""));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \uc804\ud654\ubc88\ud638", "", true, ""));
    }

    private CommonMetaDataInfo createCommonMetaData(String title, String placeholder, boolean isNecessary, String contents) {
        CommonMetaDataInfo metaData = new CommonMetaDataInfo();
        metaData.title = title;
        metaData.placeholder = placeholder;
        metaData.isNecessary = isNecessary;
        metaData.contents = contents;
        return metaData;
    }

    private void SellerInfoSetting(AlwayzProductModify azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto, String token) throws Exception {
        try {
            String inputLine;
            URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
            connection.setRequestProperty("x-access-token", token);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(response.toString());
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                JsonObject item = (JsonObject)jsonObject.get("data");
                azReg.itemInfo.sellerInfo.sellerId = item.get("_id").getAsString();
                azReg.itemInfo.sellerInfo.address = item.get("address").getAsString();
                azReg.itemInfo.sellerInfo.businessRegistrationNumber = item.get("businessRegistrationNumber").getAsString();
                azReg.itemInfo.sellerInfo.contactNumber = item.get("contactNumber").getAsString();
                azReg.itemInfo.sellerInfo.email = item.get("email").getAsString();
                azReg.itemInfo.sellerInfo.mailOrderBusinessNumber = item.get("mailOrderBusinessNumber").getAsString();
                azReg.itemInfo.sellerInfo.sellerDisplayName = item.get("sellerDisplayName").getAsString();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String ProductModifySend(String json, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(loginID, password);
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items").header("Connection", "keep-alive").header("x-access-token", token).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").method(Connection.Method.PUT).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            if (rs.body().contains("wrong")) {
                throw new Exception("\uc0c1\ud488 \uc218\uc815 \uc2e4\ud328 : " + rs.body());
            }
            JsonObject jsonObject = jsonParser.parse(rs.body()).getAsJsonObject();
            if (jsonObject.get("status").getAsInt() != 2000) {
                throw new Exception("\uc0c1\ud488 \uc218\uc815 \uc2e4\ud328 : " + jsonObject.get("msg").getAsString() + "[CODE:" + jsonObject.get("status").getAsString() + "]");
            }
            return token;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void ModifyImage(List<String> strImages, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String token) throws Exception {
        this.uploadMainImages(strImages, dto, token);
        this.uploadDetailImages(dto, dtllist, token);
    }

    private void uploadMainImages(List<String> imagePaths, ShopProductDto dto, String token) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("itemId", dto.getShopprodno());
        int index = 1;
        for (String path : imagePaths) {
            File file = new File(path);
            if (file.exists()) {
                String fileName = "main" + index + ".jpg";
                builder.addFormDataPart("image", fileName, this.createRequestBody(file));
                ++index;
                continue;
            }
            YDMAStringUtil.Print("\uba54\uc778 \uc774\ubbf8\uc9c0 \ud30c\uc77c \uc5c6\uc74c: " + path);
        }
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/main-images").put((RequestBody)builder.build()).addHeader("x-access-token", token).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").build();
        Object object = null;
        Object var8_9 = null;
        try (Response response = AlwayzAccessToken.hostNameIgnoreClinet().newCall(request2).execute();){
            YDMAStringUtil.Print(response.body().string());
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void uploadDetailImages(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String token) throws Exception {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("itemId", dto.getShopprodno());
        if (!dtllist.getProddetailfront().isEmpty()) {
            File front = this.getImageFile(dto.getCompayny_goods_cd(), "DetailFront");
            this.addImagePart(builder, "detailFront.png", front);
        }
        File detail = this.getImageFile(dto.getCompayny_goods_cd(), "Detail");
        this.addImagePart(builder, "detail.png", detail);
        if (!dtllist.getProddetailback().isEmpty() && "1".equals(dtllist.getProddetailoutput())) {
            File back = this.getImageFile(dto.getCompayny_goods_cd(), "DetailBack");
            this.addImagePart(builder, "detailBack.png", back);
        }
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/detail-images").put((RequestBody)builder.build()).addHeader("x-access-token", token).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").build();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Response response = AlwayzAccessToken.hostNameIgnoreClinet().newCall(request2).execute();){
            YDMAStringUtil.Print(response.body().string());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addImagePart(MultipartBody.Builder builder, String partName, File file) {
        if (file.exists()) {
            builder.addFormDataPart("image", partName, this.createRequestBody(file));
        } else {
            YDMAStringUtil.Print("\uc0c1\uc138 \uc774\ubbf8\uc9c0 \ud30c\uc77c \uc5c6\uc74c: " + file.getAbsolutePath());
        }
    }

    private File getImageFile(String code, String suffix) throws Exception {
        String path = ShopCommon.getImgPath() + "/" + code + "-alwayzReg" + suffix + ".png";
        return new File(path);
    }

    private RequestBody createRequestBody(File file) {
        return RequestBody.create((MediaType)MEDIA_TYPE_OCTET, (File)file);
    }

    private List<Integer> createList(int size) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            list.add(i);
            ++i;
        }
        return list;
    }

    private JsonArray createJsonArray(int count) {
        JsonArray jsonArray = new JsonArray();
        int i = 0;
        while (i < count) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceUri", "");
            jsonObject.add("file", (JsonElement)new JsonObject());
            jsonObject.addProperty("index", (Number)i);
            jsonArray.add((JsonElement)jsonObject);
            ++i;
        }
        return jsonArray;
    }

    private boolean productSoldOut(ShopProductDto dto, ShoppingMallDetailDto shopdto) {
        return this.updateSellStatus(dto, shopdto.getShoppingid(), shopdto.getPassword(), "https://alwayz-seller-back.ilevit.com/items/sold-out");
    }

    private boolean productResumeSale(ShopProductDto dto, ShoppingMallDetailDto shopdto) {
        return this.updateSellStatus(dto, shopdto.getShoppingid(), shopdto.getPassword(), "https://alwayz-seller-back.ilevit.com/items/resume");
    }

    private boolean updateSellStatus(ShopProductDto dto, String id, String pw, String url) {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(id, pw);
            String json = "{ \"itemId\": \"" + dto.getShopprodno() + "\" }";
            Connection.Response rs = Jsoup.connect((String)url).header("Connection", "keep-alive").header("x-access-token", token).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreContentType(true).execute();
            JsonObject jsonObject = jsonParser.parse(rs.body()).getAsJsonObject();
            if ("200".equals(jsonObject.get("status").getAsString())) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean DeleteProduct(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(shoppingMallDetailDto.getShoppingid(), shoppingMallDetailDto.getPassword());
            String targetUrl = "https://alwayz-seller-back.ilevit.com/sellers/items";
            String itemId = dto.getShopprodno();
            String jsonInputString = "{ \"itemId\": \"" + itemId + "\" }";
            URL url = new URL(targetUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("x-access-token", token);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
            connection.setDoOutput(true);
            Throwable throwable = null;
            Object var10_13 = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonInputString.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> loginCookie) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(shoppingMallDetailDto.getShoppingid(), shoppingMallDetailDto.getPassword());
            Info info = new Info();
            info.condition.type = "item";
            info.condition.itemCondition.id.$in.add(dto.getShopprodno());
            info.condition.itemSortCondition.createdAt = -1;
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString((Object)info);
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("x-access-token", token).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreContentType(true).execute();
            JsonObject jsonObject = jsonParser.parse(rs.body()).getAsJsonObject();
            if (jsonObject.get("data").getAsInt() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class AlwayzProductModify {
        private ItemInfo itemInfo = new ItemInfo();

        private AlwayzProductModify() {
        }
    }

    private static class CategoryInfo {
        private int minimumCategoryId;

        private CategoryInfo() {
        }
    }

    private static class CommonMetaDataInfo {
        public String title;
        public String placeholder;
        public boolean isNecessary;
        public String contents;

        private CommonMetaDataInfo() {
        }
    }

    private class Info {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class IdCondition {
            @JsonProperty(value="$in")
            private List<String> $in = new ArrayList<String>();

            private IdCondition() {
            }
        }

        private class ItemCondition {
            @JsonProperty(value="_id")
            private IdCondition id;

            private ItemCondition() {
                this.id = new IdCondition();
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }
    }

    private static class ItemInfo {
        private String _id;
        private CategoryInfo categoryInfo = new CategoryInfo();
        private String itemTitle;
        private OptionsInfo optionsInfo = new OptionsInfo();
        private List<String> mainImageUris = new ArrayList<String>();
        private List<String> detailImageUris = new ArrayList<String>();
        private ShippingInfo shippingInfo = new ShippingInfo();
        private List<CommonMetaDataInfo> commonMetaDataInfoList = new ArrayList<CommonMetaDataInfo>();
        private List<ProductMetaDataInfo> productMetaDataInfoList = new ArrayList<ProductMetaDataInfo>();
        private boolean soldOut;
        private boolean hurryUp;
        private int totalOrderQuantity;
        private int totalRatingCount;
        private double totalRatingScore;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private double discountRate;
        private List<PurchasingUsersInfo> purchasingUsersInfo = new ArrayList<PurchasingUsersInfo>();
        private boolean hideSellerInfo;
        private int vectorWeights;
        private SellerInfo sellerInfo = new SellerInfo();
        private int teamDealThreshold;
        private int purchaseLimits;
        private String testingSkuGroup;
        private List<TestingSkuGroupLogs> testingSkuGroupLogs = new ArrayList<TestingSkuGroupLogs>();
        private String sellerType;
        private boolean itemRankTestingSku;
        private boolean alfarmPhotoReviewMode;
        private String recommendItemCode;
        private String textForQuery;

        private ItemInfo() {
        }
    }

    private static class OptionsInfo {
        private List<String> optionNames = new ArrayList<String>();
        private List<List<Option>> totalOptions = new ArrayList<List<Option>>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<OptionPrice> optionPrice;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<List<OptionPrice>> optionPrices;

        private OptionsInfo() {
        }

        private static class Option {
            private String name;
            private String img;

            private Option() {
            }
        }

        private static class OptionMetaDataInfo {
            private OptionMetaDataInfo() {
            }
        }

        private static class OptionPrice {
            private int individualPurchasePrice;
            private int teamPurchasePrice;
            private int aiPrice;
            private int stockNumber;
            private boolean sold_out;
            private boolean hurry_up;
            private List<OptionMetaDataInfo> optionMetaDataInfoList = new ArrayList<OptionMetaDataInfo>();
            private String optionCode;

            private OptionPrice() {
            }
        }
    }

    private static class ProductMetaDataInfo {
        private ProductMetaDataInfo() {
        }
    }

    private static class PurchasingUsersInfo {
        private PurchasingUsersInfo() {
        }
    }

    private static class SellerInfo {
        private String sellerId;
        private String address;
        private String businessRegistrationNumber;
        private String contactNumber;
        private String email;
        private String mailOrderBusinessNumber;
        private String sellerDisplayName;

        private SellerInfo() {
        }
    }

    private static class ShippingInfo {
        private boolean freeShipping;
        private String shippingMethod;
        private int shippingFee;
        private String shippingFeeInfo;
        private int returnFee;
        private String returnFeeInfo;
        private List<RuralAreaShippingFeeInfo> ruralAreaShippingFeeInfo = new ArrayList<RuralAreaShippingFeeInfo>();
        private String shippingCompany;
        private int shippingDays;

        private ShippingInfo() {
        }

        private static class RuralAreaShippingFeeInfo {
            private String ruralAreaName;
            private String startPostNumber;
            private String endPostNumber;
            private String shippingFee;

            private RuralAreaShippingFeeInfo() {
            }
        }
    }

    private static class TestingSkuGroupLogs {
        private OptionsInfo optionsInfo = new OptionsInfo();
        private String testingSkuGroup;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private boolean soldOut;

        private TestingSkuGroupLogs() {
        }
    }
}

