/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.auction.IShopOrderAuctionCommand;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

class AuctionOrderNewCommand
extends IShopOrderAuctionCommand {
    private static IShopOrderCommand instance = new AuctionOrderNewCommand();
    IShopCommonLogin i = new IShopCommonLogin(){};
    JsonParser jsonparser = new JsonParser();
    private String cachedHddSearchAccount;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AuctionOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        this.getNewOrder(dto, ret);
        this.getConfirmOrder(dto, ret);
        this.getDelvieryCompletedOrder(dto, ret);
        return ret;
    }

    private String gethddSearchAccount(Map<String, String> cookies) throws Exception {
        if (this.cachedHddSearchAccount != null) {
            return this.cachedHddSearchAccount;
        }
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery");
        urlBuilder.append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        this.cachedHddSearchAccount = datas.get("hddSearchAccount");
        return this.cachedHddSearchAccount;
    }

    private List<ShopOrderMstDto> getNewOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String url = "https://www.esmplus.com/Escrow/Order/NewOrderSearch";
        String referrer = "https://www.esmplus.com/Escrow/Order/NewOrder?menuCode=TDM105";
        Connection.Response rs = Jsoup.connect((String)url).cookies(cookies).referrer(referrer).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchDistrType", "AL").data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "").execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
        Map<String, List<ShopOrderMstDto>> grouped = params.stream().collect(Collectors.groupingBy(dto -> dto.getMall_product_id() + "_" + dto.getUser_name() + "_" + dto.getUser_tel()));
        for (List<ShopOrderMstDto> group : grouped.values()) {
            if (group.size() <= 1) continue;
            int deliveryFee = this.calculateDeliveryFee(group);
            for (ShopOrderMstDto dto2 : group) {
                dto2.setDelv_cost(String.valueOf(deliveryFee));
                if (deliveryFee <= 0) continue;
                dto2.setDelivery_method_str2("\uc120\ubd88");
            }
        }
        if (params != null) {
            ret.addAll(params);
        }
        return ret;
    }

    private int calculateDeliveryFee(List<ShopOrderMstDto> group) {
        return group.stream().mapToInt(dto -> {
            String cost = dto.getDelv_cost().replaceAll(",", "").trim();
            if ("\ubb34\ub8cc".equals(cost)) {
                return 0;
            }
            try {
                return Integer.parseInt(cost);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }).max().orElse(0);
    }

    private List<ShopOrderMstDto> getConfirmOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String searchAcoount = this.gethddSearchAccount(cookies);
        StringBuilder referrerUrl = new StringBuilder();
        referrerUrl.append("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery").append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append(searchAcoount).append("^").append(id).append("^").append(site).append("&searchDateType=ODD").append("&searchSDT=").append(startdate).append("&searchEDT=").append(enddate).append("&searchKey=ON").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=false").append("&totalAccumulate=-").append("&listAllView=false").append("&searchDistrType=AL").append("&searchTransPolicyType=");
        String refferer = referrerUrl.toString();
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GeneralDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        Connection.Response rs1 = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/OverseasDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject1 = (JsonObject)this.jsonparser.parse(rs1.body());
        JsonArray jsonArray1 = (JsonArray)jsonobject1.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
        List<ShopOrderMstDto> params1 = this.getJsonManager(jsonArray1, orderDto, "100", cookies);
        if (params != null || params1 != null) {
            ret.addAll(params);
            ret.addAll(params1);
        }
        return ret;
    }

    private List<ShopOrderMstDto> getDelvieryCompletedOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        Connection.Response rs;
        JsonObject jsonobject;
        JsonArray jsonArray;
        List<ShopOrderMstDto> params;
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdate);
        Date edate = formatter.parse(enddate);
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            YDMAProgressBar.get().setValue("\uc625\uc158/\uc9c0\ub9c8\ucf13\uc740 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            startdate = formatter.format(cal2.getTime());
        }
        if ((params = this.getJsonManager2(jsonArray = (JsonArray)(jsonobject = (JsonObject)this.jsonparser.parse((rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/BuyDecisionSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").referrer("https://www.esmplus.com/Escrow/Delivery/BuyDecision?").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "TRD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchStatus", "").data("searchAllYn", "N").data("SortFeild", "TransDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchGlobalShopType", "").data("searchOverseaDeliveryYn", "").execute()).body())).get("data"), orderDto, "410", cookies)) != null) {
            ret.addAll(params);
        }
        return ret;
    }

    private List<ShopOrderMstDto> getJsonManager(JsonArray jsonArray, ShopOrderMstDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            for (JsonElement ele : jsonArray) {
                JsonObject object = ele.getAsJsonObject();
                String orderId = object.get("SiteOrderNo").getAsString();
                if (ShopOrderDao.get().isOrdered(orderId)) continue;
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setCompno(orderDto.getCompno());
                dto.setShopid(orderDto.getShopid());
                dto.setShop_userid(orderDto.getShop_userid());
                dto.setAuthkey1(orderDto.getAuthkey1());
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setResult_code("1");
                dto.setOrder_status(orderStatus);
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setMall_exp_cd("0");
                dto.setProduct_id("");
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setUser_email("");
                dto.setReceive_email("");
                dto.setOrder_date(this.jsonElementNullStr(object.get("OrderDate")));
                dto.setOrder_id(orderId);
                dto.setLabel(this.jsonElementNullStr(object.get("OrderNo")));
                dto.setUser_id(this.jsonElementNullStr(object.get("BuyerID")));
                dto.setUser_name(this.jsonElementNullStr(object.get("BuyerName")));
                dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                dto.setReceive_name(this.jsonElementNullStr(object.get("RcverName")));
                dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                dto.setReceive_zipcode(this.jsonElementNullStr(object.get("ZipCode")));
                dto.setReceive_addr(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("RcverInfoAd"))));
                dto.setMall_product_id(this.jsonElementNullStr(object.get("GoodsNo")));
                dto.setCompayny_goods_cd(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("SellerMngCode"))));
                dto.setP_product_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                dto.setProduct_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                String selOption = this.setHtmlTagDelete(this.jsonElementNullStr(object.get("SelOption")));
                String addOption = this.setHtmlTagDelete(this.jsonElementNullStr(object.get("AddOption")));
                dto.setP_sku_value(selOption + "," + addOption);
                dto.setSku_value(selOption);
                dto.setCopy_idx(this.jsonElementNullStr(object.get("CartNo")));
                dto.setDelv_msg(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryMemo"))));
                String fee = this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryFee")));
                String deleveryfee = "";
                deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), orderId, cookies) : this.jsonElementNullStr(object.get("DeliveryFee"));
                if (this.jsonElementNullStr(object.get("DeliveryFeeType")).equals("\uc120\ubd88") && deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                } else {
                    dto.setDelivery_method_str2(this.jsonElementNullStr(object.get("DeliveryFeeType")));
                }
                dto.setDelv_cost(deleveryfee);
                dto.setMall_won_cost(this.jsonElementNullStr(object.get("SttlExpectedAmnt")));
                dto.setSale_cost(this.jsonElementNullStr(object.get("SellPrice")).replace(",", ""));
                dto.setSale_cnt(this.jsonElementNullStr(object.get("OrderQty")));
                dto.setTotal_cost(this.jsonElementNullStr(object.get("OrderAmnt")).replace(",", ""));
                int paycost = this.parseIntSafe(this.jsonElementNullStr(object.get("OrderAmnt"))) - this.parseIntSafe(this.jsonElementNullStr(object.get("BuyerDCAmnt")));
                dto.setPay_cost(Integer.toString(paycost));
                dtolist.add(dto);
            }
        }
        catch (Exception e) {
            throw new Exception("\uc625\uc158/\uc9c0\ub9c8\ucf13 \uc8fc\ubb38 \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + e.getMessage() + "]");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> getJsonManager2(JsonArray jsonArray, ShopOrderMstDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            for (JsonElement ele : jsonArray) {
                JsonObject object = ele.getAsJsonObject();
                String orderId = object.get("SiteOrderNo").getAsString();
                if (ShopOrderDao.get().isOrdered(orderId)) continue;
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setCompno(orderDto.getCompno());
                dto.setShopid(orderDto.getShopid());
                dto.setShop_userid(orderDto.getShop_userid());
                dto.setAuthkey1(orderDto.getAuthkey1());
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_status(orderStatus);
                dto.setResult_code("1");
                dto.setWon_cost("0");
                dto.setMall_exp_cd("0");
                dto.setBox_ea("0");
                dto.setUser_email("");
                dto.setReceive_email("");
                dto.setReceive_zipcode("");
                dto.setReceive_addr("");
                dto.setProduct_id("");
                dto.setOrder_id(orderId);
                dto.setLabel(this.jsonElementNullStr(object.get("OrderNo")));
                dto.setOrder_date(this.jsonElementNullStr(object.get("OrderDate")));
                if (dto.getOrder_date().equals("")) {
                    dto.setOrder_date(this.jsonElementNullStr(object.get("PayDate")));
                }
                String userId = "";
                userId = object.has("BuyerID") ? this.jsonElementNullStr(object.get("BuyerID")) : this.jsonElementNullStr(object.get("BuyerId"));
                dto.setUser_id(userId);
                dto.setUser_name(this.jsonElementNullStr(object.get("BuyerName")));
                if (object.has("BuyerHt")) {
                    dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                    dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                } else {
                    dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerInfoHt")));
                    dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerInfoCp")));
                }
                dto.setReceive_name(this.jsonElementNullStr(object.get("RcverName")));
                dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                dto.setMall_product_id(this.jsonElementNullStr(object.get("GoodsNo")));
                dto.setP_product_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                dto.setProduct_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                dto.setCompayny_goods_cd(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("SellerMngCode"))));
                String addOption = "";
                if (object.has("AddOption")) {
                    addOption = this.setHtmlTagDelete(this.jsonElementNullStr(object.get("AddOption")));
                }
                String selOption = "";
                if (object.has("SelOption")) {
                    selOption = this.setHtmlTagDelete(this.jsonElementNullStr(object.get("SelOption")));
                }
                dto.setP_sku_value(selOption + "," + addOption);
                dto.setSku_value(selOption);
                dto.setCopy_idx(this.jsonElementNullStr(object.get("CartNo")));
                dto.setDelv_msg(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryMemo"))));
                if (object.has("DeliveryComp")) {
                    String deliveryId = this.jsonElementNullStr(object.get("DeliveryComp"));
                    if (deliveryId.equals("") && object.has("DeliveryCompCode")) {
                        deliveryId = this.jsonElementNullStr(object.get("DeliveryCompCode"));
                    }
                    dto.setDelivery_id(deliveryId);
                }
                if (object.has("InvoiceNo")) {
                    String invoiceNo = this.jsonElementNullStr(object.get("InvoiceNo"));
                    if (invoiceNo.contains("<input type")) {
                        invoiceNo = "";
                    }
                    dto.setInvoice_no(invoiceNo);
                }
                if (object.has("DeliveryCompNm")) {
                    dto.setDeliveryName(this.jsonElementNullStr(object.get("DeliveryCompNm")));
                }
                String fee = "";
                fee = object.has("DeliveryFee") ? this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryFee"))) : this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DomstDeliveryFee")));
                String deleveryfee = "";
                deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), orderId, cookies) : fee;
                if (deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                } else {
                    dto.setDelivery_method_str2("\uc120\ubd88");
                }
                String wonCost = "";
                if (object.has("SttlExpectedAmnt")) {
                    wonCost = object.get("SttlExpectedAmnt").getAsString();
                }
                dto.setMall_won_cost(wonCost);
                dto.setSale_cost(this.jsonElementNullStr(object.get("SellPrice")).replace(",", ""));
                dto.setSale_cnt(this.jsonElementNullStr(object.get("OrderQty")));
                dto.setDelv_cost(deleveryfee);
                dto.setTotal_cost(object.get("OrderAmnt").getAsString().replace(",", ""));
                int paycost = YDMAStringUtil.convertToInt(object.get("SellPrice").getAsString()) + YDMAStringUtil.convertToInt(deleveryfee);
                dto.setPay_cost(Integer.toString(paycost));
                dtolist.add(dto);
            }
        }
        catch (Exception e) {
            throw new Exception("\uc625\uc158/\uc9c0\ub9c8\ucf13 \uc8fc\ubb38 \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + e.getMessage() + "]");
        }
        return dtolist;
    }

    private String getDeliveryFee(String sellerID, String siteOrderNo, Map<String, String> cookies) throws Exception {
        String refferUrl = String.format("https://www.esmplus.com/Home/SSO?id=%s&code=%s&Param=OrderNo%%3D%s", sellerID, "TDP132", siteOrderNo);
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Member/SignIn/GetCoreAuthToken").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").data("SellerId", sellerID).data("MenuCode", "TDP132").data("Param", "OrderNo=" + siteOrderNo).referrer(refferUrl).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String url = URLDecoder.decode(rs.body(), "UTF-8");
        url = url.replaceAll("\"", "");
        Thread.sleep(1500L);
        Document doc = Jsoup.connect((String)url).cookies(cookies).followRedirects(true).ignoreContentType(true).get();
        Elements ele = doc.select("td").eq(2);
        return ele.text();
    }

    private String setHtmlTagDelete(String value) {
        return value.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }
}

