/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.elevenst;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDtoList;
import com.kdjsystem.mlink.shop.data.elevenst.IShopOrderElevenstCommand;
import com.kdjsystem.mlink.tot.common.YDMAHttpUtil;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

class ElevenstOrderNewCommand
extends IShopOrderElevenstCommand {
    private static IShopOrderCommand instance = new ElevenstOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private ElevenstOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto orddto = param.get(0);
        String apikey = orddto.getApikey();
        Object startdt = orddto.getStartDt();
        startdt = startdt != null && ((String)startdt).length() > 12 ? ((String)startdt).substring(0, 12) : startdt;
        Object enddt = orddto.getEndDt();
        enddt = enddt != null && ((String)enddt).length() > 12 ? ((String)enddt).substring(0, 12) : enddt;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(((String)startdt).substring(0, 8));
        Date edate = formatter.parse(((String)enddt).substring(0, 8));
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 7 == 0 ? (int)range / 7 : (int)range / 7 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 6);
            enddt = formatter.format(cal2.getTime()) + "2359";
        }
        Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
        htRequestProperty.put("Content-Type", "text/xml");
        htRequestProperty.put("openapikey", apikey);
        int i = 0;
        while (i < num) {
            HashMap<String, String> map_cmd = new HashMap<String, String>();
            map_cmd.put("100", String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt, enddt));
            map_cmd.put("201", String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt, enddt));
            map_cmd.put("410", String.format("https://api.11st.co.kr/rest/ordservices/completed/%s/%s", startdt, enddt));
            Consumer<Map.Entry> Search = entry -> {
                try {
                    ShopOrderMstDtoList list2 = new ShopOrderMstDtoList();
                    String response = YDMAHttpUtil.get((String)entry.getValue(), htRequestProperty);
                    response = response.replaceAll("ns2:", "");
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ShopOrderMstDtoList.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(response);
                    list2 = (ShopOrderMstDtoList)jaxbUnmarshaller.unmarshal((Reader)reader);
                    String key = (String)entry.getKey();
                    if (response.contains("resultCode>500")) {
                        throw new Exception(list2.getResult_text() + " 11\ubc88\uac00 \uc0ac\uc774\ud2b8\uc5d0\uc11c IP\ub97c \uc785\ub825\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                    }
                    if (key.equals("410")) {
                        if (list2.getList().size() > 0) {
                            for (ShopOrderMstDto dto : list2.getList()) {
                                if (ShopOrderDao.get().isOrdered(dto.getOrder_id())) continue;
                                dto.setOrder_status(key);
                                dto.setWon_cost("0");
                                dto.setShopid(orddto.getShopid());
                                dto.setShop_userid(orddto.getShop_userid());
                                dto.setAuthkey1(orddto.getAuthkey1());
                                dto.setResult_code("1");
                                dto.setDelivery_method_str2("");
                                dto.setMall_won_cost("0");
                                retList.add(dto);
                            }
                        }
                    } else if (list2.getList().size() > 0 && (key.equals("100") || key.equals("201"))) {
                        for (ShopOrderMstDto dto : list2.getList()) {
                            if (ShopOrderDao.get().isOrdered(dto.getOrder_id())) continue;
                            dto.setOrder_status("100");
                            dto.setWon_cost("0");
                            if (!dto.getBmDlvCst().equals("0")) {
                                dto.setDelv_cost(String.valueOf(Integer.parseInt(dto.getDelv_cost()) + Integer.parseInt(dto.getBmDlvCst())));
                            }
                            dto.setShopid(orddto.getShopid());
                            dto.setShop_userid(orddto.getShop_userid());
                            dto.setAuthkey1(orddto.getAuthkey1());
                            dto.setResult_code("1");
                            if (dto.getDelivery_method_str2() != null) {
                                dto.setDelivery_method_str2(this.getDeliveryMethod(dto.getDelivery_method_str2()));
                            }
                            retList.add(dto);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        throw new Exception(e.getMessage());
                    }
                    catch (Exception exception) {}
                }
            };
            map_cmd.entrySet().stream().peek(Search).collect(Collectors.toList());
            if (i == num - 2) {
                String endDate = orddto.getEndDt();
                enddt = endDate != null && endDate.length() > 12 ? endDate.substring(0, 12) : endDate;
            } else {
                cal2.add(5, 7);
                enddt = formatter.format(cal2.getTime()) + "2359";
            }
            cal1.add(5, 7);
            startdt = formatter.format(cal1.getTime()) + "0000";
            ++i;
        }
        return retList;
    }

    private String getDeliveryMethod(String method) {
        switch (method) {
            case "01": {
                return "\uc120\ubd88";
            }
            case "02": {
                return "\ucc29\ubd88";
            }
            case "03": {
                return "\ubb34\ub8cc";
            }
        }
        return method;
    }
}

