/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.common.OrderStatus;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.dao.UserExcelFormDao;
import com.kdjsystem.mlink.shop.dao.UserExcelFormDetailDto;
import com.kdjsystem.mlink.shop.dao.UserExcelFormMasterDto;
import com.kdjsystem.mlink.shop.liteOrder.ExcelValueOption;
import com.kdjsystem.mlink.shop.liteOrder.LiteOrderManagerHelper;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class LiteOrderExcelSelectDialog
extends CommandDialog {
    List<ShopOrderMstNewDto> list;
    List<List<String>> shopcheck = new ArrayList<List<String>>();
    YDMAGridColumnList col_list = new YDMAGridColumnList();
    public static String TITLE = "\uc5d1\uc140\uc800\uc7a5 \uc591\uc2dd \uc120\ud0dd";
    Button btnOk;
    Button btnCancel;
    private Combo cb_sendDome;
    private Button btn_cancel;
    private Button btn_excel;
    private List<UserExcelFormMasterDto> excelFormMasterList;
    private Map<String, UserExcelFormMasterDto> detailMap;

    public LiteOrderExcelSelectDialog(Shell parentShell, List<ShopOrderMstNewDto> list) {
        super(parentShell);
        this.list = list;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setBackground(parent.getDisplay().getSystemColor(1));
        Composite infoBox = new Composite(container, 2048);
        infoBox.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout infoLayout = new GridLayout(1, false);
        infoLayout.marginWidth = 10;
        infoLayout.marginHeight = 8;
        infoBox.setLayout((Layout)infoLayout);
        infoBox.setBackground(parent.getDisplay().getSystemColor(29));
        Label guideLabel1 = new Label(infoBox, 64);
        guideLabel1.setText("\ud654\uba74\uc5d0 \uc5d1\uc140 \uc591\uc2dd \uc124\uc815\uc73c\ub85c \uc591\uc2dd\uc744 \ucd94\uac00\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
        guideLabel1.setBackground(infoBox.getBackground());
        Label guideLabel2 = new Label(infoBox, 64);
        guideLabel2.setText("\uc544\ub798\uc758 \uc5d1\uc140 \uc591\uc2dd\uc740 \uc5d1\uc140 \uc591\uc2dd \uc124\uc815\uc5d0 \uc0ac\uc6a9\uc911\uc778 \uc591\uc2dd\ub9cc \ub098\uc635\ub2c8\ub2e4.");
        guideLabel2.setBackground(infoBox.getBackground());
        Label guideLabel3 = new Label(infoBox, 64);
        guideLabel3.setText("\uc120\ud0dd\ud55c \uc591\uc2dd\uc5d0 \ub9de\ucd94\uc5b4 \uc5d1\uc140\uc774 \uc800\uc7a5\ub429\ub2c8\ub2e4.");
        guideLabel3.setBackground(infoBox.getBackground());
        Composite comboArea = new Composite(container, 0);
        comboArea.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout comboLayout = new GridLayout(2, false);
        comboLayout.horizontalSpacing = 10;
        comboArea.setLayout((Layout)comboLayout);
        comboArea.setBackground(container.getBackground());
        Label comboLabel = new Label(comboArea, 0);
        comboLabel.setText("\uc5d1\uc140 \uc591\uc2dd \uc120\ud0dd:");
        comboLabel.setBackground(container.getBackground());
        this.cb_sendDome = new Combo(comboArea, 2060);
        this.cb_sendDome.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.init();
        return container;
    }

    private void init() {
        try {
            this.excelFormMasterList = UserExcelFormDao.get().getUserExcelFormMasterUsed();
            if (this.excelFormMasterList.size() > 0) {
                this.detailMap = new HashMap<String, UserExcelFormMasterDto>();
                for (UserExcelFormMasterDto dto : this.excelFormMasterList) {
                    this.detailMap.put(dto.getExcelFormName(), dto);
                    this.cb_sendDome.add(dto.getExcelFormName());
                }
            } else {
                this.cb_sendDome.add("\uc0ac\uc6a9\uc911\uc778 \uc5d1\uc140\uc591\uc2dd\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            this.cb_sendDome.select(0);
        }
        catch (Exception exception) {}
    }

    protected void okPressed() {
        if (!this.cb_sendDome.getText().equals("\uc0ac\uc6a9\uc911\uc778 \uc5d1\uc140\uc591\uc2dd\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.")) {
            try {
                this.saveExcel(this.cb_sendDome.getText());
            }
            catch (Exception exception) {}
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5d1\uc140 \uc591\uc2dd \uc124\uc815\uc73c\ub85c \ucd94\uac00\ud558\uac70\ub098, \uc0ac\uc6a9\uc911\uc73c\ub85c \ub9cc\ub4e4\uace0 \uc800\uc7a5\ud574\uc8fc\uc138\uc694.");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int saveExcel(String sheetName) throws Exception {
        UserExcelFormMasterDto selectDto = this.detailMap.get(this.cb_sendDome.getText());
        List<UserExcelFormDetailDto> dtlList = UserExcelFormDao.get().getUserExcelFormDetailByMasterSeq(selectDto.getSeq());
        String fileSavePath = this.getFileSavePath();
        if (fileSavePath == "") {
            return -1;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle cs_center = this.createCenterStyle(workbook);
        XSSFCellStyle cs_wrap = workbook.createCellStyle();
        cs_wrap.setWrapText(true);
        XSSFSheet prodmanager = workbook.createSheet(sheetName);
        if (prodmanager == null) {
            return -1;
        }
        Row row_head2 = prodmanager.createRow(0);
        row_head2.setHeightInPoints(20.0f);
        row_head2.setRowStyle((CellStyle)cs_center);
        for (UserExcelFormDetailDto dto2 : dtlList) {
            Cell cell = row_head2.createCell(this.columnLetterToIndex(dto2.getColIndex()));
            cell.setCellValue(dto2.getExcelColumnName());
        }
        int rowIdx = selectDto.getTop_insert_row();
        for (ShopOrderMstNewDto shopOrderMstNewDto : this.list) {
            Row row = prodmanager.createRow(rowIdx);
            Cell cell = null;
            for (UserExcelFormDetailDto detaliDto : dtlList) {
                cell = row.createCell(this.columnLetterToIndex(detaliDto.getColIndex()));
                try {
                    String excel_value = this.match(shopOrderMstNewDto, detaliDto, selectDto);
                    if (excel_value != null && excel_value.startsWith("=")) {
                        try {
                            cell.setCellFormula(excel_value.substring(1));
                        }
                        catch (Exception exception) {
                            cell.setCellValue(excel_value);
                        }
                        continue;
                    }
                    cell.setCellValue(excel_value);
                }
                catch (Exception exception) {
                    cell.setCellValue("");
                }
            }
            ++rowIdx;
        }
        for (UserExcelFormDetailDto userExcelFormDetailDto : dtlList) {
            prodmanager.autoSizeColumn(this.columnLetterToIndex(userExcelFormDetailDto.getColIndex()));
        }
        for (UserExcelFormDetailDto userExcelFormDetailDto : dtlList) {
            int currentWidth = prodmanager.getColumnWidth(this.columnLetterToIndex(userExcelFormDetailDto.getColIndex()));
            if (currentWidth >= 3000) continue;
            prodmanager.setColumnWidth(this.columnLetterToIndex(userExcelFormDetailDto.getColIndex()), 3000);
        }
        Throwable throwable = null;
        Iterator<Object> iterator = null;
        try (FileOutputStream fileOut = new FileOutputStream(fileSavePath);){
            workbook.write((OutputStream)fileOut);
        }
        catch (Throwable throwable2) {
            void var11_20;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var11_20;
        }
        boolean bl = MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)"\uc8fc\ubb38\uc815\ubcf4\ub97c \uc5d1\uc140\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4. \ud30c\uc77c\uc744 \uc5ec\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
        if (bl) {
            Desktop.getDesktop().edit(new File(fileSavePath));
        }
        return 0;
    }

    private int columnLetterToIndex(String col) {
        int result = 0;
        int i = 0;
        while (i < col.length()) {
            result = result * 26 + (col.charAt(i) - 65 + 1);
            ++i;
        }
        return result - 1;
    }

    private String match(ShopOrderMstNewDto dto, UserExcelFormDetailDto detaliDto, UserExcelFormMasterDto mstDto) {
        switch (ExcelValueOption.getCodeByLabel(detaliDto.getExcelColumnValue())) {
            case "BLANK": {
                return "";
            }
            case "ORDERSTATUS": {
                String value = OrderStatus.getInstance().findCode(dto.getOrder_status());
                if (value.equals("")) {
                    value = dto.getOrder_status();
                }
                return value;
            }
            case "ORDERDATE": {
                return dto.getOrder_date().substring(0, 10);
            }
            case "ORDERDATE_SIMPLY": {
                return dto.getOrder_date_simply();
            }
            case "ORDERDATE_NUM": {
                return dto.getOrder_date_num();
            }
            case "SHOPID": {
                return ShopCommon.getShoppingMallName(dto.getShopid());
            }
            case "SHOPUSERID": {
                return dto.getShop_userid();
            }
            case "NICKNM": {
                return dto.getNickname();
            }
            case "ORDERID": {
                return dto.getOrder_id();
            }
            case "USERNM": {
                return dto.getUser_name();
            }
            case "USERID": {
                return dto.getUser_id();
            }
            case "RECEIVERNM": {
                return dto.getReceive_name();
            }
            case "DELIVERYID": {
                if (dto.getDeliveryName() != null && !dto.getDeliveryName().equals("")) {
                    return dto.getDeliveryName();
                }
                if (dto.getDelivery_id() != null && !dto.getDelivery_id().equals("")) {
                    return LiteOrderManagerHelper.getDeliveryCompanynameBydlvId(dto.getShopid(), dto.getDelivery_id());
                }
                return "";
            }
            case "INVOICENO": {
                return dto.getInvoice_no();
            }
            case "COMPANYGOODSCD": {
                if (dto.getCompayny_goods_cd().contains("DMM")) {
                    return dto.getCompayny_goods_cd().replace("DMM", "");
                }
                return dto.getCompayny_goods_cd();
            }
            case "PAYCOST": {
                return dto.getPay_cost();
            }
            case "PRODUCTID": {
                return dto.getMall_product_id();
            }
            case "PRODUCTNAME": {
                return dto.getP_product_name();
            }
            case "PSKUVALUE1": {
                return dto.getP_sku_value();
            }
            case "PSKUVALUE2": {
                return dto.getP_sku_value2();
            }
            case "SKUVALUE": {
                return dto.getSku_value();
            }
            case "QTY": {
                return dto.getSale_cnt();
            }
            case "MALLWONCOST": {
                return dto.getMall_won_cost();
            }
            case "TOTALCOST": {
                return dto.getTotal_cost();
            }
            case "PAYCOST_ADD_DELVCOST": {
                return dto.getPay_cost_add_delv();
            }
            case "DELVCOST": {
                return dto.getDelv_cost();
            }
            case "DELIVERYMETHODSTR2": {
                return dto.getDelivery_method_str2();
            }
            case "DELIVERYMETHOD": {
                return dto.getDelivery_method();
            }
            case "DELVMSG": {
                return dto.getDelv_msg();
            }
            case "RECEIVEADDR": {
                return dto.getReceive_addr();
            }
            case "ZIPCODE": {
                return dto.getReceive_zipcode();
            }
            case "USERCEL": {
                return dto.getUser_cel();
            }
            case "USERCEL_NUM": {
                return dto.getUser_cel().replaceAll("-", "");
            }
            case "USERTEL": {
                return dto.getUser_tel();
            }
            case "USERTEL_NUM": {
                return dto.getUser_tel().replaceAll("-", "");
            }
            case "RECEIVECEL": {
                return dto.getReceive_cel();
            }
            case "RECEIVECEL_NUM": {
                return dto.getReceive_cel().replaceAll("-", "");
            }
            case "RECEIVETEL": {
                return dto.getReceive_tel();
            }
            case "RECEIVETEL_NUM": {
                return dto.getReceive_tel().replaceAll("-", "");
            }
            case "FORMULA": {
                return "=" + detaliDto.getExcelColumnMemo();
            }
            case "COLUMN_MEMO": {
                return detaliDto.getExcelColumnMemo();
            }
            case "COMPOSITE_OPTION_ADDON": {
                return dto.getP_sku_value() + " " + dto.getP_sku_value2();
            }
            case "COMPOSITE_SHOP_USERID": {
                return ShopCommon.getShoppingMallName(dto.getShopid()) + "(" + dto.getShop_userid() + ")";
            }
            case "COMPOISTE_SHOP_USERID_MALLWONCOST_DELVCOST_OPTION_ADDON": {
                return ShopCommon.getShoppingMallName(dto.getShopid()) + "/" + dto.getShop_userid() + "/" + dto.getMall_won_cost() + "/" + dto.getDelv_cost() + "/" + dto.getSku_value();
            }
            case "COMPOSITE_GUBUN_NICKNAME_PRODUCT_OPTION_QTY": {
                return dto.getNickname() + ":" + dto.getP_product_name() + mstDto.getGubun1() + dto.getP_sku_value() + mstDto.getGubun2() + dto.getSale_cnt() + mstDto.getGubun3();
            }
            case "COMPOSITE_GUBUN_PRODUCT_OPTION_QTY_ADDON": {
                return dto.getP_product_name() + mstDto.getGubun1() + dto.getP_sku_value() + mstDto.getGubun2() + dto.getSale_cnt() + mstDto.getGubun3() + mstDto.getGubun4();
            }
            case "COMPOSITE_GUBUN_PRODUCT_SELECTION_ADDON": {
                return dto.getP_product_name() + mstDto.getGubun1() + dto.getP_sku_value() + mstDto.getGubun4();
            }
            case "COMPOSITE_GUBUN_SHOP_PRODUCT_SELECTION_QTY_ADDON": {
                return ShopCommon.getShoppingMallName(dto.getShopid()) + dto.getP_product_name() + mstDto.getGubun1() + dto.getP_sku_value() + mstDto.getGubun2() + dto.getSale_cnt() + mstDto.getGubun3() + mstDto.getGubun4();
            }
            case "COMPOSITE_GUBUN_SHOP_PRODUCT_SELECTION_QTY_ADDON2": {
                return ShopCommon.getShoppingMallName(dto.getShopid()) + dto.getP_product_name() + mstDto.getGubun1() + dto.getP_sku_value() + mstDto.getGubun2() + dto.getSale_cnt() + mstDto.getGubun3() + mstDto.getGubun4();
            }
            case "REG_DATE": {
                return dto.getReg_date();
            }
            case "DISCOUNT_COST": {
                return dto.getDiscount_cost();
            }
            case "MALL_EXP_CD": {
                return dto.getMall_exp_cd();
            }
            case "CLAIMCOMPDATE": {
                return dto.getClaim_comp_date();
            }
            case "CLAIMREGDATE": {
                return dto.getClaim_reg_date();
            }
            case "CLAIMREASON": {
                return dto.getClaim_reason();
            }
            case "COUPANGOPTIONID": {
                return dto.getCoupang_option_id();
            }
            case "COUPANGMODELNO": {
                return dto.getCoupang_model_no();
            }
            case "NAVERORDERID": {
                return dto.getNaver_order_id();
            }
            case "EXTEND_ADDINFO": {
                return dto.getExtend_addInfo();
            }
            case "MALLWONCOST_ADD_DELVCOST": {
                return dto.getExpected_add_delv();
            }
            case "OPT_ADD_COST": {
                return dto.getOpt_add_cost();
            }
            case "REALRATE": {
                return dto.getReal_rate();
            }
            case "RATE": {
                return dto.getRate();
            }
            case "NAVERPRODUCTORDERID": {
                return dto.getNaver_product_order_id();
            }
            case "PRODUCT_URL": {
                return dto.getProduct_url();
            }
            case "DELIVERY_COMP_DATE": {
                return dto.getDelivery_comp_date();
            }
            case "NAVER_DELIVERY_ATTRIBUTE": {
                return dto.getNaver_delivery_attribute();
            }
            case "COPY_IDX": {
                return dto.getCopy_idx();
            }
            case "EXPRESS_DATE": {
                return dto.getExpress_date();
            }
            case "EXPRESS_DATE_NUM": {
                return dto.getExpress_date_num();
            }
            case "EXPRESS_DATE_SIMPLY": {
                return dto.getExpress_date_simply();
            }
            case "SCHEDULED_SHIPPING_DATE": {
                return dto.getScheduled_shipping_date();
            }
            case "EXPRESS_DEADLINE": {
                return dto.getExpress_deadline();
            }
            case "MALL_FEE": {
                return dto.getMall_fee();
            }
            case "LAST_REFERRAL_PATH": {
                return dto.getLast_referral_path();
            }
            case "REG_COUPANG_PSKUVALUE": {
                return dto.getCoupang_reg_option();
            }
            case "REG_COUPANG_PRODUCTNAME": {
                return dto.getCoupang_reg_name();
            }
            case "IS_MOUNTAIN_ISLAND": {
                return dto.getIs_mountain_island();
            }
            case "SALECOST": {
                return dto.getSale_cost();
            }
            case "EXPOSURE_COUPANG_PSKUVALUE": {
                return dto.getCoupang_exposure_option();
            }
            case "EXPOSURE_COUPANG_PRODUCTNAME": {
                return dto.getCoupang_exposure_name();
            }
            case "PURCHASE_CONFIRMED_DATE": {
                return dto.getPurchase_confirm_date();
            }
            case "SUPPLYCOST": {
                return dto.getSupply_cost();
            }
            case "PAYDATE": {
                return dto.getPay_date();
            }
            case "PAYDATE_NUM": {
                return dto.getPay_date_num();
            }
            case "PAYDATE_SIMPLY": {
                return dto.getPay_date_simply();
            }
            case "PAYMETHOD": {
                return dto.getPay_method();
            }
            case "ESM_PAYMENT_ID": {
                return dto.getEsm_payment_id();
            }
            case "PERS_TAX": {
                return dto.getPersonal_customs_code();
            }
        }
        return "";
    }

    private String getFileSavePath() {
        FileDialog fileSelectionDialog = MyDataManagerFactory.createExcelFileSaveDialog();
        String fileSavePath = fileSelectionDialog.open();
        if (fileSavePath == null) {
            return "";
        }
        return fileSavePath;
    }

    private XSSFCellStyle createCenterStyle(XSSFWorkbook workbook) {
        XSSFColor color_pass = new XSSFColor();
        color_pass.setIndexed((int)IndexedColors.GREY_40_PERCENT.getIndex());
        XSSFCellStyle cs_center = workbook.createCellStyle();
        cs_center.setAlignment(HorizontalAlignment.CENTER);
        cs_center.setFillForegroundColor(color_pass);
        cs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs_center.setWrapText(true);
        return cs_center;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_excel = this.createButton(parent, 0, "\uc800\uc7a5", false);
        this.btn_excel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc5d1\uc140\uc800\uc7a5.png"));
        this.btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setMinimumSize(new Point(20, 20));
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(468, 240);
    }
}

