/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class LiteOrderSettlementDialog
extends CommandDialog {
    private ShopOrderMstDto _dto;
    private ShopOrderMstNewDto _dto2;
    private Text txtTitle;
    private Text txtTotal;
    private Text txtTotal_1;
    private Text txtTotal_2;
    private Text txtTotal_3;
    private Text txtUnitFee;
    private Text txtQty;
    private Text txtOptAddFee;
    private Text txtMarketFee;
    private Text txtMarketFee_1;
    private Text txtMarketFee_2;
    private Text txtMarketFee_3;
    private Text txtRate;
    private Text txtSupply;
    private Text txtSupply_1;
    private Text txtDisCount;
    private Text txtDisCount_1;
    private Text txtDisCount_2;
    private Text txtRealTotal;
    private Text txtRealTotal_1;
    private Text txtRealRate;
    private Text txtExpected;
    private Text txtDelvCost;
    private Text txtRealTotalAddDelvCost;
    private Text txtExpectedAddDelvCost;
    Label lblMemo;
    private Font FONT_10 = SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0);
    private Font FONT_10_B = SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1);
    private boolean isUpdating = false;

    public LiteOrderSettlementDialog(Shell parentShell, ShopOrderMstDto dto) {
        super(parentShell);
        this._dto = dto;
    }

    public LiteOrderSettlementDialog(Shell parentShell, ShopOrderMstNewDto dto) {
        super(parentShell);
        this._dto2 = dto;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.txtTitle = new Text(container, 2056);
        this.txtTitle.setText("\ucfe0\ud321(sss)[\ubc94\ubc94\ubc94] | \uc8fc\ubb38\ubc88\ud638 : 123456789");
        this.txtTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtTitle.setFont(this.FONT_10);
        Composite card = this.createCard(container);
        this.l(card, "\ucd1d\uc8fc\ubb38\uae08\uc561");
        this.txtTotal = this.numBox(card, 8, 110);
        this.txtTotal.setText("");
        this.eq(card, "= (");
        Composite expr1 = new Composite(card, 0);
        expr1.setBackground(Display.getCurrent().getSystemColor(1));
        expr1.setLayout((Layout)new GridLayout(5, false));
        this.txtUnitFee = this.numBox(expr1, 0, 80);
        this.txtUnitFee.setText("");
        this.eq(expr1, "\u00d7");
        this.txtQty = this.numBox(expr1, 0, 60);
        this.txtQty.setText("1");
        this.eq(expr1, ") +");
        this.txtOptAddFee = this.numBox(expr1, 0, 80);
        this.txtOptAddFee.setText("0");
        this.l(card, "\ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561");
        this.txtMarketFee = this.numBox(card, 0, 110);
        this.txtMarketFee.setText("");
        new Label(card, 0);
        new Label(card, 0);
        this.l(card, "\uc218\uc218\ub8cc\uc728");
        this.txtRate = this.numBox(card, 8, 110);
        this.txtRate.setText("");
        this.eq(card, "= (");
        Composite expr2 = new Composite(card, 0);
        expr2.setBackground(Display.getCurrent().getSystemColor(1));
        expr2.setLayout((Layout)new GridLayout(5, false));
        this.txtMarketFee_1 = this.numBox(expr2, 0, 80);
        this.txtMarketFee_1.setText("");
        this.eq(expr2, "/");
        this.txtTotal_1 = this.numBox(expr2, 8, 80);
        this.txtTotal_1.setText("");
        this.eq(expr2, ") \u00d7");
        this.eq(expr2, "100");
        this.sep(card, 4);
        this.l(card, "\uacf5\uae09\uae08\uc561");
        this.txtSupply = this.numBox(card, 8, 110);
        this.txtSupply.setText("");
        this.eq(card, "= (");
        Composite expr3 = new Composite(card, 0);
        expr3.setBackground(Display.getCurrent().getSystemColor(1));
        expr3.setLayout((Layout)new GridLayout(3, false));
        this.txtTotal_2 = this.numBox(expr3, 8, 80);
        this.txtTotal_2.setText("");
        this.eq(expr3, "-");
        this.txtMarketFee_2 = this.numBox(expr3, 0, 80);
        this.txtMarketFee_2.setText("");
        this.l(card, "\ud560\uc778\uae08\uc561");
        this.txtDisCount = this.numBox(card, 0, 110);
        this.txtDisCount.setText("");
        new Label(card, 0);
        new Label(card, 0);
        this.l(card, "\uacb0\uc81c\uae08\uc561");
        this.txtRealTotal = this.numBox(card, 8, 110);
        this.txtRealTotal.setText("");
        this.eq(card, "= (");
        Composite expr4 = new Composite(card, 0);
        expr4.setBackground(Display.getCurrent().getSystemColor(1));
        expr4.setLayout((Layout)new GridLayout(3, false));
        this.txtTotal_3 = this.numBox(expr4, 8, 80);
        this.txtTotal_3.setText("");
        this.eq(expr4, "-");
        this.txtDisCount_1 = this.numBox(expr4, 0, 80);
        this.txtDisCount_1.setText("");
        this.sep(card, 4);
        this.l(card, "\uc2e4\uc218\uc218\ub8cc\uc728");
        this.txtRealRate = this.numBox(card, 8, 110);
        this.txtRealRate.setText("7.60%");
        this.eq(card, "= (");
        Composite expr5 = new Composite(card, 0);
        expr5.setBackground(Display.getCurrent().getSystemColor(1));
        expr5.setLayout((Layout)new GridLayout(5, false));
        this.txtMarketFee_3 = this.numBox(expr5, 0, 80);
        this.txtMarketFee_3.setText("2,497");
        this.eq(expr5, "/");
        this.txtRealTotal_1 = this.numBox(expr5, 8, 80);
        this.txtRealTotal_1.setText("32,850");
        this.eq(expr5, ") \u00d7");
        this.eq(expr5, "100");
        this.sep(card, 4);
        this.l(card, "\uc815\uc0b0\uc608\uc815\uae08\uc561");
        this.txtExpected = this.numBox(card, 8, 110);
        this.txtExpected.setText("30,353");
        this.eq(card, "= (");
        Composite expr6 = new Composite(card, 0);
        expr6.setBackground(Display.getCurrent().getSystemColor(1));
        expr6.setLayout((Layout)new GridLayout(3, false));
        this.txtSupply_1 = this.numBox(expr6, 8, 80);
        this.txtSupply_1.setText("33,213");
        this.eq(expr6, "-");
        this.txtDisCount_2 = this.numBox(expr6, 0, 80);
        this.txtDisCount_2.setText("2,860");
        this.l(card, "\ubc30\uc1a1\ube44");
        this.txtDelvCost = this.numBox(card, 0, 110);
        this.txtDelvCost.setText("3,500");
        new Label(card, 0);
        new Label(card, 0);
        this.l(card, "\uacb0\uc81c\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568)");
        this.txtRealTotalAddDelvCost = this.numBox(card, 8, 110);
        this.txtRealTotalAddDelvCost.setText("36,350");
        new Label(card, 0);
        new Label(card, 0);
        this.l(card, "\uc815\uc0b0\uc608\uc815\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568)");
        this.txtExpectedAddDelvCost = this.numBox(card, 8, 110);
        this.txtExpectedAddDelvCost.setText("33,853");
        new Label(card, 0);
        new Label(card, 0);
        this.createBanner(container, "\uc5e0\ub9c1\ud06c \uc608\uc0c1 \uc815\uc0b0\uc608\uc815\ub0b4\uc5ed\uc785\ub2c8\ub2e4. \uc2e4\uc815\uc0b0\uacfc \uc77c\ubd80 \ub2e4\ub97c \uc218 \uc788\uc73c\ub2c8 \uc810\uac80\ud558\uc2ed\uc2dc\uc624.");
        this.txtEvent();
        this.dataBind();
        return container;
    }

    private Composite createBanner(Composite parent, String text) {
        Composite wrap = new Composite(parent, 0);
        wrap.setLayoutData((Object)new GridData(4, 128, true, false));
        wrap.setBackground(new Color((Device)parent.getDisplay(), 255, 249, 219));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 12;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        wrap.setLayout((Layout)gl);
        Label icon = new Label(wrap, 0);
        icon.setBackground(wrap.getBackground());
        icon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        Label msg = new Label(wrap, 64);
        msg.setText(text);
        msg.setBackground(wrap.getBackground());
        msg.setFont(this.FONT_10);
        msg.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        return wrap;
    }

    private Composite createCard(Composite parent) {
        Composite cardShadow = new Composite(parent, 0);
        cardShadow.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gls = new GridLayout(1, false);
        gls.marginWidth = 0;
        gls.marginHeight = 0;
        cardShadow.setLayout((Layout)gls);
        Composite card = new Composite(cardShadow, 2048){};
        card.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 6;
        gd.horizontalIndent = 6;
        card.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 16;
        gl.marginHeight = 16;
        gl.horizontalSpacing = 10;
        gl.verticalSpacing = 8;
        card.setLayout((Layout)gl);
        return card;
    }

    private Label l(Composite p, String t) {
        Label lb = new Label(p, 131072);
        lb.setText(t);
        lb.setFont(this.FONT_10_B);
        lb.setBackground(p.getBackground());
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = 170;
        lb.setLayoutData((Object)gd);
        return lb;
    }

    private Text numBox(Composite p, int style, int width) {
        Text t = new Text(p, 0x20800 | style);
        t.setFont(this.FONT_10);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = width;
        t.setLayoutData((Object)gd);
        return t;
    }

    private Label eq(Composite p, String t) {
        Label lb = new Label(p, 0);
        lb.setText(t);
        lb.setFont(this.FONT_10);
        lb.setBackground(p.getBackground());
        lb.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        return lb;
    }

    private void sep(Composite parent, int span) {
        Label s = new Label(parent, 258);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = span;
        s.setLayoutData((Object)gd);
    }

    private void dataBind() {
        int totalCost = 0;
        int qty = 0;
        int expect = 0;
        int delvCost = 0;
        int unitFee = 0;
        int marketFee = 0;
        int supply = 0;
        int realTotal = 0;
        int realPlusD = 0;
        int expectPlusD = 0;
        int optaddPrice = 0;
        int discountPrice = 0;
        if (this._dto != null) {
            this.txtTitle.setText(String.format("%s(%s)[\uc218\ub839\uc790 : %s | \uc8fc\ubb38\ubc88\ud638 : %s]", ShopCommon.getShoppingMallName(this._dto.getShopid()), this._dto.getNickname(), this._dto.getReceive_name(), this._dto.getOrder_id()));
            totalCost = this.parseIntSafe(this._dto.getTotal_cost());
            qty = this.parseIntSafe(this._dto.getSale_cnt());
            expect = this.parseIntSafe(this._dto.getMall_won_cost());
            delvCost = this.parseIntSafe(this._dto.getDelv_cost());
            unitFee = totalCost / qty;
            marketFee = totalCost - expect;
            supply = totalCost - marketFee;
            realTotal = totalCost - 0;
            realPlusD = realTotal + delvCost;
            expectPlusD = expect + delvCost;
        } else {
            this.txtTitle.setText(String.format("%s(%s)[\uc218\ub839\uc790 : %s | \uc8fc\ubb38\ubc88\ud638 : %s]", ShopCommon.getShoppingMallName(this._dto2.getShopid()), this._dto2.getNickname(), this._dto2.getReceive_name(), this._dto2.getOrder_id()));
            totalCost = this.parseIntSafe(this._dto2.getTotal_cost());
            qty = this.parseIntSafe(this._dto2.getSale_cnt());
            expect = this.parseIntSafe(this._dto2.getMall_won_cost());
            delvCost = this.parseIntSafe(this._dto2.getDelv_cost());
            unitFee = this.parseIntSafe(this._dto2.getSale_cost());
            marketFee = this.parseIntSafe(this._dto2.getMall_fee());
            supply = this.parseIntSafe(this._dto2.getSupply_cost());
            realTotal = this.parseIntSafe(this._dto2.getPay_cost());
            realPlusD = this.parseIntSafe(this._dto2.getPay_cost_add_delv());
            expectPlusD = this.parseIntSafe(this._dto2.getExpected_add_delv());
            optaddPrice = this.parseIntSafe(this._dto2.getOpt_add_cost());
            discountPrice = this.parseIntSafe(this._dto2.getDiscount_cost());
        }
        this.setTextAll(this.fmtInt(totalCost), this.txtTotal, this.txtTotal_1, this.txtTotal_2, this.txtTotal_3);
        this.setTextAll(this.fmtInt(marketFee), this.txtMarketFee, this.txtMarketFee_1, this.txtMarketFee_2, this.txtMarketFee_3);
        this.setTextAll(this.fmtInt(supply), this.txtSupply, this.txtSupply_1);
        this.setTextAll(this.fmtInt(realTotal), this.txtRealTotal, this.txtRealTotal_1);
        this.setTextAll(this.fmtInt(discountPrice), this.txtDisCount, this.txtDisCount_1, this.txtDisCount_2);
        this.setText(this.txtQty, this.fmtInt(qty));
        this.setText(this.txtExpected, this.fmtInt(expect));
        this.setText(this.txtRealTotalAddDelvCost, this.fmtInt(realPlusD));
        this.setText(this.txtExpectedAddDelvCost, this.fmtInt(expectPlusD));
        this.setText(this.txtUnitFee, this.fmtInt(unitFee));
        this.setText(this.txtDelvCost, this.fmtInt(delvCost));
        this.setText(this.txtOptAddFee, this.fmtInt(optaddPrice));
        this.setText(this.txtRate, this.percentOf(marketFee, totalCost, 2));
        this.setText(this.txtRealRate, this.percentOf(marketFee, realTotal, 2));
    }

    private void txtEvent() {
        this.applyNumericFormat(this.txtUnitFee, this.txtQty, this.txtOptAddFee, this.txtMarketFee, this.txtMarketFee_1, this.txtMarketFee_2, this.txtMarketFee_3, this.txtDisCount, this.txtDisCount_1, this.txtDisCount_2, this.txtDelvCost);
    }

    private void applyNumericFormat(Text ... fields) {
        Text[] textArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            text.addListener(25, e -> {
                String oldText = ((Text)e.widget).getText();
                String newText = oldText.substring(0, e.start) + e.text + oldText.substring(e.end);
                if (!newText.matches("[0-9,]*")) {
                    e.doit = false;
                }
            });
            text.addListener(16, e -> {
                Text src = (Text)e.widget;
                this.afterCalculate(src);
            });
            ++n2;
        }
    }

    private void afterCalculate(Text text) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        try {
            if (text == this.txtMarketFee || text == this.txtMarketFee_1 || text == this.txtMarketFee_2 || text == this.txtMarketFee_3) {
                this.setTextAll(text.getText(), this.txtMarketFee, this.txtMarketFee_1, this.txtMarketFee_2, this.txtMarketFee_3);
            } else if (text == this.txtDisCount || text == this.txtDisCount_1 || text == this.txtDisCount_2) {
                this.setTextAll(text.getText(), this.txtDisCount, this.txtDisCount_1, this.txtDisCount_2);
            }
            int unitFee = this.parseIntSafe(this.txtUnitFee.getText());
            int qty = this.parseIntSafe(this.txtQty.getText());
            int optAddFee = this.parseIntSafe(this.txtOptAddFee.getText());
            int marketFee = this.parseIntSafe(this.txtMarketFee.getText());
            int discount = this.parseIntSafe(this.txtDisCount.getText());
            int delvCost = this.parseIntSafe(this.txtDelvCost.getText());
            int totalCost = unitFee * qty + optAddFee;
            int supply = totalCost - marketFee;
            int realTotal = totalCost - discount;
            int expect = supply - discount;
            int realPlusD = realTotal + delvCost;
            int expectPlusD = expect + delvCost;
            this.setTextAll(this.fmtInt(totalCost), this.txtTotal, this.txtTotal_1, this.txtTotal_2, this.txtTotal_3);
            this.setTextAll(this.fmtInt(marketFee), this.txtMarketFee, this.txtMarketFee_1, this.txtMarketFee_2, this.txtMarketFee_3);
            this.setTextAll(this.fmtInt(supply), this.txtSupply, this.txtSupply_1);
            this.setTextAll(this.fmtInt(realTotal), this.txtRealTotal, this.txtRealTotal_1);
            this.setText(this.txtExpected, this.fmtInt(expect));
            this.setText(this.txtRealTotalAddDelvCost, this.fmtInt(realPlusD));
            this.setText(this.txtExpectedAddDelvCost, this.fmtInt(expectPlusD));
            this.setText(this.txtRate, this.percentOf(marketFee, totalCost, 2));
            this.setText(this.txtRealRate, this.percentOf(marketFee, realTotal, 2));
        }
        finally {
            this.isUpdating = false;
        }
    }

    private int parseIntSafe(String s) {
        String t = this.onlyDigits(s);
        if (t.isEmpty() || t.equals("-")) {
            return 0;
        }
        try {
            return Integer.parseInt(t);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String onlyDigits(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("[^0-9]", "");
    }

    private String fmtInt(int v) {
        return String.format("%,d", v);
    }

    private void setTextAll(String v, Text ... fields) {
        Text[] textArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            this.setText(t, v);
            ++n2;
        }
    }

    private void setText(Text t, String v) {
        if (t == null) {
            return;
        }
        if (!Objects.equals(t.getText(), v)) {
            t.setText(v);
        }
    }

    private String percentOf(int part, int base, int scale) {
        if (base == 0) {
            return "0%";
        }
        double p = (double)part * 100.0 / (double)base;
        return String.format(Locale.KOREA, "%." + scale + "f%%", p);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("\uc815\uc0b0\ubcf4\uae30");
        super.configureShell(newShell);
    }

    private void oldVersion() {
    }
}

