/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.sellmall;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.HttpClientEx;
import com.kdjsystem.mlink.shop.sellmall.CategoryItemSellmallDto;
import com.kdjsystem.mlink.shop.sellmall.LoginResponseDto;
import com.kdjsystem.mlink.shop.sellmall.SellmallSessonUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SellmallAPI {
    private static SellmallAPI instance = new SellmallAPI();
    public static final String LOGIN_HOST = "http://localhost:8080";

    public static SellmallAPI get() {
        return instance;
    }

    private boolean loadCategory() throws Exception {
        String response = "";
        String path = "/v1/category/list";
        response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").addParam("X-AUTH-TOKEN", SellmallSessonUtil.get().getData()).Get(LOGIN_HOST.concat(path));
        if (response == null) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        CategorySellmall Category2 = null;
        Category2 = (CategorySellmall)mapper.readValue(response, CategorySellmall.class);
        if (Category2.code.equals("0")) {
            List<CategoryItemSellmallDto> largeCategory = Arrays.asList(Category2.list).stream().filter(p -> p.deep.equals("1")).collect(Collectors.toList());
            SellmallSessonUtil.get().setLargeCategory(largeCategory);
            List<CategoryItemSellmallDto> midCategory = Arrays.asList(Category2.list).stream().filter(p -> p.deep.equals("2")).collect(Collectors.toList());
            SellmallSessonUtil.get().setMidCategory(midCategory);
            List<CategoryItemSellmallDto> smallCategory = Arrays.asList(Category2.list).stream().filter(p -> p.deep.equals("3")).collect(Collectors.toList());
            SellmallSessonUtil.get().setSmallCategory(smallCategory);
            List<CategoryItemSellmallDto> detailCategory = Arrays.asList(Category2.list).stream().filter(p -> p.deep.equals("4")).collect(Collectors.toList());
            SellmallSessonUtil.get().setDetailCategory(detailCategory);
            SellmallSessonUtil.get().setAllCategory(Arrays.asList(Category2.list));
        }
        return true;
    }

    public boolean Login(String id, String password) throws Exception {
        boolean retVal;
        block5: {
            retVal = false;
            String path = "/v1/login";
            String formParams = String.format("id=%s&password=%s&type=M", id, password);
            String response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(LOGIN_HOST.concat(path), formParams);
            if (response != null && response.length() > 0) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    LoginResponseDto userInfo = (LoginResponseDto)mapper.readValue(response, LoginResponseDto.class);
                    if (userInfo.code.equals("0")) {
                        retVal = true;
                        SellmallSessonUtil.get().setUserInfo(userInfo);
                        this.loadCategory();
                        break block5;
                    }
                    SellmallSessonUtil.get().ResultLoginText = userInfo.msg;
                    retVal = false;
                }
                catch (Exception e) {
                    retVal = false;
                    SellmallSessonUtil.get().ResultLoginText = e.getMessage();
                }
            } else {
                retVal = false;
                SellmallSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            }
        }
        return retVal;
    }

    private static final class CategorySellmall {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="success")
        public boolean success;
        @JsonProperty(value="msg")
        public String msg;
        @JsonProperty(value="list")
        public CategoryItemSellmallDto[] list;

        private CategorySellmall() {
        }
    }
}

