/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.common;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.MainView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LiteOrderManager {
    public static void setDefaultGridColumns(YDMAGridColumnList col_list) {
        col_list.add(0, "ORDER_STATUS", "\uc0c1\ud0dc", 80);
        col_list.add(1, "ORDER_DATE", "\uc8fc\ubb38\uc77c\uc2dc", 80);
        col_list.add(2, "SHOPID", "\uc1fc\ud551\ubab0", 140);
        col_list.add(3, "SHOP_USERID", "\uc1fc\ud551\ubab0ID", 100);
        col_list.add(4, "nickname", "\ub2c9\ub124\uc784", 100);
        col_list.add(5, "ORDER_ID", "\uc8fc\ubb38\ubc88\ud638", 100);
        col_list.add(6, "user_name", "\uc8fc\ubb38\uc790", 70);
        col_list.add(7, "RECEIVE_NAME", "\uc218\ub839\uc790", 50);
        col_list.add(8, "COMPAYNY_GOODS_CD", "\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc", 100);
        col_list.add(9, "MALL_PRODUCT_ID", "\uc0c1\ud488\ubc88\ud638", 87);
        col_list.add(10, "P_PRODUCT_NAME", "\uc0c1\ud488\uba85", 300);
        col_list.add(11, "P_SKU_VALUE", "\uc635\uc158", 205);
        col_list.add(12, "SALE_CNT", "\uc218\ub7c9", 40);
        col_list.add(13, "WON_COST", "\uc6d0\uac00", 65);
        col_list.add(14, "MALL_WON_COST", "\uc815\uc0b0\uc608\uc815\uac00", 80);
        col_list.add(15, "TOTAL_COST", "\uc8fc\ubb38\uae08\uc561", 80);
        col_list.add(16, "DELV_COST", "\ubc30\uc1a1\ube44", 51);
        col_list.add(17, "DELIVERY_METHOD_STR2", "\ubc30\uc1a1\ubc29\ubc95", 61);
        col_list.add(18, "DELV_MSG", "\ubc30\uc1a1\uba54\uc138\uc9c0", 140);
        col_list.add(19, "USER_CEL", "\uc8fc\ubb38\uc790 \uc804\ud654\ubc88\ud638", 0);
        col_list.add(20, "RECEIVE_CEL", "\uc218\ub839\uc790 \uc804\ud654\ubc88\ud638", 108);
        col_list.add(21, "RECEIVE_ADDR", "\uc8fc\uc18c", 0);
        col_list.add(22, "DELIVERY_ID", "\ubc30\uc1a1\uc0ac", 80);
        col_list.add(23, "INVOICE_NO", "\uc1a1\uc7a5\ubc88\ud638", 120);
        col_list.add(24, "LABEL", "\ub77c\ubca8\ucd9c\ub825\uc5ec\ubd80", 120);
        col_list.add(25, "RECEIVE_ZIPCODE", "\uc6b0\ud3b8\ubc88\ud638", 120);
    }

    public static void setCombo(final List<ShoppingMallDetailDto> activeShops, final Combo cb_shop, final Combo cb_shoppingID) {
        List shopcdList = activeShops.stream().map(ShoppingMallDetailDto::getShopcd).distinct().collect(Collectors.toList());
        if (shopcdList.size() > 0) {
            for (String shopcd : shopcdList) {
                cb_shop.add(ShopCommon.getShoppingMallName(shopcd));
            }
            cb_shop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = cb_shop.getSelectionIndex();
                    if (index > 0) {
                        List shoppingIdList = activeShops.stream().filter(dto -> ShopCommon.getShopCd(cb_shop.getItem(index)).equals(dto.getShopcd())).map(dto -> dto.getShoppingid() + " - " + dto.getNicknm1()).collect(Collectors.toList());
                        cb_shoppingID.removeAll();
                        cb_shoppingID.add("\uc1fc\ud551\ubab0 ID \uc804\uccb4");
                        for (String shoppingID : shoppingIdList) {
                            cb_shoppingID.add(shoppingID);
                        }
                        cb_shoppingID.select(0);
                    } else {
                        cb_shoppingID.removeAll();
                        cb_shoppingID.add("\uc1fc\ud551\ubab0 ID \uc804\uccb4");
                        cb_shoppingID.select(0);
                    }
                }
            });
        }
    }

    public static String[] setDefaultDate(DateTime dateTime_to, DateTime dateTime_from) {
        String[] days = null;
        try {
            ShopPreferencesDto dto = ShopCommonDao.get().getSystemConf();
            days = YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
            int yearCurrnet = Integer.valueOf(days[0].substring(0, 4));
            int monCurrnet = Integer.valueOf(days[0].substring(4, 6));
            int dayCurrnet = Integer.valueOf(days[0].substring(6, 8));
            dateTime_to.setYear(yearCurrnet);
            dateTime_to.setMonth(monCurrnet - 1);
            dateTime_to.setDay(dayCurrnet);
            Calendar calender_dateTime_from = Calendar.getInstance();
            if (dto.getCompno() != null) {
                calender_dateTime_from.add(5, -(Integer.parseInt(dto.getOrdperiod()) - 1));
            }
            Date date_from = calender_dateTime_from.getTime();
            String str_date_from = new SimpleDateFormat("yyyyMMdd").format(date_from);
            dateTime_from.setYear(Integer.parseInt(str_date_from.substring(0, 4)));
            dateTime_from.setMonth(Integer.parseInt(str_date_from.substring(4, 6)) - 1);
            dateTime_from.setDay(Integer.parseInt(str_date_from.substring(6, 8)));
        }
        catch (Exception exception) {}
        return days;
    }

    public static String[] setDefaultDate(String data2, DateTime dateTime_to, DateTime dateTime_from) {
        String[] days = YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
        int yearCurrnet = Integer.valueOf(days[0].substring(0, 4));
        int monCurrnet = Integer.valueOf(days[0].substring(4, 6));
        int dayCurrnet = Integer.valueOf(days[0].substring(6, 8));
        dateTime_to.setYear(yearCurrnet);
        dateTime_to.setMonth(monCurrnet - 1);
        dateTime_to.setDay(dayCurrnet);
        switch (data2) {
            case "\uc624\ub298": {
                SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
                Date currentTime = new Date();
                String mTime = mSimpleDateFormat.format(currentTime);
                dateTime_from.setYear(Integer.parseInt(mTime.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(mTime.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(mTime.substring(6, 8)));
                break;
            }
            case "\uc5b4\uc81c": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                dateTime_to.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_to.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_to.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "week1": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -7);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month1": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -1);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month3": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -3);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month6": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, -6);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                dateTime_from.setYear(Integer.parseInt(aa.substring(0, 4)));
                dateTime_from.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                dateTime_from.setDay(Integer.parseInt(aa.substring(6, 8)));
            }
        }
        return days;
    }

    public static void copyClickedCellToClipboard(Shell shell, GridTableViewer gridTableViewer, YDMAGridColumnList col_list) {
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        GridItem[] gridItem = gridTableViewer.getGrid().getSelection();
        List col_idxs = Arrays.asList(gridTableViewer.getGrid().getCellSelection()).stream().map(p -> p.x).distinct().collect(Collectors.toList());
        List list = Arrays.stream(gridItem).map(d -> (ShopOrderMstDto)d.getData()).collect(Collectors.toList());
        StringBuilder sbText = new StringBuilder();
        for (ShopOrderMstDto dto : list) {
            ArrayList<String> col_values = new ArrayList<String>();
            for (Integer idx : col_idxs) {
                String value = col_list.getFieldValue(dto, col_list.getFieldName(idx));
                col_values.add(value);
            }
            sbText.append(String.join((CharSequence)"\t", col_values));
            sbText.append("\r\n");
        }
        String plainText = sbText.toString();
        String rtfText = String.format("{\\rtf1\\b %s}", sbText.toString());
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFTransfer rftTransfer = RTFTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{plainText, rtfText}, new Transfer[]{textTransfer, rftTransfer});
        clipboard.dispose();
    }

    public static void setMenuTree(Tree tree, List<ShoppingMallDetailDto> activeShops) {
        ArrayList<CodeItem> urlItem = new ArrayList<CodeItem>();
        TreeItem item = new TreeItem(tree, 0);
        item.setText(new String[]{"\uc804\uccb4", "A", "", "", "", "", "", ""});
        try {
            Map<String, Map<String, List<ShoppingMallDetailDto>>> mapList = activeShops.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
            List items = ShopCommon.getCommonCodeList("PRODUCT_SHOP").stream().map(p -> p.getCode()).collect(Collectors.toList());
            Collections.sort(items);
            for (String shopid : items) {
                LinkedHashMap map = new LinkedHashMap();
                if (mapList.get(shopid) == null) continue;
                mapList.get(shopid).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                    List list = map.put((String)x.getKey(), (List)x.getValue());
                });
                TreeItem subItem = new TreeItem(item, 0);
                for (String shopUserID : map.keySet()) {
                    List listdto = (List)map.get(shopUserID);
                    subItem.setText(new String[]{((ShoppingMallDetailDto)listdto.get(0)).getShopnm(), "C", ((ShoppingMallDetailDto)listdto.get(0)).getShopcd(), "", "", "", "", ""});
                    for (ShoppingMallDetailDto dto : listdto) {
                        TreeItem subsubItem = new TreeItem(subItem, 0);
                        String shoppingid = dto.getNicknm1() == null || dto.getNicknm1().trim().length() == 0 ? dto.getShoppingid() : dto.getNicknm1().concat("-").concat(dto.getShoppingid());
                        subsubItem.setText(new String[]{shoppingid, "U", dto.getShopcd(), dto.getShopnm(), dto.getShopseq(), dto.getShoppingid()});
                        String code = String.format("%s,%s,%s,%s,%s", dto.getShopUrl(), dto.getShoppingid(), dto.getPassword(), dto.getShopcd(), dto.getAuthkey1());
                        urlItem.add(new CodeItem(code, ((ShoppingMallDetailDto)listdto.get(0)).getShopnm() + "(" + dto.getShoppingid() + ")"));
                    }
                }
            }
            TreeItem[] treeItemArray = tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem i = treeItemArray[n2];
                TreeItem[] treeItemArray2 = i.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem s = treeItemArray2[n4];
                    TreeItem[] treeItemArray3 = s.getItems();
                    int n5 = treeItemArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem g = treeItemArray3[n6];
                        i.setExpanded(true);
                        s.setExpanded(false);
                        g.setExpanded(false);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public static List<ShopOrderMstDto> convertShoppingMallToShopOrderList(List<ShoppingMallDetailDto> list, String dateFrom, String dateTo, String status2) {
        List<ShopOrderMstDto> params = list.stream().map(dto -> {
            ShopOrderMstDto order = new ShopOrderMstDto();
            order.setShopid(dto.getShopcd());
            order.setShop_userid(dto.getShoppingid());
            order.setShopnm(dto.getShopnm());
            order.setShopPw(dto.getPassword());
            order.setApikey(dto.getApikey());
            order.setAuthkey1(dto.getAuthkey1());
            order.setAuthKey2(dto.getAuthkey2());
            order.setVendorId(dto.getVendorId());
            order.setShopseq(dto.getShopseq());
            order.setSuppstditem(dto.getSuppstditem());
            order.setSuppstdrati(dto.getSuppstdrati());
            order.setNickname(dto.getNicknm1());
            order.setStartDt(dateFrom);
            order.setEndDt(dateTo);
            order.setEDITAUTHKEY1(dto.getEditauthkey1());
            order.setEDITAPIKEY(dto.getEditapikey());
            order.setSpecificStatus(status2);
            return order;
        }).collect(Collectors.toList());
        return params;
    }

    public static void populateShopOrderMstDtoList(List<ShopOrderMstDto> resultList, ShopOrderMstDto dto) {
        resultList.forEach(result -> {
            result.setShopPw(dto.getShopPw());
            result.setApikey(dto.getApikey());
            result.setAuthkey1(dto.getAuthkey1());
            result.setAuthKey2(dto.getAuthKey2());
            result.setVendorId(dto.getVendorId());
            result.setShopseq(dto.getShopseq());
            result.setSuppstditem(dto.getSuppstditem());
            result.setSuppstdrati(dto.getSuppstdrati());
            result.setNickname(dto.getNickname());
            result.setEDITAUTHKEY1(dto.getEDITAUTHKEY1());
            result.setEDITAPIKEY(dto.getEDITAPIKEY());
        });
    }

    public static void setLabelBind(List<ShopOrderMstDto> dtolist) {
        String message = "\t\uc774 \ud398\uc774\uc9c0\uc758 \ud569\uacc4 : %s\uac74  \uc815\uc0b0\uc608\uc815\uac00: %s\uc6d0    \ud310\ub9e4\uac00: %s\uc6d0     \ubc30\uc1a1\ube44 : %s\uc6d0";
        Integer mallWon_cost = 0;
        Integer mallsale_cost = 0;
        Integer delvery_cost = 0;
        for (ShopOrderMstDto dto : dtolist) {
            mallWon_cost = mallWon_cost + YDMAStringUtil.convertToInt(dto.getMall_won_cost());
            mallsale_cost = mallsale_cost + YDMAStringUtil.convertToInt(dto.getTotal_cost());
            delvery_cost = delvery_cost + YDMAStringUtil.convertToInt(dto.getDelv_cost());
        }
        message = String.format(message, dtolist.size(), mallWon_cost, mallsale_cost, delvery_cost);
        MainView.statusBar.getStatusLineManager().setMessage(message);
    }
}

