/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.common;

import com.google.common.io.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class YDMAProgressBar2 {
    private JFrame frame;
    private Container container;
    private JProgressBar bar;
    private JLabel label;
    private JTextArea txtLog;
    private JButton btnCancel;
    private int milliseconds;
    private String title;
    private boolean visiableStatus;
    private volatile boolean cancelled = false;
    private OperationCanceledListener listener;

    public void setOperationCanceledListener(OperationCanceledListener listener) {
        this.listener = listener;
    }

    public void start(String title, int maximum, int milliseconds, boolean visiableStatus) {
        this.milliseconds = milliseconds;
        this.title = title;
        this.visiableStatus = visiableStatus;
        this.cancelled = false;
        this.frame = new JFrame(title);
        this.frame.setDefaultCloseOperation(2);
        this.bar = new JProgressBar();
        this.bar.setMaximum(maximum);
        try {
            URL url = Resources.getResource((String)"icons/MLink16_red.png");
            ImageIcon img = new ImageIcon(url);
            this.frame.setIconImage(img.getImage());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.container = this.frame.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.container.add((Component)this.bar, "North");
        if (visiableStatus) {
            this.txtLog = new JTextArea();
            this.txtLog.setFont(new Font("\ub9d1\uc740 \uace0\ub515", 1, 18));
            this.txtLog.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(this.txtLog);
            this.container.add((Component)scrollPane, "Center");
            this.label = new JLabel("\uc791\uc5c5 \uc900\ube44\uc911...");
            this.container.add((Component)this.label, "South");
            this.frame.setSize(1100, 600);
            this.frame.setLocation(10, 10);
        } else {
            this.frame.setSize(570, 80);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension screen = tk.getScreenSize();
            this.frame.setLocation(screen.width / 2 - 285, screen.height / 2 - 40);
        }
        this.btnCancel = new JButton("\uc911\ub2e8");
        this.btnCancel.addActionListener(e -> this.cancelOperation());
        this.container.add((Component)this.btnCancel, "Last");
        this.frame.setVisible(true);
    }

    public void setValue(int value, String message) {
        if (this.bar != null) {
            this.bar.setValue(value);
        }
        if (this.label != null && message != null) {
            this.label.setText(message);
        }
        this.appendLog(message);
    }

    private void appendLog(String msg) {
        if (this.txtLog != null && msg != null) {
            this.txtLog.append(msg + "\n");
            this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
        }
    }

    public void setValueBackWithFont(String text, int value, int style, int size) {
        if (this.milliseconds > 0) {
            try {
                Thread.sleep(this.milliseconds);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.bar != null) {
            this.bar.setValue(value);
            this.bar.setStringPainted(true);
        }
        if (this.frame != null && text != null) {
            this.frame.setTitle(text);
        }
        if (this.txtLog != null && text != null) {
            this.txtLog.setFont(new Font("\ub9d1\uc740 \uace0\ub515", style, size));
            this.txtLog.append(text + "\n");
            this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
        }
    }

    private void cancelOperation() {
        this.cancelled = true;
        if (this.listener != null) {
            try {
                this.listener.onOperationCanceled();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.appendLog(">>> \uc0ac\uc6a9\uc790\uac00 \uc791\uc5c5 \uc911\ub2e8\uc744 \uc694\uccad\ud588\uc2b5\ub2c8\ub2e4.");
        if (this.label != null) {
            this.label.setText("\uc791\uc5c5\uc774 \uc0ac\uc6a9\uc790\uc5d0 \uc758\ud574 \uc911\ub2e8\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public static interface OperationCanceledListener {
        public void onOperationCanceled();
    }
}

