/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.YDMAPluginUtils;
import com.kdjsystem.mlink.tot.data.dao.QuestListDao;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.StatisticalInfoManager;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class StatisticalInfoChart
extends CommandDialog {
    private static final int S = 0;
    public static String TITLE = "\ud1bb\uacc4 \ucc28\ud2b8 \ubcf4\uae30";
    StatisticalInfoManager opener;
    public int selectedIdx = -1;
    String orderListFullPath;
    Composite composite_table;
    public Grid table;
    GridTableViewer tableViewer;
    String[] _dates;
    int[] _sales;
    public String prodcd;
    public String prodnm;
    public String maxDate;
    private Grid grid;
    private GridTableViewer gridTableViewer;
    GridTableViewer tableViewer2;
    Grid table2;
    GridColumn tableViewerColumn_sumbasicStock;
    GridColumn tableViewerColumn_sumwearing;
    GridColumn tableViewerColumn_sumsale;
    GridColumn tableViewerColumn_sumwarehouseStock;
    Button btnOk;
    Button btnCancel;
    List<String> list;
    private Composite composite;

    public StatisticalInfoChart(Shell shell, StatisticalInfoManager opener, String[] dates, int[] sales) {
        super(shell);
        this.setShellStyle(0x870 | StatisticalInfoChart.getDefaultOrientation());
        this.opener = opener;
        this._dates = dates;
        this._sales = sales;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginRight = 7;
        gl_container.marginLeft = 7;
        gl_container.marginTop = 7;
        gl_container.marginBottom = 7;
        container.setLayout((Layout)gl_container);
        ScrolledComposite scrolledComposite_1 = new ScrolledComposite(container, 2816);
        GridData gd_scrolledComposite_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_scrolledComposite_1.heightHint = 386;
        gd_scrolledComposite_1.widthHint = 793;
        scrolledComposite_1.setLayoutData((Object)gd_scrolledComposite_1);
        scrolledComposite_1.setExpandHorizontal(true);
        scrolledComposite_1.setExpandVertical(true);
        this.composite = new Composite((Composite)scrolledComposite_1, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Canvas canvas = new Canvas(this.composite, 2048);
        canvas.setBackground(SWTResourceManager.getColor(1));
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite_1.setContent((Control)this.composite);
        scrolledComposite_1.setMinSize(this.composite.computeSize(-1, -1));
        canvas.addPaintListener(e -> {
            GC gc = e.gc;
            int canvasWidth = canvas.getClientArea().width - 50;
            int canvasHeight = canvas.getClientArea().height;
            if (this._sales.length == 0) {
                return;
            }
            int barWidth = canvasWidth / (this._sales.length * 2);
            int maxValue = Arrays.stream(this._sales).max().getAsInt();
            int i = 0;
            while (i < this._sales.length) {
                int barHeight = (int)((double)this._sales[i] / (double)maxValue * (double)(canvasHeight - 130));
                int x = i * 2 * barWidth + 50;
                int y = canvasHeight - barHeight - 30;
                gc.setBackground(Display.getDefault().getSystemColor(32));
                gc.fillRectangle(x, y, barWidth, barHeight);
                gc.setForeground(Display.getDefault().getSystemColor(2));
                gc.drawText(this._dates[i], x, canvasHeight - 25, true);
                NumberFormat nf = NumberFormat.getInstance();
                gc.drawText(nf.format(this._sales[i]), x, y - 20, true);
                ++i;
            }
            gc.drawLine(40, 10, 40, canvasHeight - 30);
            gc.drawLine(40, canvasHeight - 30, canvasWidth - 10, canvasHeight - 30);
        });
        scrolledComposite_1.setContent((Control)this.composite);
        this.init();
        return container;
    }

    private void init() {
        QuestListDao dao = new QuestListDao();
        dao.questionSeq();
    }

    protected void okPressed() {
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnCancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btnCancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        YDMAPluginUtils.getMonitorSize();
        return new Point(857, 527);
    }
}

