/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CaffeineCategoryCache {
    private final LoadingCache<String, String> cache;
    private final LoadingCache<String, Optional<String>> fullNameCache;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final CaffeineCategoryCache INSTANCE = new CaffeineCategoryCache();
    private static final String CATEGORY_PREFIX = "CATEGORY::";

    public static CaffeineCategoryCache getInstance() {
        return INSTANCE;
    }

    private CaffeineCategoryCache() {
        YDMAStringUtil.Print("CaffeineCategoryCache \ucd08\uae30\ud654 \uc2dc\uc791");
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(12L, TimeUnit.HOURS).build(this::loadFromDb);
        this.fullNameCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(12L, TimeUnit.HOURS).build(this::loadFullNameFromDbOptional);
        this.scheduleInvalidateTask();
    }

    private String loadFromDb(String key) throws Exception {
        try {
            String[] parts = key.split("::", 2);
            String shopcd = parts[0];
            String code = parts[1];
            YDMAStringUtil.Print("shopcategorys \uce90\uc2dc \ubbf8\uc2a4 \u2192 DB \uc870\ud68c: " + key);
            return ShopCommonDao.get().getCategoryMatchCode(shopcd, code);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("loadFromDb \uc2e4\ud328: " + key + " \u2192 " + e.getMessage());
            throw e;
        }
    }

    private Optional<String> loadFullNameFromDbOptional(String key) throws Exception {
        try {
            String id = key.replaceFirst(CATEGORY_PREFIX, "");
            YDMAStringUtil.Print("category \uce90\uc2dc \ubbf8\uc2a4 \u2192 DB \uc870\ud68c: " + key);
            ShopProductDao.get();
            String fullName = ShopProductDao.getFullCategoryName(id);
            if (fullName == null || fullName.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(fullName);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("loadFullNameFromDb \uc2e4\ud328: " + key + " \u2192 " + e.getMessage());
            throw e;
        }
    }

    public String getCategoryName(String shopcd, String code) throws Exception {
        String key = shopcd + "::" + code;
        String cached = (String)this.cache.getIfPresent((Object)key);
        if (cached != null) {
            YDMAStringUtil.Print("shopcategorys\uce90\uc2dc HIT: " + key);
            return cached;
        }
        return (String)this.cache.get((Object)key);
    }

    public String getFullCategoryName(String id) throws Exception {
        String key = CATEGORY_PREFIX + id;
        Optional result = (Optional)this.fullNameCache.getIfPresent((Object)key);
        if (result != null) {
            if (result.isPresent()) {
                YDMAStringUtil.Print("category\uce90\uc2dc HIT: " + key);
                return (String)result.get();
            }
            YDMAStringUtil.Print("category\uce90\uc2dc HIT (but empty): " + key);
            return "";
        }
        result = (Optional)this.fullNameCache.get((Object)key);
        return result.orElse("");
    }

    public void invalidate(String shopcd, String code) {
        String key = shopcd + "::" + code;
        this.cache.invalidate((Object)key);
    }

    public void invalidateCategory(String id) {
        String key = CATEGORY_PREFIX + id;
        this.fullNameCache.invalidate((Object)key);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
        this.fullNameCache.invalidateAll();
        YDMAStringUtil.Print("\uce90\uc2dc \uc804\uccb4 \ucd08\uae30\ud654\ub428");
    }

    private void scheduleInvalidateTask() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(() -> {
            YDMAStringUtil.Print("\uce90\uc2dc \uc790\ub3d9 \ucd08\uae30\ud654 \uc2e4\ud589");
            this.invalidateAll();
        }, 6L, 6L, TimeUnit.HOURS);
    }
}

