/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ApiRateLimiter;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.coupang.IShopOrderCoupangCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class CoupangLiteOrderCommand
extends IShopOrderCoupangCommand {
    private static IShopOrderCommand instance = new CoupangLiteOrderCommand();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> ret_list = new ArrayList<ShopOrderMstNewDto>();
        String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 30 == 0 ? (int)range / 30 : (int)range / 30 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            enddt = formatter.format(cal2.getTime());
        }
        int i = 0;
        while (i < num) {
            this.getOrderLite(dto, ret_list, startdt, enddt);
            cal1.add(5, 30);
            startdt = formatter.format(cal1.getTime());
            if (i == num - 2) {
                enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            } else {
                cal2.add(5, 30);
                enddt = formatter.format(cal2.getTime());
            }
            ++i;
        }
        return ret_list;
    }

    /*
     * Exception decompiling
     */
    private void getOrderLite(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String startdt, String enddt) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[11] lbl80 : CaseStatement: default:\u000a, @NONE, blocks:[11] lbl80 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getApiList(ShopOrderMstNewDto dto, String cmd, List<ShopOrderMstNewDto> ret_list, String startdt, String enddt) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v5/vendors/%s/ordersheets";
            String accessKey = dto.getAuthkey1();
            String secretKey = dto.getAuthKey2();
            String vendorid = dto.getVendorId();
            URL2 = String.format(URL2, vendorid);
            boolean flag = true;
            String token = "";
            while (flag) {
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("createdAtFrom", startdt + "+09:00").addParameter("createdAtTo", enddt + "+09:00").addParameter("status", cmd).addParameter("nextToken", token);
                HttpGet get = this.getHttp(uriBuilder, secretKey, accessKey);
                client = HttpClients.createDefault();
                ApiRateLimiter.waitForPermit();
                response = client.execute((HttpUriRequest)get);
                int status2 = response.getStatusLine().getStatusCode();
                String message = response.getStatusLine().getReasonPhrase();
                if (status2 == 200) {
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    token = resObject.get("nextToken").getAsString();
                    flag = !token.equals("");
                    JsonArray datas = resObject.get("data").getAsJsonArray();
                    if (datas.size() <= 0) continue;
                    List<ShopOrderMstNewDto> retNew = this.getNewOrderBind(datas, dto, secretKey, accessKey);
                    ret_list.addAll(retNew);
                    continue;
                }
                throw new Exception(String.format("\ucfe0\ud321\uc11c\ubc84 \uc5d0\ub7ec:{%s}", message));
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    private List<ShopOrderMstNewDto> getNewOrderBind(JsonArray datas, ShopOrderMstNewDto ordDto, String secretKey, String accessKey) throws Exception {
        ArrayList<ShopOrderMstNewDto> result_dto = new ArrayList<ShopOrderMstNewDto>();
        for (JsonElement ele : datas) {
            JsonObject data2 = ele.getAsJsonObject();
            JsonObject orderer = data2.get("orderer").getAsJsonObject();
            JsonObject receiver = data2.get("receiver").getAsJsonObject();
            JsonArray orderItems = data2.get("orderItems").getAsJsonArray();
            String status2 = this.jsonElementNullStr(data2.get("status"));
            JsonObject overseaShippingInfoDto = data2.get("overseaShippingInfoDto").getAsJsonObject();
            int i = 0;
            while (i < orderItems.size()) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(ordDto);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setLabel("");
                dto.setBox_ea("0");
                dto.setWon_cost("0");
                dto.setResult_code("1");
                dto.setOrder_status(this.getStatus(status2));
                dto.setOrder_id(this.jsonElementNullStr(data2.get("orderId")));
                dto.setOrder_date(this.jsonElementNullStr(data2.get("orderedAt")).replace("T", " "));
                dto.setDelv_msg(this.jsonElementNullStr(data2.get("parcelPrintMessage")));
                dto.setCopy_idx(this.jsonElementNullStr(data2.get("shipmentBoxId")));
                this.setReceiverInfo(dto, receiver);
                this.setOrdererInfo(dto, orderer);
                JsonObject item = orderItems.get(i).getAsJsonObject();
                dto.setMall_product_id(this.jsonElementNullStr(item.get("sellerProductId")));
                dto.setCompayny_goods_cd(this.jsonElementNullStr(item.get("externalVendorSkuCode")));
                String serviceFeeRatio = this.fetchServiceFeeRatio(item, ordDto, accessKey, secretKey);
                String vendoritemName = this.jsonElementNullStr(item.get("vendorItemName"));
                dto.setP_product_name(vendoritemName);
                if (vendoritemName.contains(",")) {
                    dto.setP_sku_value(vendoritemName.substring(vendoritemName.indexOf(",") + 1).trim());
                    dto.setCoupang_exposure_option(dto.getP_sku_value());
                } else {
                    dto.setP_sku_value(this.jsonElementNullStr(item.get("sellerProductItemName")));
                }
                dto.setSku_id(this.jsonElementNullStr(item.get("vendorItemId")));
                dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), dto.getSku_id(), dto.getShop_userid()));
                dto.setProduct_name(this.jsonElementNullStr(item.get("sellerProductName")));
                dto.setCopy_idx(this.jsonElementNullStr(data2.get("shipmentBoxId")));
                dto.setMall_exp_cd(this.jsonElementNullStr(data2.get("shipmentBoxId")));
                dto.setSku_value(this.jsonElementNullStr(item.get("externalVendorSkuCode")));
                String deliveryMethod = this.jsonElementNullStr(item.get("deliveryChargeTypeName"));
                if (deliveryMethod.equals("paid")) {
                    deliveryMethod = "\uc120\ubd88";
                }
                dto.setDelivery_method_str2(deliveryMethod);
                if (data2.has("deliveryCompanyName")) {
                    dto.setDeliveryName(this.jsonElementNullStr(data2.get("deliveryCompanyName")));
                }
                if (data2.has("invoiceNumber")) {
                    dto.setInvoice_no(this.jsonElementNullStr(data2.get("invoiceNumber")));
                }
                dto.setCoupang_exposure_name(vendoritemName);
                dto.setCoupang_reg_option(this.jsonElementNullStr(item.get("sellerProductItemName")));
                dto.setCoupang_reg_name(this.jsonElementNullStr(item.get("sellerProductName")));
                dto.setCoupang_option_id(this.jsonElementNullStr(item.get("vendorItemId")));
                dto.setPersonal_customs_code(this.jsonElementNullStr(overseaShippingInfoDto.get("personalCustomsClearanceCode")));
                dto.setExpress_date(this.jsonElementNullStr(data2.get("inTrasitDateTime")).replace("T", " "));
                dto.setDelivery_comp_date(this.jsonElementNullStr(data2.get("deliveredDate")).replace("T", " "));
                dto.setPurchase_confirm_date(this.jsonElementNullStr(item.get("confirmDate")).replace("T", " "));
                dto.setDelivery_method(this.jsonElementNullStr(data2.get("shipmentType")));
                int instantCouponDiscount = item.get("instantCouponDiscount").getAsJsonObject().get("units").getAsInt();
                int downloadableCouponDiscount = item.get("downloadableCouponDiscount").getAsJsonObject().get("units").getAsInt();
                int discountPrice = instantCouponDiscount + downloadableCouponDiscount;
                int optAddPrice = 0;
                int totalCost = item.get("orderPrice").getAsJsonObject().get("units").getAsInt();
                int saleCnt = item.get("shippingCount").getAsInt();
                int saleCost = item.get("salesPrice").getAsJsonObject().get("units").getAsInt();
                int payCost = totalCost - discountPrice;
                int delvCost = data2.get("shippingPrice").getAsJsonObject().get("units").getAsInt();
                double ratio = Double.parseDouble(serviceFeeRatio);
                int supplyCost = (int)Math.round((double)totalCost * ratio) - (int)Math.round((double)delvCost * 0.033);
                int mallFee = totalCost - supplyCost;
                int mallWonCost = supplyCost - discountPrice;
                dto.setTotal_cost(String.valueOf(totalCost));
                dto.setSale_cnt(this.fmtInt(saleCnt));
                dto.setSale_cost(this.fmtInt(saleCost));
                dto.setMall_fee(this.fmtInt(mallFee));
                dto.setSupply_cost(this.fmtInt(supplyCost));
                dto.setPay_cost(this.fmtInt(payCost));
                dto.setMall_won_cost(this.fmtInt(mallWonCost));
                dto.setOpt_add_cost(this.fmtInt(optAddPrice));
                dto.setDiscount_cost(this.fmtInt(discountPrice));
                dto.setRate(this.percentOf(mallFee, totalCost, 2));
                dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
                dto.setDelv_cost(this.fmtInt(delvCost));
                dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
                dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
                result_dto.add(dto);
                ++i;
            }
        }
        return result_dto;
    }

    private void setReceiverInfo(ShopOrderMstNewDto dto, JsonObject receiver) {
        dto.setReceive_name(this.jsonElementNullStr(receiver.get("name")));
        String tel = this.phonenumber_check(receiver.get("receiverNumber"));
        String safeNumber = this.phonenumber_check(receiver.get("safeNumber"));
        dto.setReceive_tel(tel);
        dto.setReceive_cel(safeNumber);
        dto.setReceive_email("");
        dto.setReceive_zipcode(this.jsonElementNullStr(receiver.get("postCode")));
        String addr = this.jsonElementNullStr(receiver.get("addr1")) + " " + this.jsonElementNullStr(receiver.get("addr2"));
        dto.setReceive_addr(addr);
    }

    private void setOrdererInfo(ShopOrderMstNewDto dto, JsonObject orderer) {
        dto.setUser_id("");
        dto.setUser_name(this.jsonElementNullStr(orderer.get("name")));
        String ordererNumber = this.phonenumber_check(orderer.get("ordererNumber"));
        dto.setUser_tel(ordererNumber);
        String orderersafeNumber = this.phonenumber_check(orderer.get("safeNumber"));
        dto.setUser_cel(orderersafeNumber);
        String email = this.jsonElementNullStr(orderer.get("email"));
        dto.setUser_email(email);
    }

    private String fetchServiceFeeRatio(JsonObject item, ShopOrderMstNewDto dto, String accessKey, String secretKey) throws Exception {
        String serviceFeeRatio;
        String kanCategoryId;
        String sellId;
        String sellerProductId = this.jsonElementNullStr(item.get("sellerProductId"));
        try {
            sellId = this.getSellIdFromCoupang(sellerProductId, accessKey, secretKey);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 displayCategoryCode \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        try {
            kanCategoryId = this.getKanCategoryId(sellId, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 kanCategoryId \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        try {
            serviceFeeRatio = this.getServiceFee(kanCategoryId, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 serviceFeeRatio \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        return serviceFeeRatio;
    }

    private String getSellIdFromCoupang(String sellerProductId, String accessKey, String secretKey) throws Exception {
        String url = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products/" + sellerProductId;
        URIBuilder uriBuilder = new URIBuilder().setPath(url);
        HttpGet get = this.getHttp(uriBuilder, secretKey, accessKey);
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String sellId = "";
        if (response.getStatusLine().getStatusCode() == 200) {
            InputStream is = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            JsonObject resObject = (JsonObject)this.parser.parse((Reader)br);
            JsonObject datas1 = (JsonObject)resObject.get("data");
            sellId = datas1.get("displayCategoryCode").getAsString();
        }
        return sellId;
    }

    private String getKanCategoryId(String sellId, Map<String, String> cookies) throws IOException {
        Connection.Response rs = Jsoup.connect((String)("https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/kanCategory?displayCategoryCode=" + sellId)).cookies(cookies).header("Host", "wing.coupang.com").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/json").header("Origin", "https://wing.coupang.com").method(Connection.Method.GET).timeout(15000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
        return jsonobject.get("kanCategoryId").getAsString();
    }

    private String getServiceFee(String kanCategoryId, Map<String, String> cookies) throws IOException {
        Connection.Response rs = Jsoup.connect((String)("https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/commission?categoryId=" + kanCategoryId)).cookies(cookies).header("Host", "wing.coupang.com").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/json").header("Origin", "https://wing.coupang.com").method(Connection.Method.GET).timeout(15000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject1 = (JsonObject)this.parser.parse(rs.body());
        return String.format("%.4f", 1.0 - (double)jsonobject1.get("serviceFeeRatio").getAsFloat() * 1.1 / 100.0);
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "INSTRUCT": 
            case "ACCEPT": {
                return "100";
            }
            case "DELIVERING": 
            case "DEPARTURE": {
                return "403";
            }
            case "FINAL_DELIVERY": {
                return "410";
            }
        }
        return "";
    }

    private void getApiCancelNReturnList(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String startdt, String enddt, boolean isCancel) throws Exception {
        CloseableHttpClient client;
        CloseableHttpResponse response;
        block25: {
            response = null;
            client = null;
            try {
                String URL2 = "/v2/providers/openapi/apis/api/v6/vendors/%s/returnRequests";
                String acessKey = dto.getAuthkey1();
                String secretKey = dto.getAuthKey2();
                String vendorid = dto.getVendorId();
                URL2 = String.format(URL2, vendorid);
                if (isCancel) {
                    int i = 0;
                    while (i < 2) {
                        URIBuilder uriBuilder = this.getUrlBuilder(URL2, startdt, enddt);
                        if (i == 0) {
                            uriBuilder.addParameter("cancelType", "CANCEL");
                        } else {
                            uriBuilder.addParameter("status", "RU");
                        }
                        HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                        client = HttpClients.createDefault();
                        ApiRateLimiter.waitForPermit();
                        response = client.execute((HttpUriRequest)get);
                        String message = response.getStatusLine().getReasonPhrase();
                        if (response.getStatusLine().getStatusCode() == 200) {
                            InputStream is = response.getEntity().getContent();
                            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                            JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                            JsonArray datas = resObject.get("data").getAsJsonArray();
                            if (datas.size() > 0) {
                                this.getClaimOrderBind(datas, dto, ret_list, isCancel);
                            }
                        } else {
                            throw new Exception(String.format("\ucfe0\ud321\uc11c\ubc84 \uc5d0\ub7ec:{%s}", message));
                        }
                        ++i;
                    }
                    break block25;
                }
                URIBuilder uriBuilder = this.getUrlBuilder(URL2, startdt, enddt);
                HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                client = HttpClients.createDefault();
                ApiRateLimiter.waitForPermit();
                response = client.execute((HttpUriRequest)get);
                String message = response.getStatusLine().getReasonPhrase();
                if (response.getStatusLine().getStatusCode() == 200) {
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    JsonArray datas = resObject.get("data").getAsJsonArray();
                    if (datas.size() > 0) {
                        this.getClaimOrderBind(datas, dto, ret_list, isCancel);
                    }
                    break block25;
                }
                throw new Exception(String.format("\ucfe0\ud321\uc11c\ubc84 \uc5d0\ub7ec:{%s}", message));
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void getClaimOrderBind(JsonArray datas, ShopOrderMstNewDto ordDto, List<ShopOrderMstNewDto> ret_list, boolean isCancel) {
        try {
            int i = 0;
            while (i < datas.size()) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(ordDto);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setWon_cost("0");
                dto.setLabel("");
                dto.setBox_ea("0");
                dto.setResult_code("1");
                JsonObject data2 = datas.get(i).getAsJsonObject();
                String receiptType = data2.get("receiptType").getAsString();
                String receiptStatus = data2.get("receiptStatus").getAsString();
                String status2 = this.getStatus(receiptType, receiptStatus);
                if (isCancel || !status2.equals("C01")) {
                    dto.setReceiptid(this.jsonElementNullStr(data2.get("receiptId")));
                    dto.setOrder_status(status2);
                    dto.setOrder_id(this.jsonElementNullStr(data2.get("orderId")));
                    dto.setOrder_date(this.jsonElementNullStr(data2.get("createdAt")).replace("T", " "));
                    JsonArray array = data2.get("returnItems").getAsJsonArray();
                    JsonObject returnItem = array.get(0).getAsJsonObject();
                    dto.setCopy_idx(this.jsonElementNullStr(returnItem.get("shipmentBoxId")));
                    dto.setMall_exp_cd(this.jsonElementNullStr(returnItem.get("shipmentBoxId")));
                    dto.setReceive_name(this.jsonElementNullStr(data2.get("requesterName")));
                    String tel = this.phonenumber_check(data2.get("requesterRealPhoneNumber"));
                    String safeNumber = this.phonenumber_check(data2.get("requesterPhoneNumber"));
                    dto.setReceive_tel(tel);
                    dto.setReceive_cel(safeNumber);
                    dto.setReceive_email("");
                    dto.setReceive_zipcode(this.jsonElementNullStr(data2.get("requesterZipCode")));
                    String addr = this.jsonElementNullStr(data2.get("requesterAddress")) + " " + this.jsonElementNullStr(data2.get("requesterAddressDetail"));
                    dto.setReceive_addr(addr);
                    dto.setMall_product_id(this.jsonElementNullStr(returnItem.get("sellerProductId")));
                    String vendoritemName = this.jsonElementNullStr(returnItem.get("vendorItemName"));
                    dto.setP_product_name(vendoritemName);
                    if (vendoritemName.contains(",")) {
                        dto.setP_sku_value(vendoritemName.substring(vendoritemName.indexOf(",") + 1).trim());
                        dto.setCoupang_exposure_option(dto.getP_sku_value());
                    }
                    dto.setSale_cnt(this.jsonElementNullStr(returnItem.get("purchaseCount")));
                    dto.setDelivery_method_str2("");
                    if (data2.has("returnDeliveryDtos")) {
                        JsonArray returnDeliveryDtos = data2.get("returnDeliveryDtos").getAsJsonArray();
                        if (returnDeliveryDtos.size() > 0) {
                            JsonObject returnDeliveryDto = returnDeliveryDtos.get(0).getAsJsonObject();
                            dto.setDelivery_id(this.jsonElementNullStr(returnDeliveryDto.get("deliveryCompanyCode")));
                            dto.setInvoice_no(this.jsonElementNullStr(returnDeliveryDto.get("deliveryInvoiceNo")));
                        } else {
                            dto.setDelivery_id("");
                            dto.setInvoice_no("");
                        }
                    } else {
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                    }
                    dto.setCoupang_exposure_name(vendoritemName);
                    dto.setCoupang_reg_name(this.jsonElementNullStr(returnItem.get("sellerProductName")));
                    dto.setSku_id(this.jsonElementNullStr(returnItem.get("vendorItemId")));
                    dto.setCoupang_option_id(this.jsonElementNullStr(returnItem.get("vendorItemId")));
                    dto.setProduct_name(this.jsonElementNullStr(returnItem.get("vendorItemPackageName")));
                    dto.setClaim_reason(this.jsonElementNullStr(data2.get("cancelReasonCategory1")) + this.jsonElementNullStr(data2.get("cancelReasonCategory2")));
                    dto.setClaim_reg_date(dto.getOrder_date());
                    dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), dto.getSku_id(), dto.getShop_userid()));
                    ret_list.add(dto);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private URIBuilder getUrlBuilder(String URL2, String startdt, String enddt) {
        URIBuilder builder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59"));
        return builder;
    }
}

