/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.elevenst;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDtoList;
import com.kdjsystem.mlink.shop.data.elevenst.IShopOrderElevenstCommand;
import com.kdjsystem.mlink.tot.common.YDMAHttpUtil;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ElevenstLiteOrderCommand
extends IShopOrderElevenstCommand {
    private static IShopOrderCommand instance = new ElevenstLiteOrderCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private ElevenstLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto orddto) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        String apikey = orddto.getApikey();
        Object startdt = orddto.getStartDt();
        Object enddt = orddto.getEndDt();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(((String)startdt).substring(0, 8));
        Date edate = formatter.parse(((String)enddt).substring(0, 8));
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 7 == 0 ? (int)range / 7 : (int)range / 7 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 6);
            enddt = formatter.format(cal2.getTime()) + "2359";
        }
        Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
        htRequestProperty.put("Content-Type", "text/xml");
        htRequestProperty.put("openapikey", apikey);
        Consumer<Map.Entry> Search = entry -> {
            try {
                ShopOrderMstNewDtoList list2 = new ShopOrderMstNewDtoList();
                String response = YDMAHttpUtil.get((String)entry.getValue(), htRequestProperty);
                response = response.replaceAll("ns2:", "");
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ShopOrderMstNewDtoList.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                StringReader reader = new StringReader(response);
                list2 = (ShopOrderMstNewDtoList)jaxbUnmarshaller.unmarshal((Reader)reader);
                String key = (String)entry.getKey();
                if (response.contains("resultCode>500")) {
                    throw new Exception(list2.getResult_text() + " 11\ubc88\uac00 \uc0ac\uc774\ud2b8\uc5d0\uc11c IP\ub97c \uc785\ub825\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4");
                }
                if (list2.getList().size() > 0) {
                    if (key.equals("100") || key.equals("201")) {
                        for (ShopOrderMstNewDto dto : list2.getList()) {
                            dto.setBasicInfo(orddto);
                            dto.setOrder_status("100");
                            dto.setResult_code("1");
                            dto.setIs_mountain_island("\ubcf4\ud1b5\uc9c0\uc5ed");
                            if (!dto.getBmDlvCst().equals("0")) {
                                dto.setDelv_cost(String.valueOf(Integer.parseInt(dto.getDelv_cost()) + Integer.parseInt(dto.getBmDlvCst())));
                                dto.setIs_mountain_island("\ub3c4\uc11c\uc0b0\uac04");
                                dto.setExtend_addInfo("\ub3c4\uc11c\uc0b0\uac04 \ubc30\uc1a1\ube44: " + dto.getBmDlvCst() + "\uc6d0 \ud3ec\ud568");
                            }
                            if (dto.getDelivery_method_str2() != null) {
                                dto.setDelivery_method_str2(this.getDeliveryMethod(dto.getDelivery_method_str2()));
                            }
                            dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), "", ""));
                            int totalCost = this.parseIntSafe(dto.getTotal_cost());
                            int mallFee = this.parseIntSafe(dto.getMall_fee());
                            int supplyCost = totalCost - mallFee;
                            int mallWonCost = this.parseIntSafe(dto.getMall_won_cost());
                            int discountPrice = supplyCost - mallWonCost;
                            int payCost = totalCost - discountPrice;
                            int delvCost = this.parseIntSafe(dto.getDelv_cost());
                            dto.setTotal_cost(this.fmtInt(totalCost));
                            dto.setMall_fee(this.fmtInt(mallFee));
                            dto.setSupply_cost(this.fmtInt(supplyCost));
                            dto.setPay_cost(this.fmtInt(payCost));
                            dto.setDiscount_cost(this.fmtInt(discountPrice));
                            dto.setRate(this.percentOf(mallFee, totalCost, 2));
                            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
                            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
                            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
                            retList.add(dto);
                        }
                    } else {
                        this.setDataLite(list2.getList(), htRequestProperty, key, retList, orddto);
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new Exception(e.getMessage());
                }
                catch (Exception exception) {}
            }
        };
        int i = 0;
        while (i < num) {
            HashMap<String, String> map_cmd = new HashMap<String, String>();
            this.getOrderLite(map_cmd, (String)startdt, (String)enddt, orddto);
            map_cmd.entrySet().stream().peek(Search).collect(Collectors.toList());
            if (i == num - 2) {
                enddt = orddto.getEndDt();
            } else {
                cal2.add(5, 7);
                enddt = formatter.format(cal2.getTime()) + "2359";
            }
            cal1.add(5, 7);
            startdt = formatter.format(cal1.getTime()) + "0000";
            ++i;
        }
        return retList;
    }

    private void setDataLite(List<ShopOrderMstNewDto> list, Hashtable<String, String> htRequestProperty, String key, List<ShopOrderMstNewDto> retList, ShopOrderMstNewDto orddto) throws Exception {
        for (ShopOrderMstNewDto dto2 : list) {
            ShopOrderMstNewDtoList dtoList = new ShopOrderMstNewDtoList();
            String response = YDMAHttpUtil.get("https://api.11st.co.kr/rest/ordservices/complete/" + dto2.getOrder_id(), htRequestProperty);
            response = response.replaceAll("ns2:", "");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ShopOrderMstNewDtoList.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(response);
            dtoList = (ShopOrderMstNewDtoList)jaxbUnmarshaller.unmarshal((Reader)reader);
            String deliveryResponse = YDMAHttpUtil.get("https://api.11st.co.kr/rest/claimservice/orderlistalladdr/" + dto2.getOrder_id(), htRequestProperty);
            deliveryResponse = deliveryResponse.replaceAll("ns2:", "");
            String deliveryId = deliveryResponse.substring(deliveryResponse.indexOf("<dlvEtprsCd>") + 12, deliveryResponse.indexOf("</dlvEtprsCd>"));
            String invoiceNo = deliveryResponse.substring(deliveryResponse.indexOf("<invcNo>") + 8, deliveryResponse.indexOf("</invcNo>"));
            if (response.contains("resultCode>500")) continue;
            ShopOrderMstNewDto dto = dtoList.getList().get(0);
            dto.setBasicInfo(orddto);
            dto.setResult_code("1");
            dto.setIs_mountain_island("\ubcf4\ud1b5\uc9c0\uc5ed");
            if (!dto.getBmDlvCst().equals("0")) {
                dto.setDelv_cost(String.valueOf(Integer.parseInt(dto.getDelv_cost()) + Integer.parseInt(dto.getBmDlvCst())));
                dto.setIs_mountain_island("\ub3c4\uc11c\uc0b0\uac04");
                dto.setExtend_addInfo("\ub3c4\uc11c\uc0b0\uac04 \ubc30\uc1a1\ube44: " + dto.getBmDlvCst() + "\uc6d0 \ud3ec\ud568");
            }
            dto.setOrder_status(key);
            if (dto2.getExchangeid() != null) {
                dto.setExchangeid(dto2.getExchangeid());
            }
            if (dto2.getMall_exp_cd() != null) {
                dto.setMall_exp_cd(dto2.getMall_exp_cd());
            }
            if (dto.getDelivery_method_str2() != null) {
                dto.setDelivery_method_str2(this.getDeliveryMethod(dto.getDelivery_method_str2()));
                if (dto.getDelivery_method_str2().equals("\ucc29\ubd88")) {
                    dto.setDelv_cost("0");
                }
            }
            dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), "", ""));
            int totalCost = this.parseIntSafe(dto.getTotal_cost());
            int mallFee = this.parseIntSafe(dto.getMall_fee());
            int supplyCost = totalCost - mallFee;
            int mallWonCost = this.parseIntSafe(dto.getMall_won_cost());
            int delvCost = this.parseIntSafe(dto.getDelv_cost());
            int payCost = this.parseIntSafe(dto.getPay_cost()) - delvCost;
            int discountPrice = totalCost - payCost;
            dto.setTotal_cost(this.fmtInt(totalCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost));
            dto.setDelivery_id(deliveryId);
            dto.setInvoice_no(invoiceNo);
            retList.add(dto);
        }
    }

    private void getOrderLite(Map<String, String> map_cmd, String startdt, String enddt, ShopOrderMstNewDto dto) {
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                map_cmd.put("100", String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt, enddt));
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                map_cmd.put("201", String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt, enddt));
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                map_cmd.put("403", String.format("https://api.11st.co.kr/rest/ordservices/shipping/%s/%s", startdt, enddt));
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                map_cmd.put("410", String.format("https://api.11st.co.kr/rest/ordservices/dlvcompleted/%s/%s", startdt, enddt));
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                map_cmd.put("901", String.format("https://api.11st.co.kr/rest/ordservices/completed/%s/%s", startdt, enddt));
                break;
            }
            case "\ucde8\uc18c": {
                map_cmd.put("C01", String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt, enddt));
                map_cmd.put("C02", String.format("http://api.11st.co.kr/rest/claimservice/canceledorders/%s/%s", startdt, enddt));
                break;
            }
            case "\ubc18\ud488": {
                map_cmd.put("R01", String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt, enddt));
                map_cmd.put("R02", String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt, enddt));
                break;
            }
            case "\uad50\ud658": {
                map_cmd.put("E01", String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt, enddt));
                map_cmd.put("E02", String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt, enddt));
                break;
            }
            case "\ud1b5\ud569": {
                map_cmd.put("100", String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt, enddt));
                map_cmd.put("201", String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt, enddt));
                map_cmd.put("403", String.format("https://api.11st.co.kr/rest/ordservices/shipping/%s/%s", startdt, enddt));
                map_cmd.put("410", String.format("https://api.11st.co.kr/rest/ordservices/dlvcompleted/%s/%s", startdt, enddt));
                map_cmd.put("901", String.format("https://api.11st.co.kr/rest/ordservices/completed/%s/%s", startdt, enddt));
                map_cmd.put("C01", String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt, enddt));
                map_cmd.put("C02", String.format("http://api.11st.co.kr/rest/claimservice/canceledorders/%s/%s", startdt, enddt));
                map_cmd.put("R01", String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt, enddt));
                map_cmd.put("R02", String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt, enddt));
                map_cmd.put("E01", String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt, enddt));
                map_cmd.put("E02", String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt, enddt));
            }
        }
    }

    private String getDeliveryMethod(String method) {
        switch (method) {
            case "01": {
                return "\uc120\ubd88";
            }
            case "02": {
                return "\ucc29\ubd88";
            }
            case "03": {
                return "\ubb34\ub8cc";
            }
        }
        return method;
    }
}

