/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopQnaColumn;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.shop.data.gsshop.ShopGsShopQuestionContext;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopGsShopQuestionSearch
extends ShopGsShopQuestionContext {
    IShopCommonLogin is = new IShopCommonLogin(){};
    JsonParser parser = new JsonParser();

    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        ArrayList<QuestListDto> retList = new ArrayList<QuestListDto>();
        QuestListDto dto = prodList.get(0);
        Map<String, String> cookies = this.is.loginCookie(dto.getShopid(), dto.getShopPw(), "shop0007", true, dto.getAuthkey1());
        String listtp = dto.getBtnstats().equals("\uc804\uccb4") ? "00" : (dto.getBtnstats().equals("\ubb38\uc758") ? "01" : "02");
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        if (!listtp.equals("02")) {
            this.Question(retList, dto, cookies, start, end);
        }
        return retList;
    }

    private void Question(List<QuestListDto> retList, QuestListDto ordDto, Map<String, String> cookies, String start, String end) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("inqryId", "");
        params.put("sortMthod", "desc");
        params.put("sortStd", "inqryDtm");
        params.put("termGbn", "1");
        params.put("fromSearchDtm", start);
        params.put("toSearchDtm", end);
        params.put("srchGbn", "Y");
        params.put("inqryGbn", "0");
        params.put("inqryTyp", "0");
        params.put("procSt", "0");
        params.put("pageIdx", "1");
        params.put("rowsPerPage", "30");
        String baseUrl = "https://withgs.gsshop.com/srv/custInqryAnswrMng/listCustInqry";
        try {
            GsShopRows rows = GsShopApiClient.search(baseUrl, params, cookies);
            for (GsShopRow row : rows.getRows()) {
                try {
                    QuestListDto dto = new QuestListDto();
                    dto.setQnaseq(row.getCell(GsShopQnaColumn.QNA_NO.idx));
                    dto.setQnastat(row.getCell(GsShopQnaColumn.QNA_STAT.idx).equals("\ubbf8\ub2f5\ubcc0") ? "100" : "103");
                    dto.setQgubun(row.getCell(GsShopQnaColumn.QNA_GUBUN.idx));
                    dto.setStat(row.getCell(GsShopQnaColumn.STAT.idx));
                    dto.setInsdm(row.getCell(GsShopQnaColumn.INQUIRY_DATETIME.idx));
                    dto.setInsnm(row.getCell(GsShopQnaColumn.INQUIRY_NAME.idx));
                    String content = Jsoup.parse((String)row.getCell(GsShopQnaColumn.QNA_CONTENT.idx)).text();
                    if (content.contains("/")) {
                        dto.setSubject(content.split("/")[0]);
                        dto.setQuests(content.split("/")[1]);
                    } else {
                        dto.setSubject(content);
                        dto.setQuests(content);
                    }
                    dto.setProdnm(row.getCell(GsShopQnaColumn.INQUIRY_PROD_NAME.idx));
                    dto.setGoodcd(row.getCell(GsShopQnaColumn.INQUIRY_GOODS_CD.idx));
                    dto.setMprodid(row.getCell(GsShopQnaColumn.INQUIRY_PROD_ID.idx));
                    dto.setInfono(row.getCell(GsShopQnaColumn.REG_CUST_NO.idx) + "," + row.getCell(GsShopQnaColumn.REG_CUST_GUBUN.idx));
                    dto.setRegdm(YDMATimeUtil.getCurrentTime());
                    dto.setShopid(ordDto.getShopid());
                    dto.setShopnm(ordDto.getShopnm());
                    if (dto.getQnastat().equals("103")) {
                        try {
                            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/srv/custInqryAnswrMng/detail").cookies(cookies).header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").header("Accept", "application/json, text/javascript, */*; q=0.01").data("inqryId", dto.getQnaseq()).data("inqryGbnCd", row.getCell(GsShopQnaColumn.REG_CUST_GUBUN.idx)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true).execute();
                            if (rs.statusCode() == 200) {
                                JsonObject obj = this.parser.parse(rs.body()).getAsJsonObject();
                                JsonArray arr = obj.get("custInqryAnswerDetail").getAsJsonArray();
                                obj = arr.get(0).getAsJsonObject();
                                dto.setAnsws(obj.get("answrCntnt").getAsString());
                                dto.setSenddt(obj.get("answrDt").getAsString());
                            }
                        }
                        catch (Exception e) {
                            YDMAStringUtil.Print("\uc9c0\uc5d0\uc2a4\uc0f5 \ub2f5\ubcc0\uc740 \uac00\uc838\uc624\ub294\ub370 \uc2e4\ud328 [" + e.getMessage() + "]");
                        }
                    }
                    retList.add(dto);
                }
                catch (Exception e) {
                    YDMAStringUtil.Print("\uc9c0\uc5d0\uc2a4\uc0f5 \ub2e8\uac74 \ub370\uc774\ud130 \ubc14\uc778\ub529 \uc911 \uc2e4\ud328[" + e.getMessage() + "]");
                }
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc9c0\uc5d0\uc2a4\uc0f5 \ubb38\uc758\uc218\uc9d1 \uc911 \uc804\uccb4 \uac00\uc838\uc624\ub294\ub370 \uc2e4\ud328 [" + e.getMessage() + "]");
        }
    }
}

