/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.interpark;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.interpark.IShopOrderInterParkCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class InterParkOrderSearchCommand2
extends IShopOrderInterParkCommand {
    private static IShopOrderCommand instance = new InterParkOrderSearchCommand2();
    JsonParser jsonparser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private InterParkOrderSearchCommand2() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            String id = param.get(0).getShop_userid();
            String pw = param.get(0).getShopPw();
            String shopcd = param.get(0).getShopid();
            String authKey = param.get(0).getAuthkey1();
            String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
            String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
            IShopCommonLogin i = new IShopCommonLogin(){};
            Map<String, String> cookies = i.loginCookie(id, pw, shopcd, true, authKey);
            this.allOrderList(param, dtolist, startdt, enddt, cookies);
            this.cancleList(param, dtolist, startdt, enddt, cookies);
            this.returnList(param, dtolist, startdt, enddt, cookies);
            this.exChangeList(param, dtolist, startdt, enddt, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\ubc14\uc774\uc990 \uc0c1\ud0dc\uac12 \uac00\uc838\uc624\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return dtolist;
    }

    private void exChangeList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://seller.buyzle.co.kr/api/orders/exchange-request").append("?claimOrderStatus=").append("&detailedSearchType=").append("&detailedSearchValue=").append("&searchPeriodType=exchangeRequestDate").append("&startDate=").append(startdt).append("T15%3A00%3A00Z").append("&endDate=").append(enddt).append("T14%3A59%3A00Z").append("&page=1").append("&size=50");
        Connection.Response rs = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).method(Connection.Method.GET).timeout(20000).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        jsonobject = jsonobject.get("data").getAsJsonObject();
        JsonArray jsonArray = (JsonArray)jsonobject.get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status2 = object.get("clmStatNm").getAsString();
                if (status2.equals("\uad50\ud658\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("E01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status2.equals("\uad50\ud658\ubc1c\uc1a1\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("E02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("E02");
                        temp.setOrder_date(object.get("orderExchangeDeliveryDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void returnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://seller.buyzle.co.kr/api/orders/return-request").append("?claimOrderStatus=").append("&detailedSearchType=").append("&detailedSearchValue=").append("&searchPeriodType=returnRequestDate").append("&startDate=").append(startdt).append("T15%3A00%3A00Z").append("&endDate=").append(enddt).append("T14%3A59%3A00Z").append("&page=1").append("&size=50");
        Connection.Response rs = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).method(Connection.Method.GET).timeout(20000).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        jsonobject = jsonobject.get("data").getAsJsonObject();
        JsonArray jsonArray = (JsonArray)jsonobject.get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status2 = object.get("clmStatNm").getAsString();
                if (status2.equals("\ubc18\ud488\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("R01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status2.equals("\ubc18\ud488\uc785\uace0\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("R02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("R02");
                        temp.setOrder_date(object.get("orderReturnReceiveDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void cancleList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://seller.buyzle.co.kr/api/orders/cancel-request").append("?claimOrderStatus=").append("&detailedSearchType=").append("&detailedSearchValue=").append("&searchPeriodType=cancelRequestDate").append("&startDate=").append(startdt).append("T15%3A00%3A00Z").append("&endDate=").append(enddt).append("T14%3A59%3A00Z").append("&page=1").append("&size=50");
        Connection.Response rs = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).method(Connection.Method.GET).timeout(20000).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        jsonobject = jsonobject.get("data").getAsJsonObject();
        JsonArray jsonArray = (JsonArray)jsonobject.get("orders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                String status2 = object.get("clmStatNm").getAsString();
                if (status2.equals("\ucde8\uc18c\uc694\uccad")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("C01");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                } else if (status2.equals("\ucde8\uc18c\uc644\ub8cc")) {
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("C02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("C02");
                        temp.setOrder_date(object.get("orderCancelComplateDts").getAsString().replace("T", " ").replace("Z", ""));
                        dtolist.add(dto);
                        dtolist.add(temp);
                    }
                }
                ++i;
            }
        }
    }

    private void allOrderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String startdt, String enddt, Map<String, String> cookies) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://seller.buyzle.co.kr/api/orders/total").append("?orderStatus=all").append("&detailedSearchType=").append("&detailedSearchValue=").append("&claimYn=").append("&searchPeriodType=orderDate").append("&startDate=").append(startdt).append("T15%3A00%3A00Z").append("&endDate=").append(enddt).append("T14%3A59%3A00Z").append("&adminMallYn=N").append("&page=1").append("&size=50");
        Connection.Response rs = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).method(Connection.Method.GET).timeout(20000).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        jsonobject = jsonobject.get("data").getAsJsonObject();
        JsonArray jsonArray = (JsonArray)jsonobject.get("totalOrders");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("ordclmNo").getAsString();
                String mallid = object.get("prdNm").getAsString();
                String expid = object.get("optFnm").isJsonNull() ? "" : object.get("optFnm").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    String ordStatus = object.get("ordclmPrdStatus").getAsString();
                    if (ordStatus.contains("\ubc1c\uc1a1\uc644\ub8cc")) {
                        dto.setOrder_status("403");
                        dto.setResult_code("1");
                        dtolist.add(dto);
                        continue;
                    }
                    if (!ordStatus.contains("\ubc30\uc1a1\uc644\ub8cc") && !ordStatus.contains("\uad6c\ub9e4\ud655\uc815")) continue;
                    dto.setOrder_status("410");
                    dto.setResult_code("1");
                    dtolist.add(dto);
                }
                ++i;
            }
        }
    }

    private boolean orderCheck(ShopOrderMstDto dto, String orderid, String mallid, String expid) {
        return dto.getOrder_id().equals(orderid) && dto.getProduct_name().equals(mallid) && dto.getP_sku_value().equals(expid);
    }
}

