/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.ssgmarket.IShopSSGOrderCommand;
import com.kdjsystem.mlink.shop.data.ssgmarket.SSGOrderDto;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SSGOrderExpressCommand
extends IShopSSGOrderCommand {
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private static SSGOrderExpressCommand instance = new SSGOrderExpressCommand();
    private static final String Host = "https://eapi.ssgadm.com";

    public static SSGOrderExpressCommand getInstance() {
        return instance;
    }

    private SSGOrderExpressCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            for (ShopOrderMstDto dto : param) {
                String json = this.setRequestParams(dto);
                MediaType mediaType = MediaType.parse((String)"");
                RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
                Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/saveWblNo.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
                try {
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        block28: {
                            SSGOrderDto.ResponseBody responseBody = (SSGOrderDto.ResponseBody)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseBody.class);
                            if (responseBody.getResult().getResultCode().equals("00")) {
                                json = this.setOutcompleteProcess(dto);
                                mediaType = MediaType.parse((String)"");
                                body = RequestBody.create((MediaType)mediaType, (String)json);
                                request2 = new Request.Builder().url(Host.concat("/api/pd/1/saveWhOutCompleteProcess.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
                                try {
                                    Throwable throwable2 = null;
                                    Object var15_21 = null;
                                    try (Response response1 = this.client.newCall(request2).execute();){
                                        responseBody = (SSGOrderDto.ResponseBody)mapper.readValue(response1.body().string().toString(), SSGOrderDto.ResponseBody.class);
                                        if (responseBody.getResult().getResultCode().equals("00")) {
                                            dto.setResult_code("1");
                                            dto.setOrder_status("403");
                                        } else {
                                            dto.setResult_code("-1");
                                            dto.setResult_text(responseBody.getResult().getResultDesc());
                                        }
                                        break block28;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (Exception e) {
                                    throw new Exception(e);
                                }
                            }
                            dto.setResult_code("-1");
                            dto.setResult_text(responseBody.getResult().getResultDesc());
                        }
                        retList.add(dto);
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return retList;
    }

    private String setOutcompleteProcess(ShopOrderMstDto dto) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqWhOutCompleteProcess reqWhOutCompleteProcess = new SSGOrderDto.ReqWhOutCompleteProcess();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess = new SSGOrderDto.ReqWhOutCompleteProcess.RequestWhOutCompleteProcess();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppNo = dto.getCopy_idx();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppSeq = dto.getMall_exp_cd();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.procItemQty = dto.getSale_cnt();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqWhOutCompleteProcess);
        }
        catch (Exception e) {
            throw new Exception("\ucd9c\uace0\ucc98\ub9ac \ub370\uc774\ud130 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
        return json;
    }

    private String setRequestParams(ShopOrderMstDto dto) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqWhOutCompleteProcess reqWhOutCompleteProcess = new SSGOrderDto.ReqWhOutCompleteProcess();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess = new SSGOrderDto.ReqWhOutCompleteProcess.RequestWhOutCompleteProcess();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppNo = dto.getCopy_idx();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppSeq = dto.getMall_exp_cd();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.wblNo = dto.getInvoice_no();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.delicoVenId = dto.getDelivery_id();
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppTypeCd = "20";
            reqWhOutCompleteProcess.requestWhOutCompleteProcess.shppTypeDtlCd = "22";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqWhOutCompleteProcess);
        }
        catch (Exception e) {
            throw new Exception("\uc6b4\uc1a1\uc7a5 \ub370\uc774\ud130 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
        return json;
    }
}

