/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopProductSync;
import com.kdjsystem.mlink.shop.common.ProductSyncService;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;

public class ShopProductWemarketSync
extends ProductSyncService
implements IShopProductSync {
    private static final String Host = "http://api.kdjsystem.com:8082/";

    public ShopProductWemarketSync(IShopProductSync productsync) {
        super(productsync);
    }

    @Override
    public List<ShopProductDto> excute(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ShopProductDto> syncList = new ArrayList<ShopProductDto>();
        ArrayList<ShopProductDto> totlaSyncList = new ArrayList<ShopProductDto>();
        boolean flag = true;
        int start = 1;
        String startdt = "";
        String enddt = "";
        int month = YDMATimeUtil.getMonthsDifference(dto.getDatefrom(), dto.getDateto());
        int i = 0;
        while (i <= month) {
            flag = true;
            start = 1;
            if (i == 0) {
                startdt = dto.getDatefrom();
                enddt = YDMATimeUtil.getEndofMonth(dto.getDatefrom());
            } else if (i == month) {
                startdt = YDMATimeUtil.getStartofMonth(dto.getDateto());
                enddt = dto.getDateto();
            } else {
                startdt = YDMATimeUtil.getNextMonthStartDay(dto.getDatefrom(), i);
                enddt = YDMATimeUtil.getEndofMonth(startdt);
            }
            block5: while (flag) {
                Request request2;
                ObjectMapper mapper = new ObjectMapper();
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Response response = client.newCall(request2 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductList?%s", "startDate=" + startdt + "&endDate=" + enddt + "&currentPage=" + start))).method("GET", null).addHeader("apiKey", dto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build()).execute();
                String data2 = response.body().string().toString();
                ProductData productData = (ProductData)mapper.readValue(data2, ProductData.class);
                if (!productData.getResultCode().equals("200")) continue;
                if (productData.data.list.size() == 0) {
                    flag = false;
                }
                int k = 0;
                ++start;
                syncList = new ArrayList();
                monitor.beginTask("\ub370\uc774\ud130 \uac00\uc9c0\uace0 \uc624\ub294\uc911\uc785\ub2c8\ub2e4.", productData.data.list.size());
                for (WemarketList item : productData.data.list) {
                    ShopProductDto syncDto = new ShopProductDto();
                    ++k;
                    syncDto.setGoods_nm(item.getProductName());
                    syncDto.setShopprodno(String.valueOf(item.getProductNo()));
                    syncDto.setInsertdt(item.getSaleStartDate().equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : item.getSaleStartDate());
                    syncDto.setSaleenddt(item.getSaleEndDate());
                    syncDto.setMarket_price(String.valueOf(item.getSalePrice()));
                    syncDto.setGoods_price(String.valueOf(item.getSalePrice()));
                    syncDto.setGoods_consumer_price(String.valueOf(item.getSalePrice()));
                    syncDto.setSaleStatusCd(item.getProductStatusName());
                    client = new OkHttpClient().newBuilder().build();
                    Request request1 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductAPI?%s", "productNo=" + syncDto.getShopprodno()))).method("GET", null).addHeader("apiKey", dto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
                    Response response1 = client.newCall(request1).execute();
                    String data1 = response1.body().string().toString();
                    JsonParser jsonparser = new JsonParser();
                    JsonObject jsonobject = (JsonObject)jsonparser.parse(data1);
                    JsonObject jsonobject1 = (JsonObject)jsonobject.get("data");
                    JsonObject etc = (JsonObject)jsonobject1.get("etc");
                    syncDto.setCompayny_goods_cd(etc.get("sellerProductCode").getAsString());
                    syncList.add(syncDto);
                    totlaSyncList.addAll(syncList);
                    if (productData.data.list.size() <= 0) continue;
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uac00\uc838\uc624\ub294\uc911...] " + syncDto.getCompayny_goods_cd() + " " + k + " of " + productData.data.list.size() + "...");
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        monitor.done();
                        continue block5;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return totlaSyncList;
    }

    @Override
    public List<ShopProductDto> complate(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ShopProductDto> syncList = new ArrayList<ShopProductDto>();
        ArrayList<ShopProductDto> totlaSyncList = new ArrayList<ShopProductDto>();
        boolean flag = true;
        int start = 1;
        String startdt = "";
        String enddt = "";
        try {
            int month = YDMATimeUtil.getMonthsDifference(dto.getDatefrom(), dto.getDateto());
            int i = 0;
            while (i <= month) {
                flag = true;
                start = 1;
                if (i == 0) {
                    startdt = dto.getDatefrom();
                    enddt = YDMATimeUtil.getEndofMonth(dto.getDatefrom());
                } else if (i == month) {
                    startdt = YDMATimeUtil.getStartofMonth(dto.getDateto());
                    enddt = dto.getDateto();
                } else {
                    startdt = YDMATimeUtil.getNextMonthStartDay(dto.getDatefrom(), i);
                    enddt = YDMATimeUtil.getEndofMonth(startdt);
                }
                while (flag) {
                    ObjectMapper mapper = new ObjectMapper();
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    Host.concat(String.format("wemarket/api/v1/getProductList?%s", "startDate=" + startdt + "&endDate=" + enddt + "&currentPage=" + start));
                    Request request2 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductList?%s", "startDate=" + startdt + "&endDate=" + enddt + "&currentPage=" + start))).method("GET", null).addHeader("apiKey", dto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
                    Response response = client.newCall(request2).execute();
                    String data2 = response.body().string().toString();
                    ProductData productData = (ProductData)mapper.readValue(data2, ProductData.class);
                    if (productData.getResultCode().equals("200")) {
                        if (productData.data.list.size() == 0) {
                            flag = false;
                        }
                        int k = 0;
                        ++start;
                        syncList = new ArrayList();
                        monitor.beginTask("\ub370\uc774\ud130 \uac00\uc9c0\uace0 \uc624\ub294\uc911\uc785\ub2c8\ub2e4.", productData.data.list.size());
                        for (WemarketList item : productData.data.list) {
                            ShopProductDto syncDto = new ShopProductDto();
                            ++k;
                            syncDto.setGoods_nm(item.getProductName());
                            syncDto.setShopprodno(String.valueOf(item.getProductNo()));
                            syncDto.setInsertdt(item.getSaleStartDate().equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : item.getSaleStartDate());
                            syncDto.setSaleenddt(item.getSaleEndDate());
                            syncDto.setMarket_price(String.valueOf(item.getSalePrice()));
                            syncDto.setGoods_price(String.valueOf(item.getSalePrice()));
                            syncDto.setGoods_consumer_price(String.valueOf(item.getSalePrice()));
                            syncDto.setSaleStatusCd(item.getProductStatusName());
                            client = new OkHttpClient().newBuilder().build();
                            Request request1 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductAPI?%s", "productNo=" + syncDto.getShopprodno()))).method("GET", null).addHeader("apiKey", dto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
                            Response response1 = client.newCall(request1).execute();
                            String data1 = response1.body().string().toString();
                            JsonParser jsonparser = new JsonParser();
                            JsonObject jsonobject = (JsonObject)jsonparser.parse(data1);
                            JsonObject jsonobject1 = (JsonObject)jsonobject.get("data");
                            JsonObject etc = (JsonObject)jsonobject1.get("etc");
                            syncDto.setCompayny_goods_cd(etc.get("sellerProductCode").getAsString());
                            syncList.add(syncDto);
                            if (productData.data.list.size() <= 0) continue;
                            try {
                                monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uac00\uc838\uc624\ub294\uc911...] " + syncDto.getCompayny_goods_cd() + " " + k + " of " + productData.data.list.size() + "...");
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                monitor.done();
                                break;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (syncList.size() <= 0) continue;
                    ArrayList<ShopProductDto> total = new ArrayList<ShopProductDto>();
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uc800\uc7a5\uc911\uc785\ub2c8\ub2e4...]");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
                    ArrayList<ShopProductDto> inTotal = new ArrayList<ShopProductDto>();
                    for (ShopProductDto sync : syncList) {
                        ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", sync.getCompayny_goods_cd());
                        if (infoDto != null) {
                            ShopProductDto find = total.stream().filter(d -> d.getCompayny_goods_cd().equals(infoDto.getCompayny_goods_cd())).findAny().orElse(null);
                            if (find != null) continue;
                            infoDto.setGoods_nm(sync.getGoods_nm());
                            infoDto.setGoods_price(sync.getGoods_price());
                            infoDto.setMarket_price(sync.getGoods_price());
                            infoDto.setGoods_consumer_price(sync.getGoods_price());
                            infoDto.setShopprodno(sync.getShopprodno());
                            infoDto.setInsertdt(sync.getInsertdt());
                            infoDto.setSaleenddt(sync.getSaleenddt());
                            infoDto.setShopcd(dto.getShopcd());
                            infoDto.setShopseq(dto.getShopseq());
                            infoDto.setShopuserid(dto.getShoppingid());
                            infoDto.setSendstats(this.getStatusCd(sync.getSaleStatusCd()));
                            total.add(infoDto);
                            if (!monitor.isCanceled()) continue;
                            monitor.done();
                            break;
                        }
                        ShopProductDto inDto = new ShopProductDto();
                        inDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                        inDto.setCompayny_goods_cd(sync.getCompayny_goods_cd());
                        inDto.setGoods_nm(sync.getGoods_nm());
                        inDto.setGoods_price(sync.getGoods_price());
                        inDto.setGoods_cost(sync.getGoods_price());
                        inDto.setMarket_price(sync.getGoods_price());
                        inDto.setShopprodno(sync.getShopprodno());
                        inDto.setInsertdt(sync.getInsertdt());
                        inDto.setSaleenddt(sync.getSaleenddt());
                        inDto.setShopcd(dto.getShopcd());
                        inDto.setShopseq(dto.getShopseq());
                        inDto.setShopuserid(dto.getShoppingid());
                        inDto.setSendstats(Integer.toString(8000));
                        inDto.setStatus("0");
                        inDto.setClass_cd3("999999999");
                        ProductItemDto newInfoDto = new ProductItemDto();
                        newInfoDto.setIcode(sync.getCompayny_goods_cd());
                        newInfoDto.setIname(sync.getGoods_nm());
                        newInfoDto.setPrice(sync.getGoods_price());
                        newInfoDto.setPrice_consumer(sync.getGoods_price());
                        newInfoDto.setStatus("0");
                        newInfoDto.setClass_cd3("999999999");
                        newInfoDto.setDelivery_qty("0");
                        newInfoDto.setIslimit("0");
                        newInfoDto.setCate_depth("3");
                        newInfoDto.setCert_type("0");
                        newInfoDto.setSearch("shop0000");
                        String[] image = new String[24];
                        int j = 0;
                        while (j < image.length) {
                            image[j] = "";
                            ++j;
                        }
                        newInfoDto.setImg(image);
                        newInfoDto.setDelivery_amount("0");
                        infoTotal.add(newInfoDto);
                        inTotal.add(inDto);
                    }
                    if (monitor.isCanceled()) {
                        monitor.done();
                        break;
                    }
                    if (total.size() > 0) {
                        ShopProductDao.get().setProductInfoInsertNUpdate(total);
                    }
                    if (infoTotal == null || infoTotal.size() <= 0) continue;
                    DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
                    ArrayList<ShopProductDto> ItemList2 = new ArrayList<ShopProductDto>();
                    for (ShopProductDto inList1 : inTotal) {
                        ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", inList1.getCompayny_goods_cd());
                        infoDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                        infoDto.setCompayny_goods_cd(inList1.getCompayny_goods_cd());
                        infoDto.setGoods_nm(inList1.getGoods_nm());
                        infoDto.setGoods_price(inList1.getGoods_price());
                        infoDto.setGoods_cost(inList1.getGoods_price());
                        infoDto.setMarket_price(inList1.getGoods_price());
                        infoDto.setShopprodno(inList1.getShopprodno());
                        infoDto.setInsertdt(inList1.getInsertdt());
                        infoDto.setSaleenddt(inList1.getSaleenddt());
                        infoDto.setShopcd(dto.getShopcd());
                        infoDto.setShopseq(dto.getShopseq());
                        infoDto.setShopuserid(dto.getShoppingid());
                        infoDto.setSendstats(Integer.toString(8000));
                        infoDto.setStatus("0");
                        ItemList2.add(infoDto);
                    }
                    ShopProductDao.get().setProductInfoInsertNUpdate(ItemList2);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totlaSyncList;
    }

    private String getStatusCd(String saleStatusCd) {
        String value = "";
        switch (saleStatusCd) {
            case "\ud310\ub9e4\ub300\uae30": {
                value = String.valueOf(9000);
                break;
            }
            case "\ud310\ub9e4\uc911": {
                value = String.valueOf(8000);
                break;
            }
            case "\ud310\ub9e4\uc885\ub8cc": {
                value = String.valueOf(3000);
                break;
            }
            case "\ud310\ub9e4\uc911\uc9c0": {
                value = String.valueOf(4000);
            }
        }
        return value;
    }

    public static class Data {
        private Integer totalCount;
        private List<WemarketList> list;

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public List<WemarketList> getList() {
            return this.list;
        }

        public void setList(List<WemarketList> list) {
            this.list = list;
        }
    }

    public static class ProductData {
        private String resultCode;
        private Data data;
        private String error;

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data2) {
            this.data = data2;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class WemarketList {
        private String saleEndDate;
        private Number salePrice;
        private String displayYnName;
        private String saleStatusName;
        private Integer makerNo;
        private String lcateName;
        private String mcateName;
        private Integer brandNo;
        private String saleStartDate;
        private String productStatusName;
        private String scateName;
        private String makerName;
        private Integer shipPolicyNo;
        private long productNo;
        private String registerDate;
        private String brandName;
        private String mallTypeName;
        private String productName;
        private String dcateName;
        private String changeDate;

        public String getSaleEndDate() {
            return this.saleEndDate;
        }

        public void setSaleEndDate(String saleEndDate) {
            this.saleEndDate = saleEndDate;
        }

        public Number getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(Number salePrice) {
            this.salePrice = salePrice;
        }

        public String getDisplayYnName() {
            return this.displayYnName;
        }

        public void setDisplayYnName(String displayYnName) {
            this.displayYnName = displayYnName;
        }

        public String getSaleStatusName() {
            return this.saleStatusName;
        }

        public void setSaleStatusName(String saleStatusName) {
            this.saleStatusName = saleStatusName;
        }

        public Integer getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(Integer makerNo) {
            this.makerNo = makerNo;
        }

        public String getLcateName() {
            return this.lcateName;
        }

        public void setLcateName(String lcateName) {
            this.lcateName = lcateName;
        }

        public String getMcateName() {
            return this.mcateName;
        }

        public void setMcateName(String mcateName) {
            this.mcateName = mcateName;
        }

        public Integer getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(Integer brandNo) {
            this.brandNo = brandNo;
        }

        public String getSaleStartDate() {
            return this.saleStartDate;
        }

        public void setSaleStartDate(String saleStartDate) {
            this.saleStartDate = saleStartDate;
        }

        public String getProductStatusName() {
            return this.productStatusName;
        }

        public void setProductStatusName(String productStatusName) {
            this.productStatusName = productStatusName;
        }

        public String getScateName() {
            return this.scateName;
        }

        public void setScateName(String scateName) {
            this.scateName = scateName;
        }

        public String getMakerName() {
            return this.makerName;
        }

        public void setMakerName(String makerName) {
            this.makerName = makerName;
        }

        public Integer getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(Integer shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public long getProductNo() {
            return this.productNo;
        }

        public void setProductNo(long productNo) {
            this.productNo = productNo;
        }

        public String getRegisterDate() {
            return this.registerDate;
        }

        public void setRegisterDate(String registerDate) {
            this.registerDate = registerDate;
        }

        public String getBrandName() {
            return this.brandName;
        }

        public void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        public String getMallTypeName() {
            return this.mallTypeName;
        }

        public void setMallTypeName(String mallTypeName) {
            this.mallTypeName = mallTypeName;
        }

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public String getDcateName() {
            return this.dcateName;
        }

        public void setDcateName(String dcateName) {
            this.dcateName = dcateName;
        }

        public String getChangeDate() {
            return this.changeDate;
        }

        public void setChangeDate(String changeDate) {
            this.changeDate = changeDate;
        }
    }
}

